/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.system;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.system.MQJMXConnectorHelper;
import com.sun.enterprise.connectors.system.MQJMXConnectorInfo;
import com.sun.enterprise.jms.IASJmsUtil;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class MQAdministrator {
    static Logger logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static StringManager localStrings = StringManager.getManager(ConnectorRuntime.class);
    private String target = null;

    public MQAdministrator() {
    }

    public MQAdministrator(String target) throws ConnectorRuntimeException {
        this.target = target;
    }

    public boolean destinationExists(String destName, boolean isQueue) {
        MQJMXConnectorInfo mqInfo = null;
        try {
            mqInfo = MQJMXConnectorHelper.getMQJMXConnectorInfo(this.target)[0];
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            ObjectName objName = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Monitor");
            ObjectName[] destinationObjNames = (ObjectName[])mbsc.invoke(objName, "getDestinations", null, null);
            String destType = "t";
            if (isQueue) {
                destType = "q";
            }
            for (int i = 0; i < destinationObjNames.length; ++i) {
                ObjectName oneDestObjName = destinationObjNames[i];
                String oneDestName = (String)mbsc.getAttribute(oneDestObjName, "Name");
                String oneDestType = (String)mbsc.getAttribute(oneDestObjName, "Type");
                if (!oneDestName.equals(destName.trim()) || !oneDestType.equals(destType)) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception occurred when trying to check if destination exists");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPhysicalDestination(String destName, boolean isQueue) throws ConnectorRuntimeException {
        MQJMXConnectorInfo mqInfo = null;
        try {
            if (this.target == null) {
                this.target = this.getClusterName();
            }
            if (this.destinationExists(destName, isQueue)) {
                logger.log(Level.INFO, "Destination " + destName + "exists in broker");
                return;
            }
            mqInfo = MQJMXConnectorHelper.getMQJMXConnectorInfo(this.target)[0];
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Config");
            String[] signature = null;
            AttributeList destAttrs = null;
            Object[] params = null;
            String destType = "t";
            destAttrs = new AttributeList();
            if (isQueue) {
                destAttrs.add(new Attribute(IASJmsUtil.getMaxActiveConsumersAttribute(), new Integer(IASJmsUtil.getDefaultMaxActiveConsumers())));
                destType = "q";
            }
            if (destAttrs == null || destAttrs.size() == 0) {
                signature = new String[]{"java.lang.String", "java.lang.String"};
                params = new Object[]{destType, destName};
            } else {
                signature = new String[]{"java.lang.String", "java.lang.String", "javax.management.AttributeList"};
                params = new Object[]{destType, destName, destAttrs};
            }
            mbsc.invoke(on, "create", params, signature);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private String getClusterName() throws ConfigException {
        return ClusterHelper.getClusterForInstance(ApplicationServer.getServerContext().getConfigContext(), ApplicationServer.getServerContext().getInstanceName()).getName();
    }

    private ConnectorRuntimeException handleException(Exception e) {
        logger.log(Level.WARNING, "" + e.getMessage(), e);
        ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
        cre.initCause(e);
        return cre;
    }
}

