/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.connectors.ConnectionManagerFactory;
import com.sun.enterprise.connectors.ConnectorAdminObjectAdminServiceImpl;
import com.sun.enterprise.connectors.ConnectorAdminServicesFactory;
import com.sun.enterprise.connectors.ConnectorConfigurationParserServiceImpl;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorConnectionPoolAdminServiceImpl;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorNamingEventNotifier;
import com.sun.enterprise.connectors.ConnectorResourceAdminServiceImpl;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectorSecurityAdminServiceImpl;
import com.sun.enterprise.connectors.ConnectorServiceImpl;
import com.sun.enterprise.connectors.ResourceAdapterAdminServiceImpl;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.system.MQJMXConnectorHelper;
import com.sun.enterprise.connectors.system.MQJMXConnectorInfo;
import com.sun.enterprise.connectors.util.JmsRaMapping;
import com.sun.enterprise.connectors.util.RAWriterAdapter;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public final class ConnectorRuntime
implements ConnectorConstants {
    static final Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private volatile int environment = 2;
    private final ConnectorAdminObjectAdminServiceImpl adminObjectAdmService;
    private final ConnectorConfigurationParserServiceImpl configParserAdmService;
    private final ConnectorConnectionPoolAdminServiceImpl ccPoolAdmService;
    private final ConnectorResourceAdminServiceImpl connectorResourceAdmService;
    private final ConnectorSecurityAdminServiceImpl connectorSecurityAdmService;
    private final ResourceAdapterAdminServiceImpl resourceAdapterAdmService;
    private final ConnectorServiceImpl connectorService;
    private boolean isSystemResourcesLoaded = false;
    private static final ConnectorRuntime _runtime = new ConnectorRuntime();

    public static ConnectorRuntime getRuntime() {
        return _runtime;
    }

    private ConnectorRuntime() {
        Utility.setEnvironment();
        this.adminObjectAdmService = (ConnectorAdminObjectAdminServiceImpl)ConnectorAdminServicesFactory.getService("AdminObjectResource");
        this.ccPoolAdmService = (ConnectorConnectionPoolAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorConnectionPool");
        this.connectorResourceAdmService = (ConnectorResourceAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorResource");
        this.connectorSecurityAdmService = (ConnectorSecurityAdminServiceImpl)ConnectorAdminServicesFactory.getService("Security");
        this.resourceAdapterAdmService = (ResourceAdapterAdminServiceImpl)ConnectorAdminServicesFactory.getService("ResourceAdapter");
        this.configParserAdmService = new ConnectorConfigurationParserServiceImpl();
        this.connectorService = new ConnectorServiceImpl();
    }

    public void initialize(int environment) {
        this.environment = environment;
        ConnectorServiceImpl.initialize(this.getEnviron());
    }

    public int getEnviron() {
        return this.environment;
    }

    public void destroyActiveResourceAdapter(String moduleName) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.destroyActiveResourceAdapter(moduleName);
    }

    public void destroyActiveResourceAdapter(String moduleName, boolean cascade) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.destroyActiveResourceAdapter(moduleName, cascade);
    }

    public void createActiveResourceAdapter(ConnectorDescriptor connectorDescriptor, String moduleName, String moduleDir) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.createActiveResourceAdapter(connectorDescriptor, moduleName, moduleDir);
    }

    public void createActiveResourceAdapter(String moduleDir, String moduleName) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.createActiveResourceAdapter(moduleDir, moduleName);
    }

    public ConnectionManager obtainConnectionManager(String poolName) throws ConnectorRuntimeException {
        return this.obtainConnectionManager(poolName, false);
    }

    public ConnectionManager obtainConnectionManager(String poolName, boolean forceNoLazyAssoc) throws ConnectorRuntimeException {
        ConnectionManager mgr = ConnectionManagerFactory.getAvailableConnectionManager(poolName, forceNoLazyAssoc);
        return mgr;
    }

    public ManagedConnectionFactory[] obtainManagedConnectionFactories(String poolName) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.obtainManagedConnectionFactories(poolName);
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(String poolName) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.obtainManagedConnectionFactory(poolName);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, ElementProperty[] props, SecurityMap[] securityMaps) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(ccp, connectionDefinitionName, rarName, props, securityMaps);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, ConnectionDefDescriptor cdd, String rarName) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(ccp, cdd, rarName);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(connectorPoolObj);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj, String security, Set configProperties) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(connectorPoolObj, security, configProperties);
    }

    public void createConnectorResource(String jndiName, String poolName, String resourceType) throws ConnectorRuntimeException {
        this.connectorResourceAdmService.createConnectorResource(jndiName, poolName, resourceType);
    }

    public String getDefaultPoolName(String jndiName) {
        return this.connectorService.getDefaultPoolName(jndiName);
    }

    public static boolean isJmsRa() {
        return ResourceAdapterAdminServiceImpl.isJmsRa();
    }

    public String getDefaultPoolName(String moduleName, String connectionDefName) {
        return this.connectorService.getDefaultPoolName(moduleName, connectionDefName);
    }

    public String getDefaultResourceName(String moduleName, String connectionDefName) {
        return this.connectorService.getDefaultResourceName(moduleName, connectionDefName);
    }

    public void addAdminObject(String appName, String connectorName, String jndiName, String adminObjectType, Properties props) throws ConnectorRuntimeException {
        this.adminObjectAdmService.addAdminObject(appName, connectorName, jndiName, adminObjectType, props);
    }

    public void deleteAdminObject(String jndiName) throws ConnectorRuntimeException {
        this.adminObjectAdmService.deleteAdminObject(jndiName);
    }

    public void deleteConnectorConnectionPool(String poolName) throws ConnectorRuntimeException {
        this.ccPoolAdmService.deleteConnectorConnectionPool(poolName);
    }

    public void deleteConnectorConnectionPool(String poolName, boolean cascade) throws ConnectorRuntimeException {
        this.ccPoolAdmService.deleteConnectorConnectionPool(poolName, cascade);
    }

    public void deleteConnectorResource(String jndiName) throws ConnectorRuntimeException {
        this.connectorResourceAdmService.deleteConnectorResource(jndiName);
    }

    public AuthenticationService getAuthenticationService(String rarName, String poolName) {
        return this.connectorSecurityAdmService.getAuthenticationService(rarName, poolName);
    }

    public JmsRaMapping getJmsRaMapping() {
        return this.resourceAdapterAdmService.getJmsRaMapping();
    }

    public String getSecurityPermissionSpec(String moduleName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getSecurityPermissionSpec(moduleName);
    }

    public boolean testConnectionPool(String poolName) throws ResourceException {
        return this.ccPoolAdmService.testConnectionPool(poolName);
    }

    public boolean isRarDeployed(String moduleName) {
        return this.resourceAdapterAdmService.isRarDeployed(moduleName);
    }

    public void reCreateActiveResourceAdapter(String moduleName) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.reCreateActiveResourceAdapter(moduleName);
    }

    public boolean stopAndRemoveActiveResourceAdapter(String moduleName) {
        return this.resourceAdapterAdmService.stopAndRemoveActiveResourceAdapter(moduleName);
    }

    public void killAllPools(String moduleName) {
        this.ccPoolAdmService.killAllPools(moduleName);
    }

    public void killPool(String poolName) {
        this.ccPoolAdmService.killPool(poolName);
    }

    public void addResourceAdapterConfig(String rarName, ResourceAdapterConfig raConfig) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.addResourceAdapterConfig(rarName, raConfig);
    }

    public void deleteResourceAdapterConfig(String rarName) {
        this.resourceAdapterAdmService.deleteResourceAdapterConfig(rarName);
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.reconfigureConnectorConnectionPool(ccp);
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp, Set excludedProps) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.reconfigureConnectorConnectionPool(ccp, excludedProps);
    }

    public void recreateConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        this.ccPoolAdmService.recreateConnectorConnectionPool(ccp);
    }

    public String[] getConnectionDefinitionNames(String rarName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getConnectionDefinitionNames(rarName);
    }

    public String[] getAdminObjectInterfaceNames(String rarName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getAdminObjectInterfaceNames(rarName);
    }

    public Properties getResourceAdapterConfigProps(String rarName) throws ConnectorRuntimeException {
        return rarName.indexOf("#") == -1 ? this.configParserAdmService.getResourceAdapterConfigProps(rarName) : new Properties();
    }

    public Properties getMCFConfigProps(String rarName, String connectionDefName) throws ConnectorRuntimeException {
        return rarName.indexOf("#") == -1 ? this.configParserAdmService.getMCFConfigProps(rarName, connectionDefName) : new Properties();
    }

    public Properties getAdminObjectConfigProps(String rarName, String adminObjectIntf) throws ConnectorRuntimeException {
        return rarName.indexOf("#") == -1 ? this.configParserAdmService.getAdminObjectConfigProps(rarName, adminObjectIntf) : new Properties();
    }

    public Properties getConnectorConfigJavaBeans(String rarName, String connectionDefName, String type) throws ConnectorRuntimeException {
        return this.configParserAdmService.getConnectorConfigJavaBeans(rarName, connectionDefName, type);
    }

    public String getActivationSpecClass(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        return this.configParserAdmService.getActivationSpecClass(rarName, messageListenerType);
    }

    public String[] getMessageListenerTypes(String rarName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getMessageListenerTypes(rarName);
    }

    public Properties getMessageListenerConfigProps(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        return rarName.indexOf("#") == -1 ? this.configParserAdmService.getMessageListenerConfigProps(rarName, messageListenerType) : new Properties();
    }

    public Properties getMessageListenerConfigPropTypes(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        return this.configParserAdmService.getMessageListenerConfigPropTypes(rarName, messageListenerType);
    }

    public static boolean isServer() {
        ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
        return connectorRuntime.connectorService.isServer();
    }

    public void loadDeferredResourceAdapter(String rarName) throws ConnectorRuntimeException {
        this.connectorService.loadDeferredResourceAdapter(rarName);
    }

    public boolean checkAndLoadResource(String resName) {
        return this.connectorService.checkAndLoadResource(resName);
    }

    public boolean checkAccessibility(String rarName, ClassLoader loader) {
        return this.connectorService.checkAccessibility(rarName, loader);
    }

    public static Set getConnectionDefinitionProperties(String connectionDefinitionClassName) {
        ConnectorConnectionPoolAdminServiceImpl cfr_ignored_0 = ConnectorRuntime.getRuntime().ccPoolAdmService;
        return ConnectorConnectionPoolAdminServiceImpl.getConnectionDefinitionProperties(connectionDefinitionClassName);
    }

    public static Map getConnectionDefinitionPropertiesAndDefaults(String connectionDefinitionClassName) {
        ConnectorConnectionPoolAdminServiceImpl cfr_ignored_0 = ConnectorRuntime.getRuntime().ccPoolAdmService;
        return ConnectorConnectionPoolAdminServiceImpl.getConnectionDefinitionPropertiesAndDefaults(connectionDefinitionClassName);
    }

    public ConnectorNamingEventNotifier getResourceRebindEventNotifier() {
        return this.connectorResourceAdmService.getResourceRebindEventNotifier();
    }

    public void switchOnMatching(String rarName, String poolName) {
        this.connectorService.switchOnMatching(rarName, poolName);
    }

    public void switchOnMatchingInJndi(String poolName) throws ConnectorRuntimeException {
        this.ccPoolAdmService.switchOnMatching(poolName);
    }

    public ConnectorDescriptor getConnectorDescriptor(String rarName) throws ConnectorRuntimeException {
        return this.connectorService.getConnectorDescriptor(rarName);
    }

    public static void stopAllActiveResourceAdapters() {
        ConnectorRuntime.getRuntime().resourceAdapterAdmService.stopAllActiveResourceAdapters();
    }

    public Map getResourceAdapterBeanProperties(String pathToDeployableUnit) throws ConnectorRuntimeException {
        return this.configParserAdmService.getRABeanProperties(pathToDeployableUnit);
    }

    public void initializeConnectorMonitoring() {
        this.connectorService.initializeConnectorMonitoring();
    }

    public Connection getConnection(String jndiName, String user, String password) throws SQLException {
        return this.ccPoolAdmService.getConnection(jndiName, user, password);
    }

    public Connection getConnection(String jndiName) throws SQLException {
        return this.ccPoolAdmService.getConnection(jndiName);
    }

    public boolean isConnectorConnectionPoolDeployed(String poolName) {
        return this.ccPoolAdmService.isConnectorConnectionPoolDeployed(poolName);
    }

    public MQJMXConnectorInfo[] getMQJMXConnectorInfo(String target) throws ConnectorRuntimeException {
        return MQJMXConnectorHelper.getMQJMXConnectorInfo(target);
    }

    public boolean isValidJndiSuffix(String name) {
        return this.connectorResourceAdmService.isValidJndiSuffix(name);
    }

    public Object lookupPMResource(String jndiName, boolean force) throws NamingException {
        Object result;
        try {
            result = this.connectorResourceAdmService.lookup(jndiName + "__pm");
        }
        catch (NamingException ne) {
            if (force && ResourcesUtil.isDAS()) {
                _logger.log(Level.FINE, "jdbc.unable_to_lookup_resource", new Object[]{jndiName});
                result = this.lookupDataSourceInDAS(jndiName);
            }
            throw ne;
        }
        return result;
    }

    public Object lookupNonTxResource(String jndiName, boolean force) throws NamingException {
        Object result;
        try {
            result = this.connectorResourceAdmService.lookup(jndiName + "__nontx");
        }
        catch (NamingException ne) {
            if (force && ResourcesUtil.isDAS()) {
                _logger.log(Level.FINE, "jdbc.unable_to_lookup_resource", new Object[]{jndiName});
                result = this.lookupDataSourceInDAS(jndiName);
            }
            throw ne;
        }
        return result;
    }

    private Object lookupDataSourceInDAS(String jndiName) {
        return this.connectorResourceAdmService.lookupDataSourceInDAS(jndiName);
    }

    public Object lookup(String name) throws NamingException {
        return this.connectorResourceAdmService.lookup(name);
    }

    public String[] getSystemConnectorsAllowingPoolCreation() {
        return new String[]{"jmsra", "jaxr-ra"};
    }

    public synchronized void loadAllSystemRAResources() {
        if (!this.isSystemResourcesLoaded) {
            ResourcesUtil.createInstance().loadSystemRAResources();
            this.isSystemResourcesLoaded = true;
        }
    }

    public PrintWriter getResourceAdapterLogWriter() {
        Logger logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
        RAWriterAdapter writerAdapter = new RAWriterAdapter(logger);
        return new PrintWriter(writerAdapter);
    }
}

