/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;

public class LbConfig
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    private static final Version runtimeVersion = new Version(4, 2, 0);
    public static final String CLUSTER_REF = "ClusterRef";
    public static final String SERVER_REF = "ServerRef";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public LbConfig() {
        this(1);
    }

    public LbConfig(int options) {
        super(comparators, runtimeVersion);
        this.initPropertyTables(3);
        this.createProperty("cluster-ref", CLUSTER_REF, 66098, ClusterRef.class);
        this.createAttribute(CLUSTER_REF, "ref", "Ref", 257, null, null);
        this.createAttribute(CLUSTER_REF, "lb-policy", "LbPolicy", 1, null, "round-robin");
        this.createAttribute(CLUSTER_REF, "lb-policy-module", "LbPolicyModule", 513, null, null);
        this.createProperty("server-ref", SERVER_REF, 66098, ServerRef.class);
        this.createAttribute(SERVER_REF, "ref", "Ref", 257, null, null);
        this.createAttribute(SERVER_REF, "disable-timeout-in-minutes", "DisableTimeoutInMinutes", 1, null, "30");
        this.createAttribute(SERVER_REF, "lb-enabled", "LbEnabled", 1, null, "false");
        this.createAttribute(SERVER_REF, "enabled", "Enabled", 1, null, "true");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public ClusterRef getClusterRef(int index) {
        return (ClusterRef)this.getValue(CLUSTER_REF, index);
    }

    public void setClusterRef(ClusterRef[] value) {
        this.setValue(CLUSTER_REF, value);
        if (value != null && value.length > 0) {
            this.setServerRef(null);
        }
    }

    public ClusterRef[] getClusterRef() {
        return (ClusterRef[])this.getValues(CLUSTER_REF);
    }

    public int sizeClusterRef() {
        return this.size(CLUSTER_REF);
    }

    public int addClusterRef(ClusterRef value) throws ConfigException {
        return this.addClusterRef(value, true);
    }

    public int addClusterRef(ClusterRef value, boolean overwrite) throws ConfigException {
        ClusterRef old = this.getClusterRefByRef(value.getRef());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(LbConfig.class).getString("cannotAddDuplicate", CLUSTER_REF));
        }
        return this.addValue(CLUSTER_REF, value, overwrite);
    }

    public int removeClusterRef(ClusterRef value) {
        return this.removeValue(CLUSTER_REF, value);
    }

    public int removeClusterRef(ClusterRef value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(CLUSTER_REF, value, overwrite);
    }

    public ClusterRef getClusterRefByRef(String id) {
        ClusterRef[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getClusterRef()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"ref")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public ServerRef getServerRef(int index) {
        return (ServerRef)this.getValue(SERVER_REF, index);
    }

    public void setServerRef(ServerRef[] value) {
        this.setValue(SERVER_REF, value);
        if (value != null && value.length > 0) {
            this.setClusterRef(null);
        }
    }

    public ServerRef[] getServerRef() {
        return (ServerRef[])this.getValues(SERVER_REF);
    }

    public int sizeServerRef() {
        return this.size(SERVER_REF);
    }

    public int addServerRef(ServerRef value) throws ConfigException {
        return this.addServerRef(value, true);
    }

    public int addServerRef(ServerRef value, boolean overwrite) throws ConfigException {
        ServerRef old = this.getServerRefByRef(value.getRef());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(LbConfig.class).getString("cannotAddDuplicate", SERVER_REF));
        }
        return this.addValue(SERVER_REF, value, overwrite);
    }

    public int removeServerRef(ServerRef value) {
        return this.removeValue(SERVER_REF, value);
    }

    public int removeServerRef(ServerRef value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(SERVER_REF, value, overwrite);
    }

    public ServerRef getServerRefByRef(String id) {
        ServerRef[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getServerRef()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"ref")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(LbConfig.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getName() {
        return this.getAttributeValue("name");
    }

    public void setName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("name", v, overwrite);
    }

    public void setName(String v) {
        this.setAttributeValue("name", v);
    }

    public String getResponseTimeoutInSeconds() {
        return this.getAttributeValue("response-timeout-in-seconds");
    }

    public void setResponseTimeoutInSeconds(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("response-timeout-in-seconds", v, overwrite);
    }

    public void setResponseTimeoutInSeconds(String v) {
        this.setAttributeValue("response-timeout-in-seconds", v);
    }

    public static String getDefaultResponseTimeoutInSeconds() {
        return "60".trim();
    }

    public boolean isHttpsRouting() {
        return LbConfig.toBoolean(this.getAttributeValue("https-routing"));
    }

    public void setHttpsRouting(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("https-routing", "" + v, overwrite);
    }

    public void setHttpsRouting(boolean v) {
        this.setAttributeValue("https-routing", "" + v);
    }

    public static String getDefaultHttpsRouting() {
        return "false".trim();
    }

    public String getReloadPollIntervalInSeconds() {
        return this.getAttributeValue("reload-poll-interval-in-seconds");
    }

    public void setReloadPollIntervalInSeconds(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("reload-poll-interval-in-seconds", v, overwrite);
    }

    public void setReloadPollIntervalInSeconds(String v) {
        this.setAttributeValue("reload-poll-interval-in-seconds", v);
    }

    public static String getDefaultReloadPollIntervalInSeconds() {
        return "60".trim();
    }

    public boolean isMonitoringEnabled() {
        return LbConfig.toBoolean(this.getAttributeValue("monitoring-enabled"));
    }

    public void setMonitoringEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("monitoring-enabled", "" + v, overwrite);
    }

    public void setMonitoringEnabled(boolean v) {
        this.setAttributeValue("monitoring-enabled", "" + v);
    }

    public static String getDefaultMonitoringEnabled() {
        return "false".trim();
    }

    public boolean isRouteCookieEnabled() {
        return LbConfig.toBoolean(this.getAttributeValue("route-cookie-enabled"));
    }

    public void setRouteCookieEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("route-cookie-enabled", "" + v, overwrite);
    }

    public void setRouteCookieEnabled(boolean v) {
        this.setAttributeValue("route-cookie-enabled", "" + v);
    }

    public static String getDefaultRouteCookieEnabled() {
        return "true".trim();
    }

    public ClusterRef newClusterRef() {
        return new ClusterRef();
    }

    public ServerRef newServerRef() {
        return new ServerRef();
    }

    public ElementProperty newElementProperty() {
        return new ElementProperty();
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "lb-config" + (this.canHaveSiblings() ? "[@name='" + this.getAttributeValue("name") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals("response-timeout-in-seconds")) {
            return "60".trim();
        }
        if (attr.equals("https-routing")) {
            return "false".trim();
        }
        if (attr.equals("reload-poll-interval-in-seconds")) {
            return "60".trim();
        }
        if (attr.equals("monitoring-enabled")) {
            return "false".trim();
        }
        if (attr.equals("route-cookie-enabled")) {
            return "true".trim();
        }
        return null;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void validate() throws ValidateException {
    }

    public void dump(StringBuffer str, String indent) {
        ConfigBean n;
        int i;
        str.append(indent);
        str.append("ClusterRef[" + this.sizeClusterRef() + "]");
        for (i = 0; i < this.sizeClusterRef(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getClusterRef(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(CLUSTER_REF, i, str, indent);
        }
        str.append(indent);
        str.append("ServerRef[" + this.sizeServerRef() + "]");
        for (i = 0; i < this.sizeServerRef(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getServerRef(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(SERVER_REF, i, str, indent);
        }
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("LbConfig\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

