/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config;

import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigDelete;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigSet;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.impl.ConfigAddImpl;
import com.sun.enterprise.config.impl.ConfigDeleteImpl;
import com.sun.enterprise.config.impl.ConfigSetImpl;
import com.sun.enterprise.config.impl.ConfigUpdateImpl;
import com.sun.enterprise.config.util.LoggerHelper;

public class ConfigChangeFactory {
    public static ConfigAdd createConfigAdd(ConfigContext ctx, String xpath) throws ConfigException {
        try {
            return new ConfigAddImpl(ctx, xpath);
        }
        catch (ConfigException ce) {
            LoggerHelper.info("ConfigChangeFactory.createConfigAdd: Error creating config Add", ce);
            throw ce;
        }
    }

    public static ConfigAdd createConfigAdd(String parentXpath, String childXpath, String name, ConfigBean cb) {
        return new ConfigAddImpl(parentXpath, childXpath, name, cb);
    }

    public static ConfigUpdate createConfigUpdate(String xpath, String attrName, String oldValue, String newValue) {
        return new ConfigUpdateImpl(xpath, attrName, oldValue, newValue);
    }

    public static ConfigSet createConfigSet(String parentXpath, String name, Object cb, Object[] cbArray) {
        return new ConfigSetImpl(parentXpath, name, cb, cbArray);
    }

    public static ConfigDelete createConfigDelete(String xpath) {
        return new ConfigDeleteImpl(xpath);
    }
}

