/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.admin.verifier.tests.StaticTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class IiopListenerTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Result result = new Result();
        Object value = ccce.getObject();
        String choice = ccce.getChoice();
        ConfigContext context = ccce.getConfigContext();
        String beanName = ccce.getBeanName();
        if (beanName != null) {
            return this.testSave(ccce.getName(), ccce.getObject());
        }
        IiopListener listener = (IiopListener)value;
        String id = listener.getId();
        if (!StaticTest.checkObjectName(id, result)) {
            result.failed("IIOP Listener ID Invalid ");
            return result;
        }
        result.passed("Valid Object Name");
        String hostIP = listener.getAddress();
        String hostPort = listener.getPort();
        if (choice.equals("ADD")) {
            try {
                Config config = StaticTest.getConfig(context);
                if (config != null) {
                    IiopService service = config.getIiopService();
                    IiopListener[] listeners = service.getIiopListener();
                    int count = 0;
                    for (int i = 0; i < listeners.length; ++i) {
                        if (!listeners[i].isEnabled()) continue;
                        ++count;
                    }
                }
            }
            catch (Exception e) {
                result.failed("Exception occured " + e.getMessage());
            }
        }
        try {
            if (hostPort != null && !hostPort.equals("")) {
                if (!StaticTest.isPortValid(Integer.parseInt(hostPort))) {
                    result.failed("Invalid IIOP Listener Port - " + hostPort);
                    return result;
                }
                result.passed("valid IIOP Listener Port");
            }
        }
        catch (NumberFormatException e) {
            result.failed("Port Number - " + hostPort + " : Invalid");
            return result;
        }
        try {
            InetAddress.getByName(hostIP).getHostName();
            result.passed("Valid IIOP Listener IP");
        }
        catch (UnknownHostException e) {
            result.failed("Host name not resolvable - " + hostIP);
            return result;
        }
        return result;
    }

    public Result testSave(String name, Object value) {
        Result result = new Result();
        result.passed("Passed **");
        if (name.equals("address")) {
            try {
                InetAddress.getByName((String)value).getHostName();
                result.passed("Valid Http Listener IP Address");
            }
            catch (UnknownHostException e) {
                result.failed("Host name not resolvable - " + (String)value);
            }
        }
        String hostPort = (String)value;
        if (name.equals("port")) {
            try {
                if (hostPort != null && !hostPort.equals("")) {
                    if (!StaticTest.isPortValid(Integer.parseInt(hostPort))) {
                        result.failed("Invalid IIOP Listener Port - " + hostPort);
                    } else {
                        result.passed("valid IIOP Listener Port");
                    }
                }
            }
            catch (NumberFormatException e) {
                result.failed("Port Number - " + hostPort + " : Invalid");
            }
        }
        return result;
    }
}

