/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.target;

import com.sun.enterprise.admin.target.ConfigTarget;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.util.i18n.StringManager;

public class DomainTarget
extends Target {
    private static final StringManager strMgr = StringManager.getManager(DomainTarget.class);

    protected DomainTarget(String name, ConfigContext cc) {
        super(name, cc);
    }

    public TargetType getType() {
        return TargetType.DOMAIN;
    }

    public String getTargetObjectName(String[] tokens) {
        this.checkTokens(tokens, 1);
        return tokens[0] + ":type=domain,category=config";
    }

    public ConfigTarget getConfigTarget() throws Exception {
        throw new Exception(strMgr.getString("target.no_config_for_domain"));
    }

    public String getConfigRef() throws ConfigException {
        return null;
    }

    public Server[] getServers() throws ConfigException {
        return ServerHelper.getServersInDomain(this.getConfigContext());
    }

    public Cluster[] getClusters() throws ConfigException {
        return ClusterHelper.getClustersInDomain(this.getConfigContext());
    }

    public Config[] getConfigs() throws ConfigException {
        return ConfigAPIHelper.getConfigsInDomain(this.getConfigContext());
    }

    public NodeAgent[] getNodeAgents() throws ConfigException {
        return NodeAgentHelper.getNodeAgentsInDomain(this.getConfigContext());
    }

    public ApplicationRef[] getApplicationRefs() throws ConfigException {
        throw new ConfigException(strMgr.getString("target.not_supported", "getApplicationRefs", this.getType().getName()));
    }

    public ResourceRef[] getResourceRefs() throws ConfigException {
        throw new ConfigException(strMgr.getString("target.not_supported", "getResourceRefs", this.getType().getName()));
    }
}

