/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core;

import com.sun.enterprise.admin.jmx.remote.IStringManager;
import com.sun.enterprise.admin.jmx.remote.StringManagerFactory;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class InMemoryX509TrustManager
implements X509TrustManager {
    private static IStringManager _strMgr = null;
    private KeyStore mTrustStore = null;

    public InMemoryX509TrustManager(String certNickname) {
        try {
            if (this.mTrustStore == null) {
                this.mTrustStore = this.getCertTrustore(certNickname);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (_strMgr == null) {
            _strMgr = StringManagerFactory.getClientStringManager(InMemoryX509TrustManager.class, null);
        }
    }

    public void checkClientTrusted(X509Certificate[] x509Certificate, String authType) throws CertificateException {
        throw new UnsupportedOperationException("Not Implemented for Client Trust Management");
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificate(chain);
    }

    protected void checkCertificate(X509Certificate[] chain) throws CertificateException, IllegalArgumentException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException(_strMgr.getString("emptyServerCertificate"));
        }
        for (int i = 0; i < chain.length; ++i) {
            chain[i].checkValidity();
        }
        try {
            if (!this.certificateExists(chain[0])) {
                throw new CertificateException(_strMgr.getString("serverCertificateNotTrusted"));
            }
        }
        catch (Exception ex) {
            throw new CertificateException(ex.getMessage());
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    private KeyStore getCertTrustore(String certNickname) throws KeyStoreException {
        int i;
        SecuritySupport secSupp = SecurityUtil.getSecuritySupport();
        KeyStore[] trustStore = secSupp.getTrustStores();
        boolean found = false;
        Certificate cert = null;
        for (i = 0; i < trustStore.length; ++i) {
            cert = trustStore[i].getCertificate(certNickname);
            if (cert == null) continue;
            found = true;
            break;
        }
        if (found && trustStore != null) {
            return trustStore[i];
        }
        return null;
    }

    private boolean certificateExists(X509Certificate x509Certificate) throws KeyStoreException {
        if (this.mTrustStore == null) {
            return false;
        }
        return this.mTrustStore.getCertificateAlias(x509Certificate) != null;
    }
}

