/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.appserv.management.event.StatisticMonitorNotification;
import com.sun.enterprise.admin.selfmanagement.event.StatisticMonitor;
import com.sun.enterprise.admin.selfmanagement.event.StringStatisticMonitorMBean;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringStatisticMonitor
extends StatisticMonitor
implements StringStatisticMonitorMBean {
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    private String stringToCompare = "";
    private boolean notifyMatch = false;
    private boolean notifyDiffer = false;
    private int[] status = new int[16];
    private static final String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.string.matches", "jmx.monitor.string.differs"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "com.sun.appserv.management.event.StatisticMonitorNotification", "Notifications sent by the StringStatisticMonitor MBean")};
    private static final int MATCHING = 0;
    private static final int DIFFERING = 1;
    private static final int MATCHING_OR_DIFFERING = 2;

    @Override
    public synchronized void start() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.status[i] = 2;
        }
        this.doStart();
    }

    @Override
    public synchronized void stop() {
        this.doStop();
    }

    @Override
    public synchronized String getDerivedGauge(ObjectName object) {
        return (String)super.getDerivedGauge(object);
    }

    @Override
    public synchronized long getDerivedGaugeTimeStamp(ObjectName object) {
        return super.getDerivedGaugeTimeStamp(object);
    }

    @Override
    @Deprecated
    public synchronized String getDerivedGauge() {
        return (String)this.derivedGauge[0];
    }

    @Override
    @Deprecated
    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    @Override
    public synchronized String getStringToCompare() {
        return this.stringToCompare;
    }

    @Override
    public synchronized void setStringToCompare(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null string to compare");
        }
        this.stringToCompare = value;
        for (int i = 0; i < this.elementCount; ++i) {
            this.status[i] = 2;
        }
    }

    @Override
    public synchronized boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    @Override
    public synchronized void setNotifyMatch(boolean value) {
        this.notifyMatch = value;
    }

    @Override
    public synchronized boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    @Override
    public synchronized void setNotifyDiffer(boolean value) {
        this.notifyDiffer = value;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return (MBeanNotificationInfo[])notifsInfo.clone();
    }

    @Override
    boolean isComparableTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        return value instanceof String;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onErrorNotification(StatisticMonitorNotification notification) {
        int index = this.indexOf(notification.getObservedObject());
        StringStatisticMonitor stringStatisticMonitor = this;
        synchronized (stringStatisticMonitor) {
            this.status[index] = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    StatisticMonitorNotification buildAlarmNotification(ObjectName object, String attribute, Comparable<?> value) {
        String type = null;
        String msg = null;
        String trigger = null;
        int index = this.indexOf(object);
        StringStatisticMonitor stringStatisticMonitor = this;
        synchronized (stringStatisticMonitor) {
            if (this.status[index] == 2) {
                if (this.derivedGauge[index].equals(this.stringToCompare)) {
                    if (this.notifyMatch) {
                        type = "jmx.monitor.string.matches";
                        msg = "";
                        trigger = this.stringToCompare;
                    }
                    this.status[index] = 1;
                } else {
                    if (this.notifyDiffer) {
                        type = "jmx.monitor.string.differs";
                        msg = "";
                        trigger = this.stringToCompare;
                    }
                    this.status[index] = 0;
                }
            } else if (this.status[index] == 0) {
                if (this.derivedGauge[index].equals(this.stringToCompare)) {
                    if (this.notifyMatch) {
                        type = "jmx.monitor.string.matches";
                        msg = "";
                        trigger = this.stringToCompare;
                    }
                    this.status[index] = 1;
                }
            } else if (this.status[index] == 1 && !this.derivedGauge[index].equals(this.stringToCompare)) {
                if (this.notifyDiffer) {
                    type = "jmx.monitor.string.differs";
                    msg = "";
                    trigger = this.stringToCompare;
                }
                this.status[index] = 0;
            }
        }
        return new StatisticMonitorNotification(type, this, 0L, 0L, msg, null, null, null, trigger);
    }

    @Override
    synchronized void insertSpecificElementAt(int index) {
        if (this.elementCount >= this.status.length) {
            this.status = this.expandArray(this.status);
        }
        this.status[index] = 2;
    }

    @Override
    synchronized void removeSpecificElementAt(int index) {
        this.removeElementAt(this.status, index);
    }
}

