/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.StatisticMonitor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.monitor.Monitor;

public class MonitorEvent
implements Event {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    private static StringManager sm = StringManager.getManager(MonitorEvent.class);
    private ObjectName objName = null;
    private static String description = null;
    private static String defaultDescription = sm.getString("selfmgmt_event.monitor_event_description");
    private StatisticMonitor sMonitor = null;
    private Monitor monitor = null;

    MonitorEvent(StatisticMonitor monitor, ObjectName objName, String description) {
        monitor.start();
        try {
            MBeanServerFactory.getMBeanServer().registerMBean(monitor, objName);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "smgt.internal_error", ex);
        }
        this.sMonitor = monitor;
        this.objName = objName;
        MonitorEvent.description = description != null ? description : defaultDescription;
    }

    MonitorEvent(Monitor monitor, ObjectName objName, String description) {
        monitor.start();
        try {
            MBeanServerFactory.getMBeanServer().registerMBean(monitor, objName);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "smgt.internal_error", ex);
        }
        this.monitor = monitor;
        this.objName = objName;
        MonitorEvent.description = description != null ? description : defaultDescription;
    }

    public ObjectName getObjectName() {
        return this.objName;
    }

    public String getType() {
        return "monitor";
    }

    public NotificationFilter getNotificationFilter() {
        return null;
    }

    public String getDescription() {
        return description;
    }

    public void destroy() {
        try {
            if (this.monitor != null) {
                this.monitor.stop();
            }
            if (this.sMonitor != null) {
                this.sMonitor.stop();
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "smgt.internal_error", ex);
        }
        try {
            MBeanServerFactory.getMBeanServer().unregisterMBean(this.objName);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "smgt.internal_error", ex);
        }
    }
}

