/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.admin.monitor.callflow.EntityManagerMethod;
import com.sun.enterprise.admin.monitor.callflow.EntityManagerQueryMethod;
import com.sun.enterprise.admin.monitor.callflow.Listener;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import com.sun.enterprise.admin.selfmanagement.event.TraceEventImpl;

public class CallflowEventListener
implements Listener {
    private static TraceEventImpl traceImpl = null;
    private static CallflowEventListener _instance = new CallflowEventListener();

    static CallflowEventListener getInstance() {
        return _instance;
    }

    static synchronized void setTraceImpl(TraceEventImpl impl) {
        traceImpl = impl;
    }

    static synchronized void register() {
        Switch.getSwitch().getCallFlowAgent().registerListener(CallflowEventListener.getInstance());
    }

    static synchronized void unregister() {
        Switch.getSwitch().getCallFlowAgent().unregisterListener(CallflowEventListener.getInstance());
    }

    public void requestStart(String requestId, RequestType requestType, String callerIPAddress, String remoteUser) {
        traceImpl.requestStart(requestId, requestType, callerIPAddress, System.nanoTime(), Thread.currentThread().toString());
    }

    public void requestEnd(String requestId) {
        traceImpl.requestEnd(requestId, System.nanoTime(), Thread.currentThread().toString());
    }

    public void ejbMethodStart(String requestId, String methodName, String applicationName, String moduleName, String componentName, ComponentType componentType, String securityId, String transactionId) {
        traceImpl.ejbMethodStart(requestId, methodName, componentType.toString(), applicationName, moduleName, componentName, transactionId, securityId, System.nanoTime(), Thread.currentThread().toString());
    }

    public void ejbMethodEnd(String requestId, Throwable exception) {
        traceImpl.ejbMethodEnd(requestId, exception, System.nanoTime(), Thread.currentThread().toString());
    }

    public void webMethodStart(String requestId, String methodName, String applicationName, String moduleName, String componentName, ComponentType componentType, String callerPrincipal) {
        traceImpl.webMethodStart(requestId, methodName, applicationName, componentType.toString(), componentName, callerPrincipal, System.nanoTime(), Thread.currentThread().toString());
    }

    public void webMethodEnd(String requestId, Throwable exception) {
        traceImpl.webMethodEnd(requestId, exception, System.nanoTime(), Thread.currentThread().toString());
    }

    public void entityManagerMethodStart(String requestId, EntityManagerMethod entityManagerMethod, String applicationName, String moduleName, String componentName, ComponentType componentType, String callerPrincipal) {
    }

    public void entityManagerMethodEnd(String requestId) {
    }

    public void entityManagerQueryStart(String requestId, EntityManagerQueryMethod queryMethod, String applicationName, String moduleName, String componentName, ComponentType componentType, String callerPrincipal) {
    }

    public void entityManagerQueryEnd(String requestId) {
    }
}

