/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.custom.loading;

import com.sun.enterprise.admin.mbeans.custom.CMBStrings;
import com.sun.enterprise.admin.server.core.CustomMBeanException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MBeanAttributeSetter {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private final MBeanServer mbs;
    private final ObjectName on;
    private static final Map<String, String> P2W = new HashMap<String, String>();

    public MBeanAttributeSetter(MBeanServer mbs, ObjectName on) {
        this.mbs = mbs;
        this.on = on;
    }

    public void setIt(String name, String value) throws CustomMBeanException {
        try {
            String at = this.getAttributeType(name);
            Object atv = this.getAttributeValue(at, name, value);
            Attribute atr = new Attribute(name, atv);
            this.mbs.setAttribute(this.on, atr);
        }
        catch (CustomMBeanException cmbe) {
            throw cmbe;
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
    }

    private String getAttributeType(String name) throws CustomMBeanException {
        String type = null;
        ArrayList<String> attNames = new ArrayList<String>();
        try {
            MBeanAttributeInfo[] mais;
            for (MBeanAttributeInfo mai : mais = this.mbs.getMBeanInfo(this.on).getAttributes()) {
                String an = mai.getName();
                attNames.add(an);
                if (!an.equals(name)) continue;
                type = mai.getType();
                break;
            }
        }
        catch (Exception e) {
            logger.info(CMBStrings.get("getAttributeTypeNonFatal", name));
        }
        if (type == null) {
            String names = new String();
            for (int i = 0; i < attNames.size(); ++i) {
                if (i != 0) {
                    names = names + ", ";
                }
                names = names + (String)attNames.get(i);
            }
            String mesg = CMBStrings.get("cmb.badAttribute", name, names);
            logger.warning(mesg);
            throw new CustomMBeanException(mesg);
        }
        return type;
    }

    private Object getAttributeValue(String type, String name, String value) throws CustomMBeanException {
        Character valueObject = null;
        try {
            if (this.isPrimitive(type)) {
                return this.getAttributeValue(this.toWrapper(type), name, value);
            }
            Class<?> c = Class.forName(type);
            Object[] params = new Object[]{value};
            if (c.equals(Character.class)) {
                if (value.length() != 1) {
                    String mesg = CMBStrings.get("cmb.badCharAttribute", name, value);
                    logger.warning(mesg);
                    throw new CustomMBeanException(mesg);
                }
                valueObject = Character.valueOf(value.charAt(0));
            } else {
                Constructor<?> ctor = c.getConstructor(String.class);
                valueObject = ctor.newInstance(params);
            }
        }
        catch (Throwable t) {
            String msg = CMBStrings.get("attributeValueError", name, type, value);
            throw new CustomMBeanException(msg, t);
        }
        return valueObject;
    }

    private boolean isPrimitive(String type) {
        boolean primitive = Integer.TYPE.getName().equals(type) || Character.TYPE.getName().equals(type) || Short.TYPE.getName().equals(type) || Byte.TYPE.getName().equals(type) || Boolean.TYPE.getName().equals(type) || Double.TYPE.getName().equals(type) || Float.TYPE.getName().equals(type) || Long.TYPE.getName().equals(type);
        return primitive;
    }

    private String toWrapper(String primitive) {
        return P2W.get(primitive);
    }

    static {
        P2W.put(Integer.TYPE.getName(), Integer.class.getName());
        P2W.put(Character.TYPE.getName(), Character.class.getName());
        P2W.put(Short.TYPE.getName(), Short.class.getName());
        P2W.put(Byte.TYPE.getName(), Byte.class.getName());
        P2W.put(Boolean.TYPE.getName(), Boolean.class.getName());
        P2W.put(Double.TYPE.getName(), Double.class.getName());
        P2W.put(Float.TYPE.getName(), Float.class.getName());
        P2W.put(Long.TYPE.getName(), Long.class.getName());
    }
}

