/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.custom;

import com.sun.enterprise.admin.mbeans.custom.MBeanValidator;
import com.sun.enterprise.admin.mbeans.custom.loading.MBeanClassLoader;
import java.util.Map;
import javax.management.MBeanRegistration;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectNameSelectionAlgorithm {
    private ObjectNameSelectionAlgorithm() {
    }

    public static ObjectName select(Map<String, String> params) throws RuntimeException {
        ObjectName on = null;
        try {
            on = params.containsKey("object-name") ? new ObjectName(params.get("object-name")) : MBeanValidator.formDefaultObjectName(params);
            return on;
        }
        catch (MalformedObjectNameException me) {
            throw new RuntimeException(me);
        }
    }

    public static boolean implementsMBeanRegistrationInterface(String className) throws RuntimeException {
        boolean imri = false;
        try {
            Class<?>[] iifs;
            MBeanClassLoader mbcl = new MBeanClassLoader();
            Class<?> mbc = Class.forName(className, false, mbcl);
            for (Class<?> c : iifs = mbc.getInterfaces()) {
                if (!MBeanRegistration.class.equals(c)) continue;
                imri = true;
                mbc = null;
                mbcl = null;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return imri;
    }

    private static boolean implementsMBeanRegistrationInterface(Map<String, String> params) throws RuntimeException {
        return ObjectNameSelectionAlgorithm.implementsMBeanRegistrationInterface(params.get("impl-class-name"));
    }
}

