/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.mbeans.DomainDiagnosticsMBean;
import com.sun.enterprise.diagnostics.DiagnosticAgent;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainDiagnostics
implements DomainDiagnosticsMBean {
    protected Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private PluggableFeatureFactory featureFactory;

    public DomainDiagnostics() {
        this.initPluggableFeatureFactory();
    }

    @Override
    public String generateReport(Map input) throws Exception {
        if (input != null) {
            if (this.featureFactory != null) {
                DiagnosticAgent agent = this.featureFactory.getDiagnosticAgent();
                return agent.generateReport(input);
            }
            throw new Exception("Unable to retrieve feature factory");
        }
        throw new Exception(" Null input");
    }

    @Override
    public List<String> getConfidentialProperties() throws Exception {
        if (this.featureFactory != null) {
            DiagnosticAgent agent = this.featureFactory.getDiagnosticAgent();
            String repositoryDir = ApplicationServer.getServerContext().getInstanceEnvironment().getInstancesRoot();
            return agent.getConfidentialProperties(repositoryDir);
        }
        throw new Exception(" Unable to retrive Pluggable Feature Factory");
    }

    private void initPluggableFeatureFactory() {
        this.featureFactory = ApplicationServer.getServerContext().getPluggableFeatureFactory();
        if (this.featureFactory == null) {
            this._logger.log(Level.WARNING, "diagnostic-service.error_initalize_pluggable_factory");
        }
    }
}

