/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.dottedname.valueaccessor;

import com.sun.enterprise.admin.dottedname.DottedNameStrings;
import com.sun.enterprise.admin.dottedname.valueaccessor.PrefixedValueAccessorBase;
import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public abstract class PropertyValueAccessorBase
extends PrefixedValueAccessorBase {
    abstract String getGetPropertyMethodName();

    abstract String getSetPropertyMethodName();

    abstract String getGetPropertiesMethodName();

    public PropertyValueAccessorBase(MBeanServerConnection conn, String prefix) {
        super(conn, prefix);
    }

    public Attribute getValue(ObjectName objectName, String valueName) throws IOException, ReflectionException, InstanceNotFoundException, AttributeNotFoundException {
        Attribute result = null;
        try {
            Object value = this.getMBS().invoke(objectName, this.getGetPropertyMethodName(), new Object[]{valueName}, new String[]{"java.lang.String"});
            result = new Attribute(valueName, value);
        }
        catch (MBeanException e) {
            throw new AttributeNotFoundException(DottedNameStrings.getString("AttributeNotFound", valueName));
        }
        catch (ReflectionException e) {
            throw new AttributeNotFoundException(DottedNameStrings.getString("AttributeNotFound", valueName));
        }
        return result;
    }

    public Attribute setValue(ObjectName objectName, Attribute attr) throws Exception {
        this.getMBS().invoke(objectName, this.getSetPropertyMethodName(), new Object[]{attr}, new String[]{"javax.management.Attribute"});
        return attr;
    }

    public String[] getAllPropertyNames(ObjectName objectName) throws IOException, ReflectionException, InstanceNotFoundException {
        return this.getAllPropertyNames(objectName, false);
    }

    public String[] getAllPropertyNames(ObjectName objectName, boolean bIncludingPrefix) throws IOException, ReflectionException, InstanceNotFoundException {
        String[] names = null;
        try {
            AttributeList props = (AttributeList)this.getMBS().invoke(objectName, this.getGetPropertiesMethodName(), null, null);
            names = new String[props.size()];
            for (int i = 0; i < names.length; ++i) {
                Attribute attr = (Attribute)props.get(i);
                names[i] = bIncludingPrefix ? this.getDottedNamePrefix() + attr.getName() : attr.getName();
            }
        }
        catch (MBeanException e) {
            names = new String[]{};
        }
        catch (RuntimeOperationsException e) {
            names = new String[]{};
        }
        catch (ReflectionException e) {
            names = new String[]{};
        }
        return names;
    }
}

