/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedName;
import com.sun.enterprise.admin.dottedname.DottedNameAliasSupport;
import com.sun.enterprise.admin.dottedname.DottedNameFactory;
import com.sun.enterprise.admin.dottedname.DottedNameLogger;
import com.sun.enterprise.admin.dottedname.DottedNameQuery;
import com.sun.enterprise.admin.dottedname.DottedNameResolver;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import javax.management.ObjectName;

public class DottedNameResolverForAliases
implements DottedNameResolver {
    final DottedNameQuery mQuery;
    final DottedNameServerInfo mServerInfo;

    public DottedNameResolverForAliases(DottedNameQuery query, DottedNameServerInfo serverInfo) {
        this.mQuery = query;
        this.mServerInfo = serverInfo;
    }

    protected String getUnaliasedName(String dottedNameString) {
        DottedName dn;
        DottedName actualDN = dn = DottedNameFactory.getInstance().get(dottedNameString);
        if (!DottedName.isWildcardName(dottedNameString)) {
            try {
                String actualScope = DottedNameAliasSupport.resolveScope(this.mServerInfo, dn);
                if (!actualScope.equals(dn.getScope())) {
                    actualDN = DottedNameFactory.getInstance().get(DottedName.toString(dn.getDomain(), actualScope, dn.getParts()));
                }
            }
            catch (Exception e) {
                DottedNameLogger.logException(e);
            }
        }
        return actualDN.toString();
    }

    public ObjectName resolveDottedName(String dottedName) {
        String unaliasedName = this.getUnaliasedName(dottedName);
        ObjectName result = this.mQuery.dottedNameToObjectName(unaliasedName);
        return result;
    }
}

