/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common.domains.registry;

import com.sun.enterprise.admin.common.domains.registry.AlreadyRegisteredException;
import com.sun.enterprise.admin.common.domains.registry.DomainEntry;
import com.sun.enterprise.admin.common.domains.registry.DomainRegistryException;
import com.sun.enterprise.admin.common.domains.registry.DomainRegistryI;
import com.sun.enterprise.admin.common.domains.registry.InvalidRootException;
import com.sun.enterprise.admin.common.domains.registry.UnregisteredDomainException;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;

class Registry
implements Serializable,
Cloneable,
DomainRegistryI {
    TreeMap roots = new TreeMap();
    HashMap entries = new HashMap();

    Registry() {
    }

    public boolean isRegistered(String name) {
        return this.roots.containsKey(name);
    }

    public void registerDomain(DomainEntry de) throws DomainRegistryException {
        if (this.isRegistered(de.getName())) {
            throw new AlreadyRegisteredException(de.getName());
        }
        if (this.containsRoot(de.getRoot())) {
            throw new InvalidRootException("The root \"" + de.getRoot() + "\" is already registered");
        }
        this.roots.put(de.getName(), de.getRoot());
        this.entries.put(de.getName(), de);
    }

    public void unregisterDomain(String domain_name) throws DomainRegistryException {
        if (!this.isRegistered(domain_name)) {
            throw new UnregisteredDomainException(domain_name);
        }
        this.delete(domain_name);
    }

    public void unregisterDomain(DomainEntry de) throws DomainRegistryException {
        this.unregisterDomain(de.getName());
    }

    public void reregisterDomain(DomainEntry de) throws DomainRegistryException {
        if (this.isRegistered(de.getName())) {
            if (!this.roots.get(de.getName()).equals(de.getRoot())) {
                throw new InvalidRootException("The given root (" + de.getRoot() + ") of domain " + de.getName() + " doesn't match the already registered root for this domain");
            }
        } else if (this.containsRoot(de.getRoot())) {
            throw new InvalidRootException("The given root (" + de.getRoot() + ") of domain " + de.getName() + " is already registered with a different domain");
        }
        this.entries.put(de.getName(), de);
    }

    public Iterator iterator() throws DomainRegistryException {
        return new RegistryIterator(this);
    }

    public boolean containsDomain(DomainEntry de) throws DomainRegistryException {
        return this.entries.values().contains(de);
    }

    public DomainEntry getDomain(String name) throws DomainRegistryException {
        return (DomainEntry)this.entries.get(name);
    }

    public int size() {
        return this.roots.size();
    }

    private boolean containsRoot(File root) {
        return this.roots.containsValue(root);
    }

    private void delete(String name) {
        this.roots.remove(name);
        this.entries.remove(name);
    }

    protected Object clone() {
        try {
            Registry lhs = (Registry)super.clone();
            lhs.roots = (TreeMap)this.roots.clone();
            lhs.entries = (HashMap)this.entries.clone();
            return lhs;
        }
        catch (CloneNotSupportedException cne) {
            return null;
        }
    }

    class RegistryIterator
    implements Iterator {
        Registry registry;
        Iterator iterator;

        RegistryIterator(Registry r) {
            this.registry = (Registry)r.clone();
            this.iterator = this.registry.roots.keySet().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() throws NoSuchElementException {
            return Registry.this.entries.get((String)this.iterator.next());
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

