/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.StringValidator;
import java.io.Serializable;
import java.util.Properties;

public class JMSObjectInfo
implements Serializable {
    private String jndiName;
    private String type;
    private Properties attrs;

    public JMSObjectInfo(String jndiName, String type) {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(type, "type", StringValidator.getInstance());
        this.jndiName = jndiName;
        this.type = type;
        this.attrs = new Properties();
    }

    public JMSObjectInfo(String jndiName, String type, Properties attrs) {
        this(jndiName, type);
        ArgChecker.checkValid(attrs, "attrs");
        this.attrs = attrs;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getType() {
        return this.type;
    }

    public Properties getAttrs() {
        return this.attrs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.jndiName);
        sb.append(' ');
        sb.append(this.type);
        sb.append(' ');
        sb.append(this.attrs);
        return sb.toString();
    }
}

