/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.ejb.spi.io.J2EEObjectStreamFactory;
import com.sun.ejb.spi.io.NonSerializableObjectHandler;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOUtils {
    private static final Logger _ejbLogger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static J2EEObjectStreamFactory _streamFactory;

    public static final void setJ2EEObjectStreamFactory(J2EEObjectStreamFactory factory) {
        _streamFactory = factory;
    }

    public static ObjectInputStream createObjectInputStream(InputStream is, boolean resolveObject, ClassLoader loader) throws Exception {
        return _streamFactory.createObjectInputStream(is, resolveObject, loader);
    }

    public static ObjectOutputStream createObjectOutputStream(OutputStream os, boolean replaceObject, NonSerializableObjectHandler handler) throws IOException {
        return _streamFactory.createObjectOutputStream(os, replaceObject, handler);
    }

    public static final byte[] serializeObject(Object obj, boolean replaceObject) throws NotSerializableException, IOException {
        byte[] data = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = _streamFactory.createObjectOutputStream(bos, replaceObject, new NonSerializableObjectHandler(){

                public Object handleNonSerializableObject(Object obj) {
                    return obj;
                }
            });
            oos.writeObject(obj);
            oos.flush();
            data = bos.toByteArray();
        }
        catch (NotSerializableException notSerEx) {
            throw notSerEx;
        }
        catch (Exception th) {
            IOException ioEx = new IOException(th.toString());
            ioEx.initCause(th);
            throw ioEx;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception ex) {}
            }
            try {
                bos.close();
            }
            catch (Exception ex) {}
        }
        return data;
    }

    public static final Object deserializeObject(byte[] data, boolean resolveObject, ClassLoader classLoader) throws Exception {
        Object obj = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(data);
            ois = _streamFactory.createObjectInputStream(bis, resolveObject, classLoader);
            obj = ois.readObject();
        }
        catch (Exception ex) {
            _ejbLogger.log(Level.FINE, "Error during deserialization", ex);
            throw ex;
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception ex) {
                _ejbLogger.log(Level.FINEST, "Error during ois.close()", ex);
            }
            try {
                bis.close();
            }
            catch (Exception ex) {
                _ejbLogger.log(Level.FINEST, "Error during bis.close()", ex);
            }
        }
        return obj;
    }
}

