/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.container;

import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.ejb.spi.container.ContainerService;
import com.sun.ejb.spi.io.J2EEObjectStreamFactory;
import com.sun.enterprise.util.S1ASThreadPoolManager;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContainerServiceImpl
implements ContainerService {
    private static String J2EE_OBJECT_FACTORY_NAME = "com.sun.ejb.base.io.J2EEObjectStreamFactoryImpl";
    private static final Logger _ejbLogger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private Timer timer;
    private J2EEObjectStreamFactory j2eeObjectStreamFactory;

    public void initializeService() {
        this.timer = new Timer(true);
        try {
            Class<?> clazz = Class.forName(J2EE_OBJECT_FACTORY_NAME);
            this.j2eeObjectStreamFactory = (J2EEObjectStreamFactory)clazz.newInstance();
            _ejbLogger.log(Level.FINE, "Instantiated J2EEObjectStreamFactory");
        }
        catch (Exception ex) {
            _ejbLogger.log(Level.WARNING, "Couldn't instantiate J2EEObjectstreamFactory", ex);
        }
    }

    public Timer getTimer() {
        return this.timer;
    }

    public J2EEObjectStreamFactory getJ2EEObjectStreamFactory() {
        return this.j2eeObjectStreamFactory;
    }

    public void scheduleWork(ClassLoader classLoader, Runnable target) {
        ThreadPoolWork work = new ThreadPoolWork(classLoader, target);
        try {
            ThreadPoolManager threadpoolMgr = S1ASThreadPoolManager.getThreadPoolManager();
            ThreadPool threadpool = threadpoolMgr.getDefaultThreadPool();
            threadpool.getAnyWorkQueue().addWork(work);
        }
        catch (Throwable th) {
            String errMsg = "Error while adding work to orb threadpool. Hence doing it in current thread";
            _ejbLogger.log(Level.WARNING, errMsg, th);
            work.doWork();
        }
    }

    public void shutdown() {
        this.timer = null;
    }

    private static class ThreadPoolWork
    implements Work {
        private final ClassLoader classLoader;
        private final Runnable target;
        private long enqueTime;

        public ThreadPoolWork(ClassLoader classLoader, Runnable target) {
            this.classLoader = classLoader;
            this.target = target;
        }

        public void setEnqueueTime(long timeInMillis) {
            this.enqueTime = timeInMillis;
        }

        public long getEnqueueTime() {
            return this.enqueTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doWork() {
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (System.getSecurityManager() == null) {
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            Thread.currentThread().setContextClassLoader(ThreadPoolWork.this.classLoader);
                            return null;
                        }
                    });
                }
                this.target.run();
            }
            catch (Throwable throwable) {
                try {
                    _ejbLogger.log(Level.FINE, "Error during execution", throwable);
                }
                catch (Throwable throwable2) {
                    if (System.getSecurityManager() == null) {
                        Thread.currentThread().setContextClassLoader(prevClassLoader);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction(prevClassLoader){
                            final /* synthetic */ ClassLoader val$prevClassLoader;
                            {
                                this.val$prevClassLoader = classLoader;
                            }

                            public Object run() {
                                Thread.currentThread().setContextClassLoader(this.val$prevClassLoader);
                                return null;
                            }
                        });
                    }
                    throw throwable2;
                }
                if (System.getSecurityManager() == null) {
                    Thread.currentThread().setContextClassLoader(prevClassLoader);
                } else {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
            }
            if (System.getSecurityManager() == null) {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            } else {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
        }

        public String getName() {
            return "ThreadPoolWork";
        }
    }
}

