/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.newtimer;

import com.sun.corba.ee.impl.codegen.ASMUtil;
import com.sun.corba.ee.impl.codegen.Identifier;
import com.sun.corba.ee.spi.codegen.Expression;
import com.sun.corba.ee.spi.codegen.ImportList;
import com.sun.corba.ee.spi.codegen.Type;
import com.sun.corba.ee.spi.codegen.Wrapper;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import com.sun.corba.ee.spi.orbutil.newtimer.Controllable;
import com.sun.corba.ee.spi.orbutil.newtimer.Timer;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactory;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactoryBuilder;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerGroup;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerPointSourceGenerator {
    private static Type Controllable;
    private static Type TimerManager;
    private static Type TimerFactory;
    private static Type Timer;
    private static Type TimerEventController;
    private static Type TimerGroup;
    private static ImportList standardImports;
    private static Type generatedInterfaceType;
    private static Type generatedBaseClassType;

    public static Pair<String, TimerFactory> parseDescription(String fileName) throws IOException {
        return TimerPointSourceGenerator.parseDescription(fileName, false);
    }

    public static Pair<String, TimerFactory> parseDescription(String fileName, boolean debug) throws IOException {
        Handler handler = new Handler(debug);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        File file = null;
        try {
            SAXParser saxParser = factory.newSAXParser();
            file = new File(fileName);
            saxParser.parse(file, (DefaultHandler)handler);
        }
        catch (Exception exc) {
            System.out.println("Exception in processing " + file + ": " + exc);
            exc.printStackTrace();
            return null;
        }
        return handler.getResult();
    }

    public static void generateSourceFiles(String dirName, Pair<String, TimerFactory> description) throws IOException {
        String packageName = description.first();
        TimerFactory tf = description.second();
        TimerPointSourceGenerator.generateInterface(dirName, packageName, tf);
        TimerPointSourceGenerator.generateBaseClass(dirName, packageName, tf);
        TimerPointSourceGenerator.generateImpl(false, dirName, packageName, tf);
        TimerPointSourceGenerator.generateImpl(true, dirName, packageName, tf);
    }

    private static void generateInterface(String dirName, String packageName, TimerFactory tf) throws IOException {
        TimerPointSourceGenerator.startFile(packageName);
        Wrapper._interface(1, tf.name(), new Type[0]);
        TimerPointSourceGenerator.generateAccessorMethods(tf, false);
        TimerPointSourceGenerator.generateEnterExitMethods(tf, GenerationType.METHOD_HEADER);
        Wrapper._end();
        generatedInterfaceType = Type._classGenerator(Wrapper._classGenerator());
        TimerPointSourceGenerator.writeFile(dirName, generatedInterfaceType);
    }

    private static void generateBaseClass(String dirName, String packageName, TimerFactory tf) throws IOException {
        TimerPointSourceGenerator.startFile(packageName);
        Wrapper._import(generatedInterfaceType.name());
        String baseClassName = tf.name() + "Base";
        Wrapper._class(1025, baseClassName, Wrapper._Object(), generatedInterfaceType);
        TimerPointSourceGenerator.generateFields(tf);
        TimerPointSourceGenerator.generateConstructor(tf);
        TimerPointSourceGenerator.generateAccessorMethods(tf, true);
        Wrapper._end();
        generatedBaseClassType = Type._classGenerator(Wrapper._classGenerator());
        TimerPointSourceGenerator.writeFile(dirName, generatedBaseClassType);
    }

    private static void generateImpl(boolean isNoop, String dirName, String packageName, TimerFactory tf) throws IOException {
        TimerPointSourceGenerator.startFile(packageName);
        Wrapper._import(generatedBaseClassType.name());
        String className = isNoop ? tf.name() + "DisabledImpl" : tf.name() + "EnabledImpl";
        Wrapper._class(1, className, generatedBaseClassType, new Type[0]);
        Wrapper._constructor(1, new Type[0]);
        Expression tfe = Wrapper._arg(TimerFactory, "tf");
        Expression tec = Wrapper._arg(TimerEventController, "tec");
        Wrapper._body();
        Wrapper._expr(Wrapper._super(tfe, tec));
        Wrapper._end();
        TimerPointSourceGenerator.generateEnterExitMethods(tf, isNoop ? GenerationType.DISABLED_METHOD : GenerationType.ENABLED_METHOD);
        Wrapper._end();
        Type thisClass = Type._classGenerator(Wrapper._classGenerator());
        TimerPointSourceGenerator.writeFile(dirName, thisClass);
    }

    private static void generateAccessorMethods(TimerFactory tf, boolean isImpl) {
        int modifiers = isImpl ? 17 : 1025;
        for (Timer timer : tf.timers().values()) {
            Wrapper._method(modifiers, Timer, timer.name(), new Type[0]);
            if (isImpl) {
                Wrapper._body();
                Wrapper._return(Wrapper._field(Wrapper._this(), timer.name()));
            }
            Wrapper._end();
        }
        for (TimerGroup timerGroup : tf.timerGroups().values()) {
            Wrapper._method(modifiers, TimerGroup, timerGroup.name(), new Type[0]);
            if (isImpl) {
                Wrapper._body();
                Wrapper._return(Wrapper._field(Wrapper._this(), timerGroup.name()));
            }
            Wrapper._end();
        }
    }

    private static void startFile(String packageName) {
        Wrapper._clear();
        Wrapper._package(packageName);
        Wrapper._import(standardImports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String dirName, Type type) throws IOException {
        File file = ASMUtil.getFile(dirName, type.name(), ".java");
        PrintStream ps = new PrintStream(file);
        try {
            Wrapper._sourceCode(ps, new Properties());
        }
        finally {
            ps.close();
        }
    }

    private static void generateFields(TimerFactory tf) {
        Wrapper._data(20, TimerEventController, "controller");
        for (Timer timer : tf.timers().values()) {
            Wrapper._data(20, Timer, timer.name());
        }
        for (TimerGroup timerGroup : tf.timerGroups().values()) {
            Wrapper._data(18, TimerGroup, timerGroup.name());
        }
    }

    private static void generateConstructor(TimerFactory tf) {
        Wrapper._constructor(1, new Type[0]);
        Expression tfe = Wrapper._arg(TimerFactory, "tf");
        Expression controller = Wrapper._arg(TimerEventController, "controller");
        Wrapper._body();
        Wrapper._assign(Wrapper._field(Wrapper._this(), "controller"), controller);
        for (Timer timer : tf.timers().values()) {
            Wrapper._assign(Wrapper._v(timer.name()), Wrapper._call(tfe, "makeTimer", Wrapper._const(timer.name()), Wrapper._const(timer.description())));
        }
        for (TimerGroup timerGroup : tf.timerGroups().values()) {
            Wrapper._assign(Wrapper._v(timerGroup.name()), Wrapper._call(tfe, "makeTimerGroup", Wrapper._const(timerGroup.name()), Wrapper._const(timerGroup.description())));
        }
        for (TimerGroup timerGroup : tf.timerGroups().values()) {
            for (Controllable controllable : timerGroup.contents()) {
                Wrapper._expr(Wrapper._call(Wrapper._v(timerGroup.name()), "add", Wrapper._v(controllable.name())));
            }
        }
        Wrapper._end();
    }

    private static void generateEnterExitMethods(TimerFactory tf, GenerationType gtype) {
        for (Timer timer : tf.timers().values()) {
            TimerPointSourceGenerator.generateMethod("enter", timer.name(), gtype);
            TimerPointSourceGenerator.generateMethod("exit", timer.name(), gtype);
        }
    }

    private static void generateMethod(String op, String timer, GenerationType gtype) {
        int modifiers = gtype == GenerationType.METHOD_HEADER ? 1025 : 1;
        Wrapper._method(modifiers, Wrapper._void(), op + "_" + timer, new Type[0]);
        if (gtype != GenerationType.METHOD_HEADER) {
            Wrapper._body();
            if (gtype == GenerationType.ENABLED_METHOD) {
                Wrapper._expr(Wrapper._call(Wrapper._v("controller"), op, Wrapper._v(timer)));
            }
        }
        Wrapper._end();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Required arguments: input-file output-directory");
            System.exit(1);
        } else {
            try {
                String infile = args[0];
                String outdir = args[1];
                boolean debug = Boolean.parseBoolean(args[2]);
                Pair<String, TimerFactory> result = TimerPointSourceGenerator.parseDescription(infile, debug);
                TimerPointSourceGenerator.generateSourceFiles(outdir, result);
            }
            catch (Exception exc) {
                System.out.println("Failed with exception: " + exc);
                exc.printStackTrace();
                System.exit(1);
            }
        }
    }

    static {
        Wrapper._clear();
        Wrapper._package();
        Controllable = Wrapper._import("com.sun.corba.ee.spi.orbutil.newtimer.Controllable");
        TimerManager = Wrapper._import("com.sun.corba.ee.spi.orbutil.newtimer.TimerManager");
        TimerFactory = Wrapper._import("com.sun.corba.ee.spi.orbutil.newtimer.TimerFactory");
        Timer = Wrapper._import("com.sun.corba.ee.spi.orbutil.newtimer.Timer");
        TimerEventController = Wrapper._import("com.sun.corba.ee.spi.orbutil.newtimer.TimerEventController");
        TimerGroup = Wrapper._import("com.sun.corba.ee.spi.orbutil.newtimer.TimerGroup");
        standardImports = Wrapper._import();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum GenerationType {
        METHOD_HEADER,
        ENABLED_METHOD,
        DISABLED_METHOD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Handler
    extends DefaultHandler {
        private static final int WIDTH = 4;
        private static final String TIMER_ELEMENT = "timer";
        private static final String TIMING_ELEMENT = "timing";
        private static final String TIMER_GROUP_ELEMENT = "timerGroup";
        private static final String CONTAINS_ELEMENT = "contains";
        private static final String NAME_ATTR = "name";
        private static final String DESCRIPTION_ATTR = "description";
        private static final String PACKAGE_ATTR = "package";
        private boolean debug;
        private int level;
        private char[] pad;
        private TimingInfoProcessor tip;
        private Pair<String, TimerFactory> result;

        public Handler(boolean debug) {
            this.debug = debug;
            this.level = 0;
            this.setPad();
            this.tip = null;
            this.result = null;
        }

        private void indent() {
            ++this.level;
            this.setPad();
        }

        private void undent() {
            --this.level;
            this.setPad();
        }

        private void setPad() {
            int length = 4 * this.level;
            this.pad = new char[length];
            for (int ctr = 0; ctr < length; ++ctr) {
                this.pad[ctr] = 32;
            }
        }

        private void dprint(String msg) {
            if (this.debug) {
                System.out.print(this.pad);
                System.out.println(msg);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.dprint("startDocument called");
        }

        @Override
        public void endDocument() throws SAXException {
            this.dprint("endDocument called");
            this.result = this.tip.getResult();
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            this.indent();
            this.dprint("namespaceURI=" + namespaceURI);
            this.dprint("lName=" + lName);
            this.dprint("qName=" + qName);
            this.dprint("Attributes:");
            for (int ctr = 0; ctr < attrs.getLength(); ++ctr) {
                this.dprint("\tlocal name    =" + attrs.getLocalName(ctr));
                this.dprint("\tqualified name=" + attrs.getQName(ctr));
                this.dprint("\tvalue         =" + attrs.getValue(ctr));
            }
            if (qName.equals(TIMING_ELEMENT)) {
                String name = attrs.getValue(NAME_ATTR);
                String pkg = attrs.getValue(PACKAGE_ATTR);
                this.tip = new TimingInfoProcessor(name, pkg);
            } else if (qName.equals(TIMER_ELEMENT)) {
                String name = attrs.getValue(NAME_ATTR);
                String desc = attrs.getValue(DESCRIPTION_ATTR);
                this.tip.addTimer(name, desc);
            } else if (qName.equals(TIMER_GROUP_ELEMENT)) {
                String name = attrs.getValue(NAME_ATTR);
                String desc = attrs.getValue(DESCRIPTION_ATTR);
                this.tip.addTimerGroup(name, desc);
            } else if (qName.equals(CONTAINS_ELEMENT)) {
                String name = attrs.getValue(NAME_ATTR);
                this.tip.contains(name);
            } else {
                throw new IllegalStateException("Unknown XML element: " + qName);
            }
        }

        @Override
        public void endElement(String namespaceURI, String lName, String qName) throws SAXException {
            this.undent();
        }

        public Pair<String, TimerFactory> getResult() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimingInfoProcessor {
        private boolean done = false;
        private String pkg;
        private TimerFactory tf;
        private Map<String, List<String>> contents;
        private TimerGroup currentTimerGroup;

        private void checkForValidIdentifier(String name) {
            if (!Identifier.isValidIdentifier(name)) {
                throw new IllegalArgumentException("name " + name + " is not a valid Java identifier");
            }
        }

        private void checkDone() {
            if (this.done) {
                throw new IllegalStateException("past getResult: no other methods may be called");
            }
        }

        public TimingInfoProcessor(String name, String pkg) {
            this.pkg = pkg;
            this.checkForValidIdentifier(name);
            if (!Identifier.isValidFullIdentifier(pkg)) {
                throw new IllegalArgumentException(pkg + " is not a valid package name");
            }
            this.tf = TimerFactoryBuilder.make(name, name);
            this.contents = new LinkedHashMap<String, List<String>>();
            this.currentTimerGroup = null;
        }

        public void addTimer(String name, String desc) {
            this.checkDone();
            this.checkForValidIdentifier(name);
            this.tf.makeTimer(name, desc);
            this.currentTimerGroup = null;
        }

        public void addTimerGroup(String name, String desc) {
            this.checkDone();
            this.checkForValidIdentifier(name);
            this.currentTimerGroup = this.tf.makeTimerGroup(name, desc);
        }

        public void contains(String name) {
            this.checkDone();
            if (this.currentTimerGroup == null) {
                throw new IllegalStateException("contains must be called after an addTimerGroup call");
            }
            String cname = this.currentTimerGroup.name();
            List<String> list = this.contents.get(cname);
            if (list == null) {
                list = new ArrayList<String>();
                this.contents.put(cname, list);
            }
            list.add(name);
        }

        private static Controllable getControllable(TimerFactory tf, String name) {
            Controllable result = tf.timers().get(name);
            if (result == null) {
                result = tf.timerGroups().get(name);
            }
            if (result == null) {
                throw new IllegalArgumentException(name + " is not a valid Timer or TimerGroup name");
            }
            return result;
        }

        private void updateTimerFactoryContents() {
            for (String str : this.contents.keySet()) {
                List<String> list = this.contents.get(str);
                TimerGroup tg = this.tf.timerGroups().get(str);
                for (String content : list) {
                    tg.add(TimingInfoProcessor.getControllable(this.tf, content));
                }
            }
        }

        public Pair<String, TimerFactory> getResult() {
            this.checkDone();
            this.done = true;
            this.updateTimerFactoryContents();
            Pair<String, TimerFactory> result = new Pair<String, TimerFactory>(this.pkg, this.tf);
            return result;
        }
    }
}

