/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.monitoring;

import com.sun.corba.ee.spi.monitoring.MonitoredAttribute;
import com.sun.corba.ee.spi.monitoring.MonitoredObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoredObjectImpl
implements MonitoredObject {
    private final String name;
    private final String description;
    private Map<String, MonitoredObject> children = new HashMap<String, MonitoredObject>();
    private Map<String, MonitoredAttribute> attributes = new HashMap<String, MonitoredAttribute>();
    private MonitoredObject parent = null;

    MonitoredObjectImpl(String name, String description) {
        this.name = name;
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitoredObject getChild(String name) {
        MonitoredObjectImpl monitoredObjectImpl = this;
        synchronized (monitoredObjectImpl) {
            return this.children.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getChildren() {
        MonitoredObjectImpl monitoredObjectImpl = this;
        synchronized (monitoredObjectImpl) {
            return this.children.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(MonitoredObject m) {
        if (m != null) {
            MonitoredObjectImpl monitoredObjectImpl = this;
            synchronized (monitoredObjectImpl) {
                this.children.put(m.getName(), m);
                m.setParent(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(String name) {
        if (name != null) {
            MonitoredObjectImpl monitoredObjectImpl = this;
            synchronized (monitoredObjectImpl) {
                this.children.remove(name);
            }
        }
    }

    @Override
    public synchronized MonitoredObject getParent() {
        return this.parent;
    }

    @Override
    public synchronized void setParent(MonitoredObject p) {
        this.parent = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitoredAttribute getAttribute(String name) {
        MonitoredObjectImpl monitoredObjectImpl = this;
        synchronized (monitoredObjectImpl) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<MonitoredAttribute> getAttributes() {
        MonitoredObjectImpl monitoredObjectImpl = this;
        synchronized (monitoredObjectImpl) {
            return this.attributes.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAttribute(MonitoredAttribute value) {
        if (value != null) {
            MonitoredObjectImpl monitoredObjectImpl = this;
            synchronized (monitoredObjectImpl) {
                this.attributes.put(value.getName(), value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) {
        if (name != null) {
            MonitoredObjectImpl monitoredObjectImpl = this;
            synchronized (monitoredObjectImpl) {
                this.attributes.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearState() {
        MonitoredObjectImpl monitoredObjectImpl = this;
        synchronized (monitoredObjectImpl) {
            for (MonitoredAttribute ma : this.attributes.values()) {
                ma.clearState();
            }
            for (MonitoredObject mo : this.children.values()) {
                mo.clearState();
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

