/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.BufferQueue;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.pept.encoding.OutputObject;
import com.sun.corba.ee.pept.transport.ByteBufferPool;
import com.sun.corba.ee.pept.transport.Connection;
import java.util.Iterator;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.OutputStream;

public class BufferManagerWriteCollect
extends BufferManagerWrite {
    private BufferQueue queue = new BufferQueue();
    private boolean sentFragment = false;
    private boolean debug = false;

    BufferManagerWriteCollect(com.sun.corba.ee.spi.orb.ORB orb) {
        super(orb);
        if (orb != null) {
            this.debug = orb.transportDebugFlag;
        }
    }

    public boolean sentFragment() {
        return this.sentFragment;
    }

    public int getBufferSize() {
        return this.orb.getORBData().getGIOPFragmentSize();
    }

    public void overflow(ByteBufferWithInfo bbwi) {
        MessageBase.setFlag(bbwi.getByteBuffer(), 2);
        this.queue.enqueue(bbwi);
        ByteBufferWithInfo newBbwi = new ByteBufferWithInfo((ORB)((Object)this.orb), this);
        newBbwi.setFragmented(true);
        ((CDROutputObject)this.outputObject).setByteBufferWithInfo(newBbwi);
        FragmentMessage header = ((CDROutputObject)this.outputObject).getMessageHeader().createFragmentMessage();
        header.write((OutputStream)((CDROutputObject)this.outputObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage() {
        this.queue.enqueue(((CDROutputObject)this.outputObject).getByteBufferWithInfo());
        Iterator bufs = this.iterator();
        Connection conn = ((OutputObject)this.outputObject).getMessageMediator().getConnection();
        conn.writeLock();
        try {
            ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
            while (bufs.hasNext()) {
                ByteBufferWithInfo bbwi = (ByteBufferWithInfo)bufs.next();
                ((CDROutputObject)this.outputObject).setByteBufferWithInfo(bbwi);
                conn.sendWithoutLock((CDROutputObject)this.outputObject);
                this.sentFragment = true;
                if (this.debug) {
                    int bbAddress = System.identityHashCode(bbwi.getByteBuffer());
                    StringBuffer sb = new StringBuffer(80);
                    sb.append("sendMessage() - releasing ByteBuffer id (");
                    sb.append(bbAddress).append(") to ByteBufferPool.");
                    String msg = sb.toString();
                    this.dprint(msg);
                }
                byteBufferPool.releaseByteBuffer(bbwi.getByteBuffer());
                bbwi.setByteBuffer(null);
                bbwi = null;
            }
            this.sentFullMessage = true;
        }
        finally {
            conn.writeUnlock();
        }
    }

    public void close() {
        Iterator bufs = this.iterator();
        ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
        while (bufs.hasNext()) {
            ByteBufferWithInfo bbwi = (ByteBufferWithInfo)bufs.next();
            if (bbwi == null || bbwi.getByteBuffer() == null) continue;
            if (this.debug) {
                int bbAddress = System.identityHashCode(bbwi.getByteBuffer());
                StringBuffer sb = new StringBuffer(80);
                sb.append("close() - releasing ByteBuffer id (");
                sb.append(bbAddress).append(") to ByteBufferPool.");
                String msg = sb.toString();
                this.dprint(msg);
            }
            byteBufferPool.releaseByteBuffer(bbwi.getByteBuffer());
            bbwi.setByteBuffer(null);
            Object var3_3 = null;
        }
    }

    private void dprint(String msg) {
        ORBUtility.dprint("BufferManagerWriteCollect", msg);
    }

    private Iterator iterator() {
        return new BufferManagerWriteCollectIterator();
    }

    private class BufferManagerWriteCollectIterator
    implements Iterator {
        private BufferManagerWriteCollectIterator() {
        }

        public boolean hasNext() {
            return BufferManagerWriteCollect.this.queue.size() != 0;
        }

        public Object next() {
            return BufferManagerWriteCollect.this.queue.dequeue();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

