/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.https;

import com.sun.enterprise.admin.jmx.remote.IStringManager;
import com.sun.enterprise.admin.jmx.remote.StringManagerFactory;
import com.sun.enterprise.admin.jmx.remote.https.AsadminTruststore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.X509TrustManager;

public class SunOneBasicX509TrustManager
implements X509TrustManager {
    private final Object _alias;
    private boolean _alreadyInvoked;
    private CertificateException _lastCertException;
    private RuntimeException _lastRuntimeException;
    private static IStringManager _strMgr = null;

    public SunOneBasicX509TrustManager(Object alias, Map env) {
        if (_strMgr == null) {
            _strMgr = StringManagerFactory.getClientStringManager(SunOneBasicX509TrustManager.class, env);
        }
        this._alias = alias;
        this._alreadyInvoked = false;
        this._lastCertException = null;
        this._lastRuntimeException = null;
    }

    public SunOneBasicX509TrustManager() {
        this(null, null);
    }

    public void checkClientTrusted(X509Certificate[] x509Certificate, String authType) throws CertificateException {
        throw new UnsupportedOperationException("Not Implemented for Client Trust Management");
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (!this._alreadyInvoked) {
            this._alreadyInvoked = true;
            try {
                this.checkCertificate(chain);
            }
            catch (RuntimeException ex) {
                this._lastRuntimeException = ex;
                throw ex;
            }
            catch (CertificateException ex) {
                this._lastCertException = ex;
                throw ex;
            }
        } else {
            if (this._lastRuntimeException != null) {
                throw this._lastRuntimeException;
            }
            if (this._lastCertException != null) {
                throw this._lastCertException;
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    protected boolean promptForConfirmation() {
        return true;
    }

    protected String promptForPassword() throws IOException {
        if (this.promptForConfirmation()) {
            System.out.print(_strMgr.getString("certificateDbPrompt"));
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
            return r.readLine();
        }
        return null;
    }

    protected boolean isItOKToAddCertToTrustStore(X509Certificate c) throws IOException {
        if (this.promptForConfirmation()) {
            System.out.println(c.toString());
            System.out.print(_strMgr.getString("certificateTrustPrompt"));
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
            String result = r.readLine();
            return result != null && result.equalsIgnoreCase("y");
        }
        return true;
    }

    private String getAliasName() {
        String aliasName = this._alias != null ? this._alias.toString() : "";
        DateFormat f = DateFormat.getDateTimeInstance(1, 1);
        aliasName = aliasName + ":" + f.format(new Date());
        return aliasName;
    }

    protected void checkCertificate(X509Certificate[] chain) throws RuntimeException, CertificateException, IllegalArgumentException {
        block9: {
            if (chain == null || chain.length == 0) {
                throw new IllegalArgumentException(_strMgr.getString("emptyServerCertificate"));
            }
            for (int i = 0; i < chain.length; ++i) {
                chain[i].checkValidity();
            }
            try {
                AsadminTruststore truststore = null;
                try {
                    truststore = new AsadminTruststore();
                }
                catch (IOException ex) {
                    String password = this.promptForPassword();
                    if (password != null) {
                        truststore = new AsadminTruststore(password);
                    }
                    throw ex;
                }
                if (truststore.certificateExists(chain[0])) break block9;
                if (this.isItOKToAddCertToTrustStore(chain[0])) {
                    truststore.addCertificate(this.getAliasName(), chain[0]);
                    break block9;
                }
                throw new CertificateException(_strMgr.getString("serverCertificateNotTrusted"));
            }
            catch (CertificateException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

