/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.comm;

import com.sun.appserv.management.client.RedirectException;
import com.sun.enterprise.admin.jmx.remote.comm.HttpConnectorAddress;
import com.sun.enterprise.admin.jmx.remote.comm.IConnection;
import com.sun.enterprise.admin.jmx.remote.streams.JMXChunkedInputStream;
import com.sun.enterprise.admin.jmx.remote.streams.JMXChunkedOutputStream;
import com.sun.enterprise.admin.jmx.remote.streams.JMXInbandStream;
import com.sun.enterprise.admin.jmx.remote.streams.StreamMBeanServerRequestMessage;
import com.sun.enterprise.admin.jmx.remote.streams.StreamMBeanServerResponseMessage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.logging.Logger;

class ServletConnection
implements IConnection,
Runnable {
    static final String UNKNOWN_HOST = "Unknown host : ";
    static final String UNAUTHORIZED_ACCESS = "Invalid user or password";
    private URLConnection mConnection = null;
    private ObjectOutputStream mObjectOutStream = null;
    private ObjectInputStream mObjectInStream = null;
    private HttpConnectorAddress hca;
    private URL uri;
    boolean isRedirectionEnabled = true;
    private static final Logger logger = Logger.getLogger("com.sun.logging.enterprise.system.admin.jmx.connector");
    private boolean response_received = false;
    private int streamSize = 0;
    private int reqSize = 0;

    ServletConnection(HttpConnectorAddress a) throws IOException {
        try {
            String uri = a.getPath();
            if (uri == null || uri.trim().length() == 0) {
                uri = "/web1/remotejmx";
            }
            this.mConnection = a.openConnection(uri);
            this.hca = a;
            String flag = System.getProperty("com.sun.jmx.remote.http.redirect.detect");
            if (flag != null && flag.equalsIgnoreCase("false")) {
                this.isRedirectionEnabled = false;
            }
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
    }

    public Object receive() throws IOException, ClassNotFoundException, RedirectException {
        Object value = null;
        try {
            int respCode;
            if (this.isRedirectionEnabled && (respCode = ((HttpURLConnection)this.mConnection).getResponseCode()) == 302) {
                String redirectUrl = this.mConnection.getHeaderFields().get("Location").get(0);
                throw new RedirectException(redirectUrl, "HTTP connection failed: 302 Moved Temporarily");
            }
            InputStream in = this.mConnection.getInputStream();
            this.mObjectInStream = new ObjectInputStream(in);
            value = this.mObjectInStream.readObject();
            this.response_received = true;
            JMXInbandStream.setOutputStream(null, 0L);
            StreamMBeanServerResponseMessage res = (StreamMBeanServerResponseMessage)value;
            if (res.isStreamAvailable()) {
                JMXInbandStream.setIncomingStream(new JMXChunkedInputStream(in));
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof RedirectException) {
                throw ioe;
            }
            this.handleException(ioe);
        }
        return value;
    }

    public void send(Serializable req) throws IOException {
        InputStream in = null;
        if (req instanceof StreamMBeanServerRequestMessage) {
            StreamMBeanServerRequestMessage reqm = (StreamMBeanServerRequestMessage)req;
            JMXInbandStream.setIncomingStream(null);
            in = JMXInbandStream.getOutgoingStream();
            if (in != null) {
                reqm.setStreamAvailable(true);
                int len = (int)JMXInbandStream.getOutgoingStreamLength();
                ByteArrayOutputStream byO = new ByteArrayOutputStream();
                ObjectOutputStream oO = new ObjectOutputStream(byO);
                oO.writeObject(reqm);
                this.reqSize = byO.size();
                byO.reset();
                int chunks = len / 8192 + 2;
                this.streamSize = this.reqSize + len + chunks * 4;
                ((HttpURLConnection)this.mConnection).setFixedLengthStreamingMode(this.streamSize);
                this.mConnection.setRequestProperty("Connection", "Close");
            }
        }
        this.sendReq(req);
        if (in != null) {
            this.sendStream();
        }
    }

    private void sendStream() {
        this.run();
    }

    public URL getURL() {
        return this.mConnection.getURL();
    }

    HttpConnectorAddress getHttpConnectorAddress() {
        return this.hca;
    }

    public void run() {
        JMXChunkedOutputStream out = null;
        try {
            out = new JMXChunkedOutputStream(this.mConnection.getOutputStream());
            InputStream in = JMXInbandStream.getOutgoingStream();
            byte[] bytes = new byte[8192];
            int len = 0;
            boolean prLen = false;
            boolean flBytes = false;
            while ((len = in.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, len);
            }
            JMXInbandStream.setOutputStream(null, 0L);
            ((OutputStream)out).flush();
            out.writeEOF(this.reqSize);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void sendReq(Serializable object) throws IOException {
        this.response_received = false;
        try {
            this.mObjectOutStream = new ObjectOutputStream(new BufferedOutputStream(this.mConnection.getOutputStream()));
            this.mObjectOutStream.writeObject(object);
            this.mObjectOutStream.flush();
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
    }

    public void close() {
        try {
            this.mObjectInStream.close();
            this.mObjectOutStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleException(IOException e) throws IOException {
        int responseCode;
        IOException exception = null;
        exception = e instanceof UnknownHostException ? new UnknownHostException(UNKNOWN_HOST + e.getMessage()) : (e instanceof ConnectException ? new ConnectException(this.createConnectExceptionMessage()) : ((responseCode = ((HttpURLConnection)this.mConnection).getResponseCode()) == 401 ? new IOException(UNAUTHORIZED_ACCESS) : e));
        throw exception;
    }

    private String createConnectExceptionMessage() {
        String h = this.hca.getHost();
        int p = this.hca.getPort();
        String msg = "Unable to connect to admin-server at given host: [" + h + "] and port: [" + p + "].\nPlease check if this server is up and running and that the host and port provided are correct.";
        return msg;
    }
}

