/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.cli.framework.ValidCommand;
import com.sun.enterprise.cli.framework.ValidOption;
import java.util.Map;
import java.util.Vector;

public class CommandValidator {
    private static final String COMMAND_NAME_REGEXP = "^[a-z\\-][a-z0-9\\-\\_\\ ]*$";
    private static final String OPTION_NAME_REGEXP = "^\\w[-\\w]*";
    private static final String NUMBER_OF_OPERANDS_QUANTIFIER_REGEXP = "^[\\*\\?\\+]";
    private static final String NUMBER_OF_OPERANDS_REGEXP = "^\\+?\\d+";
    private static final String NUMBER_OF_OPERANDS_INCLUSION_REGEXP = "^\\d+\\-\\d+";
    private static final String BOOLEAN = "boolean";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String PLUS = "+";
    private static final String QUESTION_MARK = "?";
    private static final String DASH = "-";

    public void validateCommandAndOptions(ValidCommand validCommand, Map optionsList, Vector operands) throws CommandValidationException {
        if (validCommand == null || optionsList == null || operands == null) {
            throw new CommandValidationException(this.getLocalizedString("CouldNotValidateCommand", null));
        }
        this.verifyCommandName(validCommand.getName());
        this.verifyOptionsAreValid(validCommand, optionsList);
        this.verifyRequiredOptions(validCommand.getRequiredOptions(), optionsList, validCommand.getName());
        this.verifyDeprecatedOptions(validCommand.getDeprecatedOptions(), optionsList, validCommand.getName());
        this.verifyBooleanOptions(validCommand.getRequiredOptions(), optionsList);
        this.verifyNumberOfOperands(validCommand.getNumberOfOperands(), operands.size());
    }

    private boolean verifyCommandName(String commandName) throws CommandValidationException {
        if (!commandName.matches(COMMAND_NAME_REGEXP)) {
            throw new CommandValidationException(this.getLocalizedString("InvalidCommand", new Object[]{commandName}));
        }
        return true;
    }

    private boolean verifyOptionName(String optionName) {
        return optionName.matches(OPTION_NAME_REGEXP);
    }

    private boolean verifyDeprecatedOptions(Vector deprecatedOptionsList, Map optionsList, String commandName) throws CommandValidationException {
        for (int ii = 0; ii < deprecatedOptionsList.size(); ++ii) {
            String optionName = ((ValidOption)deprecatedOptionsList.get(ii)).getName();
            if (!this.verifyOptionName(optionName)) {
                throw new CommandValidationException(this.getLocalizedString("InvalidOption", new Object[]{optionName, commandName}));
            }
            if (!optionsList.containsKey(optionName)) continue;
            CLILogger.getInstance().printWarning(this.getLocalizedString("OptionDeprecated", new Object[]{optionName}));
        }
        return true;
    }

    private boolean verifyRequiredOptions(Vector requiredOptionsList, Map optionsList, String commandName) throws CommandValidationException {
        for (int ii = 0; ii < requiredOptionsList.size(); ++ii) {
            String optionName = ((ValidOption)requiredOptionsList.get(ii)).getName();
            if (!this.verifyOptionName(optionName)) {
                throw new CommandValidationException(this.getLocalizedString("InvalidOption", new Object[]{optionName, commandName}));
            }
            if (optionsList.containsKey(optionName) || ((ValidOption)requiredOptionsList.get(ii)).hasDefaultValue()) continue;
            throw new CommandValidationException(this.getLocalizedString("OptionIsRequired", new Object[]{optionName}));
        }
        return true;
    }

    private boolean verifyOptionsAreValid(ValidCommand validCommand, Map optionsList) throws CommandValidationException {
        for (String optionName : optionsList.keySet()) {
            if (!(validCommand.hasValidOption(optionName) || validCommand.hasRequiredOption(optionName) || validCommand.hasDeprecatedOption(optionName))) {
                throw new CommandValidationException(this.getLocalizedString("InvalidOption", new Object[]{optionName, validCommand.getName()}));
            }
            if (optionsList.get(optionName) != null) continue;
            throw new CommandValidationException(this.getLocalizedString("OptionValueNotSpecified", new Object[]{optionName}));
        }
        return true;
    }

    private boolean verifyBooleanOptions(Vector baseOptionsList, Map optionsList) throws CommandValidationException {
        for (int ii = 0; ii < baseOptionsList.size(); ++ii) {
            String optionValue;
            String optionType = ((ValidOption)baseOptionsList.get(ii)).getType();
            String optionName = ((ValidOption)baseOptionsList.get(ii)).getName();
            if (optionType.compareToIgnoreCase(BOOLEAN) != 0 || !optionsList.containsKey(optionName) || (optionValue = ((String)optionsList.get(optionName)).trim()) != null && (optionValue.compareToIgnoreCase(TRUE) == 0 || optionValue.compareToIgnoreCase(FALSE) == 0)) continue;
            throw new CommandValidationException(this.getLocalizedString("OptionIsBoolean", new Object[]{optionName}));
        }
        return true;
    }

    private boolean verifyNumberOfOperands(String numberOfOperands, int operandSize) throws CommandValidationException {
        if (numberOfOperands.matches(NUMBER_OF_OPERANDS_QUANTIFIER_REGEXP)) {
            if (numberOfOperands.equals(QUESTION_MARK) && (operandSize < 0 || operandSize > 1)) {
                throw new CommandValidationException(this.getLocalizedString("ZeroOrOneOperand", null));
            }
            if (numberOfOperands.equals(PLUS) && operandSize < 1) {
                throw new CommandValidationException(this.getLocalizedString("GreaterThanOneOperand", null));
            }
        } else if (numberOfOperands.matches(NUMBER_OF_OPERANDS_REGEXP)) {
            if (numberOfOperands.startsWith(PLUS) && Integer.parseInt(numberOfOperands.substring(1)) > operandSize) {
                throw new CommandValidationException(this.getLocalizedString("GreaterOrEqualToOperand", new Object[]{numberOfOperands.substring(1)}));
            }
            if (!numberOfOperands.startsWith(PLUS) && Integer.parseInt(numberOfOperands) == 1 && operandSize < 1) {
                throw new CommandValidationException(this.getLocalizedString("OperandIsRequired", null));
            }
            if (!numberOfOperands.startsWith(PLUS) && Integer.parseInt(numberOfOperands) != operandSize) {
                throw new CommandValidationException(this.getLocalizedString("EqualToOperand", new Object[]{numberOfOperands}));
            }
        } else if (numberOfOperands.matches(NUMBER_OF_OPERANDS_INCLUSION_REGEXP)) {
            int index = numberOfOperands.indexOf(DASH);
            int min = Integer.parseInt(numberOfOperands.substring(0, index));
            int max = Integer.parseInt(numberOfOperands.substring(index + 1));
            if (min > operandSize || max < operandSize) {
                throw new CommandValidationException(this.getLocalizedString("BetweenNumberOperand", new Object[]{String.valueOf(min), String.valueOf(max)}));
            }
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidSytanxForNumberOfOperands", new Object[]{numberOfOperands}));
        }
        return true;
    }

    private String getLocalizedString(String key, Object[] toInsert) {
        try {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            if (toInsert == null) {
                return lsm.getString(key);
            }
            return lsm.getString(key, toInsert);
        }
        catch (CommandValidationException cve) {
            return "Key not found";
        }
    }
}

