/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.HTTPServiceMonitor;
import com.sun.appserv.management.monitor.KeepAliveMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.statistics.KeepAliveStats;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Timer;

public class KeepAliveMonitorTask
extends MonitorTask {
    private final String displayFormat = "%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s %6$-8s %7$-8s";

    public KeepAliveMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        String keepAliveTitle = localStrings.getString("commands.monitor.keep_alive_monitoring");
        String title = String.format("%1$40s", keepAliveTitle);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        HTTPServiceMonitor httpserviceMonitor = this.srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        KeepAliveMonitor keepAliveMonitor = httpserviceMonitor.getKeepAliveMonitor();
        if (keepAliveMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        KeepAliveStats keepAliveStats = keepAliveMonitor.getKeepAliveStats();
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(keepAliveStats);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private void displayHeader() {
        String cc = localStrings.getString("commands.monitor.cc");
        String cf = localStrings.getString("commands.monitor.cf");
        String ch = localStrings.getString("commands.monitor.ch");
        String cr = localStrings.getString("commands.monitor.cr");
        String cto = localStrings.getString("commands.monitor.cto");
        String mc = localStrings.getString("commands.monitor.mc");
        String sto = localStrings.getString("commands.monitor.sto");
        String header = String.format("%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s %6$-8s %7$-8s", cc, cf, ch, cr, cto, mc, sto);
        CLILogger.getInstance().printMessage(header);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.monitor.keep_alive_write_to_file"));
        }
    }

    private void displayData(KeepAliveStats kas) {
        String data = String.format("%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s %6$-8s %7$-8s", kas.getCountConnections().getCount(), kas.getCountFlushes().getCount(), kas.getCountHits().getCount(), kas.getCountRefusals().getCount(), kas.getCountTimeouts().getCount(), kas.getMaxConnections().getCount(), kas.getSecondsTimeouts().getCount());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s", kas.getCountConnections().getCount(), kas.getCountFlushes().getCount(), kas.getCountHits().getCount(), kas.getCountRefusals().getCount(), kas.getCountTimeouts().getCount(), kas.getMaxConnections().getCount(), kas.getSecondsTimeouts().getCount());
            this.writeToFile(fileData);
        }
    }

    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.keep_alive_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

