/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class ListSecurityMapCommand
extends GenericCommand {
    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation failed");
        }
        String objectName = this.getObjectName();
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        String[] map2 = null;
        String[] principals = null;
        String[] usergroups = null;
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        try {
            ArrayList list = (ArrayList)mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            for (String[] map2 : list) {
                int i;
                CLILogger.getInstance().printMessage(" ====================================");
                CLILogger.getInstance().printMessage(" Security Map Name is :" + map2[0]);
                CLILogger.getInstance().printMessage(" =====================================");
                if (map2[1] != null) {
                    principals = this.getOptionsList(map2[1]);
                }
                if (map2[2] != null) {
                    usergroups = this.getOptionsList(map2[2]);
                }
                if (principals != null) {
                    CLILogger.getInstance().printMessage("Principals for Security Map :" + map2[0] + "  are :");
                    for (i = 0; i < principals.length; ++i) {
                        CLILogger.getInstance().printMessage("<principal>  " + principals[i]);
                    }
                }
                CLILogger.getInstance().printMessage("\n");
                if (usergroups != null) {
                    CLILogger.getInstance().printMessage("UserGroups for Security Map :" + map2[0] + "  are :");
                    for (i = 0; i < usergroups.length; ++i) {
                        CLILogger.getInstance().printMessage("<user-group>  " + usergroups[i]);
                    }
                }
                CLILogger.getInstance().printMessage("\n");
                if (map2[3] != null) {
                    String username = map2[3];
                    CLILogger.getInstance().printMessage("Backend Principal User Name for :" + map2[0] + "  is  :" + username);
                    CLILogger.getInstance().printMessage(" \n");
                }
                if (map2[4] == null) continue;
                String password = map2[4];
                CLILogger.getInstance().printMessage("Backend Principal Password for :" + map2[0] + "  is  :" + password);
                CLILogger.getInstance().printMessage("\n");
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
    }

    private String[] getOptionsList(Object sOptions) {
        StringTokenizer optionTokenizer = new StringTokenizer((String)sOptions, ",");
        int size = optionTokenizer.countTokens();
        String[] sOptionsList = new String[size];
        for (int ii = 0; ii < size; ++ii) {
            sOptionsList[ii] = optionTokenizer.nextToken();
        }
        return sOptionsList;
    }

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }
}

