/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.JBICommand;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;

public class JBILifecycleCommands
extends JBICommand {
    private static final String START_COMPONENT = "start-jbi-component";
    private static final String STOP_COMPONENT = "stop-jbi-component";
    private static final String SHUT_DOWN_COMPONENT = "shut-down-jbi-component";
    private static final String START_SERVICE_ASSEMBLY = "start-jbi-service-assembly";
    private static final String STOP_SERVICE_ASSEMBLY = "stop-jbi-service-assembly";
    private static final String SHUT_DOWN_SERVICE_ASSEMBLY = "shut-down-jbi-service-assembly";

    public void runCommand() throws CommandException, CommandValidationException {
        String result = "";
        String successKey = "";
        try {
            if (this.preRunInit()) {
                String targetName = this.getOption("target");
                boolean force = this.getBooleanOption("force");
                String componentName = (String)this.getOperands().get(0);
                if (this.name.equals(START_COMPONENT)) {
                    result = this.mJbiAdminCommands.startComponent(componentName, targetName);
                    successKey = "JBISuccessStartedComponent";
                } else if (this.name.equals(STOP_COMPONENT)) {
                    result = this.mJbiAdminCommands.stopComponent(componentName, targetName);
                    successKey = "JBISuccessStoppedComponent";
                } else if (this.name.equals(SHUT_DOWN_COMPONENT)) {
                    result = this.mJbiAdminCommands.shutdownComponent(componentName, force, targetName);
                    successKey = "JBISuccessShutDownComponent";
                } else if (this.name.equals(START_SERVICE_ASSEMBLY)) {
                    result = this.mJbiAdminCommands.startServiceAssembly(componentName, targetName);
                    successKey = "JBISuccessStartAssemblyComponent";
                } else if (this.name.equals(STOP_SERVICE_ASSEMBLY)) {
                    result = this.mJbiAdminCommands.stopServiceAssembly(componentName, targetName);
                    successKey = "JBISuccessStoppedAssembly";
                } else if (this.name.equals(SHUT_DOWN_SERVICE_ASSEMBLY)) {
                    result = this.mJbiAdminCommands.shutdownServiceAssembly(componentName, force, targetName);
                    successKey = "JBISuccessShutDownAssembly";
                }
            }
            this.processJBIAdminResult(result, successKey);
        }
        catch (Exception e) {
            this.processTaskException(e);
        }
    }
}

