/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;

public class GenerateJVMReportCommand
extends GenericCommand {
    private static final String SUMMARY_OPERATION = "getSummary";
    private static final String CLASS_OPERATION = "getClassInformation";
    private static final String MEMORY_OPERATION = "getMemoryInformation";
    private static final String THREADDUMP_OPERATION = "getThreadDump";
    private static final String TYPE_OPTION = "type";
    private String typeOption;

    public boolean validateOptions() throws CommandValidationException {
        if (!super.validateOptions()) {
            return false;
        }
        this.typeOption = this.getOption(TYPE_OPTION);
        if (this.typeOption.matches("summary|memory|class|thread")) {
            return true;
        }
        throw new CommandValidationException(this.getLocalizedString("InvalidTypeOption"));
    }

    protected String getOperationName() throws CommandException {
        String operationName = SUMMARY_OPERATION;
        if (this.typeOption.equals("memory")) {
            operationName = MEMORY_OPERATION;
        } else if (this.typeOption.equals("class")) {
            operationName = CLASS_OPERATION;
        } else if (this.typeOption.equals("thread")) {
            operationName = THREADDUMP_OPERATION;
        }
        return operationName;
    }

    protected void handleReturnValue(Object returnval) {
        Class<?> cl = returnval.getClass();
        if (cl.getName().equals(String.class.getName())) {
            String returnString = (String)returnval;
            CLILogger.getInstance().printMessage(returnString);
        }
    }
}

