/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv;

import com.sun.cacao.DeploymentDescriptor;
import com.sun.mfwk.CMM_MBean;
import com.sun.mfwk.MfAbstractCpModule;
import com.sun.mfwk.MfAgentNode;
import com.sun.mfwk.MfInstalledProductDelegateSupport;
import com.sun.mfwk.MfInstanceID;
import com.sun.mfwk.MfMonitoringState;
import com.sun.mfwk.MfObjectFactory;
import com.sun.mfwk.MfStatesManager;
import com.sun.mfwk.agent.appserv.ASServerManager;
import com.sun.mfwk.agent.appserv.ASServerManagerRegistry;
import com.sun.mfwk.agent.appserv.connection.ConnectionRegistry;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import com.sun.mfwk.agent.appserv.modeler.MBeanModeler;
import com.sun.mfwk.discovery.MfDiscoveryInfo;
import com.sun.mfwk.discovery.MfDiscoveryService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ASModule
extends MfAbstractCpModule
implements NotificationListener {
    private String sourceClass = ASModule.class.getName();

    public ASModule(DeploymentDescriptor descriptor) {
        super(descriptor);
        this.logger.entering(this.sourceClass, "Constructor", new Object[]{descriptor});
        this.logger.exiting(this.sourceClass, "Constructor finish");
    }

    public void initialize() throws Exception {
        this.logger.entering(this.sourceClass, "initialize");
        try {
            Properties properties = this.descriptor.getParameters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addDiscoveryListener();
        this.logger.exiting(this.sourceClass, "initialize");
    }

    public void start() {
        this.logger.entering(this.sourceClass, "start", this.moduleName);
        try {
            Map delegateMap = MBeanModeler.getDelegateMap();
            delegateMap.put("CMM_InstalledProduct", MfInstalledProductDelegateSupport.class);
            this.logger.fine(this.sourceClass + " Creates the ObjectFactory for " + this.moduleName);
            this.objectFactory = MfObjectFactory.getObjectFactory((String)this.moduleName);
            this.logger.fine(this.sourceClass + " Creates the delegateFactory for " + this.moduleName);
            this.delegateFactory = this.objectFactory.getDelegateFactory(delegateMap);
            this.logger.fine(this.sourceClass + " Creates the CMM_InstalledProduct");
            String installedProductInstanceId = this.moduleName + ":" + "type=CMM_InstalledProduct," + "name=" + this.productName + ",collectionID=" + ObjectName.quote(this.installedLocation);
            installedProductInstanceId = MfInstanceID.getInstanceID((String)installedProductInstanceId).getCanonicalName();
            this.installedProduct = this.objectFactory.createObject(installedProductInstanceId);
            this.delegateFactory.createDelegate(this.descriptor, this.installedProduct);
            MfAgentNode.createRelationsWithAgent((String)this.moduleName, (CMM_MBean)this.installedProduct);
            this.logger.fine(this.sourceClass + " Initialize the module " + this.moduleName);
            this.initialize();
            this.logger.exiting(this.sourceClass, "start", this.moduleName);
        }
        catch (Exception ex) {
            this.logger.throwing(this.sourceClass, "Start failed for module = " + this.moduleName, ex);
            return;
        }
    }

    public void finalize() throws Exception {
        this.logger.entering(this.sourceClass, "finalize");
        this.logger.exiting(this.sourceClass, "finalize");
    }

    private void addDiscoveryListener() {
        try {
            this.logger.log(Level.FINE, "Adding Discovery Listener for Application Server");
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("ApplicationServer");
            ObjectName dson = new ObjectName("com.sun.mfwk:type=mfDiscoveryService");
            this.getMbs().addNotificationListener(dson, this, (NotificationFilter)filter, null);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unable to register listener for discovery.", e);
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        try {
            this.logger.info("**Discovered new Application Server Instance**");
            LogDomains.setLogger(this.logger);
            String type = notification.getType();
            if (!MfDiscoveryService.objectName.equals(notification.getSource())) {
                return;
            }
            MfDiscoveryInfo msg = null;
            if (notification.getUserData() != null) {
                msg = (MfDiscoveryInfo)notification.getUserData();
                Map map = this.deserializeUserData(msg.getUserData());
                map.put("uri", msg.getUri());
                String domainName = (String)map.get("domain");
                Boolean isDAS = (Boolean)map.get("isDAS");
                String instanceName = (String)map.get("com.sun.aas.instanceName");
                ASServerManagerRegistry serverManagerRegistry = ASServerManagerRegistry.getInstance();
                serverManagerRegistry.addASServerManager(this.moduleName, instanceName, domainName);
                ASServerManager sManager = serverManagerRegistry.getASServerManager(instanceName, domainName);
                if (msg.getMessageType() == 12) {
                    this.logger.finest("DISCOVERY HELLO message");
                    ConnectionRegistry reg = ConnectionRegistry.getInstance();
                    reg.setConnectionCredentials(instanceName, domainName, map);
                    sManager.start();
                    this.logger.log(Level.INFO, "Set states of all objects to " + MfStatesManager.STATE_INITIALIZED);
                    MfStatesManager.setState((int)MfStatesManager.STATE_INITIALIZED);
                    this.delegateFactory.setMonitoringStates(MfMonitoringState.STATE_INITIALIZED);
                    MfStatesManager.setState((int)MfStatesManager.STATE_STEADY);
                }
                if (msg.getMessageType() == 13) {
                    this.logger.finest("DISCOVERY LEAVE message");
                    sManager.stop();
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error in discovery event handling", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map deserializeUserData(byte[] data) throws ClassNotFoundException, IOException {
        Map map = null;
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(data);
            ois = new ObjectInputStream(bais);
            map = (Map)ois.readObject();
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e) {}
        }
        return map;
    }
}

