/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DOMUtil {
    public static final DOMUtil UTIL = new DOMUtil();

    public Element getElement(Document aParentDocument, String aTagName) {
        NodeList nodeList = aParentDocument.getElementsByTagName(aTagName);
        return nodeList != null ? (Element)nodeList.item(0) : null;
    }

    public Element getElement(Element elem, String tagName) {
        NodeList nl = elem.getElementsByTagName(tagName);
        Element childElem = (Element)nl.item(0);
        return childElem;
    }

    public String getElementValue(Document doc, String elemName) {
        String elemVal = null;
        Element elem = this.getElement(doc, elemName);
        elemVal = this.getTextData(elem);
        return elemVal;
    }

    private Text getText(Element aElement) {
        Node node = null;
        aElement.normalize();
        node = aElement.getFirstChild();
        if (node == null || !(node instanceof Text)) {
            node = aElement.getOwnerDocument().createTextNode("");
            aElement.appendChild(node);
        }
        return (Text)node;
    }

    public void setTextData(Element aElement, String aData) {
        this.getText(aElement).setData(aData);
    }

    public String getTextData(Element aElement) {
        return this.getText(aElement).getData();
    }

    public String DOM2String(Document aDocument, Writer aWriter) throws Exception {
        Transformer transformer2;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer2 = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            Object transformer2 = null;
            throw e;
        }
        transformer2.setOutputProperty("method", "xml");
        transformer2.setOutputProperty("omit-xml-declaration", "no");
        transformer2.setOutputProperty("standalone", "yes");
        transformer2.setOutputProperty("cdata-section-elements", "");
        transformer2.setOutputProperty("indent", "no");
        transformer2.transform(new DOMSource(aDocument), new StreamResult(aWriter));
        return aWriter.toString();
    }

    public NodeList getElements(Element aParentElement, String aTagName) {
        return aParentElement.getElementsByTagNameNS(aParentElement.getNamespaceURI(), aTagName);
    }

    public NodeList getElements(Document aParentDocument, String aTagName) {
        return aParentDocument.getElementsByTagNameNS("*", aTagName);
    }

    public NodeList getChildElements(Element aElement, String aElementTagName) {
        NodeList nodeList = aElement.getChildNodes();
        NodeListImpl list = new NodeListImpl();
        int count = nodeList.getLength();
        for (int i = 0; i < count; ++i) {
            String tagName;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(tagName = this.getElementName((Element)node)).equals(aElementTagName)) continue;
            list.add(node);
        }
        return list;
    }

    public Element getChildElement(Element aElement, String aElementTagName) {
        NodeList list = this.getChildElements(aElement, aElementTagName);
        if (list != null && list.getLength() > 0) {
            return (Element)list.item(0);
        }
        return null;
    }

    public String getElementName(Element aElement) {
        String tagName = aElement.getTagName();
        return this.getName(tagName);
    }

    public String getName(String aName) {
        int lastIdx = aName.lastIndexOf(58);
        if (lastIdx >= 0) {
            return aName.substring(lastIdx + 1);
        }
        return aName;
    }

    public Document buildDOMDocument(String xmlText) throws Exception {
        StringReader reader = new StringReader(xmlText);
        return UTIL.buildDOMDocument(reader);
    }

    public Document buildDOMDocument(Reader xmlReader) throws Exception {
        Document xmlDoc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        docBuilder.setErrorHandler(new DefaultHandler(){

            public void fatalError(SAXParseException e) throws SAXException {
                throw new SAXException(e.getMessage());
            }
        });
        InputSource is = new InputSource(xmlReader);
        xmlDoc = docBuilder.parse(is);
        return xmlDoc;
    }

    public static String replaceXmlEscapeCharsToEntityRefereces(String xmlString) {
        if (xmlString == null) {
            return xmlString;
        }
        StringBuffer sbuff = new StringBuffer(2 * xmlString.length());
        block5: for (int i = 0; i < xmlString.length(); ++i) {
            switch (xmlString.charAt(i)) {
                case '&': {
                    sbuff.append("&amp;");
                    continue block5;
                }
                case '<': {
                    sbuff.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sbuff.append("&gt;");
                    continue block5;
                }
                default: {
                    sbuff.append(xmlString.charAt(i));
                }
            }
        }
        return sbuff.toString();
    }

    public static String replaceXmlEntityReferecesToEscapeChars(String xmlString) {
        if (xmlString == null) {
            return xmlString;
        }
        String[] entities = new String[]{"&lt;", "&gt;", "&amp;"};
        char[] escapeChar = new char[]{'<', '>', '&'};
        StringBuffer sbuff = new StringBuffer(xmlString.length());
        for (int i = 0; i < xmlString.length(); ++i) {
            int eIdx;
            char ch = xmlString.charAt(i);
            if (ch != '&') {
                sbuff.append(ch);
                continue;
            }
            String what = null;
            boolean found = false;
            for (eIdx = 0; eIdx < entities.length && !(found = xmlString.startsWith(what = entities[eIdx], i)); ++eIdx) {
            }
            if (!found) continue;
            sbuff.append(escapeChar[eIdx]);
            i += what.length() - 1;
        }
        return sbuff.toString();
    }

    public static class NodeListImpl
    extends ArrayList
    implements NodeList {
        public int getLength() {
            return this.size();
        }

        public Node item(int aIndex) {
            return (Node)this.get(aIndex);
        }
    }
}

