/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class FileHelper {
    private static boolean sMemoryCleaned = false;
    private static final int BLOCK_SIZE = 8192;
    private static final String FINGERPRINT_ALG = "SHA-256";
    static char[] b32Chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static boolean fileCopy(String source, String destination) throws IOException {
        File sourceFile = new File(source);
        File destFile = new File(destination);
        if (!destFile.exists()) {
            int read;
            byte[] buf = new byte[8192];
            FileInputStream fis = new FileInputStream(sourceFile);
            FileOutputStream fos = new FileOutputStream(destFile);
            do {
                if ((read = fis.read(buf, 0, buf.length)) <= 0) continue;
                fos.write(buf, 0, read);
            } while (read >= buf.length);
            fis.close();
            fos.close();
            return true;
        }
        return false;
    }

    public static String fileFingerprint(File file) throws IOException {
        byte[] buffer = new byte[8192];
        try {
            int bytes;
            MessageDigest md = MessageDigest.getInstance(FINGERPRINT_ALG);
            DigestInputStream dis = new DigestInputStream(new FileInputStream(file), md);
            while ((bytes = dis.read(buffer, 0, buffer.length)) > 0) {
            }
            byte[] digest = md.digest();
            int dlen = digest.length / 2;
            for (int i = 0; i < dlen; i += 2) {
                int n = i;
                digest[n] = (byte)(digest[n] ^ digest[i + dlen]);
            }
            return FileHelper.encode(digest, dlen);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    private static String encode(byte[] bytes, int len) {
        StringBuilder sb = new StringBuilder((len * 8 + 4) / 5);
        int pad = len * 8 % 5;
        int bitCount = 8 - pad;
        int bits = bytes[0] & 0xFF;
        if (pad != 0) {
            sb.append(b32Chars[bits >> 5 & (1 << pad) - 1]);
        }
        int i = 1;
        while (true) {
            if (bitCount < 5) {
                if (i >= len) break;
                bitCount += 8;
                bits = (bits << 8) + (bytes[i++] & 0xFF);
            }
            sb.append(b32Chars[bits >> (bitCount -= 5) & 0x1F]);
        }
        return sb.toString();
    }

    public static boolean createFile(File file) {
        if (file.exists()) {
            return true;
        }
        try {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
            return true;
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            return false;
        }
    }

    public static boolean createFolder(File folder) {
        if (folder.exists()) {
            return true;
        }
        if (folder.getParentFile() != null && !folder.getParentFile().exists()) {
            folder.getParentFile().mkdirs();
        }
        return folder.mkdir();
    }

    public static boolean cleanDirectory(File dir) {
        File[] tmps = dir.listFiles();
        for (int i = 0; i < tmps.length; ++i) {
            if (tmps[i].isDirectory() && !FileHelper.cleanDirectory(tmps[i])) {
                return false;
            }
            if (tmps[i].delete()) continue;
            if (!sMemoryCleaned) {
                FileHelper.finalizeDiscardedObjects();
                sMemoryCleaned = true;
            }
            if (tmps[i].delete()) continue;
            return false;
        }
        return true;
    }

    public static void finalizeDiscardedObjects() {
        System.gc();
        System.runFinalization();
    }

    public static boolean areFilesIdentical(File f1, File f2) throws IOException {
        int BLOCK_SIZE = 65536;
        byte[] bufF1 = new byte[BLOCK_SIZE];
        byte[] bufF2 = new byte[BLOCK_SIZE];
        boolean match = false;
        if (f1.length() == f2.length()) {
            FileInputStream inputStreamF1 = new FileInputStream(f1);
            FileInputStream inputStreamF2 = new FileInputStream(f2);
            int bytesReadF1 = 0;
            int bytesReadF2 = 0;
            do {
                boolean bl = match = (bytesReadF1 = ((InputStream)inputStreamF1).read(bufF1)) == (bytesReadF2 = ((InputStream)inputStreamF2).read(bufF2)) && Arrays.equals(bufF1, bufF2);
            } while (match && bytesReadF1 > -1);
            if (inputStreamF1 != null) {
                ((InputStream)inputStreamF1).close();
            }
            if (inputStreamF2 != null) {
                ((InputStream)inputStreamF2).close();
            }
        }
        return match;
    }

    public static boolean copy(String from, String to) throws IOException {
        try {
            File sourceFile = new File(from);
            if (sourceFile != null && !sourceFile.exists()) {
                return false;
            }
            if (sourceFile.isFile()) {
                return FileHelper.fileCopy(from, to);
            }
            File destinationDir = new File(to);
            if (!destinationDir.exists() && !FileHelper.createFolder(destinationDir)) {
                return false;
            }
            File sourceDir = new File(from);
            String[] files = sourceDir.list();
            for (int i = 0; i < files.length; ++i) {
                File source = new File(sourceDir, files[i]);
                File dest = new File(destinationDir, files[i]);
                if (FileHelper.copy(source.getAbsolutePath(), dest.getAbsolutePath())) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    public static String getTimestamp() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return format.format(new Date());
    }
}

