/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.support;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.common.LoggerMBean;
import com.sun.jbi.management.config.ConfigurationBuilder;
import com.sun.jbi.management.support.DefaultLoggerMBeanImpl;
import com.sun.jbi.management.support.PersistentLoggerMBeanImpl;
import com.sun.jbi.util.EnvironmentAccess;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class MBeanHelper
implements com.sun.jbi.management.MBeanHelper {
    private final MBeanServer mMBeanServer;
    private final MBeanNames mMBeanNames;
    private Logger mLogger;
    private StringTranslator mTranslator;

    public MBeanHelper(MBeanServer aMBeanServer, MBeanNames aMBeanNames, Logger aLogger) {
        this.mMBeanServer = aMBeanServer;
        this.mMBeanNames = aMBeanNames;
        this.mLogger = aLogger;
        EnvironmentContext ctx = EnvironmentAccess.getContext();
        this.mTranslator = ctx.getStringTranslator("com.sun.jbi.management");
    }

    public boolean createSystemServiceLoggerMBean(String aService, Logger aLogger) {
        this.mLogger.fine("createSystemServiceLoggerMBean for Service=" + aService + " logger=" + aLogger.getName());
        ObjectName mbname = this.mMBeanNames.getSystemServiceLoggerMBeanName(aService, aLogger);
        if (null == mbname) {
            String statusMsg = this.mTranslator.getString("MBEAN_HELPER_FAILED_OBJECT_CREATION", aService, "Logger");
            this.mLogger.severe(statusMsg);
            return false;
        }
        PersistentLoggerMBeanImpl loggerImpl = new PersistentLoggerMBeanImpl(aLogger);
        try {
            StandardMBean mbean = new StandardMBean(loggerImpl, LoggerMBean.class);
            this.mMBeanServer.registerMBean(mbean, mbname);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createBindingLoggerMBean(String aName, String anAlias, Logger aLogger, String aDisplayName) {
        this.mLogger.fine("createBindingLoggerMBean for Binding=" + aName + " logger=" + aLogger.getName());
        ObjectName mbname = this.mMBeanNames.getBindingLoggerMBeanName(aName, aLogger);
        if (null == mbname) {
            String statusMsg = this.mTranslator.getString("MBEAN_HELPER_FAILED_OBJECT_CREATION", aName, "Logger");
            this.mLogger.warning(statusMsg);
            return false;
        }
        DefaultLoggerMBeanImpl loggerImpl = new DefaultLoggerMBeanImpl(aLogger, aDisplayName);
        try {
            StandardMBean mbean = new StandardMBean(loggerImpl, LoggerMBean.class);
            this.mMBeanServer.registerMBean(mbean, mbname);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createEngineLoggerMBean(String aName, String anAlias, Logger aLogger, String aDisplayName) {
        this.mLogger.fine("createEngineLoggerMBean for Engine=" + aName + " logger=" + aLogger.getName());
        ObjectName mbname = this.mMBeanNames.getEngineLoggerMBeanName(aName, aLogger);
        if (null == mbname) {
            String statusMsg = this.mTranslator.getString("MBEAN_HELPER_FAILED_OBJECT_CREATION", aName, "Logger");
            this.mLogger.warning(statusMsg);
            return false;
        }
        DefaultLoggerMBeanImpl loggerImpl = new DefaultLoggerMBeanImpl(aLogger, aDisplayName);
        try {
            StandardMBean mbean = new StandardMBean(loggerImpl, LoggerMBean.class);
            this.mMBeanServer.registerMBean(mbean, mbname);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean destroySystemServiceLoggerMBean(String aService) {
        this.mLogger.fine("destroySystemServiceLoggerMBean for Service=" + aService);
        ObjectName mbname = this.mMBeanNames.getSystemServiceMBeanName(aService, "Logger");
        if (null == mbname) {
            String statusMsg = this.mTranslator.getString("MBEAN_HELPER_FAILED_OBJECT_CREATION", aService, "Logger");
            this.mLogger.severe(statusMsg);
            return false;
        }
        try {
            this.mMBeanServer.unregisterMBean(mbname);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean destroySystemServiceLoggerMBean(String aService, Logger aLogger) {
        this.mLogger.fine("destroySystemServiceLoggerMBean for Service=" + aService);
        ObjectName mbname = this.mMBeanNames.getSystemServiceLoggerMBeanName(aService, aLogger);
        if (null == mbname) {
            String statusMsg = this.mTranslator.getString("MBEAN_HELPER_FAILED_OBJECT_CREATION", aService, "Logger");
            this.mLogger.severe(statusMsg);
            return false;
        }
        try {
            this.mMBeanServer.unregisterMBean(mbname);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean destroyBindingLoggerMBean(String aName, String anAlias, Logger aLogger) {
        ObjectName mbname = this.mMBeanNames.getBindingLoggerMBeanName(aName, aLogger);
        if (null == mbname) {
            String statusMsg = this.mTranslator.getString("MBEAN_HELPER_FAILED_OBJECT_CREATION", aName, "Logger");
            this.mLogger.warning(statusMsg);
            return false;
        }
        try {
            this.mMBeanServer.unregisterMBean(mbname);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean destroyEngineLoggerMBean(String aName, String anAlias, Logger aLogger) {
        ObjectName mbname = this.mMBeanNames.getEngineLoggerMBeanName(aName, aLogger);
        if (null == mbname) {
            String statusMsg = this.mTranslator.getString("MBEAN_HELPER_FAILED_OBJECT_CREATION", aName, "Logger");
            this.mLogger.warning(statusMsg);
            return false;
        }
        try {
            this.mMBeanServer.unregisterMBean(mbname);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Level getLogLevel(String attrName, EnvironmentContext envCtx) {
        MBeanNames.ServiceType svcType = MBeanNames.ServiceType.valueOf(ConfigurationCategory.Logger.toString());
        ObjectName configMBeanName = envCtx.getMBeanNames().getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(svcType));
        Level level = null;
        try {
            if (envCtx.getMBeanServer().isRegistered(configMBeanName)) {
                String attrValue = (String)envCtx.getMBeanServer().getAttribute(configMBeanName, attrName);
                if (attrValue != null) {
                    level = Level.parse(attrValue);
                }
            } else {
                Logger.getLogger("com.sun.jbi").finest("MBean " + configMBeanName + "is not registered");
            }
        }
        catch (JMException jmex) {
            Logger.getLogger("com.sun.jbi").warning(jmex.toString());
        }
        return level;
    }

    public static void setLogLevel(String logName, String logLevel, EnvironmentContext envCtx, Logger aLogger) {
        MBeanNames.ServiceType svcType = MBeanNames.ServiceType.valueOf(ConfigurationCategory.Logger.toString());
        ObjectName configMBeanName = envCtx.getMBeanNames().getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(svcType));
        try {
            if (envCtx.getMBeanServer().isRegistered(configMBeanName)) {
                Attribute attrib = new Attribute(logName, logLevel);
                envCtx.getMBeanServer().setAttribute(configMBeanName, attrib);
            } else {
                aLogger.finest("MBean " + configMBeanName + "is not registered");
            }
        }
        catch (JMException jmex) {
            aLogger.warning(jmex.toString());
        }
    }

    public static void revertToGlobalLogLevel(String logName, EnvironmentContext envCtx, Logger aLogger) {
        MBeanNames.ServiceType svcType = MBeanNames.ServiceType.valueOf(ConfigurationCategory.Logger.toString());
        ObjectName configMBeanName = envCtx.getMBeanNames().getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(svcType));
        try {
            if (envCtx.getMBeanServer().isRegistered(configMBeanName)) {
                envCtx.getMBeanServer().invoke(configMBeanName, "deleteOverride", new Object[]{logName}, new String[]{"java.lang.String"});
            } else {
                aLogger.finest("MBean " + configMBeanName + "is not registered");
            }
        }
        catch (JMException jmex) {
            aLogger.warning(jmex.toString());
        }
    }
}

