/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.internal.support;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.ComponentInstallationContext;
import com.sun.jbi.util.EnvironmentAccess;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlReader
implements ErrorHandler,
EntityResolver {
    private Document mDocument = null;
    private DocumentFragment mComponentFragment = null;
    private DocumentFragment mIdentificationFragment = null;
    private boolean mErrorsFound = false;
    private boolean mSawBinding = false;
    private boolean mSawEngine = false;
    private boolean mSawDeployment = false;
    private boolean mSawLibrary = false;
    private String mSavedDescription;
    private String mSavedId;
    private Vector mSavedSharedLibraryIds;
    private Vector mSavedLifecycleClassNames;
    private Vector mSavedLifecycleClassPath;
    private String mSavedBootstrapClassName;
    private Vector mSavedBootstrapClassPath;
    private boolean mSavedBootstrapClassLoaderDelegation;
    private boolean mSavedComponentClassLoaderDelegation;
    private boolean mSavedSharedLibraryClassLoaderDelegation;
    private EnvironmentContext mEnvironmentContext = this.getEnvironmentContext();
    private static final String PATH_TO_SCHEMA_FILE = "/schemas/jbi.xsd";
    private static final String PATH_TO_MM_SCHEMA_FILE = "/schemas/managementMessage.xsd";
    private boolean mIsValidateManagementMsg = false;

    public String loadAndParse(String aFileName, boolean isOnlyIdNeeded) throws Exception {
        try {
            File configFile = new File(aFileName);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(this);
            this.mDocument = docBuilder.parse(configFile);
            if (null == this.mDocument) {
                return null;
            }
            this.mSavedId = null;
            this.jbiParse(!isOnlyIdNeeded);
            if (!isOnlyIdNeeded) {
                this.tellWhatWeFound();
            }
            return this.mSavedId;
        }
        catch (FileNotFoundException nfe) {
            throw nfe;
        }
        catch (SAXParseException spe) {
            throw spe;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public boolean validate(InputStream istr) throws Exception {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(true);
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            String jbiHome = this.mEnvironmentContext.getJbiInstallRoot();
            if (null == jbiHome || "".equals(jbiHome)) {
                return false;
            }
            jbiHome = jbiHome.replace('\\', '/');
            String schema = jbiHome + PATH_TO_SCHEMA_FILE;
            docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schema);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(this);
            docBuilder.setEntityResolver(this);
            this.mDocument = docBuilder.parse(istr);
            istr.close();
            return null != this.mDocument;
        }
        catch (SAXParseException spe) {
            throw spe;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public boolean validate(String aFileName) throws Exception {
        try {
            File configFile = new File(aFileName);
            FileInputStream config = new FileInputStream(configFile);
            return this.validate(config);
        }
        catch (FileNotFoundException nfe) {
            throw nfe;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public boolean validateManagementMessage(String aMMsgStr) throws Exception {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            this.mIsValidateManagementMsg = true;
            docBuilderFactory.setValidating(true);
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            String jbiHome = this.mEnvironmentContext.getJbiInstallRoot();
            if (null == jbiHome || "".equals(jbiHome)) {
                return false;
            }
            jbiHome = jbiHome.replace('\\', '/');
            String schema = jbiHome + PATH_TO_MM_SCHEMA_FILE;
            docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schema);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(this);
            docBuilder.setEntityResolver(this);
            InputSource isrc = new InputSource(new CharArrayReader(aMMsgStr.toCharArray()));
            this.mDocument = docBuilder.parse(isrc);
            return null != this.mDocument;
        }
        catch (FileNotFoundException nfe) {
            throw nfe;
        }
        catch (SAXParseException spe) {
            throw spe;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void error(SAXParseException aSaxException) throws SAXException {
        throw aSaxException;
    }

    public void fatalError(SAXParseException aSaxException) throws SAXException {
        throw aSaxException;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource mIpSrc = null;
        String jbiHome = this.mEnvironmentContext.getJbiInstallRoot();
        if (null == jbiHome || "".equals(jbiHome)) {
            return mIpSrc;
        }
        jbiHome = jbiHome.replace('\\', '/');
        try {
            mIpSrc = this.mIsValidateManagementMsg ? new InputSource(new FileInputStream(new File(jbiHome + PATH_TO_MM_SCHEMA_FILE))) : new InputSource(new FileInputStream(new File(jbiHome + PATH_TO_SCHEMA_FILE)));
        }
        catch (FileNotFoundException nfe) {
            // empty catch block
        }
        return mIpSrc;
    }

    public void warning(SAXParseException aSaxException) throws SAXException {
        throw aSaxException;
    }

    void jbiParse(boolean isRegressTest) {
        block33: {
            String type = null;
            this.mSavedId = null;
            this.mSavedDescription = null;
            this.mSavedBootstrapClassName = null;
            this.mSavedBootstrapClassPath = null;
            this.mSavedLifecycleClassNames = null;
            this.mSavedLifecycleClassPath = null;
            this.mSavedSharedLibraryIds = null;
            this.mSawBinding = false;
            this.mSawEngine = false;
            this.mSawDeployment = false;
            this.mSawLibrary = false;
            this.mComponentFragment = null;
            this.mIdentificationFragment = null;
            this.mSavedBootstrapClassLoaderDelegation = false;
            this.mSavedComponentClassLoaderDelegation = false;
            this.mSavedSharedLibraryClassLoaderDelegation = false;
            try {
                if (null != this.strip(XPathAPI.selectNodeList(this.mDocument, "jbi/component"))) {
                    Node typeNode;
                    String nn;
                    Element elem;
                    Node n;
                    int i;
                    this.mSavedId = this.stripString("jbi/component/identification/name");
                    this.mSavedDescription = this.stripString("jbi/component/identification/description");
                    this.mSavedLifecycleClassNames = this.stripArray("jbi/component/component-class-name");
                    this.mSavedLifecycleClassPath = this.stripArray("jbi/component/component-class-path/path-element");
                    this.mSavedBootstrapClassName = this.stripString("jbi/component/bootstrap-class-name");
                    this.mSavedBootstrapClassPath = this.stripArray("jbi/component/bootstrap-class-path/path-element");
                    this.mSavedSharedLibraryIds = this.stripArray("jbi/component/shared-library");
                    NodeList componentTree = XPathAPI.selectNodeList(this.mDocument, "jbi/component");
                    if (null != componentTree.item(0)) {
                        NodeList nl = componentTree.item(0).getChildNodes();
                        boolean foundBootstrap = false;
                        for (i = 0; i < nl.getLength(); ++i) {
                            n = nl.item(i);
                            if (n.getNodeType() != 1) continue;
                            elem = (Element)n;
                            nn = elem.getTagName();
                            if (!foundBootstrap) {
                                foundBootstrap = "bootstrap-class-path".equals(nn);
                                continue;
                            }
                            if ("shared-library".equals(nn)) continue;
                            if (null == this.mComponentFragment) {
                                this.mComponentFragment = this.mDocument.createDocumentFragment();
                            }
                            this.mComponentFragment.appendChild(n);
                        }
                    }
                    if (null != (typeNode = componentTree.item(0).getAttributes().getNamedItem("bootstrap-class-loader-delegation"))) {
                        type = typeNode.getNodeValue();
                        this.mSavedBootstrapClassLoaderDelegation = "self-first".equals(type);
                        type = null;
                    }
                    if (null != (typeNode = componentTree.item(0).getAttributes().getNamedItem("component-class-loader-delegation"))) {
                        type = typeNode.getNodeValue();
                        this.mSavedComponentClassLoaderDelegation = "self-first".equals(type);
                        type = null;
                    }
                    if (null != (typeNode = componentTree.item(0).getAttributes().getNamedItem("type"))) {
                        type = typeNode.getNodeValue();
                    }
                    if ("binding-component".equals(type)) {
                        this.mSawBinding = true;
                    } else if ("service-engine".equals(type)) {
                        this.mSawEngine = true;
                    } else {
                        if (isRegressTest) {
                            System.out.println("Invalid Component subtype: " + type);
                        }
                        this.mSavedId = null;
                    }
                    componentTree = XPathAPI.selectNodeList(this.mDocument, "jbi/component/identification");
                    if (null != componentTree.item(0)) {
                        NodeList nl = componentTree.item(0).getChildNodes();
                        for (i = 0; i < nl.getLength(); ++i) {
                            n = nl.item(i);
                            if (n.getNodeType() != 1 || "name".equals(nn = (elem = (Element)n).getTagName()) || "description".equals(nn)) continue;
                            if (null == this.mIdentificationFragment) {
                                this.mIdentificationFragment = this.mDocument.createDocumentFragment();
                            }
                            this.mIdentificationFragment.appendChild(n);
                        }
                    }
                } else if (null != this.strip(XPathAPI.selectNodeList(this.mDocument, "jbi/service-assembly"))) {
                    this.mSawDeployment = true;
                    this.mSavedId = this.stripString("jbi/service-assembly/identification/component-name");
                    this.mSavedDescription = this.stripString("jbi/service-assembly/identification/description");
                    NodeList componentTree = XPathAPI.selectNodeList(this.mDocument, "jbi/service-assembly/identification");
                    if (null != componentTree.item(0)) {
                        NodeList nl = componentTree.item(0).getChildNodes();
                        for (int i = 0; i < nl.getLength(); ++i) {
                            Element elem;
                            String nn;
                            Node n = nl.item(i);
                            if (n.getNodeType() != 1 || "name".equals(nn = (elem = (Element)n).getTagName()) || "description".equals(nn)) continue;
                            if (null == this.mIdentificationFragment) {
                                this.mIdentificationFragment = this.mDocument.createDocumentFragment();
                            }
                            this.mIdentificationFragment.appendChild(n);
                        }
                    }
                } else if (null != this.strip(XPathAPI.selectNodeList(this.mDocument, "jbi/shared-library"))) {
                    this.mSawLibrary = true;
                    this.mSavedId = this.stripString("jbi/shared-library/identification/name");
                    this.mSavedDescription = this.stripString("jbi/shared-library/identification/description");
                    this.mSavedLifecycleClassPath = this.stripArray("jbi/shared-library/shared-library-class-path/path-element");
                    NodeList componentTree = XPathAPI.selectNodeList(this.mDocument, "jbi/shared-library");
                    Node typeNode = componentTree.item(0).getAttributes().getNamedItem("class-loader-delegation");
                    if (null != typeNode) {
                        type = typeNode.getNodeValue();
                        this.mSavedSharedLibraryClassLoaderDelegation = "self-first".equals(type);
                    }
                    if (null != (componentTree = XPathAPI.selectNodeList(this.mDocument, "jbi/shared-library/identification")).item(0)) {
                        NodeList nl = componentTree.item(0).getChildNodes();
                        for (int i = 0; i < nl.getLength(); ++i) {
                            Element elem;
                            String nn;
                            Node n = nl.item(i);
                            if (n.getNodeType() != 1 || "name".equals(nn = (elem = (Element)n).getTagName()) || "description".equals(nn)) continue;
                            if (null == this.mIdentificationFragment) {
                                this.mIdentificationFragment = this.mDocument.createDocumentFragment();
                            }
                            this.mIdentificationFragment.appendChild(n);
                        }
                    }
                } else if (isRegressTest) {
                    System.out.println("Invalid Component type.");
                }
            }
            catch (TransformerException te) {
                if (isRegressTest) {
                    System.out.println("Unexpected Exception: " + te.toString());
                }
            }
            catch (Throwable t) {
                if (!isRegressTest) break block33;
                System.out.println("Unexpected Exception: " + t.getClass().getName());
                t.printStackTrace();
            }
        }
    }

    void tellWhatWeFound() {
        boolean totalMatches = false;
        String type = null;
        try {
            if (null != this.strip(XPathAPI.selectNodeList(this.mDocument, "jbi/component"))) {
                NodeList componentTree = XPathAPI.selectNodeList(this.mDocument, "jbi/component");
                Node typeNode = componentTree.item(0).getAttributes().getNamedItem("type");
                if (null != typeNode) {
                    type = typeNode.getNodeValue();
                }
            } else {
                type = null != this.strip(XPathAPI.selectNodeList(this.mDocument, "jbi/service-assembly")) ? "service-assembly" : (null != this.strip(XPathAPI.selectNodeList(this.mDocument, "jbi/shared-library")) ? "shared-library" : "invalid");
            }
        }
        catch (TransformerException te) {
            System.out.println("Unexpected Exception: " + te.toString());
        }
        if (this.mSawEngine || this.mSawBinding) {
            System.out.println("JBI Type:" + type);
            System.out.println("COMPONENT CLASS LOADER DELEGATION: " + this.delegationToString(this.mSavedComponentClassLoaderDelegation));
            System.out.println("BOOTSTRAP CLASS LOADER DELEGATION: " + this.delegationToString(this.mSavedBootstrapClassLoaderDelegation));
            System.out.println("ID: " + this.mSavedId);
            System.out.println("DESCRIPTION: " + this.getDescription());
            System.out.println("COMPONENT CLASS: " + this.mSavedLifecycleClassNames);
            System.out.println("COMPONENT CLASSPATH: " + this.mSavedLifecycleClassPath);
            System.out.println("BOOTSTRAP CLASS: " + this.mSavedBootstrapClassName);
            System.out.println("BOOTSTRAP CLASSPATH: " + this.mSavedBootstrapClassPath);
            System.out.println("SHARED LIBRARY ID:" + this.mSavedSharedLibraryIds);
            if (null != this.mComponentFragment) {
                System.out.println("COMPONENT DOCUMENT FRAGMENT:" + this.documentFragmentToString(this.mComponentFragment));
            }
            if (null != this.mIdentificationFragment) {
                System.out.println("IDENTIFICATION DOCUMENT FRAGMENT:" + this.documentFragmentToString(this.mIdentificationFragment));
            }
        } else if (this.mSawDeployment) {
            System.out.println("JBI Type:" + type);
            System.out.println("ID: " + this.mSavedId);
            System.out.println("DESCRIPTION: " + this.getDescription());
            if (null != this.mIdentificationFragment) {
                System.out.println("IDENTIFICATION DOCUMENT FRAGMENT:" + this.documentFragmentToString(this.mIdentificationFragment));
            }
        } else if (this.mSawLibrary) {
            System.out.println("JBI Type:" + type);
            System.out.println("CLASS LOADER DELEGATION: " + this.delegationToString(this.mSavedSharedLibraryClassLoaderDelegation));
            System.out.println("ID: " + this.mSavedId);
            System.out.println("DESCRIPTION: " + this.getDescription());
            System.out.println("COMPONENT CLASSPATH: " + this.mSavedLifecycleClassPath);
            if (null != this.mIdentificationFragment) {
                System.out.println("IDENTIFICATION DOCUMENT FRAGMENT:" + this.documentFragmentToString(this.mIdentificationFragment));
            }
        } else {
            System.out.println("VALIDATION ERROR.");
        }
    }

    public boolean isBinding() {
        return this.mSawBinding;
    }

    public boolean isEngine() {
        return this.mSawEngine;
    }

    public boolean isDeployment() {
        return this.mSawDeployment;
    }

    public boolean isSharedLibrary() {
        return this.mSawLibrary;
    }

    public String getDescription() {
        return this.mSavedDescription;
    }

    public String getId() {
        return this.mSavedId;
    }

    public String getBootstrapClassName() {
        return this.mSavedBootstrapClassName;
    }

    public Vector getBootstrapClassPath() {
        return this.mSavedBootstrapClassPath;
    }

    public Vector getLifecycleClassNames() {
        return this.mSavedLifecycleClassNames;
    }

    public Vector getLifecycleClassPath() {
        return this.mSavedLifecycleClassPath;
    }

    public Vector getSharedLibraryIds() {
        return this.mSavedSharedLibraryIds;
    }

    public ComponentInstallationContext getInstallationContext() {
        String className = null;
        if (null != this.mSavedLifecycleClassNames && this.mSavedLifecycleClassNames.size() > 0) {
            className = (String)this.mSavedLifecycleClassNames.get(0);
        }
        ComponentInstallationContext ic = new ComponentInstallationContext(this.mSavedId, this.mSawBinding ? 1 : 2, className, this.mSavedLifecycleClassPath, this.mComponentFragment);
        ic.setDescription(this.mSavedDescription);
        if (this.isAlternateBootstrapClassLoaderDelegation()) {
            ic.setBootstrapClassLoaderSelfFirst();
        }
        if (this.isAlternateComponentClassLoaderDelegation()) {
            ic.setComponentClassLoaderSelfFirst();
        }
        return ic;
    }

    public boolean isAlternateBootstrapClassLoaderDelegation() {
        return this.mSavedBootstrapClassLoaderDelegation;
    }

    public boolean isAlternateComponentClassLoaderDelegation() {
        return this.mSavedComponentClassLoaderDelegation;
    }

    public boolean isAlternateSharedLibraryClassLoaderDelegation() {
        return this.mSavedSharedLibraryClassLoaderDelegation;
    }

    public void setEnvironmentContext(EnvironmentContext aContext) {
        this.mEnvironmentContext = aContext;
    }

    public Document getXmlDocument() {
        return this.mDocument;
    }

    public DocumentFragment getComponentDocumentFragment() {
        return this.mComponentFragment;
    }

    public DocumentFragment getIdentificationDocumentFragment() {
        return this.mIdentificationFragment;
    }

    Vector stripArray(NodeList aNodeList) {
        Vector<String> elements = new Vector<String>();
        for (int j = 0; j < aNodeList.getLength(); ++j) {
            String theData;
            Text text = (Text)aNodeList.item(j).getFirstChild();
            if (null == text || null == (theData = text.getData())) continue;
            elements.addElement(theData.trim());
        }
        return elements;
    }

    String strip(NodeList aNodeList) {
        if (aNodeList == null) {
            return null;
        }
        if (aNodeList.getLength() == 1) {
            Text text = (Text)aNodeList.item(0).getFirstChild();
            if (null == text) {
                return null;
            }
            String theData = text.getData();
            if (null == theData) {
                return null;
            }
            return theData.trim();
        }
        return null;
    }

    String stripString(String anXpath) throws TransformerException {
        return this.strip(XPathAPI.selectNodeList(this.mDocument, anXpath));
    }

    Vector stripArray(String anXpath) throws TransformerException {
        return this.stripArray(XPathAPI.selectNodeList(this.mDocument, anXpath));
    }

    private String delegationToString(boolean aDelegation) {
        if (aDelegation) {
            return "self-first";
        }
        return "parent-first";
    }

    private String documentFragmentToString(DocumentFragment aDocumentFragment) {
        return this.childrenAsString(aDocumentFragment);
    }

    private String nodeToString(Node aNode) {
        short type = aNode.getNodeType();
        switch (type) {
            case 9: {
                return this.documentToString((Document)aNode);
            }
            case 11: {
                return this.documentFragmentToString((DocumentFragment)aNode);
            }
            case 10: {
                return this.documentTypeToString((DocumentType)aNode);
            }
            case 1: {
                return this.elementToString((Element)aNode);
            }
            case 2: {
                return this.attributeToString((Attr)aNode);
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 12: {
                return this.notationToString((Notation)aNode);
            }
            case 7: {
                return this.procInstToString((ProcessingInstruction)aNode);
            }
            case 3: {
                return this.textToString((Text)aNode);
            }
            case 8: {
                return this.commentToString((Comment)aNode);
            }
            case 4: {
                return this.cDataToString((CDATASection)aNode);
            }
        }
        return null;
    }

    private String prettyPrintChildren(Node node) {
        StringBuffer sb = new StringBuffer();
        NodeList l = node.getChildNodes();
        int size = l.getLength();
        for (int i = 0; i < size; ++i) {
            Node n = l.item(i);
            if (n.getNodeType() == 3) {
                Text t = (Text)n;
                sb.append("CHILD #" + i);
                sb.append(t.getData() + "\n");
                continue;
            }
            sb.append("CHILD #" + i + "is not a Text node.\n");
            sb.append(this.nodeToString(n));
        }
        return sb.toString();
    }

    private String childrenAsString(Node aNode) {
        StringBuffer sb = new StringBuffer();
        NodeList l = aNode.getChildNodes();
        int size = l.getLength();
        for (int i = 0; i < size; ++i) {
            Node n = l.item(i);
            sb.append(this.nodeToString(n));
        }
        return sb.toString();
    }

    private String documentToString(Document aDocument) {
        return this.childrenAsString(aDocument);
    }

    private String documentTypeToString(DocumentType docType) {
        String is;
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE " + docType.getName());
        String pubID = docType.getPublicId();
        String sysID = docType.getSystemId();
        if (pubID != null) {
            sb.append(" PUBLIC " + pubID);
            if (sysID != null) {
                sb.append(" " + sysID);
            }
        } else if (sysID != null) {
            sb.append(" SYSTEM " + sysID);
        }
        if ((is = docType.getInternalSubset()) != null) {
            sb.append(" [" + is + "]");
        }
        sb.append("\n");
        return sb.toString();
    }

    private String elementToString(Element elem) {
        StringBuffer sb = new StringBuffer();
        String n = elem.getTagName();
        sb.append("<" + n);
        NamedNodeMap a = elem.getAttributes();
        for (int i = 0; i < a.getLength(); ++i) {
            Attr att = (Attr)a.item(i);
            sb.append(" ");
            sb.append(this.nodeToString(att));
        }
        if (elem.hasChildNodes()) {
            sb.append(">" + this.childrenAsString(elem));
            sb.append("</" + n + ">");
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }

    private String attributeToString(Attr anAttribute) {
        return anAttribute.getName() + "=\"" + anAttribute.getValue() + "\"";
    }

    private String notationToString(Notation notation) {
        StringBuffer sb = new StringBuffer();
        sb.append("<!NOTATION " + notation.getNodeName());
        String pubID = notation.getPublicId();
        String sysID = notation.getSystemId();
        if (pubID != null) {
            sb.append(" PUBLIC " + pubID);
            if (sysID != null) {
                sb.append(" " + sysID);
            }
        } else if (sysID != null) {
            sb.append(" SYSTEM " + sysID);
        }
        sb.append("\n");
        return sb.toString();
    }

    private String procInstToString(ProcessingInstruction pi) {
        return "<?" + pi.getTarget() + " " + pi.getData() + "?>\n";
    }

    private String textToString(Text text) {
        return text.getData();
    }

    private String cDataToString(CDATASection cdata) {
        return "<![CDATA[" + cdata.getData() + "]]>\n";
    }

    private String commentToString(Comment comment) {
        return "<!--" + comment.getData() + "-->\n";
    }

    private EnvironmentContext getEnvironmentContext() {
        if (this.mEnvironmentContext == null) {
            this.mEnvironmentContext = EnvironmentAccess.getContext();
        }
        return this.mEnvironmentContext;
    }
}

