/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.InstallationServiceMBean;
import com.sun.jbi.management.InstallerMBean;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.descriptor.ComponentDescriptor;
import com.sun.jbi.management.facade.Facade;
import com.sun.jbi.management.facade.Installer;
import com.sun.jbi.management.internal.support.DOMUtil;
import com.sun.jbi.management.internal.support.JarFactory;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.message.MessageHelper;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.data.ComponentInfoImpl;
import com.sun.jbi.management.registry.xml.GenericQueryImpl;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.repository.RepositoryException;
import com.sun.jbi.management.system.ManagementException;
import com.sun.jbi.management.util.FileHelper;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.jbi.JBIException;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallationService
extends Facade
implements InstallationServiceMBean {
    private static final String INSTALL_ROOT = "install_root";
    private static final String WORKSPACE = "workspace";
    private static final String DELETE_ME = ".DELETE_ME";
    private static final String LOGGER_CONFIG = "config";
    private static final String UPGRADE_COMPONENT = "upgradeComponent";
    private static final String METAINF = "META-INF";
    private static final String JBIXML = "jbi.xml";
    private static final String TMP_DIR = "tmp";
    private static final String SLASH = "/";

    public InstallationService(EnvironmentContext ctx, String target) throws ManagementException {
        super(ctx, target);
    }

    public ObjectName loadNewInstaller(String installZipURL) {
        boolean wasPreRegistered = false;
        ObjectName installerObjName = null;
        try {
            Archive compArchive = this.validateArchive(installZipURL, ArchiveType.COMPONENT, "loadNewInstaller");
            ComponentDescriptor descr = new ComponentDescriptor(compArchive.getJbiXml());
            ComponentType compType = descr.getComponentType();
            String compName = descr.getName();
            if (this.mTarget.equals("domain")) {
                this.componentRegistrationCheck("loadNewInstaller", compName, false);
                this.addComponentToDomain("loadNewInstaller", compName, compArchive);
                installerObjName = this.registerInstallerMBean(compName, compType, "loadNewInstaller");
            } else {
                boolean isRegistered = false;
                try {
                    isRegistered = this.getGenericQuery().isComponentRegistered(compName);
                }
                catch (RegistryException rex) {
                    this.mLog.warning(rex.getMessage());
                    throw new RuntimeException(this.mMsgBuilder.buildExceptionMessage("loadNewInstaller", (Throwable)((Object)rex)));
                }
                if (!isRegistered) {
                    this.addComponentToDomain("loadNewInstaller", compName, compArchive);
                } else {
                    File newFile = new File(installZipURL);
                    File domainFile = new File(this.getRegistry().getRepository().findArchive(ArchiveType.COMPONENT, compName));
                    this.archiveEqualityCheck(newFile, domainFile, ArchiveType.COMPONENT, compName);
                    wasPreRegistered = true;
                    installZipURL = compArchive.getPath();
                }
                try {
                    installerObjName = this.loadNewInstallerForTarget(installZipURL, descr);
                }
                catch (ManagementException mex) {
                    if (!wasPreRegistered) {
                        this.removeComponentFromDomain("loadNewInstaller", compName);
                    }
                    throw new RuntimeException(mex.getMessage());
                }
            }
            return installerObjName;
        }
        catch (ManagementException mex) {
            this.mLog.warning(MessageHelper.getMsgString((Exception)((Object)mex), this.mLog.getLevel()));
            throw new RuntimeException(mex.getMessage());
        }
    }

    public ObjectName loadInstaller(String componentName) {
        try {
            this.componentRegistrationCheck("loadInstaller", componentName, true);
            ComponentType compType = null;
            try {
                compType = this.getGenericQuery().getComponentType(componentName);
            }
            catch (Exception rex) {
                this.mLog.warning(rex.getMessage());
                throw new RuntimeException(this.mMsgBuilder.buildExceptionMessage("loadInstaller", rex));
            }
            ObjectName installerObjName = this.mTarget.equals("domain") ? this.registerInstallerMBean(componentName, compType, "loadInstaller") : this.loadInstallerForTarget(componentName, compType);
            return installerObjName;
        }
        catch (ManagementException mex) {
            this.mLog.warning(MessageHelper.getMsgString((Exception)((Object)mex), this.mLog.getLevel()));
            throw new RuntimeException(mex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean unloadInstaller(String componentName, boolean isToBeDeleted) {
        ObjectName configName;
        ObjectName instName = null;
        try {
            instName = this.getRegisteredInstallerMBean(componentName);
            configName = this.getRegisteredInstallerConfigMBean(componentName);
        }
        catch (ManagementException mex) {
            this.mLog.warning(MessageHelper.getMsgString((Exception)((Object)mex), this.mLog.getLevel()));
            return false;
        }
        boolean wasUnloaded = false;
        boolean wasUnloadedFromTarget = true;
        if (this.mMBeanSvr.isRegistered(instName)) {
            if (!"domain".equals(this.mTarget)) {
                try {
                    wasUnloadedFromTarget = this.unloadInstallerFromTarget(componentName);
                }
                catch (ManagementException mex) {
                    throw new RuntimeException(mex.getMessage());
                }
            }
            try {
                this.canUninstallComponentFromDomainCheck(componentName);
            }
            catch (ManagementException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            if (wasUnloadedFromTarget) {
                try {
                    this.mMBeanSvr.unregisterMBean(instName);
                    if (this.mMBeanSvr.isRegistered(configName)) {
                        this.mMBeanSvr.unregisterMBean(configName);
                    }
                }
                catch (JMException jmex) {
                    this.mLog.warning(jmex.getMessage());
                    wasUnloaded = false;
                }
                wasUnloaded = true;
            }
            try {
                if (!isToBeDeleted) return wasUnloaded;
                return this.removeComponentFromDomain("unloadInstaller", componentName);
            }
            catch (ManagementException mex) {
                throw new RuntimeException(mex.getMessage());
            }
        }
        this.mLog.fine("Installer MBean " + instName + " not registered.");
        return wasUnloaded;
    }

    public String installSharedLibrary(String slZipURL) {
        try {
            boolean wasPreRegistered = false;
            Archive slArchive = this.validateArchive(slZipURL, ArchiveType.SHARED_LIBRARY, "installSharedLibrary");
            String slName = slArchive.getJbiXml().getSharedLibrary().getIdentification().getName();
            if (this.mTarget.equals("domain")) {
                this.sharedLibraryRegistrationCheck("installSharedLibrary", slName, false);
                this.addSharedLibraryToDomain("installSharedLibrary", slName, slArchive);
            } else {
                boolean isRegistered = false;
                boolean isSystemLibrary = false;
                try {
                    isRegistered = this.getGenericQuery().isSharedLibraryRegistered(slName);
                }
                catch (RegistryException rex) {
                    this.mLog.warning(rex.getMessage());
                    throw new RuntimeException(this.mMsgBuilder.buildExceptionMessage("installSharedLibrary", (Throwable)((Object)rex)));
                }
                if (!isRegistered) {
                    this.addSharedLibraryToDomain("installSharedLibrary", slName, slArchive);
                } else {
                    File newFile = new File(slZipURL);
                    File domainFile = new File(this.getRegistry().getRepository().findArchive(ArchiveType.SHARED_LIBRARY, slName));
                    this.archiveEqualityCheck(newFile, domainFile, ArchiveType.SHARED_LIBRARY, slName);
                    wasPreRegistered = true;
                }
                try {
                    String path = this.getRegistry().getRepository().findArchive(ArchiveType.SHARED_LIBRARY, slName);
                    this.mLog.fine("Installing shared library " + path + " to target " + this.mTarget);
                    this.installSharedLibraryToTarget(slName, path);
                }
                catch (ManagementException mex) {
                    if (!wasPreRegistered) {
                        this.removeSharedLibraryFromDomain("installSharedLibrary", slName);
                    }
                    throw new RuntimeException(mex.getMessage());
                }
            }
            return slName;
        }
        catch (ManagementException mex) {
            this.mLog.warning(MessageHelper.getMsgString((Exception)((Object)mex), this.mLog.getLevel()));
            throw new RuntimeException(mex.getMessage());
        }
    }

    public boolean uninstallSharedLibrary(String slName) {
        return this.uninstallSharedLibrary(slName, false);
    }

    @Override
    public ObjectName loadInstallerFromRepository(String componentName) throws JBIException {
        ObjectName facadeInstallerObjName = null;
        try {
            if ("domain".equals(this.mTarget)) {
                this.throwNotSupportedManagementException("installComponentFromRepository");
            }
            this.componentRegistrationCheck("loadNewInstaller", componentName, true);
            Archive compArchive = this.getRegistry().getRepository().getArchive(ArchiveType.COMPONENT, componentName);
            ComponentDescriptor descr = new ComponentDescriptor(compArchive.getJbiXml());
            String installZipURL = compArchive.getPath();
            this.mLog.fine("Installing component from repository " + installZipURL + " to target " + this.mTarget);
            facadeInstallerObjName = this.loadNewInstallerForTarget(installZipURL, descr);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        return facadeInstallerObjName;
    }

    @Override
    public String installSharedLibraryFromRepository(String sharedLibraryName) throws JBIException {
        try {
            if ("domain".equals(this.mTarget)) {
                this.throwNotSupportedManagementException("installSharedLibraryFromRepository");
            }
            this.sharedLibraryRegistrationCheck("installSharedLibraryFromRepository", sharedLibraryName, true);
            Archive slArchive = this.getRegistry().getRepository().getArchive(ArchiveType.SHARED_LIBRARY, sharedLibraryName);
            String slZipUrl = slArchive.getPath();
            this.mLog.fine("Installing shared library from repository " + slZipUrl + " to target " + this.mTarget);
            this.installSharedLibraryToTarget(sharedLibraryName, slZipUrl);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        return sharedLibraryName;
    }

    @Override
    public boolean uninstallSharedLibrary(String slName, boolean keep) {
        String sccsWithWarning = null;
        try {
            this.sharedLibraryRegistrationCheck("uninstallSharedLibrary", slName, true);
            if (!"domain".equals(this.mTarget)) {
                sccsWithWarning = this.uninstallSharedLibraryFromTarget(slName);
            } else if (this.isSharedLibraryInstalled(slName)) {
                String[] params = new String[]{slName};
                this.mMsgBuilder.throwManagementException("uninstallSharedLibrary", "JBI_ADMIN_SHARED_LIBRARY_INSTALLED_ON_TARGETS", params);
            }
            if (!keep) {
                this.removeSharedLibraryFromDomain("uninstallSharedLibrary", slName);
            }
            if (sccsWithWarning != null) {
                throw new RuntimeException(sccsWithWarning);
            }
            return true;
        }
        catch (ManagementException mex) {
            this.mLog.warning(MessageHelper.getMsgString((Exception)((Object)mex), this.mLog.getLevel()));
            throw new RuntimeException(mex.getMessage());
        }
    }

    @Override
    public String upgradeComponent(String componentName, String installZipURL) throws JBIException {
        this.mLog.finer("upgradeComponent in facade installation service entered");
        if (!this.mTarget.equals("domain")) {
            String message = this.mTranslator.getString("JBI_ADMIN_COMPONENT_UPGRADE_DOMAIN_TARGET_ONLY");
            this.mLog.warning(message);
            throw new JBIException(message);
        }
        try {
            this.validateComponentRegistration(componentName);
            this.validateArchive(installZipURL, ArchiveType.COMPONENT, UPGRADE_COMPONENT);
            this.validateComponentName(componentName, installZipURL);
            this.validateComponentStateInAllTargets(componentName);
        }
        catch (ManagementException mEx) {
            this.mLog.warning(mEx.getMessage());
            throw new JBIException(mEx.getMessage());
        }
        this.mLog.fine("Preconditions for upgrade are satisfied for component: " + componentName);
        String backupDir = this.mEnvCtx.getJbiInstanceRoot() + File.separator + TMP_DIR + File.separator + componentName + "_" + this.getRegistry().getGenericQuery().getComponentUpgradeNumber(componentName) + "_" + FileHelper.getTimestamp();
        String existingInstallRoot = this.getComponentInstallRoot(componentName);
        String componentRoot = new File(existingInstallRoot).getParent();
        try {
            this.updateInstallRootInDomainRepository(backupDir, componentName, installZipURL);
        }
        catch (ManagementException mEx) {
            this.mLog.warning(mEx.getMessage());
            this.restoreInstallRootInDomainRepository(componentName, backupDir, componentRoot);
            throw new JBIException(mEx.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mLog.warning(ex.getMessage());
            throw new JBIException(ex.getMessage());
        }
        List<String> updateInstances = this.getAllInstancesInstallingComponent(componentName);
        MessageBuilder.Message result = this.upgradeComponent(componentName, installZipURL, updateInstances);
        if (result.isSuccess()) {
            this.incrementComponentUpgradeNumber(componentName);
            this.mLog.info(this.mTranslator.getString("JBI_ADMIN_COMPONENT_UPGRADE_SUCCESSFUL", componentName));
            return result.getMessage();
        }
        this.restoreInstallRootInDomainRepository(componentName, backupDir, componentRoot);
        this.mLog.warning(this.mTranslator.getString("JBI_ADMIN_COMPONENT_UPGRADE_FAILED", componentName));
        throw new JBIException(result.getMessage());
    }

    private ObjectName registerInstallerMBean(String componentName, ComponentType type, String taskId) throws ManagementException {
        return this.registerInstallerMBean(componentName, type, taskId, null);
    }

    private ObjectName registerInstallerMBean(String componentName, ComponentType type, String taskId, HashMap instanceInstMBeans) throws ManagementException {
        try {
            ObjectName instName = null;
            if (ComponentType.BINDING.equals((Object)type)) {
                instName = this.mMBeanNames.getBindingMBeanName(componentName, MBeanNames.ComponentServiceType.Installer, this.mTarget);
            } else if (ComponentType.ENGINE.equals((Object)type)) {
                instName = this.mMBeanNames.getEngineMBeanName(componentName, MBeanNames.ComponentServiceType.Installer, this.mTarget);
            }
            if (!this.mMBeanSvr.isRegistered(instName)) {
                Installer installer = new Installer(this.mEnvCtx, this.mTarget, componentName, instanceInstMBeans);
                StandardMBean mbean = new StandardMBean(installer, InstallerMBean.class);
                this.mMBeanSvr.registerMBean(mbean, instName);
            } else {
                this.mLog.warning("Installer MBean " + instName + " already registered");
            }
            return instName;
        }
        catch (Exception ex) {
            String[] params = new String[]{componentName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_LOAD_NEW_INSTALLER", params);
            return null;
        }
    }

    private ObjectName loadNewInstallerForTarget(String installZipURL, ComponentDescriptor descr) throws ManagementException {
        this.componentInstallationCheck(descr.getName(), true);
        this.dependentSharedLibraryInstallationCheck(descr.getName(), descr.getSharedLibraryIds());
        this.mLog.fine(this.mTranslator.getString("JBI_ADMIN_LOADING_NEW_INSTALLER_ON_TARGET", descr.getName(), this.mTarget));
        ObjectName remoteInstObjName = null;
        HashMap<String, ObjectName> instInstallerMBeans = null;
        if (this.mPlatform.isStandaloneServer(this.mTarget)) {
            remoteInstObjName = this.loadNewInstallerForInstance(this.mTarget, installZipURL);
            instInstallerMBeans = new HashMap();
            instInstallerMBeans.put(this.mTarget, remoteInstObjName);
        } else {
            instInstallerMBeans = this.loadNewInstallerForCluster(this.mTarget, installZipURL);
        }
        return this.registerInstallerMBean(descr.getName(), descr.getComponentType(), "loadNewInstaller", instInstallerMBeans);
    }

    private ObjectName loadInstallerForTarget(String compName, ComponentType compType) throws ManagementException {
        this.componentInstallationCheck(compName, false);
        this.mLog.fine(this.mTranslator.getString("JBI_ADMIN_LOADING_INSTALLER_ON_TARGET", compName, this.mTarget));
        ObjectName remoteInstObjName = null;
        HashMap<String, ObjectName> instInstallerMBeans = null;
        if (this.mPlatform.isStandaloneServer(this.mTarget)) {
            remoteInstObjName = this.loadInstallerForInstance(this.mTarget, compName);
            instInstallerMBeans = new HashMap();
            instInstallerMBeans.put(this.mTarget, remoteInstObjName);
        } else {
            instInstallerMBeans = this.loadInstallerForCluster(this.mTarget, compName);
        }
        return this.registerInstallerMBean(compName, compType, "loadInstaller", instInstallerMBeans);
    }

    private boolean unloadInstallerFromTarget(String componentName) throws ManagementException {
        this.mLog.fine(this.mTranslator.getString("JBI_ADMIN_UNLOADING_INSTALLER_FROM_TARGET", componentName, this.mTarget));
        boolean unloaded = false;
        boolean isToBeDeletedFromInstance = true;
        if (this.isComponentInstalled(componentName)) {
            isToBeDeletedFromInstance = false;
        }
        unloaded = this.mPlatform.isStandaloneServer(this.mTarget) ? this.unloadInstallerFromInstance(this.mTarget, componentName, isToBeDeletedFromInstance) : this.unloadInstallerFromCluster(this.mTarget, componentName, isToBeDeletedFromInstance);
        return unloaded;
    }

    private ObjectName getRegisteredInstallerMBean(String componentName) throws ManagementException {
        ComponentType compType = this.getComponentType(componentName);
        ObjectName instName = null;
        if (ComponentType.BINDING.equals((Object)compType)) {
            instName = this.mMBeanNames.getBindingMBeanName(componentName, MBeanNames.ComponentServiceType.Installer, this.mTarget);
        } else if (ComponentType.ENGINE.equals((Object)compType)) {
            instName = this.mMBeanNames.getEngineMBeanName(componentName, MBeanNames.ComponentServiceType.Installer, this.mTarget);
        } else {
            String[] params = new String[]{componentName};
            this.mMsgBuilder.throwManagementException("unloadInstaller", "JBI_ADMIN_UNKNOWN_COMPONENT", params);
        }
        return instName;
    }

    private ObjectName getRegisteredInstallerConfigMBean(String componentName) throws ManagementException {
        return this.mMBeanNames.getComponentMBeanName(componentName, this.getComponentType(componentName), MBeanNames.ComponentServiceType.Configuration, this.mTarget);
    }

    private void componentRegistrationCheck(String taskId, String componentName, boolean throwExWhenNotRegistered) throws ManagementException {
        String[] params;
        boolean registered = false;
        try {
            registered = this.getGenericQuery().isComponentRegistered(componentName);
        }
        catch (RegistryException rex) {
            this.mLog.warning(rex.getMessage());
            throw new RuntimeException(this.mMsgBuilder.buildExceptionMessage("componentRegistrationCheck", (Throwable)((Object)rex)));
        }
        if (!registered && throwExWhenNotRegistered) {
            params = new String[]{componentName};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_UNKNOWN_COMPONENT", params);
        }
        if (registered && !throwExWhenNotRegistered) {
            params = new String[]{componentName};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_KNOWN_COMPONENT", params);
        }
    }

    private void sharedLibraryRegistrationCheck(String taskId, String libraryName, boolean throwExWhenNotRegistered) throws ManagementException {
        String[] params;
        boolean registered = false;
        try {
            registered = this.getGenericQuery().isSharedLibraryRegistered(libraryName);
        }
        catch (RegistryException rex) {
            this.mLog.warning(rex.getMessage());
            throw new RuntimeException(this.mMsgBuilder.buildExceptionMessage("sharedLibraryRegistrationCheck", (Throwable)((Object)rex)));
        }
        if (!registered && throwExWhenNotRegistered) {
            params = new String[]{libraryName};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_UNKNOWN_SHARED_LIBRARY", params);
        }
        if (registered && !throwExWhenNotRegistered) {
            params = new String[]{libraryName};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_KNOWN_SHARED_LIBRARY", params);
        }
    }

    private void addSharedLibraryToDomain(String taskId, String slName, Archive slArchive) throws ManagementException {
        String archivePath = slArchive.getPath();
        try {
            this.mLog.finer("Adding shared library " + slName + " to the domain");
            this.getRegistry().getRepository().addArchive(slArchive);
            this.getUpdater().addSharedLibrary(slName, slArchive.getFileName(), slArchive.getUploadTimestamp());
        }
        catch (RegistryException ex) {
            String[] params = new String[]{slName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_ADD_SHARED_LIBRARY", params);
        }
        catch (RepositoryException ex) {
            String[] params = new String[]{slName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_ADD_SHARED_LIBRARY", params);
        }
    }

    private void removeSharedLibraryFromDomain(String taskId, String slName) throws ManagementException {
        boolean isSystemLibrary = false;
        try {
            if (!this.getGenericQuery().isSharedLibraryInstalled(slName)) {
                this.getUpdater().removeSharedLibrary("domain", slName);
                this.getRegistry().getRepository().removeArchive(ArchiveType.SHARED_LIBRARY, slName);
            }
        }
        catch (RepositoryException ex) {
            String[] params = new String[]{slName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_REMOVE_SHARED_LIBRARY", params);
        }
        catch (RegistryException ex) {
            String[] params = new String[]{slName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_REMOVE_SHARED_LIBRARY", params);
        }
    }

    private void addComponentToDomain(String taskId, String compName, Archive compArchive) throws ManagementException {
        try {
            this.mLog.fine("Adding component " + compName + " to the domain");
            this.getRegistry().getRepository().addArchive(compArchive);
            this.getUpdater().addComponent(compName, compArchive.getFileName(), compArchive.getUploadTimestamp());
        }
        catch (RegistryException ex) {
            String[] params = new String[]{compName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_ADD_COMPONENT", params);
        }
        catch (RepositoryException ex) {
            String[] params = new String[]{compName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_ADD_COMPONENT", params);
        }
    }

    private boolean removeComponentFromDomain(String taskId, String compName) throws ManagementException {
        boolean removed;
        block5: {
            removed = false;
            try {
                if (this.getGenericQuery().isComponentInstalled(compName)) break block5;
                try {
                    this.unregisterComponentExtensionMBean("domain", compName);
                    this.unregisterComponentLifeCycleMBean("domain", compName);
                }
                catch (Exception ex) {
                    this.mLog.warning(ex.getMessage());
                }
                this.getUpdater().removeComponent("domain", compName);
                this.getRegistry().getRepository().removeArchive(ArchiveType.COMPONENT, compName);
                removed = true;
            }
            catch (RepositoryException ex) {
                String[] params = new String[]{compName, ex.getMessage()};
                this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_REMOVE_COMPONENT", params);
            }
            catch (RegistryException ex) {
                String[] params = new String[]{compName, ex.getMessage()};
                this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_REMOVE_COMPONENT", params);
            }
        }
        return removed;
    }

    private ObjectName getRemoteInstallationServiceObjectName(String instanceName) {
        MBeanNames mbnNames = this.mMgtCtx.getMBeanNames(instanceName);
        return mbnNames.getSystemServiceMBeanName("InstallationService", "InstallationService");
    }

    private String installSharedLibraryToTarget(String slName, String slInstallZipPath) throws ManagementException {
        String response = null;
        this.mLog.info(this.mTranslator.getString("JBI_ADMIN_INSTALLING_SHARED_LIBRARY_TO_TARGET", slName, this.mTarget));
        this.sharedLibraryInstallationCheck(slName, true);
        response = this.mPlatform.isStandaloneServer(this.mTarget) ? this.installSharedLibraryToInstance(this.mTarget, slName, slInstallZipPath) : this.installSharedLibraryToCluster(this.mTarget, slName, slInstallZipPath);
        this.addSharedLibraryToTarget(slName);
        return response;
    }

    private String installSharedLibraryToInstance(String serverName, String slName, String slInstallZipPath) throws ManagementException {
        if (this.isInstanceRunning(serverName)) {
            this.mLog.fine("Installing shared library to instance " + serverName);
            slInstallZipPath = !serverName.equals(this.mPlatform.getAdminServerName()) ? this.uploadFile(serverName, slInstallZipPath) : this.toFileURL(slInstallZipPath);
            String[] sign = new String[]{"java.lang.String"};
            Object[] params = new String[]{slInstallZipPath};
            slName = (String)this.invokeRemoteOperation(this.getRemoteInstallationServiceObjectName(serverName), "installSharedLibrary", params, sign, serverName);
        }
        return slName;
    }

    private String installSharedLibraryToCluster(String clusterName, String slName, String slInstallZipPath) throws ManagementException {
        String response = slName;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            for (String instance : instances) {
                try {
                    response = this.installSharedLibraryToInstance(instance, slName, slInstallZipPath);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            if (exceptionMap.size() > 0) {
                this.handleClusteredInstanceFailures("installSharedLibrary", exceptionMap, instances.size(), "JBI_ADMIN_FAILED_INSTALL_SHARED_LIBRARY_TO_INSTANCE");
            }
        }
        return response;
    }

    private String uninstallSharedLibraryFromTarget(String slName) throws ManagementException {
        boolean uninstalled = false;
        boolean isSuccess = false;
        String result = null;
        this.sharedLibraryInstallationCheck(slName, false);
        this.dependentComponentCheck(this.mTarget, slName);
        this.mLog.fine(this.mTranslator.getString("JBI_ADMIN_UNINSTALLING_SHARED_LIBRARY_FROM_TARGET", slName, this.mTarget));
        try {
            uninstalled = this.mPlatform.isStandaloneServer(this.mTarget) ? this.uninstallSharedLibraryFromInstance(this.mTarget, slName) : this.uninstallSharedLibraryFromCluster(this.mTarget, slName);
        }
        catch (ManagementException mex) {
            if (MessageBuilder.isXmlString(mex.getMessage())) {
                MessageBuilder.Message msg = this.mMsgBuilder.createMessage(mex.getMessage());
                isSuccess = msg.isSuccess();
            }
            if (!isSuccess) {
                throw mex;
            }
            result = mex.getMessage();
        }
        if (uninstalled || isSuccess) {
            this.removeSharedLibraryFromTarget(slName);
        }
        return result;
    }

    private boolean uninstallSharedLibraryFromInstance(String serverName, String slName) throws ManagementException {
        boolean success = true;
        if (this.isInstanceRunning(serverName)) {
            this.mLog.fine("Uninstalling shared library from instance " + serverName);
            String[] sign = new String[]{"java.lang.String"};
            Object[] params = new String[]{slName};
            Boolean rslt = (Boolean)this.invokeRemoteOperation(this.getRemoteInstallationServiceObjectName(serverName), "uninstallSharedLibrary", params, sign, serverName);
            success = rslt;
        }
        return success;
    }

    private boolean uninstallSharedLibraryFromCluster(String clusterName, String slName) throws ManagementException {
        boolean uninstalled = true;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            for (String instance : instances) {
                try {
                    boolean currResult = this.uninstallSharedLibraryFromInstance(instance, slName);
                    uninstalled &= currResult;
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            if (exceptionMap.size() > 0) {
                this.handleClusteredInstanceFailures("uninstallSharedLibrary", exceptionMap, exceptionMap.size(), "JBI_ADMIN_FAILED_UNINSTALL_SHARED_LIBRARY_FROM_INSTANCE");
            }
        } else {
            uninstalled = true;
        }
        return uninstalled;
    }

    private ObjectName loadNewInstallerForInstance(String serverName, String installZipURL) throws ManagementException {
        ObjectName remoteInstaller = null;
        if (this.isInstanceRunning(serverName)) {
            installZipURL = !serverName.equals(this.mPlatform.getAdminServerName()) ? this.uploadFile(serverName, installZipURL) : this.toFileURL(installZipURL);
            String[] sign = new String[]{"java.lang.String"};
            Object[] params = new String[]{installZipURL};
            remoteInstaller = (ObjectName)this.invokeRemoteOperation(this.getRemoteInstallationServiceObjectName(serverName), "loadNewInstaller", params, sign, serverName);
        }
        return remoteInstaller;
    }

    private HashMap<String, ObjectName> loadNewInstallerForCluster(String clusterName, String installZipURL) throws ManagementException {
        HashMap<String, ObjectName> installerMBeans = new HashMap<String, ObjectName>();
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            for (String instance : instances) {
                try {
                    ObjectName installerMBean = this.loadNewInstallerForInstance(instance, installZipURL);
                    installerMBeans.put(instance, installerMBean);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                    installerMBeans.put(instance, null);
                }
            }
            if (exceptionMap.size() > 0) {
                this.handleClusteredInstanceFailures("loadNewInstaller", exceptionMap, instances.size(), "JBI_ADMIN_FAILED_LOAD_NEW_INSTALLER_ON_INSTANCE");
            }
        }
        return installerMBeans;
    }

    private HashMap<String, ObjectName> loadInstallerForCluster(String clusterName, String compName) throws ManagementException {
        HashMap<String, ObjectName> installerMBeans = new HashMap<String, ObjectName>();
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            for (String instance : instances) {
                try {
                    ObjectName installerMBean = this.loadInstallerForInstance(instance, compName);
                    installerMBeans.put(instance, installerMBean);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                    installerMBeans.put(instance, null);
                }
            }
            if (exceptionMap.size() > 0) {
                this.handleClusteredInstanceFailures("loadInstaller", exceptionMap, instances.size(), "JBI_ADMIN_FAILED_LOAD_NEW_INSTALLER_ON_INSTANCE");
            }
        }
        return installerMBeans;
    }

    private ObjectName loadInstallerForInstance(String serverName, String compName) throws ManagementException {
        ObjectName instObjName = null;
        if (this.isInstanceRunning(serverName)) {
            String[] sign = new String[]{"java.lang.String"};
            Object[] params = new String[]{compName};
            instObjName = (ObjectName)this.invokeRemoteOperation(this.getRemoteInstallationServiceObjectName(serverName), "loadInstaller", params, sign, serverName);
        }
        return instObjName;
    }

    private boolean unloadInstallerFromInstance(String serverName, String componentName, boolean isToBeDeletedFromInstance) throws ManagementException {
        boolean result = false;
        if (this.isInstanceRunning(serverName)) {
            String[] sign = new String[]{"java.lang.String", "boolean"};
            Object[] params = new Object[]{componentName, new Boolean(isToBeDeletedFromInstance)};
            Boolean unloaded = (Boolean)this.invokeRemoteOperation(this.getRemoteInstallationServiceObjectName(serverName), "unloadInstaller", params, sign, serverName);
            result = unloaded;
        } else {
            result = true;
        }
        return result;
    }

    private boolean unloadInstallerFromCluster(String clusterName, String componentName, boolean isToBeDeletedFromInstance) throws ManagementException {
        boolean unloaded = false;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            for (String instance : instances) {
                boolean currResult = false;
                try {
                    currResult = this.unloadInstallerFromInstance(instance, componentName, isToBeDeletedFromInstance);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                    currResult = false;
                    continue;
                }
                unloaded = currResult | unloaded;
            }
            if (exceptionMap.size() > 0) {
                this.handleClusteredInstanceFailures("unloadInstaller", exceptionMap, instances.size(), "JBI_ADMIN_FAILED_UNLOAD_INSTALLER_FROM_INSTANCE");
            }
        } else {
            unloaded = true;
        }
        return unloaded;
    }

    private void dependentComponentCheck(String targetName, String slName) throws ManagementException {
        try {
            ComponentQuery compQuery = this.getRegistry().getComponentQuery(targetName);
            List<String> depComps = compQuery.getDependentComponentIds(slName);
            List<String> instances = this.getTargetInstances(targetName);
            for (String component : depComps) {
                for (String instanceName : instances) {
                    if (ComponentState.STARTED != this.getComponentState(component, instanceName)) continue;
                    Object[] params = new String[]{component, instanceName, slName};
                    String errMsg = this.mTranslator.getString("JBI_ADMIN_DEPENDENT_COMPONENT_ACTIVE", params);
                    String jbiTaskMsg = this.mMsgBuilder.buildFrameworkMessage("dependentComponentCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
                    throw new ManagementException(jbiTaskMsg);
                }
            }
        }
        catch (RegistryException rex) {
            String errMsg = this.mMsgBuilder.buildExceptionMessage("uninstalSharedLibrary", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
    }

    private void addSharedLibraryToTarget(String slName) throws ManagementException {
        try {
            if (!this.mTarget.equals(this.mPlatform.getAdminServerName())) {
                ComponentQuery compQuery = this.getRegistry().getComponentQuery("domain");
                ComponentInfoImpl slInfo = (ComponentInfoImpl)compQuery.getSharedLibraryInfo(slName);
                slInfo.setInstallRoot(this.getSharedLibraryInstallRoot(slName));
                this.getUpdater().addSharedLibrary(this.mTarget, slInfo);
            }
        }
        catch (RegistryException rex) {
            String errMsg = this.mMsgBuilder.buildExceptionMessage("addSharedLibraryToTarget", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
    }

    private void removeSharedLibraryFromTarget(String slName) throws ManagementException {
        try {
            if (!this.mTarget.equals(this.mPlatform.getAdminServerName())) {
                this.getUpdater().removeSharedLibrary(this.mTarget, slName);
            }
        }
        catch (RegistryException rex) {
            String errMsg = this.mMsgBuilder.buildExceptionMessage("removeSharedLibraryFromTarget", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
    }

    private List<String> getTargetInstances(String targetName) {
        ArrayList<String> instances = new ArrayList<String>();
        if (this.mPlatform.isStandaloneServer(targetName)) {
            instances.add(targetName);
        } else if (this.mPlatform.isCluster(targetName)) {
            instances.addAll(this.mPlatform.getServersInCluster(targetName));
        }
        return instances;
    }

    private String getSharedLibraryInstallRoot(String slName) throws RegistryException, ManagementException {
        Archive archive = this.getRegistry().getRepository().getArchive(ArchiveType.SHARED_LIBRARY, slName);
        String archivePath = archive.getPath();
        return new File(archivePath).getParent();
    }

    private void dependentSharedLibraryInstallationCheck(String componentName, List<String> requiredSharedLibs) throws ManagementException {
        if (!requiredSharedLibs.isEmpty()) {
            ArrayList<String> uninstalledLibs = new ArrayList<String>();
            for (String slName : requiredSharedLibs) {
                if (this.isSharedLibraryInstalled(slName)) continue;
                uninstalledLibs.add(slName);
            }
            if (!uninstalledLibs.isEmpty()) {
                Object[] params = new String[]{componentName, InstallationService.listToString(uninstalledLibs)};
                String errMsg = this.mTranslator.getString("JBI_ADMIN_REQUIRED_SHARED_LIBRARIES_NOT_INSTALLLED", params);
                String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("dependentSharedLibraryInstallationCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
                throw new ManagementException(jbiMsg);
            }
        }
    }

    private void canUninstallComponentFromDomainCheck(String componentName) throws ManagementException {
        try {
            if (this.getGenericQuery().isComponentInstalled(componentName)) {
                Object[] params = new String[]{componentName};
                String errMsg = this.mTranslator.getString("JBI_ADMIN_COMPONENT_INSTALLED_ON_TARGETS", params);
                String jbiTaskMsg = this.mMsgBuilder.buildFrameworkMessage("unloadInstaller", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
                throw new ManagementException(jbiTaskMsg);
            }
        }
        catch (RegistryException rex) {
            throw new ManagementException(this.mMsgBuilder.buildExceptionMessage("canUninstallComponentFromDomainCheck", (Throwable)((Object)rex)));
        }
    }

    private void validateComponentRegistration(String componentName) throws ManagementException {
        try {
            if (!this.getGenericQuery().isComponentRegistered(componentName)) {
                throw new ManagementException(this.mTranslator.getString("JBI_ADMIN_UPGRADE_COMPONENT_NOT_INSTALLED", componentName));
            }
            this.mLog.finer("Component " + componentName + " is registered in the system");
        }
        catch (RegistryException regEx) {
            throw new ManagementException(regEx.getMessage());
        }
    }

    private void validateComponentStateInAllTargets(String componentName) throws ManagementException {
        List<String> targets = this.getAllInstancesInstallingComponent(componentName);
        for (String target : targets) {
            if (this.getComponentState(componentName, target) == ComponentState.SHUTDOWN) continue;
            throw new ManagementException(this.mTranslator.getString("JBI_ADMIN_UPGRADE_COMPONENT_NOT_SHUTDOWN", componentName, target));
        }
        this.mLog.finer("Component " + componentName + " is Shutdown in all targets");
    }

    private MessageBuilder.Message upgradeComponent(String componentName, String installZipURL, List<String> instances) throws JBIException {
        HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
        HashMap<String, String> responseMap = new HashMap<String, String>();
        for (String instance : instances) {
            try {
                String instanceResult = this.upgradeComponent(componentName, installZipURL, instance);
                responseMap.put(instance, instanceResult);
            }
            catch (JBIException jbiEx) {
                exceptionMap.put(instance, jbiEx);
            }
        }
        return new MessageBuilder(this.mTranslator).buildCompositeMessage(UPGRADE_COMPONENT, responseMap, exceptionMap, false);
    }

    private String upgradeComponent(String componentName, String installZipURL, String instanceName) throws ManagementException {
        String updateResult;
        if (this.isInstanceRunning(instanceName)) {
            this.mLog.fine("Uploading " + installZipURL + " to target " + instanceName);
            String componentInstallZipPath = !instanceName.equals(this.mPlatform.getAdminServerName()) ? this.uploadFile(instanceName, installZipURL) : this.toFileURL(installZipURL);
            String[] sign = new String[]{"java.lang.String", "java.lang.String"};
            Object[] params = new String[]{componentName, componentInstallZipPath};
            updateResult = (String)this.invokeRemoteOperation(this.getRemoteInstallationServiceObjectName(instanceName), UPGRADE_COMPONENT, params, sign, instanceName);
            componentInstallZipPath = null;
        } else {
            this.mLog.fine(instanceName + " is down. Component upgrade will be performed by synchronization.");
            updateResult = this.mMsgBuilder.buildFrameworkMessage(UPGRADE_COMPONENT, MessageBuilder.TaskResult.SUCCESS);
        }
        return updateResult;
    }

    private void validateComponentName(String componentName, String installZipURL) throws ManagementException {
        String PATH_TO_JBI_XML = "META-INF/jbi.xml";
        try {
            String existingDescPath = this.getComponentInstallRoot(componentName) + File.separator + METAINF + File.separator + JBIXML;
            File existingDesc = new File(existingDescPath);
            String temporaryDirPath = this.mEnvCtx.getJbiInstanceRoot() + File.separator + TMP_DIR + File.separator + componentName + "_validate" + FileHelper.getTimestamp();
            File temporaryDir = new File(temporaryDirPath);
            temporaryDir.mkdir();
            JarFactory jarHelper = new JarFactory(temporaryDir.getAbsolutePath());
            jarHelper.unJar(new File(installZipURL));
            String newDescPath = temporaryDir + File.separator + METAINF + File.separator + JBIXML;
            File newDesc = new File(newDescPath);
            boolean namesMatch = DOMUtil.areElementsEqual(existingDesc, newDesc, "/jbi:jbi/jbi:component/jbi:identification/jbi:name");
            if (!namesMatch) {
                throw new ManagementException(this.mTranslator.getString("JBI_ADMIN_UPGRADE_COMPONENT_NAME_NOT_SAME"));
            }
            this.mLog.finer("Component names are the same");
            FileHelper.cleanDirectory(temporaryDir);
            temporaryDir.delete();
        }
        catch (IOException ioEx) {
            this.mLog.warning(ioEx.toString());
            throw new ManagementException(ioEx.getMessage());
        }
    }

    List<String> getAllInstancesInstallingComponent(String componentName) throws ManagementException {
        List<String> instances;
        try {
            instances = this.getGenericQuery().getServersInstallingComponent(componentName);
            List<String> clusters = this.getGenericQuery().getClustersInstallingComponent(componentName);
            if (!clusters.isEmpty()) {
                for (String cluster : clusters) {
                    instances.addAll(this.mPlatform.getServersInCluster(cluster));
                }
            }
        }
        catch (RegistryException regEx) {
            throw new ManagementException(regEx.toString());
        }
        return instances;
    }

    private void updateInstallRootInDomainRepository(String installRootBkup, String componentName, String installZipURL) throws ManagementException {
        try {
            String existingArchiveName = this.getRegistry().getGenericQuery().getComponentFileName(componentName);
            String installRoot = this.getComponentInstallRoot(componentName);
            File installRootDir = new File(installRoot);
            String componentRoot = installRootDir.getParent();
            FileHelper.copy(componentRoot, installRootBkup);
            this.mLog.finer("Install root has been saved in " + installRootBkup);
            installRootDir = null;
            this.getRegistry().getRepository().removeArchive(ArchiveType.COMPONENT, componentName);
            installRootDir = new File(installRoot);
            if (installRootDir.exists()) {
                String message = this.mTranslator.getString("JBI_ADMIN_COMPONENT_UPGRADE_DOMAIN_INSTALL_ROOT_NOT_UPDATED", componentName);
                throw new ManagementException(message);
            }
            Archive upgradeArchive = this.getRegistry().getRepository().addArchive(ArchiveType.COMPONENT, installZipURL);
            this.mLog.finer("Successfully added new archive in repository");
            String backupWorkspace = installRootBkup + File.separator + INSTALL_ROOT + File.separator + WORKSPACE;
            FileHelper.copy(backupWorkspace, installRoot + File.separator + WORKSPACE);
            this.mLog.finer("Successfully recreated component workspace");
            String backupConfig = installRootBkup + File.separator + LOGGER_CONFIG;
            String config = installRoot + File.separator + LOGGER_CONFIG;
            boolean result = FileHelper.copy(backupConfig, config);
            if (result) {
                this.mLog.finer("Successfully restored logger settings");
            } else if (new File(backupConfig).exists()) {
                this.mLog.warning(this.mTranslator.getString("JBI_ADMIN_COMPONENT_UPGRADE_LOGGER_SETTINGS_NOT_RESTORED", componentName));
            }
            this.modifyArchiveNameInRegistry(componentName, existingArchiveName, upgradeArchive.getFileName());
            ((GenericQueryImpl)this.getRegistry().getGenericQuery()).removeComponentFromCache(componentName);
        }
        catch (RepositoryException repEx) {
            throw new ManagementException(this.mTranslator.getString("JBI_ADMIN_COMPONENT_UPGRADE_DOMAIN_INSTALL_ROOT_NOT_UPDATED", componentName) + repEx.getMessage());
        }
        catch (RegistryException regEx) {
            throw new ManagementException(this.mTranslator.getString("JBI_ADMIN_COMPONENT_UPGRADE_DOMAIN_INSTALL_ROOT_NOT_UPDATED", componentName) + regEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new ManagementException(this.mTranslator.getString("JBI_ADMIN_COMPONENT_UPGRADE_DOMAIN_INSTALL_ROOT_NOT_UPDATED", componentName) + ioEx.getMessage());
        }
    }

    private void restoreInstallRootInDomainRepository(String componentName, String backupComponentRoot, String componentRoot) {
        try {
            File marker;
            if (this.getRegistry().getRepository().archiveExists(ArchiveType.COMPONENT, componentName)) {
                this.getRegistry().getRepository().removeArchive(ArchiveType.COMPONENT, componentName);
            }
            if ((marker = new File(componentRoot, DELETE_ME)) != null && marker.exists()) {
                marker.delete();
            }
            FileHelper.copy(backupComponentRoot, componentRoot);
            this.mLog.fine("install root has been restored");
        }
        catch (Exception ex) {
            this.mLog.warning(this.mTranslator.getString("JBI_ADMIN_COMPONENT_UPGRADE_DOMAIN_INSTALL_ROOT_NOT_RESTORED") + ex.getMessage());
        }
    }

    private void incrementComponentUpgradeNumber(String componentName) throws RegistryException {
        BigInteger currNumber = this.getRegistry().getGenericQuery().getComponentUpgradeNumber(componentName);
        this.getRegistry().getUpdater().setComponentUpgradeNumber(componentName, currNumber.add(BigInteger.ONE));
    }

    private String getComponentInstallRoot(String componentName) {
        Archive archive = null;
        String archivePath = null;
        String installRoot = null;
        archive = this.getRegistry().getRepository().getArchive(ArchiveType.COMPONENT, componentName);
        if (archive != null) {
            archivePath = archive.getPath();
            installRoot = new File(archivePath).getParent() + File.separator + INSTALL_ROOT;
        }
        this.mLog.finer("Install Root for component " + componentName + " is " + installRoot);
        return installRoot;
    }

    private void modifyArchiveNameInRegistry(String componentName, String existingName, String newName) throws RegistryException, ManagementException {
        if (!existingName.equals(newName)) {
            this.getUpdater().setComponentFileName(componentName, newName);
        }
    }
}

