/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.config;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.config.ConfigurationFactory;
import com.sun.jbi.management.config.DescriptorSupport;
import com.sun.jbi.util.EnvironmentAccess;
import java.util.Properties;
import javax.management.modelmbean.ModelMBeanAttributeInfo;

public class SystemConfigurationFactory
extends ConfigurationFactory {
    public static final String JBI_HOME = "jbiHome";
    public static final String DEFAULT_LOG_LEVEL = "defaultLogLevel";
    public static final String HEART_BEAT_INTERVAL = "heartBeatInterval";
    private static final int sNumAttributes = 3;

    public SystemConfigurationFactory(Properties defProps) {
        super(defProps, ConfigurationCategory.System);
    }

    public ModelMBeanAttributeInfo[] createMBeanAttributeInfo() {
        ModelMBeanAttributeInfo[] attributeInfos = new ModelMBeanAttributeInfo[3];
        DescriptorSupport descr = new DescriptorSupport();
        String attrDescr = this.getString("JBI_HOME_DESCR");
        descr.setAttributeName(JBI_HOME);
        descr.setDisplayName(this.getString("JBI_HOME_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("JBI_HOME_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("JBI_HOME_DESCR"));
        descr.setToolTip(this.getString("JBI_HOME_DESCR"));
        descr.setToolTipId(this.getToken("JBI_HOME_DESCR"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(true);
        descr.setDefault(this.getJbiHome());
        attributeInfos[0] = new ModelMBeanAttributeInfo(JBI_HOME, "java.lang.String", attrDescr, true, false, false, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("DEFAULT_LOG_LEVEL_DESCR");
        descr.setAttributeName(DEFAULT_LOG_LEVEL);
        descr.setDisplayName(this.getString("DEFAULT_LOG_LEVEL_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("DEFAULT_LOG_LEVEL_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("DEFAULT_LOG_LEVEL_DESCR"));
        descr.setToolTip(this.getString("DEFAULT_LOG_LEVEL_TOOLTIP"));
        descr.setToolTipId(this.getToken("DEFAULT_LOG_LEVEL_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        descr.setDefault(this.getDefaultLogLevel());
        descr.setEnumValue("{SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST}");
        attributeInfos[1] = new ModelMBeanAttributeInfo(DEFAULT_LOG_LEVEL, "java.lang.String", attrDescr, true, false, false, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("HEART_BEAT_INTERVAL_DESCR");
        descr.setAttributeName(HEART_BEAT_INTERVAL);
        descr.setDisplayName(this.getString("HEART_BEAT_INTERVAL_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("HEART_BEAT_INTERVAL_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("HEART_BEAT_INTERVAL_DESCR"));
        descr.setToolTip(this.getString("HEART_BEAT_INTERVAL_TOOLTIP"));
        descr.setToolTipId(this.getToken("HEART_BEAT_INTERVAL_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        String defHeartBeat = this.mDefaults.getProperty(this.getQualifiedKey(HEART_BEAT_INTERVAL), "5500");
        descr.setDefault(Integer.parseInt(defHeartBeat));
        descr.setMinValue(1000);
        descr.setMaxValue(Integer.MAX_VALUE);
        descr.setUnit("milliseconds");
        attributeInfos[2] = new ModelMBeanAttributeInfo(HEART_BEAT_INTERVAL, "int", attrDescr, true, true, false, descr);
        return attributeInfos;
    }

    private String getJbiHome() {
        EnvironmentContext envCtx = EnvironmentAccess.getContext();
        return envCtx.getJbiInstallRoot();
    }
}

