/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.template;

import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.SyntaxException;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutFacet;
import com.sun.jsftemplating.layout.descriptors.LayoutForEach;
import com.sun.jsftemplating.layout.descriptors.LayoutIf;
import com.sun.jsftemplating.layout.descriptors.LayoutWhile;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import com.sun.jsftemplating.layout.descriptors.handler.IODescriptor;
import com.sun.jsftemplating.layout.template.BaseProcessingContext;
import com.sun.jsftemplating.layout.template.CustomParserCommand;
import com.sun.jsftemplating.layout.template.NameValuePair;
import com.sun.jsftemplating.layout.template.ProcessingContext;
import com.sun.jsftemplating.layout.template.ProcessingContextEnvironment;
import com.sun.jsftemplating.layout.template.TemplateParser;
import com.sun.jsftemplating.util.LayoutElementUtil;
import com.sun.jsftemplating.util.LogUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateReader {
    public static final String FACET_ELEMENT = "facet";
    public static final String FOREACH_ELEMENT = "foreach";
    public static final String IF_ELEMENT = "if";
    public static final String LIST_ELEMENT = "list";
    public static final String MARKUP_ELEMENT = "markup";
    public static final String WHILE_ELEMENT = "while";
    public static final String ID_ATTRIBUTE = "id";
    public static final String OVERWRITE_ATTRIBUTE = "overwrite";
    public static final String CONDITION_ATTRIBUTE = "condition";
    public static final String IF_HANDLER = "if";
    public static final char LEFT_CURLY = '{';
    public static final char RIGHT_CURLY = '}';
    public static final ProcessingContext LAYOUT_DEFINITION_CONTEXT = new LayoutDefinitionContext();
    public static final ProcessingContext LAYOUT_COMPONENT_CONTEXT = new LayoutComponentContext();
    public static final ProcessingContext LAYOUT_FACET_CONTEXT = new LayoutFacetContext();
    public static final ProcessingContext LAYOUT_IF_CONTEXT = new LayoutIfContext();
    public static final ProcessingContext LAYOUT_FOREACH_CONTEXT = new LayoutForEachContext();
    public static final ProcessingContext LAYOUT_WHILE_CONTEXT = new LayoutWhileContext();
    public static CustomParserCommand EVENT_PARSER_COMMAND = new EventParserCommand();
    private static Map<String, CustomParserCommand> _parserCmds = TemplateReader.initCustomParserCommands();
    private Stack<String> _tagStack = new Stack();
    private TemplateParser _tpl = null;
    private int _idNumber = 1;
    private String _id = null;

    public TemplateReader(String id, URL url) {
        if (id == null) {
            throw new IllegalArgumentException("Template id's may not be null!");
        }
        this._id = id;
        this._tpl = new TemplateParser(url);
    }

    public TemplateReader(String id, TemplateParser parser) {
        this._id = id;
        this._tpl = parser;
    }

    public TemplateParser getTemplateParser() {
        return this._tpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutDefinition read() throws IOException {
        TemplateParser parser = this.getTemplateParser();
        parser.open();
        try {
            LayoutDefinition layoutDefinition = this.readLayoutDefinition();
            return layoutDefinition;
        }
        finally {
            parser.close();
        }
    }

    private LayoutDefinition readLayoutDefinition() throws IOException {
        LayoutDefinition ld = new LayoutDefinition(this._id);
        ld.setResources(LayoutDefinitionManager.getGlobalResources());
        return (LayoutDefinition)this.process(LAYOUT_DEFINITION_CONTEXT, ld, false);
    }

    public LayoutElement process(ProcessingContext ctx, LayoutElement parent, boolean nested) throws IOException {
        TemplateParser parser = this.getTemplateParser();
        parser.skipCommentsAndWhiteSpace(" \t\r\n");
        ProcessingContextEnvironment env = new ProcessingContextEnvironment(this, parent, nested);
        int ch = parser.nextChar();
        String startTag = null;
        String tmpstr = null;
        boolean finished = false;
        while (ch != -1) {
            switch (ch) {
                case 60: {
                    parser.skipCommentsAndWhiteSpace(" \t\r\n");
                    ch = parser.nextChar();
                    if (ch == 47) {
                        parser.skipCommentsAndWhiteSpace(" \t\r\n");
                        if (this.isTagStackEmpty()) {
                            parser.skipCommentsAndWhiteSpace(" \t\r\n!");
                            throw new SyntaxException("Found end tag '&lt;/" + parser.readToken() + "...' but did not find matching begin tag!");
                        }
                        startTag = this.popTag();
                        if (startTag.length() > 0 && startTag.charAt(0) == '!') {
                            ch = parser.nextChar();
                            if (ch == 33) {
                                parser.skipCommentsAndWhiteSpace(" \t\r\n");
                            } else {
                                parser.unread(ch);
                            }
                            tmpstr = parser.readToken();
                            if (!startTag.contains(tmpstr)) {
                                throw new SyntaxException("Expected to find closing tag '&lt;/" + startTag + "...&gt;' but instead found '&lt;/'" + (ch == 33 ? Character.valueOf('!') : "") + tmpstr + "...&gt;'.");
                            }
                            ctx.endSpecial(env, tmpstr);
                        } else {
                            tmpstr = parser.readToken();
                            if (!startTag.equals(tmpstr)) {
                                throw new SyntaxException("Expected to find closing tag '&lt;/" + startTag + "...&gt;' but instead found '&lt;/'" + tmpstr + "...&gt;'.");
                            }
                            ctx.endComponent(env, tmpstr);
                        }
                        finished = true;
                        parser.skipCommentsAndWhiteSpace(" \t\r\n");
                        ch = parser.nextChar();
                        if (ch == 62) break;
                        throw new SyntaxException("While processing closing tag '&lt;/" + tmpstr + "...' expected to encounter closing '&gt;' but" + " found '" + (char)ch + "' instead!");
                    }
                    if (ch == 33) {
                        tmpstr = parser.readToken();
                        this.pushTag("!" + tmpstr);
                        ctx.beginSpecial(env, tmpstr);
                        break;
                    }
                    parser.unread(ch);
                    tmpstr = parser.readToken();
                    if (tmpstr.equals("f:verbatim")) {
                        parser.skipCommentsAndWhiteSpace(" \t\r\n");
                        parser.nextChar();
                        tmpstr = parser.readUntil("</f:verbatim>", false);
                        tmpstr = tmpstr.substring(0, tmpstr.length() - "</f:verbatim>".length());
                        ctx.staticText(env, tmpstr);
                        break;
                    }
                    this.pushTag(tmpstr);
                    ctx.beginComponent(env, tmpstr);
                    break;
                }
                case 39: {
                    ctx.escapedStaticText(env, parser.readLine());
                    break;
                }
                case 34: {
                    ctx.staticText(env, parser.readLine());
                    break;
                }
                default: {
                    parser.unread(ch);
                    ctx.handleDefault(env, null);
                }
            }
            if (finished) {
                return parent;
            }
            parser.skipCommentsAndWhiteSpace(" \t\r\n");
            ch = parser.nextChar();
        }
        return parent;
    }

    public LayoutComponent createLayoutComponent(LayoutElement parent, boolean nested, String type) throws IOException {
        ComponentType componentType = LayoutDefinitionManager.getGlobalComponentType(type);
        if (componentType == null) {
            throw new IllegalArgumentException("ComponentType '" + type + "' not defined!");
        }
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        NameValuePair nvp = null;
        String id = null;
        String overwrite = null;
        int ch = 0;
        boolean single = false;
        TemplateParser parser = this.getTemplateParser();
        while (ch != -1) {
            parser.skipCommentsAndWhiteSpace(" \t\r\n");
            ch = parser.nextChar();
            if (ch == 62) break;
            if (ch == 47) {
                parser.skipCommentsAndWhiteSpace(" \t\r\n");
                ch = parser.nextChar();
                if (ch != 62) {
                    throw new SyntaxException("'" + type + "' tag contained " + "'/' that was not followed by a '&gt;' character!");
                }
                single = true;
                break;
            }
            parser.unread(ch);
            nvp = parser.getNVP(null);
            if (nvp.getName().equals(ID_ATTRIBUTE)) {
                id = nvp.getValue().toString();
                continue;
            }
            if (nvp.getName().equals(OVERWRITE_ATTRIBUTE)) {
                overwrite = nvp.getValue().toString();
                continue;
            }
            nvps.add(nvp);
        }
        if (id == null) {
            id = LayoutElementUtil.getGeneratedId(type, this.getNextIdNumber());
        }
        LayoutComponent component = new LayoutComponent(parent, id, componentType);
        if (overwrite != null) {
            component.setOverwrite(Boolean.valueOf(overwrite));
        }
        for (NameValuePair np : nvps) {
            component.addOption(np.getName(), np.getValue());
        }
        component.setNested(nested);
        TemplateReader.checkForFacetChild(parent, component);
        parser.unread(62);
        if (single) {
            parser.unread(47);
        }
        return component;
    }

    public static void checkForFacetChild(LayoutElement parent, LayoutComponent component) {
        if (LayoutElementUtil.isLayoutComponentChild(component)) {
            component.setFacetChild(false);
        } else {
            String id = component.getUnevaluatedId();
            while (parent != null) {
                if (parent instanceof LayoutFacet) {
                    if (!LayoutElementUtil.isLayoutComponentChild(parent)) break;
                    id = parent.getUnevaluatedId();
                    break;
                }
                parent = parent.getParent();
            }
            component.addOption("_facetName", id);
        }
    }

    public String popTag() {
        return this._tagStack.pop();
    }

    public void pushTag(String tag) {
        this._tagStack.push(tag);
    }

    public boolean isTagStackEmpty() {
        return this._tagStack.empty();
    }

    public int getNextIdNumber() {
        return this._idNumber++;
    }

    public static CustomParserCommand getCustomParserCommand(String id) {
        return _parserCmds.get(id);
    }

    public static void setCustomParserCommand(String id, CustomParserCommand command) {
        _parserCmds.put(id, command);
    }

    protected static Map<String, CustomParserCommand> initCustomParserCommands() {
        HashMap<String, CustomParserCommand> map = new HashMap<String, CustomParserCommand>();
        map.put("if", new IfParserCommand());
        map.put(WHILE_ELEMENT, new WhileParserCommand());
        map.put(FOREACH_ELEMENT, new ForeachParserCommand());
        map.put(FACET_ELEMENT, new FacetParserCommand());
        return map;
    }

    public static class FacetParserCommand
    implements CustomParserCommand {
        public void process(ProcessingContext ctx, ProcessingContextEnvironment env, String name) throws IOException {
            char first;
            TemplateReader reader = env.getReader();
            TemplateParser parser = reader.getTemplateParser();
            String id = parser.readUntil(62, true).trim();
            boolean singleTag = false;
            if (id.endsWith("/")) {
                reader.popTag();
                id = id.substring(0, id.length() - 1).trim();
                singleTag = true;
            }
            if ((first = id.charAt(0)) == '\"' || first == '\'') {
                if (id.indexOf(62) != -1) {
                    throw new SyntaxException("Unable to find ending (" + first + ") on !facet declaration with id (" + id.substring(0, id.indexOf(62)) + ") on component (" + env.getParent().getUnevaluatedId() + ").");
                }
                id = id.substring(1, id.length() - 1).trim();
            }
            LayoutElement parent = env.getParent();
            LayoutFacet facetElt = new LayoutFacet(parent, id);
            parent.addChildLayoutElement(facetElt);
            boolean isRendered = !LayoutElementUtil.isNestedLayoutComponent(facetElt);
            facetElt.setRendered(isRendered);
            if (singleTag && !isRendered && LogUtil.configEnabled()) {
                LogUtil.config(this, "Facet (" + id + ") specified, however, there is no component specified " + "inside this facet.  Nothing will happen.");
            }
            reader.process(LAYOUT_FACET_CONTEXT, facetElt, LayoutElementUtil.isLayoutComponentChild(facetElt));
        }
    }

    public static class ForeachParserCommand
    implements CustomParserCommand {
        public void process(ProcessingContext ctx, ProcessingContextEnvironment env, String name) throws IOException {
            TemplateReader reader = env.getReader();
            TemplateParser parser = reader.getTemplateParser();
            String key = parser.readUntil(58, true).trim();
            String listExp = parser.readUntil(62, true).trim();
            LayoutElement parent = env.getParent();
            LayoutForEach elt = new LayoutForEach(parent, listExp, key);
            parent.addChildLayoutElement(elt);
            if (listExp.endsWith("/")) {
                reader.popTag();
            } else {
                reader.process(LAYOUT_FOREACH_CONTEXT, elt, LayoutElementUtil.isLayoutComponentChild(elt));
            }
        }
    }

    public static class WhileParserCommand
    extends IfParserCommand {
        public void process(ProcessingContext ctx, ProcessingContextEnvironment env, String name) throws IOException {
            TemplateReader reader = env.getReader();
            TemplateParser parser = reader.getTemplateParser();
            String condition = parser.readUntil(62, false).trim();
            LayoutElement parent = env.getParent();
            LayoutWhile elt = new LayoutWhile(parent, condition);
            parent.addChildLayoutElement(elt);
            if (condition.endsWith("/")) {
                reader.popTag();
            } else {
                reader.process(LAYOUT_WHILE_CONTEXT, elt, LayoutElementUtil.isLayoutComponentChild(elt));
            }
        }
    }

    public static class IfParserCommand
    implements CustomParserCommand {
        public void process(ProcessingContext ctx, ProcessingContextEnvironment env, String name) throws IOException {
            TemplateReader reader = env.getReader();
            TemplateParser parser = reader.getTemplateParser();
            String condition = parser.readUntil(62, false).trim();
            LayoutElement parent = env.getParent();
            LayoutIf ifElt = new LayoutIf(parent, condition);
            parent.addChildLayoutElement(ifElt);
            if (condition.endsWith("/")) {
                reader.popTag();
            } else {
                reader.process(LAYOUT_IF_CONTEXT, ifElt, LayoutElementUtil.isLayoutComponentChild(ifElt));
            }
        }
    }

    public static class EventParserCommand
    implements CustomParserCommand {
        public void process(ProcessingContext ctx, ProcessingContextEnvironment env, String eventName) throws IOException {
            Handler handler = null;
            ArrayList<Handler> handlers = new ArrayList<Handler>();
            TemplateReader reader = env.getReader();
            TemplateParser parser = reader.getTemplateParser();
            Handler parentHandler = null;
            Stack<Handler> handlerStack = new Stack<Handler>();
            parser.skipCommentsAndWhiteSpace(" \t\r\n");
            int ch = parser.nextChar();
            while (ch != -1 && ch != 47 && ch != 62) {
                if (ch == 123 || ch == 125) {
                    if (ch == 123) {
                        handlerStack.push(parentHandler);
                        parentHandler = handler;
                    } else {
                        if (handlerStack.empty()) {
                            throw new SyntaxException("Encountered unmatched '}' when parsing handlers for '" + eventName + "' event.");
                        }
                        parentHandler = (Handler)handlerStack.pop();
                    }
                    parser.skipCommentsAndWhiteSpace(" \t\r\n,;");
                    ch = parser.nextChar();
                    continue;
                }
                parser.unread(ch);
                handler = this.readHandler(parser, eventName);
                if (parentHandler == null) {
                    handlers.add(handler);
                } else {
                    parentHandler.addChildHandler(handler);
                }
                ch = parser.nextChar();
            }
            if (ch == -1) {
                throw new SyntaxException("Unexpected EOF encountered while parsing handlers for event '" + eventName + "'!");
            }
            if (!handlerStack.empty()) {
                throw new SyntaxException("Unmatched '{' when parsing handlers for '" + eventName + "' event.");
            }
            if (ch == 62) {
                throw new SyntaxException("Handlers for event '" + eventName + "' did not end with '/&gt;' but instead ended with '&gt;'!");
            }
            if (ch == 47) {
                parser.skipCommentsAndWhiteSpace(" \t\r\n");
                ch = parser.nextChar();
                if (ch != 62) {
                    throw new SyntaxException("Expected '/&gt;' a end of '" + eventName + "' event.  But found '/" + (char)ch + "'.");
                }
                reader.popTag();
                ctx.endSpecial(env, eventName);
            }
            env.getParent().setHandlers(eventName, handlers);
        }

        private Handler readHandler(TemplateParser parser, String eventName) throws IOException {
            String target = null;
            String defVal = null;
            NameValuePair nvp = null;
            HandlerDefinition def = null;
            String handlerId = parser.readToken();
            def = LayoutDefinitionManager.getGlobalHandlerDefinition(handlerId);
            if (def == null) {
                throw new SyntaxException("Handler '" + handlerId + "' in event '" + eventName + "' is not declared!  " + "Ensure the '@Handler' annotation has been defined " + "on the handler Java method, that it has been " + "compiled with the annotation processing tool, and " + "that the resulting" + " 'META-INF/jsftemplating/Handler.map' is located " + "in your classpath (you may need to do a clean " + "build).");
            }
            Handler handler = new Handler(def);
            Map<String, IODescriptor> inputs = def.getInputDefs();
            if (inputs.size() == 1) {
                defVal = inputs.keySet().toArray()[0].toString();
            }
            parser.skipCommentsAndWhiteSpace(" \t\r\n");
            int ch = parser.nextChar();
            if (ch != 40) {
                throw new SyntaxException("While processing '&lt;!" + eventName + "...' the handler '" + handlerId + "' was missing the '(' character!");
            }
            parser.skipWhiteSpace(" \t\r\n");
            ch = parser.nextChar();
            if (ch != 35 || !handlerId.equals("if")) {
                parser.unread(ch);
                parser.skipCommentsAndWhiteSpace("");
                ch = parser.nextChar();
            }
            if (handlerId.equals("if") && ch != 39 && ch != 34 && ch != 99) {
                parser.unread(ch);
                handler.setCondition(parser.readUntil(41, false).trim());
                ch = 41;
            }
            while (ch != -1 && ch != 41) {
                parser.unread(ch);
                try {
                    nvp = parser.getNVP(defVal);
                }
                catch (SyntaxException ex) {
                    throw new SyntaxException("Unable to process handler '" + handlerId + "'!", ex);
                }
                parser.skipCommentsAndWhiteSpace(" \t\r\n,;");
                ch = parser.nextChar();
                target = nvp.getTarget();
                if (target != null) {
                    handler.setOutputMapping(nvp.getName(), nvp.getValue().toString(), target);
                    continue;
                }
                String name = nvp.getName();
                if (name.equals(TemplateReader.CONDITION_ATTRIBUTE) && (inputs.get(TemplateReader.CONDITION_ATTRIBUTE) == null || handlerId.equals("if"))) {
                    handler.setCondition(nvp.getValue().toString());
                    continue;
                }
                handler.setInputValue(nvp.getName(), nvp.getValue());
            }
            parser.skipCommentsAndWhiteSpace(" \t\r\n,;");
            return handler;
        }
    }

    protected static class LayoutFacetContext
    extends BaseProcessingContext {
        protected LayoutFacetContext() {
        }
    }

    protected static class LayoutComponentContext
    extends BaseProcessingContext {
        protected LayoutComponentContext() {
        }

        public void handleDefault(ProcessingContextEnvironment env, String content) throws IOException {
            TemplateParser parser = env.getReader().getTemplateParser();
            String bodyContent = parser.readUntil(60, true);
            parser.unread(60);
        }

        public void beginSpecial(ProcessingContextEnvironment env, String content) throws IOException {
            super.beginSpecial(env, content);
        }
    }

    protected static class LayoutWhileContext
    extends BaseProcessingContext {
        protected LayoutWhileContext() {
        }
    }

    protected static class LayoutForEachContext
    extends BaseProcessingContext {
        protected LayoutForEachContext() {
        }
    }

    protected static class LayoutIfContext
    extends BaseProcessingContext {
        protected LayoutIfContext() {
        }
    }

    protected static class LayoutDefinitionContext
    extends BaseProcessingContext {
        protected LayoutDefinitionContext() {
        }
    }
}

