/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors.handler;

import java.io.Serializable;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

public class IODescriptor
implements Serializable {
    private static Map<String, Class> _typeMap = new HashMap<String, Class>();
    private String _name = null;
    private String _description = null;
    private Object _default = null;
    private Class _type = Object.class;
    private boolean _required = false;
    private static final long serialVersionUID = -6216999559790066926L;

    public IODescriptor(String name, String type) {
        this.setName(name);
        this.setType(type);
    }

    public String getName() {
        if (this._name == null) {
            throw new NullPointerException("Name cannot be null!");
        }
        return this._name;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String desc) {
        this._description = desc;
    }

    public Class getType() {
        return this._type;
    }

    public void setType(Class type) {
        this._type = type;
    }

    public void setType(String type) {
        if (type == null || type.trim().length() == 0) {
            return;
        }
        Class<?> cls = _typeMap.get(type);
        if (cls == null) {
            try {
                cls = Class.forName(type);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to determine parameter type '" + type + "' for parameter named '" + this.getName() + "'.", ex);
            }
        }
        this._type = cls;
    }

    public Object getDefault() {
        return this._default;
    }

    public void setDefault(Object def) {
        this._default = def;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public String toString() {
        Formatter printf = new Formatter();
        printf.format("%-28s  %-40s  %s", this._name + (this._required ? "(required)" : ""), this._type, this._default == null ? "" : "DEFAULT: " + this._default.toString());
        if (this._description != null) {
            printf.format("\n\t%s", this._description);
        }
        return printf.toString();
    }

    static {
        _typeMap.put("boolean", Boolean.class);
        _typeMap.put("Boolean", Boolean.class);
        _typeMap.put("byte", Byte.class);
        _typeMap.put("Byte", Byte.class);
        _typeMap.put("char", Character.class);
        _typeMap.put("Character", Character.class);
        _typeMap.put("double", Double.class);
        _typeMap.put("Double", Double.class);
        _typeMap.put("float", Float.class);
        _typeMap.put("Float", Float.class);
        _typeMap.put("int", Integer.class);
        _typeMap.put("Integer", Integer.class);
        _typeMap.put("long", Long.class);
        _typeMap.put("Long", Long.class);
        _typeMap.put("short", Short.class);
        _typeMap.put("Short", Short.class);
        _typeMap.put("char[]", String.class);
        _typeMap.put("String", String.class);
        _typeMap.put("Object", Object.class);
    }
}

