/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.component.factory;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.component.factory.ComponentFactory;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.event.CommandActionListener;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.TypeConverter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;

public abstract class ComponentFactoryBase
implements ComponentFactory {
    private static Map<String, Class> _typeCache = new HashMap<String, Class>();

    protected void setOptions(FacesContext context, LayoutComponent desc, UIComponent comp) {
        if (desc == null) {
            return;
        }
        String compId = desc.getId(context, comp.getParent());
        if (compId != null && !compId.equals("")) {
            comp.setId(compId);
        }
        Iterator<String> it = desc.getOptions().keySet().iterator();
        Object value = null;
        Object strVal = null;
        String key = null;
        while (it.hasNext()) {
            key = it.next();
            this.setOption(context, comp, key, desc.getEvaluatedOption(context, key, comp));
        }
        List<Handler> handlers = desc.getHandlers("command");
        if (handlers != null && comp instanceof ActionSource) {
            ((ActionSource)comp).addActionListener((ActionListener)CommandActionListener.getInstance());
        }
        this.storeInstanceHandlers(desc, comp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setOption(FacesContext context, UIComponent comp, String key, Object value) {
        String strVal = "" + value;
        if (ComponentUtil.isValueReference(strVal)) {
            ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), strVal, Object.class);
            comp.setValueExpression(key, ve);
            return;
        }
        Map attributes = comp.getAttributes();
        if (value == null) {
            try {
                attributes.remove(key);
                return;
            }
            catch (IllegalArgumentException ex) {
                try {
                    attributes.put(key, null);
                    return;
                }
                catch (IllegalArgumentException iae) {
                    if (!LogUtil.infoEnabled()) return;
                    LogUtil.info("JSFT0006", key, comp.getId(), comp.getClass().getName());
                    if (!LogUtil.fineEnabled()) return;
                    LogUtil.fine("Unable to set (" + key + ").", iae);
                }
            }
            return;
        }
        try {
            attributes.put(key, value);
            return;
        }
        catch (IllegalArgumentException ex) {
            Class type = ComponentFactoryBase.findPropertyType(comp, key);
            if (type == null) throw new IllegalArgumentException("Failed to set property (" + key + ") with value (" + value + "), which is of type (" + value.getClass().getName() + ").  This occured " + "on the component named (" + comp.getId() + ") of type (" + comp.getClass().getName() + ").", ex);
            try {
                attributes.put(key, TypeConverter.asType(type, value));
                return;
            }
            catch (IllegalArgumentException ex2) {
                throw new IllegalArgumentException("Failed to set property (" + key + ") with " + "value (" + value + "), which is of type (" + value.getClass().getName() + ").  Expected " + "type (" + type.getName() + ").  This " + "occured on the component named (" + comp.getId() + ") of type (" + comp.getClass().getName() + ").", ex2);
            }
        }
    }

    private static Class findPropertyType(UIComponent comp, String key) {
        Class<?> compClass = comp.getClass();
        String cacheKey = compClass.getName() + ';' + key;
        if (_typeCache.containsKey(cacheKey)) {
            return _typeCache.get(cacheKey);
        }
        Class<?> val = null;
        Method meth = null;
        String methodName = ComponentFactoryBase.getGetterName(key);
        try {
            meth = compClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                meth = compClass.getMethod("is" + methodName.substring(3), new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                ex2.printStackTrace();
            }
        }
        if (meth != null) {
            val = meth.getReturnType();
        } else {
            Object obj = comp.getAttributes().get("key");
            if (val != null) {
                val = obj.getClass();
            }
        }
        HashMap<String, Class> newTypeCache = new HashMap<String, Class>(_typeCache);
        newTypeCache.put(cacheKey, val);
        _typeCache = newTypeCache;
        return val;
    }

    private static String getGetterName(String name) {
        return "get" + (char)(name.charAt(0) & 0xFFDF) + name.substring(1);
    }

    protected void storeInstanceHandlers(LayoutComponent desc, UIComponent comp) {
        if (!desc.isNested()) {
            return;
        }
        Iterator<String> it = desc.getHandlersByTypeMap().keySet().iterator();
        if (it.hasNext()) {
            String eventType = null;
            Map compAttrs = comp.getAttributes();
            while (it.hasNext()) {
                eventType = it.next();
                if (eventType.equals("beforeCreate") || eventType.equals("afterCreate")) continue;
                compAttrs.put(eventType, desc.getHandlers(eventType));
            }
        }
    }

    protected void addChild(FacesContext context, LayoutComponent descriptor, UIComponent parent, UIComponent child) {
        if (descriptor.isFacetChild()) {
            String name = (String)descriptor.getEvaluatedOption(context, "_facetName", child);
            if (name != null) {
                parent.getFacets().put(name, child);
            } else {
                if (LogUtil.configEnabled()) {
                    LogUtil.config("Warning: no facet name was supplied for '" + descriptor.getId(context, child) + "'!");
                }
                child.setParent(parent);
            }
        } else {
            parent.getChildren().add(child);
        }
    }

    protected UIComponent createComponent(FacesContext ctx, String componentType, LayoutComponent desc, UIComponent parent) {
        UIComponent comp = null;
        String binding = (String)desc.getEvaluatedOption(ctx, "binding", parent);
        if (binding != null && ComponentUtil.isValueReference(binding)) {
            ValueExpression ve = ctx.getApplication().getExpressionFactory().createValueExpression(ctx.getELContext(), binding, UIComponent.class);
            comp = ctx.getApplication().createComponent(ve, ctx, componentType);
        } else {
            comp = ctx.getApplication().createComponent(componentType);
        }
        if (parent != null) {
            this.addChild(ctx, desc, parent, comp);
        }
        return comp;
    }
}

