/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.ManagedConnection;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.LocalTransaction;

public class DirectLocalTransaction
implements LocalTransaction {
    private ManagedConnection mc = null;
    private DirectConnection dc = null;
    private long transactionID = -1L;
    protected boolean started = false;
    protected boolean active = false;

    public DirectLocalTransaction(ManagedConnection managedConnection, DirectConnection directConnection) {
        this.mc = managedConnection;
        this.dc = directConnection;
    }

    public synchronized void begin() throws ResourceException {
        try {
            if (this.dc.isClosed()) {
                EISSystemException eISSystemException = new EISSystemException("MQRA:LT:startTransaction exception:Connection is closed");
                throw eISSystemException;
            }
            this.transactionID = this.dc._startTransaction("DirectLocalTransaction.begin()");
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException("MQRA:LT:startTransaction exception:" + exception.getMessage());
            eISSystemException.initCause((Throwable)exception);
            throw eISSystemException;
        }
        this.started = true;
        this.active = true;
        this.mc.setLTActive(true);
    }

    public synchronized void commit() throws ResourceException {
        block6: {
            try {
                if (!this.dc.isClosed()) {
                    this.dc._commitTransaction("DirectLocalTransaction.commit()", this.transactionID);
                    break block6;
                }
                EISSystemException eISSystemException = new EISSystemException("MQRA:LT:commitTransaction exception:Connection is closed");
                throw eISSystemException;
            }
            catch (Exception exception) {
                EISSystemException eISSystemException = new EISSystemException("MQRA:LT:commit exception:" + exception.getMessage());
                eISSystemException.initCause((Throwable)exception);
                throw eISSystemException;
            }
            finally {
                this.mc.setLTActive(false);
                this.started = false;
                this.active = false;
            }
        }
    }

    public synchronized void rollback() throws ResourceException {
        block6: {
            try {
                if (!this.dc.isClosed()) {
                    this.dc._rollbackTransaction("DirectLocalTransaction.rollback()", this.transactionID);
                    break block6;
                }
                EISSystemException eISSystemException = new EISSystemException("MQRA:LT:rillbackTransaction exception:Connection is closed");
                throw eISSystemException;
            }
            catch (Exception exception) {
                EISSystemException eISSystemException = new EISSystemException("MQRA:LT:rollback exception:" + exception.getMessage());
                eISSystemException.initCause((Throwable)exception);
                throw eISSystemException;
            }
            finally {
                this.mc.setLTActive(false);
                this.started = false;
                this.active = false;
            }
        }
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public boolean started() {
        return this.started;
    }

    public boolean isActive() {
        return this.active;
    }
}

