/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.broker;

import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdException;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdOptions;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdPrinter;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdProperties;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerCmdStatusEvent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminUtil;
import com.sun.messaging.jmq.admin.bkrutil.BrokerConstants;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.io.MetricCounters;
import com.sun.messaging.jmq.jmsclient.GenericPortMapperClient;
import com.sun.messaging.jmq.util.DebugPrinter;
import com.sun.messaging.jmq.util.DestLimitBehavior;
import com.sun.messaging.jmq.util.DestState;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.MultiColumnPrinter;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.ServiceState;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jms.management.server.BrokerState;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class CmdRunner
implements BrokerCmdOptions,
BrokerConstants,
AdminEventListener {
    private static final int METRICS_TOTALS = 0;
    private static final int METRICS_RATES = 1;
    private static final int METRICS_CONNECTIONS = 2;
    private static final int METRICS_CONSUMER = 3;
    private static final int METRICS_DISK = 4;
    private static final int METRICS_REMOVE = 5;
    private static final int LIST_ALL = 0;
    private static final int LIST_TOPIC = 1;
    private static final int LIST_QUEUE = 2;
    private int[] zeroNegOneInt = new int[]{0, -1};
    private long[] zeroNegOneLong = new long[]{0L, -1L};
    private String[] zeroNegOneString = new String[]{"0", "-1"};
    private String[] negOneString = new String[]{"-1"};
    private AdminResources ar = Globals.getAdminResources();
    private BrokerCmdProperties brokerCmdProps;
    private BrokerAdmin admin;

    public CmdRunner(BrokerCmdProperties brokerCmdProperties) {
        this.brokerCmdProps = brokerCmdProperties;
    }

    public int runCommands() {
        int n = 0;
        if (this.brokerCmdProps.debugModeSet()) {
            n = this.runDebug(this.brokerCmdProps);
            return n;
        }
        String string = this.brokerCmdProps.getCommand();
        if (string.equals("list")) {
            n = this.runList(this.brokerCmdProps);
        } else if (string.equals("pause")) {
            n = this.runPause(this.brokerCmdProps);
        } else if (string.equals("resume")) {
            n = this.runResume(this.brokerCmdProps);
        } else if (string.equals("shutdown")) {
            n = this.runShutdown(this.brokerCmdProps);
        } else if (string.equals("restart")) {
            n = this.runRestart(this.brokerCmdProps);
        } else if (string.equals("create")) {
            n = this.runCreate(this.brokerCmdProps);
        } else if (string.equals("destroy")) {
            n = this.runDestroy(this.brokerCmdProps);
        } else if (string.equals("purge")) {
            n = this.runPurge(this.brokerCmdProps);
        } else if (string.equals("update")) {
            n = this.runUpdate(this.brokerCmdProps);
        } else if (string.equals("query")) {
            n = this.runQuery(this.brokerCmdProps);
        } else if (string.equals("metrics")) {
            n = this.runMetrics(this.brokerCmdProps);
        } else if (string.equals("reload")) {
            n = this.runReload(this.brokerCmdProps);
        } else if (string.equals("commit")) {
            n = this.runCommit(this.brokerCmdProps);
        } else if (string.equals("rollback")) {
            n = this.runRollback(this.brokerCmdProps);
        } else if (string.equals("compact")) {
            n = this.runCompact(this.brokerCmdProps);
        } else if (string.equals("quiesce")) {
            n = this.runQuiesce(this.brokerCmdProps);
        } else if (string.equals("takeover")) {
            n = this.runTakeover(this.brokerCmdProps);
        } else if (string.equals("unquiesce")) {
            n = this.runUnquiesce(this.brokerCmdProps);
        } else if (string.equals("reset")) {
            n = this.runReset(this.brokerCmdProps);
        } else if (string.equals(".exists")) {
            n = this.runExists(this.brokerCmdProps);
        } else if (string.equals(".getattr")) {
            n = this.runGetAttr(this.brokerCmdProps);
        } else if (string.equals("._kill")) {
            n = this.runUngracefulKill(this.brokerCmdProps);
        } else if (string.equals(".purgeall")) {
            n = this.runPurgeAll(this.brokerCmdProps);
        } else if (string.equals(".destroyall")) {
            n = this.runDestroyAll(this.brokerCmdProps);
        }
        return n;
    }

    public void adminEventDispatched(AdminEvent adminEvent) {
        BrokerCmdStatusEvent brokerCmdStatusEvent;
        int n;
        if (adminEvent instanceof BrokerCmdStatusEvent && (n = (brokerCmdStatusEvent = (BrokerCmdStatusEvent)adminEvent).getType()) == 31) {
            int n2 = brokerCmdStatusEvent.getNumRetriesAttempted();
            int n3 = brokerCmdStatusEvent.getMaxNumRetries();
            long l = brokerCmdStatusEvent.getRetryTimeount();
            Object[] objectArray = new Object[]{Integer.toString(n2), Integer.toString(n3), Long.toString(l)};
            String string = this.ar.getString("A1350", objectArray);
            Globals.stdOutPrintln(string);
        }
    }

    private int runList(BrokerCmdProperties brokerCmdProperties) {
        boolean bl;
        BrokerAdmin brokerAdmin = this.init();
        String string = brokerCmdProperties.getCommandArg();
        String string2 = brokerCmdProperties.getDestType();
        int n = this.getDestTypeMask(brokerCmdProperties);
        boolean bl2 = bl = string2 == null;
        if ("dst".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1203"));
                return 1;
            }
            boolean bl3 = brokerCmdProperties.forceModeSet();
            if (!bl3) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            if (bl) {
                Globals.stdOutPrintln(this.ar.getString("A1201"));
            } else if (DestType.isQueue(n)) {
                Globals.stdOutPrintln(this.ar.getString("A1291"));
            } else if (DestType.isTopic(n)) {
                Globals.stdOutPrintln(this.ar.getString("A1290"));
            }
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetDestinationsMessage(null, -1);
                Vector vector = brokerAdmin.receiveGetDestinationsReplyMessage();
                if (vector != null) {
                    if (bl) {
                        this.listDests(brokerCmdProperties, vector, 0);
                    } else if (DestType.isTopic(n)) {
                        this.listDests(brokerCmdProperties, vector, 1);
                    } else if (DestType.isQueue(n)) {
                        this.listDests(brokerCmdProperties, vector, 2);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1203"));
                    return 1;
                }
                Globals.stdOutPrintln(this.ar.getString("A1202"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1203"));
                return 1;
            }
        }
        if ("svc".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1206"));
                return 1;
            }
            boolean bl4 = brokerCmdProperties.forceModeSet();
            if (!bl4) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1204"));
            this.printBrokerInfo(brokerAdmin);
            try {
                BrokerCmdPrinter brokerCmdPrinter;
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetServicesMessage(null);
                Vector vector = brokerAdmin.receiveGetServicesReplyMessage();
                if (vector != null) {
                    brokerCmdPrinter = new BrokerCmdPrinter(3, 4, "-");
                    Object[] objectArray = new String[3];
                    objectArray[0] = this.ar.getString("A1420");
                    objectArray[1] = this.ar.getString("A1421");
                    objectArray[2] = this.ar.getString("A1422");
                    brokerCmdPrinter.addTitle((String[])objectArray);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        ServiceInfo serviceInfo = (ServiceInfo)enumeration.nextElement();
                        objectArray[0] = serviceInfo.name;
                        if (serviceInfo.port == -1) {
                            objectArray[1] = "-";
                        } else if (serviceInfo.dynamicPort) {
                            switch (serviceInfo.state) {
                                case -1: {
                                    objectArray[1] = this.ar.getString("A1520");
                                    break;
                                }
                                default: {
                                    objectArray[1] = new Integer(serviceInfo.port).toString() + " (" + this.ar.getString("A1520") + ")";
                                    break;
                                }
                            }
                        } else {
                            objectArray[1] = new Integer(serviceInfo.port).toString() + " (" + this.ar.getString("A1521") + ")";
                        }
                        objectArray[2] = ServiceState.getString(serviceInfo.state);
                        brokerCmdPrinter.add(objectArray);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1206"));
                    return 1;
                }
                brokerCmdPrinter.println();
                Globals.stdOutPrintln(this.ar.getString("A1205"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1206"));
                return 1;
            }
        }
        if ("dur".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1553"));
                return 1;
            }
            boolean bl5 = brokerCmdProperties.forceModeSet();
            if (!bl5) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string3 = brokerCmdProperties.getDestName();
            Globals.stdOutPrintln(this.ar.getString("A1551", string3));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1553"));
                return 1;
            }
            try {
                this.isDestTypeTopic(brokerAdmin, string3);
            }
            catch (BrokerAdminException brokerAdminException) {
                if (7 == brokerAdminException.getType()) {
                    brokerAdminException.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3111", string3));
                }
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1553"));
                return 1;
            }
            try {
                BrokerCmdPrinter brokerCmdPrinter;
                brokerAdmin.sendGetDurablesMessage(string3, null);
                Vector vector = brokerAdmin.receiveGetDurablesReplyMessage();
                if (vector != null) {
                    brokerCmdPrinter = new BrokerCmdPrinter(4, 3, "-");
                    Object[] objectArray = new String[4];
                    objectArray[0] = this.ar.getString("A1430");
                    objectArray[1] = this.ar.getString("A1431");
                    objectArray[2] = this.ar.getString("A1432");
                    objectArray[3] = this.ar.getString("A1433");
                    brokerCmdPrinter.addTitle((String[])objectArray);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        DurableInfo durableInfo = (DurableInfo)enumeration.nextElement();
                        objectArray[0] = durableInfo.name == null ? "" : durableInfo.name;
                        objectArray[1] = durableInfo.clientID == null ? "" : durableInfo.clientID;
                        objectArray[2] = new Integer(durableInfo.nMessages).toString();
                        objectArray[3] = durableInfo.isActive ? this.ar.getString("A1510") : this.ar.getString("A1511");
                        brokerCmdPrinter.add(objectArray);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1553"));
                    return 1;
                }
                brokerCmdPrinter.setKeyCriteria(new int[]{0, 1});
                brokerCmdPrinter.println();
                Globals.stdOutPrintln(this.ar.getString("A1552"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1553"));
                return 1;
            }
        }
        if ("txn".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1253"));
                return 1;
            }
            boolean bl6 = brokerCmdProperties.forceModeSet();
            if (!bl6) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1250"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetTxnsMessage();
                Vector vector = brokerAdmin.receiveGetTxnsReplyMessage();
                if (vector != null && vector.size() > 0) {
                    BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(5, 3, "-");
                    BrokerCmdPrinter brokerCmdPrinter2 = new BrokerCmdPrinter(4, 3, "-");
                    BrokerCmdPrinter brokerCmdPrinter3 = new BrokerCmdPrinter(4, 3, "-");
                    Object[] objectArray = new String[5];
                    objectArray[0] = this.ar.getString("A1263");
                    objectArray[1] = this.ar.getString("A1269");
                    objectArray[2] = this.ar.getString("A1270");
                    objectArray[3] = this.ar.getString("A1272");
                    objectArray[4] = this.ar.getString("A1266");
                    brokerCmdPrinter.addTitle((String[])objectArray);
                    objectArray[0] = this.ar.getString("A1263");
                    objectArray[1] = this.ar.getString("A1269");
                    objectArray[2] = this.ar.getString("A1270");
                    objectArray[3] = this.ar.getString("A1266");
                    brokerCmdPrinter2.addTitle((String[])objectArray);
                    objectArray[0] = this.ar.getString("A1263");
                    objectArray[1] = this.ar.getString("A1269");
                    objectArray[2] = "# Acks";
                    objectArray[3] = "Remote broker";
                    brokerCmdPrinter3.addTitle((String[])objectArray);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string4;
                        String string5;
                        Integer n2;
                        Long l;
                        Hashtable hashtable = (Hashtable)enumeration.nextElement();
                        Integer n3 = (Integer)hashtable.get("type");
                        if (n3 == 0) {
                            l = (Long)hashtable.get("txnid");
                            objectArray[0] = this.checkNullAndPrint(l);
                            n2 = (Integer)hashtable.get("state");
                            objectArray[1] = this.getTxnStateString(n2);
                            string5 = (String)hashtable.get("user");
                            objectArray[2] = this.checkNullAndPrint(string5);
                            n2 = (Integer)hashtable.get("nmsgs");
                            string5 = this.checkNullAndPrint(n2);
                            n2 = (Integer)hashtable.get("nacks");
                            string4 = this.checkNullAndPrint(n2);
                            objectArray[3] = string5 + "/" + string4;
                            l = (Long)hashtable.get("timestamp");
                            objectArray[4] = this.checkNullAndPrintTimestamp(l);
                            brokerCmdPrinter.add(objectArray);
                            continue;
                        }
                        if (n3 == 1) {
                            l = (Long)hashtable.get("txnid");
                            objectArray[0] = this.checkNullAndPrint(l);
                            n2 = (Integer)hashtable.get("state");
                            objectArray[1] = this.getTxnStateString(n2);
                            string5 = (String)hashtable.get("user");
                            objectArray[2] = this.checkNullAndPrint(string5);
                            l = (Long)hashtable.get("timestamp");
                            objectArray[3] = this.checkNullAndPrintTimestamp(l);
                            brokerCmdPrinter2.add(objectArray);
                            continue;
                        }
                        if (n3 != 2) continue;
                        l = (Long)hashtable.get("txnid");
                        objectArray[0] = this.checkNullAndPrint(l);
                        n2 = (Integer)hashtable.get("state");
                        objectArray[1] = this.getTxnStateString(n2);
                        n2 = (Integer)hashtable.get("nacks");
                        objectArray[2] = string4 = this.checkNullAndPrint(n2);
                        string5 = (String)hashtable.get("homebroker");
                        objectArray[3] = this.checkNullAndPrint(string5);
                        brokerCmdPrinter3.add(objectArray);
                    }
                    Globals.stdOutPrintln("Transactions that are owned by this broker");
                    brokerCmdPrinter.println();
                    Globals.stdOutPrintln("   Transactions that involve remote brokers");
                    brokerCmdPrinter2.setIndent(3);
                    brokerCmdPrinter2.println();
                    Globals.stdOutPrintln("Transactions that are owned by a remote broker");
                    brokerCmdPrinter3.println();
                    Globals.stdOutPrintln(this.ar.getString("A1251"));
                }
                Globals.stdOutPrintln(this.ar.getString("A1252"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1253"));
                return 1;
            }
        } else if ("cxn".equals(string)) {
            String string6 = brokerCmdProperties.getService();
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1321"));
                return 1;
            }
            boolean bl7 = brokerCmdProperties.forceModeSet();
            if (!bl7) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            if (string6 == null) {
                Globals.stdOutPrintln(this.ar.getString("A1318"));
                this.printBrokerInfo(brokerAdmin);
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1319"));
                this.printServiceInfo(string6);
                Globals.stdOutPrintln(this.ar.getString("A1200"));
                this.printBrokerInfo(brokerAdmin);
            }
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetConnectionsMessage(string6, null);
                Vector vector = brokerAdmin.receiveGetConnectionsReplyMessage();
                if (vector != null && vector.size() > 0) {
                    BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(6, 2, "-");
                    Object[] objectArray = new String[6];
                    int n4 = 0;
                    int n5 = n4++;
                    objectArray[n5] = this.ar.getString("A1323");
                    int n6 = n4++;
                    objectArray[n6] = this.ar.getString("A1327");
                    int n7 = n4++;
                    objectArray[n7] = this.ar.getString("A1331");
                    int n8 = n4++;
                    objectArray[n8] = this.ar.getString("A1328");
                    int n9 = n4++;
                    objectArray[n9] = this.ar.getString("A1329");
                    int n10 = n4++;
                    objectArray[n10] = this.ar.getString("A1325");
                    brokerCmdPrinter.addTitle((String[])objectArray);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Hashtable hashtable = (Hashtable)enumeration.nextElement();
                        n4 = 0;
                        Long l = (Long)hashtable.get("cxnid");
                        objectArray[n4++] = this.checkNullAndPrint(l);
                        String string7 = (String)hashtable.get("user");
                        objectArray[n4++] = this.checkNullAndPrint(string7);
                        string7 = (String)hashtable.get("service");
                        objectArray[n4++] = this.checkNullAndPrint(string7);
                        Integer n11 = (Integer)hashtable.get("nproducers");
                        objectArray[n4++] = this.checkNullAndPrint(n11);
                        n11 = (Integer)hashtable.get("nconsumers");
                        objectArray[n4++] = this.checkNullAndPrint(n11);
                        string7 = (String)hashtable.get("host");
                        objectArray[n4++] = this.checkNullAndPrint(string7);
                        brokerCmdPrinter.add(objectArray);
                    }
                    brokerCmdPrinter.println();
                    Globals.stdOutPrintln(this.ar.getString("A1320"));
                }
                Globals.stdOutPrintln(this.ar.getString("A1322"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1321"));
                return 1;
            }
        } else if ("bkr".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1713"));
                return 1;
            }
            boolean bl8 = brokerCmdProperties.forceModeSet();
            if (!bl8) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1712"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetBrokerPropsMessage();
                Properties properties = brokerAdmin.receiveGetBrokerPropsReplyMessage();
                BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 3, null);
                Object[] objectArray = new String[2];
                String string8 = properties.getProperty("imq.cluster.ha");
                boolean bl9 = Boolean.valueOf(string8);
                if (bl9) {
                    objectArray[0] = this.ar.getString("A1709");
                    objectArray[1] = string8 = properties.getProperty("imq.cluster.clusterid", "");
                    brokerCmdPrinter.add(objectArray);
                }
                objectArray[0] = this.ar.getString("A1710");
                objectArray[1] = !bl9 ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
                brokerCmdPrinter.add(objectArray);
                brokerCmdPrinter.println();
                brokerAdmin.sendGetClusterMessage(true);
                Vector vector = brokerAdmin.receiveGetClusterReplyMessage();
                if (vector != null && vector.size() > 0) {
                    BrokerCmdPrinter brokerCmdPrinter4;
                    if (bl9) {
                        brokerCmdPrinter4 = new BrokerCmdPrinter(6, 3, "-");
                        Object[] objectArray2 = new String[6];
                        brokerCmdPrinter4.setSortNeeded(false);
                        brokerCmdPrinter4.setTitleAlign(1);
                        int n12 = 0;
                        objectArray2[n12++] = "";
                        objectArray2[n12++] = "";
                        objectArray2[n12++] = "";
                        objectArray2[n12++] = "";
                        int n13 = n12++;
                        objectArray2[n13] = this.ar.getString("A1720");
                        int n14 = n12++;
                        objectArray2[n14] = this.ar.getString("A1721");
                        brokerCmdPrinter4.addTitle((String[])objectArray2);
                        n12 = 0;
                        int n15 = n12++;
                        objectArray2[n15] = this.ar.getString("A1716");
                        int n16 = n12++;
                        objectArray2[n16] = this.ar.getString("A1717");
                        int n17 = n12++;
                        objectArray2[n17] = this.ar.getString("A1718");
                        int n18 = n12++;
                        objectArray2[n18] = this.ar.getString("A1719");
                        int n19 = n12++;
                        objectArray2[n19] = this.ar.getString("A1736");
                        int n20 = n12++;
                        objectArray2[n20] = this.ar.getString("A1737");
                        brokerCmdPrinter4.addTitle((String[])objectArray2);
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            Hashtable hashtable = (Hashtable)enumeration.nextElement();
                            n12 = 0;
                            objectArray2[n12++] = this.checkNullAndPrint(hashtable.get("ID"));
                            objectArray2[n12++] = this.checkNullAndPrint(hashtable.get("Address"));
                            Integer n21 = (Integer)hashtable.get("State");
                            objectArray2[n12++] = n21 != null ? BrokerState.toString(n21) : "";
                            Long l = (Long)hashtable.get("NumMsgs");
                            objectArray2[n12++] = this.checkNullAndPrint(l);
                            objectArray2[n12++] = this.checkNullAndPrint(hashtable.get("TakeoverBrokerID"));
                            l = (Long)hashtable.get("StatusTimestamp");
                            if (l != null) {
                                long l2 = System.currentTimeMillis() - l;
                                objectArray2[n12++] = this.getTimeString(l2);
                            } else {
                                objectArray2[n12++] = "";
                            }
                            brokerCmdPrinter4.add(objectArray2);
                        }
                    } else {
                        brokerCmdPrinter4 = new BrokerCmdPrinter(2, 3, "-");
                        Object[] objectArray3 = new String[2];
                        brokerCmdPrinter4.setSortNeeded(false);
                        brokerCmdPrinter4.setTitleAlign(1);
                        int n22 = 0;
                        int n23 = n22++;
                        objectArray3[n23] = this.ar.getString("A1717");
                        int n24 = n22++;
                        objectArray3[n24] = this.ar.getString("A1718");
                        brokerCmdPrinter4.addTitle((String[])objectArray3);
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            Hashtable hashtable = (Hashtable)enumeration.nextElement();
                            n22 = 0;
                            objectArray3[n22++] = this.checkNullAndPrint(hashtable.get("Address"));
                            Integer n25 = (Integer)hashtable.get("State");
                            objectArray3[n22++] = n25 != null ? BrokerState.toString(n25) : "";
                            brokerCmdPrinter4.add(objectArray3);
                        }
                    }
                    brokerCmdPrinter4.println();
                    Globals.stdOutPrintln(this.ar.getString("A1714"));
                }
                Globals.stdOutPrintln(this.ar.getString("A1715"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1713"));
                return 1;
            }
        } else if ("jmx".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1723"));
                return 1;
            }
            boolean bl10 = brokerCmdProperties.forceModeSet();
            if (!bl10) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1722"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetJMXConnectorsMessage(null);
                Vector vector = brokerAdmin.receiveGetJMXConnectorsReplyMessage();
                if (vector != null) {
                    BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(3, 4, null);
                    Object[] objectArray = new String[3];
                    objectArray[0] = this.ar.getString("A1726");
                    objectArray[1] = this.ar.getString("A1727");
                    objectArray[2] = this.ar.getString("A1728");
                    brokerCmdPrinter.addTitle((String[])objectArray);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Hashtable hashtable = (Hashtable)enumeration.nextElement();
                        int n26 = 0;
                        objectArray[n26++] = this.checkNullAndPrint(hashtable.get("name"));
                        objectArray[n26++] = this.checkNullAndPrint(hashtable.get("active"));
                        objectArray[n26++] = this.checkNullAndPrint(hashtable.get("url"));
                        brokerCmdPrinter.add(objectArray);
                    }
                    brokerCmdPrinter.println();
                    Globals.stdOutPrintln(this.ar.getString("A1724"));
                }
                Globals.stdErrPrintln(this.ar.getString("A1725"));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1724"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1723"));
                return 1;
            }
        } else if ("msg".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln("Listing messages failed.");
                return 1;
            }
            boolean bl11 = brokerCmdProperties.forceModeSet();
            if (!bl11) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string9 = brokerCmdProperties.getTargetName();
            n = this.getDestTypeMask(brokerCmdProperties);
            Long l = brokerCmdProperties.getMaxNumMsgsRetrieved();
            Long l3 = brokerCmdProperties.getStartMsgIndex();
            Globals.stdOutPrintln("Listing messages for the destination");
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetMessagesMessage(string9, n, false, null, l3, l);
                Vector vector = brokerAdmin.receiveGetMessagesReplyMessage();
                if (vector != null && vector.size() != 0) {
                    BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(4, 3, "-");
                    Object[] objectArray = new String[4];
                    brokerCmdPrinter.setSortNeeded(false);
                    int n27 = 0;
                    objectArray[n27++] = "Message #";
                    objectArray[n27++] = "Message IDs";
                    objectArray[n27++] = "Priority";
                    objectArray[n27++] = "Body Type";
                    brokerCmdPrinter.addTitle((String[])objectArray);
                    long l4 = 0L;
                    if (l3 != null) {
                        l4 = l3;
                    }
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        HashMap hashMap = (HashMap)enumeration.nextElement();
                        n27 = 0;
                        objectArray[n27++] = Long.toString(l4++);
                        objectArray[n27++] = this.checkNullAndPrint(hashMap.get("MessageID"));
                        objectArray[n27++] = this.checkNullAndPrint(hashMap.get("Priority"));
                        objectArray[n27++] = this.checkNullAndPrintMsgBodyType((Integer)hashMap.get("MessageBodyType"), false);
                        brokerCmdPrinter.add(objectArray);
                    }
                    brokerCmdPrinter.println();
                    Globals.stdOutPrintln("Successfully listed messages.");
                } else {
                    Globals.stdErrPrintln("There are no messages.");
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln("Successfully listed messages.");
                }
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln("Listing messages failed.");
                return 1;
            }
        }
        brokerAdmin.close();
        return 0;
    }

    private String getTimeString(long l) {
        String string = null;
        if (l < 1000L) {
            string = l + " milliseconds";
        } else if (l < 60000L) {
            long l2 = l / 1000L;
            string = l2 + " seconds";
        } else if (l < 3600000L) {
            long l3 = l / 60000L;
            string = l3 + " minutes";
        } else {
            string = "> 1 hour";
        }
        return string;
    }

    private void listDests(BrokerCmdProperties brokerCmdProperties, Vector vector, int n) {
        BrokerCmdPrinter brokerCmdPrinter = this.setupListDestTitle(n);
        Object[] objectArray = new String[9];
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            DestinationInfo destinationInfo = (DestinationInfo)enumeration.nextElement();
            int n2 = 0;
            float f = 0.0f;
            if ("__JMQAdmin".equals(destinationInfo.name) || DestType.isInternal(destinationInfo.fulltype)) continue;
            if (DestType.isTemporary(destinationInfo.type)) {
                if (!brokerCmdProperties.showTempDestModeSet()) continue;
                string = BrokerAdminUtil.getDestinationType(destinationInfo.type) + " (" + this.ar.getString("A1631") + ")";
            } else {
                string = BrokerAdminUtil.getDestinationType(destinationInfo.type);
            }
            if (n == 1 && !DestType.isTopic(destinationInfo.type) || n == 2 && !DestType.isQueue(destinationInfo.type)) continue;
            int n3 = destinationInfo.nMessages - destinationInfo.nTxnMessages;
            long l = destinationInfo.nMessageBytes;
            if (n3 > 0) {
                f = (float)l / (float)n3;
            }
            objectArray[n2++] = destinationInfo.name;
            objectArray[n2++] = string;
            objectArray[n2++] = DestState.toString(destinationInfo.destState);
            objectArray[n2++] = new Integer(destinationInfo.nProducers).toString();
            if (DestType.isTopic(destinationInfo.type)) {
                objectArray[n2++] = new Integer(destinationInfo.nConsumers).toString();
            } else if (n == 2) {
                objectArray[n2++] = new Integer(destinationInfo.naConsumers).toString();
                objectArray[n2++] = new Integer(destinationInfo.nfConsumers).toString();
            } else {
                objectArray[n2++] = new Integer(destinationInfo.naConsumers + destinationInfo.nfConsumers).toString();
            }
            objectArray[n2++] = new Integer(n3).toString();
            objectArray[n2++] = new Integer(destinationInfo.nUnackMessages).toString();
            objectArray[n2++] = new Float(f).toString();
            brokerCmdPrinter.add(objectArray);
        }
        brokerCmdPrinter.setKeyCriteria(new int[]{0, 1});
        brokerCmdPrinter.println();
    }

    private String getTxnStateString(Integer n) {
        if (n == null) {
            return "";
        }
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.ar.getString("A1280");
            }
            case 1: {
                return this.ar.getString("A1281");
            }
            case 2: {
                return this.ar.getString("A1282");
            }
            case 3: {
                return this.ar.getString("A1283");
            }
            case 4: {
                return this.ar.getString("A1284");
            }
            case 5: {
                return this.ar.getString("A1285");
            }
            case 6: {
                return this.ar.getString("A1286");
            }
            case 7: {
                return this.ar.getString("A1287");
            }
        }
        return this.ar.getString("A1288");
    }

    private int runPause(BrokerCmdProperties brokerCmdProperties) {
        String string = null;
        String string2 = this.ar.getString("A5016");
        String string3 = this.ar.getString("A5015");
        String string4 = this.ar.getString("A5018");
        String string5 = this.ar.getString("A5017");
        BrokerAdmin brokerAdmin = this.init();
        boolean bl = brokerCmdProperties.forceModeSet();
        String string6 = brokerCmdProperties.getCommandArg();
        if ("bkr".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1209"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1207"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1209"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5005"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendPauseMessage(null);
                    brokerAdmin.receivePauseReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1208"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1209"));
                    return 1;
                }
            }
            if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                Globals.stdOutPrintln(this.ar.getString("A1210"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", string));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1210"));
            return 1;
        }
        if ("svc".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1213"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string7 = brokerCmdProperties.getTargetName();
            Globals.stdOutPrintln(this.ar.getString("A1211"));
            this.printServiceInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1213"));
                return 1;
            }
            try {
                this.isAdminService(brokerAdmin, string7);
            }
            catch (BrokerAdminException brokerAdminException) {
                if (7 == brokerAdminException.getType()) {
                    brokerAdminException.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3109", string7));
                }
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1213"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5006"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendPauseMessage(string7);
                    brokerAdmin.receivePauseReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1212"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1213"));
                    return 1;
                }
            }
            if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                Globals.stdOutPrintln(this.ar.getString("A1214"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", string));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1214"));
            return 1;
        }
        if ("dst".equals(string6)) {
            BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
            Object[] objectArray = new String[2];
            boolean bl2 = true;
            String string8 = brokerCmdProperties.getTargetName();
            int n = this.getDestTypeMask(brokerCmdProperties);
            String string9 = brokerCmdProperties.getPauseType();
            if (string8 != null) {
                bl2 = false;
            }
            if (brokerAdmin == null) {
                if (bl2) {
                    Globals.stdErrPrintln(this.ar.getString("A1311"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1275"));
                }
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            if (bl2) {
                Globals.stdOutPrintln(this.ar.getString("A1309"));
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1273"));
                this.printDestinationInfo();
            }
            if (string9 != null) {
                Globals.stdOutPrintln(this.ar.getString("A1317"));
                objectArray[0] = this.ar.getString("A1442");
                objectArray[1] = string9;
                brokerCmdPrinter.add(objectArray);
                brokerCmdPrinter.println();
            }
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                if (bl2) {
                    Globals.stdErrPrintln(this.ar.getString("A1311"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1275"));
                }
                return 1;
            }
            if (!bl) {
                string = bl2 ? this.getUserInput(this.ar.getString("A5025"), string5) : this.getUserInput(this.ar.getString("A5021"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    int n2 = this.getPauseTypeVal(string9);
                    brokerAdmin.sendPauseMessage(string8, n, n2);
                    brokerAdmin.receivePauseReplyMessage();
                    if (bl2) {
                        Globals.stdOutPrintln(this.ar.getString("A1310"));
                    }
                    Globals.stdOutPrintln(this.ar.getString("A1274"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    if (bl2) {
                        Globals.stdErrPrintln(this.ar.getString("A1311"));
                    } else {
                        Globals.stdErrPrintln(this.ar.getString("A1275"));
                    }
                    return 1;
                }
            } else {
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    if (bl2) {
                        Globals.stdOutPrintln(this.ar.getString("A1312"));
                    } else {
                        Globals.stdOutPrintln(this.ar.getString("A1276"));
                    }
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", string));
                Globals.stdOutPrintln("");
                if (bl2) {
                    Globals.stdOutPrintln(this.ar.getString("A1312"));
                } else {
                    Globals.stdOutPrintln(this.ar.getString("A1276"));
                }
                return 1;
            }
        }
        brokerAdmin.close();
        return 0;
    }

    private int runReset(BrokerCmdProperties brokerCmdProperties) {
        String string = null;
        String string2 = this.ar.getString("A5016");
        String string3 = this.ar.getString("A5015");
        String string4 = this.ar.getString("A5018");
        String string5 = this.ar.getString("A5017");
        BrokerAdmin brokerAdmin = this.init();
        boolean bl = brokerCmdProperties.forceModeSet();
        String string6 = brokerCmdProperties.getCommandArg();
        if ("bkr".equals(string6)) {
            BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
            Object[] objectArray = new String[2];
            String string7 = brokerCmdProperties.getResetType();
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1766"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1764"));
            if (string7 != null) {
                Globals.stdOutPrintln(this.ar.getString("A1317"));
                objectArray[0] = this.ar.getString("A1768");
                objectArray[1] = string7;
                brokerCmdPrinter.add(objectArray);
                brokerCmdPrinter.println();
            }
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1766"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5031"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    String string8 = this.getResetTypeVal(string7);
                    brokerAdmin.sendResetBrokerMessage(string8);
                    brokerAdmin.receiveResetBrokerReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1765"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1766"));
                    return 1;
                }
            } else {
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln(this.ar.getString("A1767"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", string));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1767"));
                return 1;
            }
        }
        brokerAdmin.close();
        return 0;
    }

    private int runResume(BrokerCmdProperties brokerCmdProperties) {
        String string = null;
        String string2 = this.ar.getString("A5016");
        String string3 = this.ar.getString("A5015");
        String string4 = this.ar.getString("A5018");
        String string5 = this.ar.getString("A5017");
        BrokerAdmin brokerAdmin = this.init();
        boolean bl = brokerCmdProperties.forceModeSet();
        String string6 = brokerCmdProperties.getCommandArg();
        if ("bkr".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1217"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1215"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1217"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5007"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendResumeMessage(null);
                    brokerAdmin.receiveResumeReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1216"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1217"));
                    return 1;
                }
            }
            if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                Globals.stdOutPrintln(this.ar.getString("A1218"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", string));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1218"));
            return 1;
        }
        if ("svc".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1221"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string7 = brokerCmdProperties.getTargetName();
            Globals.stdOutPrintln(this.ar.getString("A1219"));
            this.printServiceInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1221"));
                return 1;
            }
            try {
                this.isAdminService(brokerAdmin, string7);
            }
            catch (BrokerAdminException brokerAdminException) {
                if (7 == brokerAdminException.getType()) {
                    brokerAdminException.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3110", string7));
                }
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1221"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5008"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendResumeMessage(string7);
                    brokerAdmin.receiveResumeReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1220"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1221"));
                    return 1;
                }
            }
            if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                Globals.stdOutPrintln(this.ar.getString("A1222"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", string));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1222"));
            return 1;
        }
        if ("dst".equals(string6)) {
            boolean bl2 = true;
            String string8 = brokerCmdProperties.getTargetName();
            int n = this.getDestTypeMask(brokerCmdProperties);
            if (string8 != null) {
                bl2 = false;
            }
            if (brokerAdmin == null) {
                if (bl2) {
                    Globals.stdErrPrintln(this.ar.getString("A1315"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1294"));
                }
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            if (bl2) {
                Globals.stdOutPrintln(this.ar.getString("A1313"));
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1292"));
                this.printDestinationInfo();
                Globals.stdOutPrintln(this.ar.getString("A1200"));
            }
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                if (bl2) {
                    Globals.stdErrPrintln(this.ar.getString("A1315"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1294"));
                }
                return 1;
            }
            if (!bl) {
                string = bl2 ? this.getUserInput(this.ar.getString("A5026"), string5) : this.getUserInput(this.ar.getString("A5022"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendResumeMessage(string8, n);
                    brokerAdmin.receiveResumeReplyMessage();
                    if (bl2) {
                        Globals.stdOutPrintln(this.ar.getString("A1314"));
                    }
                    Globals.stdOutPrintln(this.ar.getString("A1293"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    if (bl2) {
                        Globals.stdErrPrintln(this.ar.getString("A1315"));
                    } else {
                        Globals.stdErrPrintln(this.ar.getString("A1294"));
                    }
                    return 1;
                }
            } else {
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    if (bl2) {
                        Globals.stdOutPrintln(this.ar.getString("A1316"));
                    } else {
                        Globals.stdOutPrintln(this.ar.getString("A1295"));
                    }
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", string));
                Globals.stdOutPrintln("");
                if (bl2) {
                    Globals.stdOutPrintln(this.ar.getString("A1316"));
                } else {
                    Globals.stdOutPrintln(this.ar.getString("A1295"));
                }
                return 1;
            }
        }
        brokerAdmin.close();
        return 0;
    }

    private int runShutdown(BrokerCmdProperties brokerCmdProperties) {
        String string;
        String string2 = null;
        String string3 = this.ar.getString("A5016");
        String string4 = this.ar.getString("A5015");
        String string5 = this.ar.getString("A5018");
        String string6 = this.ar.getString("A5017");
        BrokerAdmin brokerAdmin = this.init();
        if (brokerAdmin == null) {
            Globals.stdErrPrintln(this.ar.getString("A1225"));
            return 1;
        }
        boolean bl = brokerCmdProperties.forceModeSet();
        if (!bl) {
            brokerAdmin = this.promptForAuthentication(brokerAdmin);
        }
        boolean bl2 = brokerCmdProperties.noFailoverSet();
        int n = brokerCmdProperties.getTime();
        Globals.stdOutPrintln(this.ar.getString("A1223"));
        this.printBrokerInfo(brokerAdmin);
        try {
            this.connectToBroker(brokerAdmin);
            string = this.getPortMapperSessionID(brokerCmdProperties, brokerAdmin);
        }
        catch (BrokerAdminException brokerAdminException) {
            this.handleBrokerAdminException(brokerAdminException);
            Globals.stdErrPrintln(this.ar.getString("A1225"));
            return 1;
        }
        if (!bl) {
            string2 = this.getUserInput(this.ar.getString("A5009"), string6);
            Globals.stdOutPrintln("");
        }
        if (string4.equalsIgnoreCase(string2) || string3.equalsIgnoreCase(string2) || bl) {
            try {
                brokerAdmin.sendShutdownMessage(false, false, bl2, n);
                brokerAdmin.receiveShutdownReplyMessage();
                if (this.waitForShutdown(brokerAdmin, string, brokerCmdProperties)) {
                    Globals.stdOutPrintln(this.ar.getString("A1224"));
                }
                Globals.stdOutPrintln(this.ar.getString("A1760"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1225"));
                return 1;
            }
        } else {
            if (string6.equalsIgnoreCase(string2) || string5.equalsIgnoreCase(string2)) {
                Globals.stdOutPrintln(this.ar.getString("A1226"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", string2));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1226"));
            return 1;
        }
        return 0;
    }

    private boolean waitForShutdown(BrokerAdmin brokerAdmin, String string, BrokerCmdProperties brokerCmdProperties) {
        int n;
        GenericPortMapperClient genericPortMapperClient = null;
        String string2 = brokerAdmin.getBrokerHost();
        String string3 = brokerAdmin.getBrokerPort();
        String string4 = null;
        if (brokerCmdProperties == null) {
            return false;
        }
        long l = brokerCmdProperties.getShutdownWaitInterval();
        int n2 = brokerCmdProperties.getTime();
        if (n2 > 0) {
            return false;
        }
        if (string == null) {
            return false;
        }
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            n = 7676;
        }
        boolean bl = false;
        boolean bl2 = false;
        Globals.stdOutPrintln(this.ar.getString("A1761", string2 + ":" + string3));
        while (!bl) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                genericPortMapperClient = new GenericPortMapperClient(string2, n);
            }
            catch (Exception exception) {
                bl = true;
            }
            if (genericPortMapperClient == null) continue;
            string4 = genericPortMapperClient.getProperty("sessionid", null, "PORTMAPPER", "portmapper");
            if (string4 == null) {
                bl = true;
                continue;
            }
            if (string4.equals(string)) continue;
            bl = true;
        }
        return true;
    }

    private String getPortMapperSessionID(BrokerCmdProperties brokerCmdProperties, BrokerAdmin brokerAdmin) {
        int n;
        String string = brokerAdmin.getBrokerHost();
        String string2 = brokerAdmin.getBrokerPort();
        String string3 = null;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            n = 7676;
        }
        try {
            GenericPortMapperClient genericPortMapperClient = new GenericPortMapperClient(string, n);
            string3 = genericPortMapperClient.getProperty("sessionid", null, "PORTMAPPER", "portmapper");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    private int runRestart(BrokerCmdProperties brokerCmdProperties) {
        String string = null;
        String string2 = this.ar.getString("A5016");
        String string3 = this.ar.getString("A5015");
        String string4 = this.ar.getString("A5018");
        String string5 = this.ar.getString("A5017");
        BrokerAdmin brokerAdmin = this.init();
        if (brokerAdmin == null) {
            Globals.stdErrPrintln(this.ar.getString("A1229"));
            return 1;
        }
        boolean bl = brokerCmdProperties.forceModeSet();
        if (!bl) {
            brokerAdmin = this.promptForAuthentication(brokerAdmin);
        }
        Globals.stdOutPrintln(this.ar.getString("A1227"));
        this.printBrokerInfo(brokerAdmin);
        try {
            this.connectToBroker(brokerAdmin);
        }
        catch (BrokerAdminException brokerAdminException) {
            this.handleBrokerAdminException(brokerAdminException);
            Globals.stdErrPrintln(this.ar.getString("A1229"));
            return 1;
        }
        if (!bl) {
            string = this.getUserInput(this.ar.getString("A5010"), string5);
            Globals.stdOutPrintln("");
        }
        if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
            try {
                brokerAdmin.sendShutdownMessage(true);
                brokerAdmin.receiveShutdownReplyMessage();
                if (!this.reconnectToBroker(brokerAdmin)) {
                    Globals.stdErrPrintln(this.ar.getString("A1229"));
                    return 1;
                }
                Globals.stdOutPrintln(this.ar.getString("A1228"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1229"));
                return 1;
            }
        } else {
            if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                Globals.stdOutPrintln(this.ar.getString("A1230"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", string));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1230"));
            return 1;
        }
        brokerAdmin.close();
        return 0;
    }

    private int runCreate(BrokerCmdProperties brokerCmdProperties) {
        BrokerAdmin brokerAdmin = this.init();
        if (brokerAdmin == null) {
            Globals.stdErrPrintln(this.ar.getString("A1233"));
            return 1;
        }
        boolean bl = brokerCmdProperties.forceModeSet();
        if (!bl) {
            brokerAdmin = this.promptForAuthentication(brokerAdmin);
        }
        String string = brokerCmdProperties.getTargetName();
        int n = this.getDestTypeMask(brokerCmdProperties);
        Properties properties = brokerCmdProperties.getTargetAttrs();
        Globals.stdOutPrintln(this.ar.getString("A1231"));
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        brokerCmdPrinter.setSortNeeded(false);
        objectArray[0] = this.ar.getString("A1400");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1401");
        objectArray[1] = BrokerAdminUtil.getDestinationType(n);
        brokerCmdPrinter.add(objectArray);
        String string2 = null;
        string2 = properties.getProperty("maxNumMsgs");
        if (string2 != null) {
            objectArray[0] = this.ar.getString("A1407");
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        if ((string2 = properties.getProperty("maxTotalMsgBytes")) != null) {
            objectArray[0] = this.ar.getString("A1406");
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        if ((string2 = properties.getProperty("maxBytesPerMsg")) != null) {
            objectArray[0] = this.ar.getString("A1408");
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        if ((string2 = properties.getProperty("maxNumProducers")) != null) {
            objectArray[0] = this.ar.getString("A1415");
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        if ((string2 = properties.getProperty("maxNumActiveConsumers")) != null) {
            objectArray[0] = this.ar.getString("A1410");
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        if ((string2 = properties.getProperty("maxNumBackupConsumers")) != null) {
            objectArray[0] = this.ar.getString("A1409");
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        if ((string2 = properties.getProperty("limitBehavior")) != null) {
            objectArray[0] = this.ar.getString("A1412");
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        if ((string2 = properties.getProperty("consumerFlowLimit")) != null) {
            objectArray[0] = this.ar.getString("A1414");
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        if ((string2 = properties.getProperty("isLocalOnly")) != null) {
            objectArray[0] = this.ar.getString("A1411");
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        if ((string2 = properties.getProperty("localDeliveryPreferred")) != null) {
            objectArray[0] = this.ar.getString("A1413");
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        if ((string2 = properties.getProperty("useDMQ")) != null) {
            objectArray[0] = this.ar.getString("A1446");
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        brokerCmdPrinter.println();
        Globals.stdOutPrintln(this.ar.getString("A1200"));
        this.printBrokerInfo(brokerAdmin);
        try {
            long l;
            SizeString sizeString;
            DestinationInfo destinationInfo = new DestinationInfo();
            destinationInfo.setType(n);
            destinationInfo.setName(string);
            string2 = properties.getProperty("maxTotalMsgBytes");
            if (string2 != null) {
                try {
                    sizeString = new SizeString(string2);
                    l = sizeString.getBytes();
                    destinationInfo.setMaxMessageBytes(l);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string2 = properties.getProperty("maxNumMsgs")) != null) {
                destinationInfo.setMaxMessages(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty("maxBytesPerMsg")) != null) {
                try {
                    sizeString = new SizeString(string2);
                    l = sizeString.getBytes();
                    destinationInfo.setMaxMessageSize(l);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string2 = properties.getProperty("maxNumBackupConsumers")) != null) {
                destinationInfo.setMaxFailoverConsumers(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty("maxNumActiveConsumers")) != null) {
                destinationInfo.setMaxActiveConsumers(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty("isLocalOnly")) != null) {
                destinationInfo.setScope(Boolean.valueOf(string2));
            }
            if ((string2 = properties.getProperty("limitBehavior")) != null) {
                destinationInfo.setLimitBehavior(this.getLimitBehavValue(string2));
            }
            if ((string2 = properties.getProperty("localDeliveryPreferred")) != null) {
                destinationInfo.setClusterDeliveryPolicy(this.getClusterDeliveryPolicy(string2));
            }
            if ((string2 = properties.getProperty("consumerFlowLimit")) != null) {
                destinationInfo.setPrefetch(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty("maxNumProducers")) != null) {
                destinationInfo.setMaxProducers(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty("useDMQ")) != null) {
                destinationInfo.setUseDMQ(Boolean.valueOf(string2));
            }
            this.connectToBroker(brokerAdmin);
            brokerAdmin.sendCreateDestinationMessage(destinationInfo);
            brokerAdmin.receiveCreateDestinationReplyMessage();
            Globals.stdOutPrintln(this.ar.getString("A1232"));
        }
        catch (BrokerAdminException brokerAdminException) {
            this.handleBrokerAdminException(brokerAdminException);
            Globals.stdErrPrintln(this.ar.getString("A1233"));
            return 1;
        }
        brokerAdmin.close();
        return 0;
    }

    private int runDestroy(BrokerCmdProperties brokerCmdProperties) {
        String string = null;
        String string2 = this.ar.getString("A5016");
        String string3 = this.ar.getString("A5015");
        String string4 = this.ar.getString("A5018");
        String string5 = this.ar.getString("A5017");
        String string6 = brokerCmdProperties.getCommandArg();
        boolean bl = brokerCmdProperties.forceModeSet();
        BrokerAdmin brokerAdmin = this.init();
        if ("dst".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1236"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string7 = brokerCmdProperties.getTargetName();
            int n = this.getDestTypeMask(brokerCmdProperties);
            Globals.stdOutPrintln(this.ar.getString("A1234"));
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1236"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5003"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendDestroyDestinationMessage(string7, n);
                    brokerAdmin.receiveDestroyDestinationReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1235"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1236"));
                    return 1;
                }
            }
            if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                Globals.stdOutPrintln(this.ar.getString("A1237"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", string));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1237"));
            return 1;
        }
        if ("dur".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1556"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string8 = brokerCmdProperties.getTargetName();
            String string9 = brokerCmdProperties.getClientID();
            Globals.stdOutPrintln(this.ar.getString("A1554"));
            this.printDurableSubscriptionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1556"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5014"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendDestroyDurableMessage(string8, string9);
                    brokerAdmin.receiveDestroyDurableReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1555"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1556"));
                    return 1;
                }
            }
            if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                Globals.stdOutPrintln(this.ar.getString("A1557"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", string));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1557"));
            return 1;
        }
        if ("cxn".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1730"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string10 = brokerCmdProperties.getTargetName();
            Long l = null;
            try {
                l = Long.valueOf(string10);
            }
            catch (NumberFormatException numberFormatException) {
                Globals.stdErrPrintln(this.ar.getString("A3159", string10));
                Globals.stdErrPrintln(this.ar.getString("A1730"));
                return 1;
            }
            Globals.stdOutPrintln(this.ar.getString("A1729"));
            this.printConnectionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1730"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5029"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendDestroyConnectionMessage(l);
                    brokerAdmin.receiveDestroyConnectionReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1731"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1730"));
                    return 1;
                }
            }
            if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                Globals.stdOutPrintln(this.ar.getString("A1732"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", string));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1732"));
            return 1;
        }
        if ("msg".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln("Destroying message failed.");
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string11 = brokerCmdProperties.getTargetName();
            int n = this.getDestTypeMask(brokerCmdProperties);
            String string12 = brokerCmdProperties.getMsgID();
            Globals.stdOutPrintln("Destroying message:");
            this.printMessageInfo();
            Globals.stdOutPrintln("In the destination");
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln("Destroying message failed.");
                return 1;
            }
            if (!bl) {
                string = this.getUserInput("Are you sure you want to destroy this message? (y/n)[n] ", string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendDestroyMessagesMessage(string11, n, string12);
                    brokerAdmin.receiveDestroyMessagesReplyMessage();
                    Globals.stdOutPrintln("Successfully destroyed message.");
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln("Destroying message failed.");
                    return 1;
                }
            } else {
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln("The message was not destroyed.\n");
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", string));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln("The message was not destroyed.\n");
                return 1;
            }
        }
        brokerAdmin.close();
        return 0;
    }

    private int runPurge(BrokerCmdProperties brokerCmdProperties) {
        String string = null;
        String string2 = this.ar.getString("A5016");
        String string3 = this.ar.getString("A5015");
        String string4 = this.ar.getString("A5018");
        String string5 = this.ar.getString("A5017");
        String string6 = brokerCmdProperties.getCommandArg();
        boolean bl = brokerCmdProperties.forceModeSet();
        BrokerAdmin brokerAdmin = this.init();
        if ("dst".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1240"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string7 = brokerCmdProperties.getTargetName();
            int n = this.getDestTypeMask(brokerCmdProperties);
            Globals.stdOutPrintln(this.ar.getString("A1238"));
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1240"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5004"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendPurgeDestinationMessage(string7, n);
                    brokerAdmin.receivePurgeDestinationReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1239"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1240"));
                    return 1;
                }
            }
            if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                Globals.stdOutPrintln(this.ar.getString("A1241"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", string));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1241"));
            return 1;
        }
        if ("dur".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1634"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string8 = brokerCmdProperties.getTargetName();
            String string9 = brokerCmdProperties.getClientID();
            Globals.stdOutPrintln(this.ar.getString("A1635"));
            this.printDurableSubscriptionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1634"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5020"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendPurgeDurableMessage(string8, string9);
                    brokerAdmin.receivePurgeDurableReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1636"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1634"));
                    return 1;
                }
            } else {
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln(this.ar.getString("A1637"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", string));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1637"));
                return 1;
            }
        }
        brokerAdmin.close();
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int runPurgeAll(BrokerCmdProperties var1_1) {
        var3_2 = null;
        var8_3 = 0;
        var4_4 = this.ar.getString("A5016");
        var5_5 = this.ar.getString("A5015");
        var6_6 = this.ar.getString("A5018");
        var7_7 = this.ar.getString("A5017");
        var9_8 = var1_1.getCommandArg();
        var10_9 = var1_1.forceModeSet();
        var2_10 = this.init();
        if ("dst".equals(var9_8)) {
            if (var2_10 == null) {
                Globals.stdErrPrintln("Purging all the destinations failed");
                return 1;
            }
            if (!var10_9) {
                var2_10 = this.promptForAuthentication(var2_10);
            }
            Globals.stdOutPrintln("Purging all the destinations");
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(var2_10);
            try {
                this.connectToBroker(var2_10);
            }
            catch (BrokerAdminException var11_11) {
                this.handleBrokerAdminException(var11_11);
                Globals.stdErrPrintln("Purging all the destinations failed");
                return 1;
            }
            if (!var10_9) {
                var3_2 = this.getUserInput("Are you sure you want to purge all the destinations? (y/n)[n] ", var7_7);
                Globals.stdOutPrintln("");
            }
            if (var5_5.equalsIgnoreCase(var3_2) || var4_4.equalsIgnoreCase(var3_2) || var10_9) {
                try {
                    var11_12 = false;
                    var2_10.sendGetDestinationsMessage(null, -1);
                    var12_14 = var2_10.receiveGetDestinationsReplyMessage();
                    if (var12_14 != null) {
                        var13_15 = var12_14.elements();
                        while (var13_15.hasMoreElements()) {
                            var14_16 = (DestinationInfo)var13_15.nextElement();
                            var15_17 = var14_16.name;
                            var16_18 = var14_16.type;
                            if ("__JMQAdmin".equals(var15_17) || DestType.isInternal(var14_16.fulltype) || DestType.isTemporary(var14_16.type)) {
                                Globals.stdOutPrintln("Skipping destination: " + var15_17);
                                continue;
                            }
                            try {
                                var2_10.sendPurgeDestinationMessage(var15_17, var16_18);
                                var2_10.receivePurgeDestinationReplyMessage();
                                if (DestType.isQueue(var16_18)) {
                                    Globals.stdOutPrintln("Successfully purged queue " + var15_17);
                                } else {
                                    Globals.stdOutPrintln("Successfully purged topic " + var15_17);
                                }
                                var11_12 = true;
                            }
                            catch (BrokerAdminException var17_19) {
                                this.handleBrokerAdminException(var17_19);
                                if (DestType.isQueue(var16_18)) {
                                    Globals.stdOutPrintln("Purging failed for queue " + var15_17);
                                } else {
                                    Globals.stdOutPrintln("Purging failed for topic " + var15_17);
                                }
                                var8_3 = 1;
                            }
                        }
                    }
                    if (var11_12) ** GOTO lbl79
                    Globals.stdOutPrintln("No destinations purged.");
                }
                catch (BrokerAdminException var11_13) {
                    this.handleBrokerAdminException(var11_13);
                    Globals.stdErrPrintln("Purging all the destinations failed");
                    return 1;
                }
            } else {
                if (var7_7.equalsIgnoreCase(var3_2) || var6_6.equalsIgnoreCase(var3_2)) {
                    Globals.stdOutPrintln("The destinations were not purged.");
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", var3_2));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln("The destinations were not purged.");
                return 1;
            }
        }
lbl79:
        // 4 sources

        var2_10.close();
        return var8_3;
    }

    /*
     * Unable to fully structure code
     */
    private int runDestroyAll(BrokerCmdProperties var1_1) {
        var3_2 = null;
        var8_3 = 0;
        var4_4 = this.ar.getString("A5016");
        var5_5 = this.ar.getString("A5015");
        var6_6 = this.ar.getString("A5018");
        var7_7 = this.ar.getString("A5017");
        var9_8 = var1_1.getCommandArg();
        var10_9 = var1_1.forceModeSet();
        var2_10 = this.init();
        if ("dst".equals(var9_8)) {
            if (var2_10 == null) {
                Globals.stdErrPrintln("Destroying all the destinations failed");
                return 1;
            }
            if (!var10_9) {
                var2_10 = this.promptForAuthentication(var2_10);
            }
            Globals.stdOutPrintln("Destroying all the destinations");
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(var2_10);
            try {
                this.connectToBroker(var2_10);
            }
            catch (BrokerAdminException var11_11) {
                this.handleBrokerAdminException(var11_11);
                Globals.stdErrPrintln("Destroying all the destinations failed");
                return 1;
            }
            if (!var10_9) {
                var3_2 = this.getUserInput("Are you sure you want to destroy all the destinations? (y/n)[n] ", var7_7);
                Globals.stdOutPrintln("");
            }
            if (var5_5.equalsIgnoreCase(var3_2) || var4_4.equalsIgnoreCase(var3_2) || var10_9) {
                try {
                    var11_12 = false;
                    var2_10.sendGetDestinationsMessage(null, -1);
                    var12_14 = var2_10.receiveGetDestinationsReplyMessage();
                    if (var12_14 != null) {
                        var13_15 = var12_14.elements();
                        while (var13_15.hasMoreElements()) {
                            var14_16 = (DestinationInfo)var13_15.nextElement();
                            var15_17 = var14_16.name;
                            var16_18 = var14_16.type;
                            if ("__JMQAdmin".equals(var15_17) || DestType.isInternal(var14_16.fulltype) || DestType.isTemporary(var14_16.type) || DestType.isDMQ(var14_16.type)) {
                                Globals.stdOutPrintln("Skipping destination: " + var15_17);
                                continue;
                            }
                            try {
                                var2_10.sendDestroyDestinationMessage(var15_17, var16_18);
                                var2_10.receiveDestroyDestinationReplyMessage();
                                if (DestType.isQueue(var16_18)) {
                                    Globals.stdOutPrintln("Successfully destroyed queue " + var15_17);
                                } else {
                                    Globals.stdOutPrintln("Successfully destroyed topic " + var15_17);
                                }
                                var11_12 = true;
                            }
                            catch (BrokerAdminException var17_19) {
                                this.handleBrokerAdminException(var17_19);
                                if (DestType.isQueue(var16_18)) {
                                    Globals.stdOutPrintln("Destroy failed for queue " + var15_17);
                                } else {
                                    Globals.stdOutPrintln("Destroy failed for topic " + var15_17);
                                }
                                var8_3 = 1;
                            }
                        }
                    }
                    if (var11_12) ** GOTO lbl79
                    Globals.stdOutPrintln("No destinations destroyed.");
                }
                catch (BrokerAdminException var11_13) {
                    this.handleBrokerAdminException(var11_13);
                    Globals.stdErrPrintln("Destroying all the destinations failed");
                    return 1;
                }
            } else {
                if (var7_7.equalsIgnoreCase(var3_2) || var6_6.equalsIgnoreCase(var3_2)) {
                    Globals.stdOutPrintln("The destinations were not destroyed.");
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", var3_2));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln("The destinations were not destroyed.");
                return 1;
            }
        }
lbl79:
        // 4 sources

        var2_10.close();
        return var8_3;
    }

    private int runUpdate(BrokerCmdProperties brokerCmdProperties) {
        String string = null;
        String string2 = this.ar.getString("A5016");
        String string3 = this.ar.getString("A5015");
        String string4 = this.ar.getString("A5018");
        String string5 = this.ar.getString("A5017");
        BrokerAdmin brokerAdmin = this.init();
        String string6 = brokerCmdProperties.getCommandArg();
        boolean bl = brokerCmdProperties.forceModeSet();
        if ("bkr".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1538"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Properties properties = brokerCmdProperties.getTargetAttrs();
            Globals.stdOutPrintln(this.ar.getString("A1539"));
            Globals.stdOutPrintln("");
            this.printAttrs(properties);
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5011"), string5);
                Globals.stdOutPrintln("");
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln(this.ar.getString("A1540"));
                    return 0;
                }
                if (!string3.equalsIgnoreCase(string) && !string2.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln(this.ar.getString("A1026", string));
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(this.ar.getString("A1540"));
                    return 1;
                }
            }
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendUpdateBrokerPropsMessage(properties);
                brokerAdmin.receiveUpdateBrokerPropsReplyMessage();
                Globals.stdOutPrintln(this.ar.getString("A1541"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1538"));
                return 1;
            }
        }
        if ("svc".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1542"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Properties properties = brokerCmdProperties.getTargetAttrs();
            String string7 = brokerCmdProperties.getTargetName();
            Globals.stdOutPrintln(this.ar.getString("A1543", string7));
            Globals.stdOutPrintln("");
            this.printAttrs(properties);
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            ServiceInfo serviceInfo = this.getServiceInfoFromAttrs(properties);
            serviceInfo.setName(string7);
            int n = -1;
            int n2 = -1;
            Vector vector = null;
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetServicesMessage(string7);
                vector = brokerAdmin.receiveGetServicesReplyMessage();
                if (vector != null && vector.size() == 1) {
                    Enumeration enumeration = vector.elements();
                    ServiceInfo serviceInfo2 = (ServiceInfo)enumeration.nextElement();
                    n = serviceInfo2.type;
                    n2 = serviceInfo2.port;
                }
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1542"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5012"), string5);
                Globals.stdOutPrintln("");
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln(this.ar.getString("A1544"));
                    return 0;
                }
                if (!string3.equalsIgnoreCase(string) && !string2.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln(this.ar.getString("A1026", string));
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(this.ar.getString("A1544"));
                    return 1;
                }
            }
            if (serviceInfo.isModified(1) && n2 == -1) {
                Globals.stdErrPrintln(this.ar.getString("A3149", string7));
                Globals.stdErrPrintln(this.ar.getString("A1542"));
                return 1;
            }
            try {
                brokerAdmin.sendUpdateServiceMessage(serviceInfo);
                brokerAdmin.receiveUpdateServiceReplyMessage();
                Globals.stdOutPrintln(this.ar.getString("A1545"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1542"));
                return 1;
            }
        }
        if ("dst".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1546"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Properties properties = brokerCmdProperties.getTargetAttrs();
            int n = this.getDestTypeMask(brokerCmdProperties);
            String string8 = brokerCmdProperties.getTargetName();
            if (DestType.isQueue(n)) {
                Globals.stdOutPrintln(this.ar.getString("A1547", string8));
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1548", string8));
            }
            Globals.stdOutPrintln("");
            this.printAttrs(properties);
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5013"), string5);
                Globals.stdOutPrintln("");
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln(this.ar.getString("A1549"));
                    return 0;
                }
                if (!string3.equalsIgnoreCase(string) && !string2.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln(this.ar.getString("A1026", string));
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(this.ar.getString("A1549"));
                    return 1;
                }
            }
            try {
                DestinationInfo destinationInfo = this.getDestinationInfoFromAttrs(properties);
                destinationInfo.setType(n);
                destinationInfo.setName(string8);
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendUpdateDestinationMessage(destinationInfo);
                brokerAdmin.receiveUpdateDestinationReplyMessage();
                Globals.stdOutPrintln(this.ar.getString("A1550"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1546"));
                return 1;
            }
        }
        brokerAdmin.close();
        return 0;
    }

    private void printAttrs(Properties properties) {
        this.printAttrs(properties, false);
    }

    private void printAttrs(Properties properties, boolean bl) {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        if (bl) {
            brokerCmdPrinter = new BrokerCmdPrinter(2, 4, "-");
            objectArray[0] = "Property Name";
            objectArray[1] = "Property Value";
            brokerCmdPrinter.addTitle((String[])objectArray);
        } else {
            brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            objectArray[0] = string;
            objectArray[1] = string2;
            brokerCmdPrinter.add(objectArray);
        }
        brokerCmdPrinter.println();
    }

    private ServiceInfo getServiceInfoFromAttrs(Properties properties) {
        ServiceInfo serviceInfo = new ServiceInfo();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            int n = 0;
            boolean bl = true;
            if (string.equals("port")) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                if (!bl) continue;
                serviceInfo.setPort(n);
                continue;
            }
            if (string.equals("minThreads")) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                if (!bl) continue;
                serviceInfo.setMinThreads(n);
                continue;
            }
            if (!string.equals("maxThreads")) continue;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (!bl) continue;
            serviceInfo.setMaxThreads(n);
        }
        return serviceInfo;
    }

    private DestinationInfo getDestinationInfoFromAttrs(Properties properties) {
        DestinationInfo destinationInfo = new DestinationInfo();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            SizeString sizeString;
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            int n = 0;
            long l = 0L;
            boolean bl = true;
            if (string.equals("maxTotalMsgBytes")) {
                try {
                    sizeString = new SizeString(string2);
                    l = sizeString.getBytes();
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                if (!bl) continue;
                destinationInfo.setMaxMessageBytes(l);
                continue;
            }
            if (string.equals("maxNumMsgs")) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                if (!bl) continue;
                destinationInfo.setMaxMessages(n);
                continue;
            }
            if (string.equals("maxBytesPerMsg")) {
                try {
                    sizeString = new SizeString(string2);
                    l = sizeString.getBytes();
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                if (!bl) continue;
                destinationInfo.setMaxMessageSize(l);
                continue;
            }
            if (string.equals("maxNumBackupConsumers")) {
                try {
                    destinationInfo.setMaxFailoverConsumers(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string.equals("maxNumActiveConsumers")) {
                try {
                    destinationInfo.setMaxActiveConsumers(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string.equals("isLocalOnly")) {
                destinationInfo.setScope(Boolean.valueOf(string2));
            }
            if (string.equals("limitBehavior")) {
                destinationInfo.setLimitBehavior(this.getLimitBehavValue(string2));
            }
            if (string.equals("localDeliveryPreferred")) {
                destinationInfo.setClusterDeliveryPolicy(this.getClusterDeliveryPolicy(string2));
            }
            if (string.equals("consumerFlowLimit")) {
                try {
                    destinationInfo.setPrefetch(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string.equals("maxNumProducers")) {
                try {
                    destinationInfo.setMaxProducers(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!string.equals("useDMQ")) continue;
            destinationInfo.setUseDMQ(Boolean.valueOf(string2));
        }
        return destinationInfo;
    }

    private int runQuery(BrokerCmdProperties brokerCmdProperties) {
        BrokerAdmin brokerAdmin = this.init();
        String string = brokerCmdProperties.getCommandArg();
        if ("dst".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1245"));
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string2 = brokerCmdProperties.getTargetName();
            int n = this.getDestTypeMask(brokerCmdProperties);
            Globals.stdOutPrintln(this.ar.getString("A1242"));
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                Object[] objectArray;
                BrokerCmdPrinter brokerCmdPrinter;
                DestinationInfo destinationInfo;
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetDestinationsMessage(string2, n);
                Vector vector = brokerAdmin.receiveGetDestinationsReplyMessage();
                if (vector != null && vector.size() == 1) {
                    Enumeration enumeration = vector.elements();
                    destinationInfo = (DestinationInfo)enumeration.nextElement();
                    brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
                    objectArray = new String[2];
                    brokerCmdPrinter.setSortNeeded(false);
                    objectArray[0] = this.ar.getString("A1400");
                    objectArray[1] = destinationInfo.name;
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1401");
                    objectArray[1] = BrokerAdminUtil.getDestinationType(destinationInfo.type);
                    if (DestType.isTemporary(destinationInfo.type)) {
                        objectArray[1] = (String)objectArray[1] + " (" + this.ar.getString("A1631") + ")";
                    }
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1429");
                    objectArray[1] = DestState.toString(destinationInfo.destState);
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1427");
                    objectArray[1] = destinationInfo.autocreated ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = "";
                    objectArray[1] = "";
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1404");
                    objectArray[1] = "";
                    brokerCmdPrinter.add(objectArray);
                    String string3 = "    ";
                    objectArray[0] = string3 + this.ar.getString("A1735");
                    objectArray[1] = new Integer(destinationInfo.nMessages - destinationInfo.nTxnMessages).toString();
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = string3 + this.ar.getString("A1734");
                    objectArray[1] = new Integer(destinationInfo.nTxnMessages).toString();
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1405");
                    objectArray[1] = "";
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = string3 + this.ar.getString("A1735");
                    objectArray[1] = new Long(destinationInfo.nMessageBytes - destinationInfo.nTxnMessageBytes).toString();
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = string3 + this.ar.getString("A1734");
                    objectArray[1] = new Long(destinationInfo.nTxnMessageBytes).toString();
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1428");
                    objectArray[1] = new Integer(destinationInfo.nProducers).toString();
                    brokerCmdPrinter.add(objectArray);
                    if (DestType.isQueue(n)) {
                        objectArray[0] = this.ar.getString("A1416");
                        objectArray[1] = new Integer(destinationInfo.naConsumers).toString();
                        brokerCmdPrinter.add(objectArray);
                        objectArray[0] = this.ar.getString("A1417");
                        objectArray[1] = new Integer(destinationInfo.nfConsumers).toString();
                        brokerCmdPrinter.add(objectArray);
                    } else {
                        objectArray[0] = this.ar.getString("A1688");
                        objectArray[1] = new Integer(destinationInfo.nConsumers).toString();
                        brokerCmdPrinter.add(objectArray);
                    }
                    objectArray[0] = "";
                    objectArray[1] = "";
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1407");
                    objectArray[1] = this.checkAndPrintUnlimitedInt(destinationInfo.maxMessages, this.zeroNegOneInt);
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1406");
                    objectArray[1] = this.checkAndPrintUnlimitedLong(destinationInfo.maxMessageBytes, this.zeroNegOneLong);
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1408");
                    objectArray[1] = new Long(destinationInfo.maxMessageSize).toString();
                    objectArray[1] = this.checkAndPrintUnlimitedLong(destinationInfo.maxMessageSize, this.zeroNegOneLong);
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1415");
                    objectArray[1] = this.checkAndPrintUnlimitedInt(destinationInfo.maxProducers, -1);
                    brokerCmdPrinter.add(objectArray);
                    if (DestType.isQueue(n)) {
                        objectArray[0] = this.ar.getString("A1410");
                        objectArray[1] = this.checkAndPrintUnlimitedInt(destinationInfo.maxActiveConsumers, -1);
                        brokerCmdPrinter.add(objectArray);
                        objectArray[0] = this.ar.getString("A1409");
                        objectArray[1] = this.checkAndPrintUnlimitedInt(destinationInfo.maxFailoverConsumers, -1);
                        brokerCmdPrinter.add(objectArray);
                    }
                    objectArray[0] = "";
                    objectArray[1] = "";
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1412");
                    objectArray[1] = DestLimitBehavior.getString(destinationInfo.destLimitBehavior);
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1414");
                    objectArray[1] = this.checkAndPrintUnlimitedInt(destinationInfo.maxPrefetch, -1);
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1411");
                    objectArray[1] = destinationInfo.isDestinationLocal() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                    brokerCmdPrinter.add(objectArray);
                    if (DestType.isQueue(n)) {
                        objectArray[0] = this.ar.getString("A1413");
                        objectArray[1] = destinationInfo.destCDP == 1 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                        brokerCmdPrinter.add(objectArray);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1335"));
                    Globals.stdErrPrintln(this.ar.getString("A1245"));
                    return 1;
                }
                objectArray[0] = this.ar.getString("A1446");
                objectArray[1] = destinationInfo.useDMQ() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                brokerCmdPrinter.add(objectArray);
                brokerCmdPrinter.println();
                Globals.stdOutPrintln(this.ar.getString("A1243"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1245"));
                return 1;
            }
        }
        if ("svc".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1249"));
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string4 = brokerCmdProperties.getTargetName();
            Globals.stdOutPrintln(this.ar.getString("A1246"));
            this.printServiceInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                Object[] objectArray;
                BrokerCmdPrinter brokerCmdPrinter;
                ServiceInfo serviceInfo;
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetServicesMessage(string4);
                Vector vector = brokerAdmin.receiveGetServicesReplyMessage();
                if (vector != null && vector.size() == 1) {
                    Enumeration enumeration = vector.elements();
                    serviceInfo = (ServiceInfo)enumeration.nextElement();
                    brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
                    objectArray = new String[2];
                    brokerCmdPrinter.setSortNeeded(false);
                    objectArray[0] = this.ar.getString("A1420");
                    objectArray[1] = serviceInfo.name;
                    brokerCmdPrinter.add(objectArray);
                    objectArray[0] = this.ar.getString("A1422");
                    objectArray[1] = ServiceState.getString(serviceInfo.state);
                    brokerCmdPrinter.add(objectArray);
                    if (serviceInfo.port != -1) {
                        objectArray[0] = this.ar.getString("A1421");
                        if (serviceInfo.dynamicPort) {
                            switch (serviceInfo.state) {
                                case -1: {
                                    objectArray[1] = this.ar.getString("A1520");
                                    break;
                                }
                                default: {
                                    objectArray[1] = new Integer(serviceInfo.port).toString() + " (" + this.ar.getString("A1520") + ")";
                                    break;
                                }
                            }
                        } else {
                            objectArray[1] = new Integer(serviceInfo.port).toString() + " (" + this.ar.getString("A1521") + ")";
                        }
                        brokerCmdPrinter.add(objectArray);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1335"));
                    Globals.stdErrPrintln(this.ar.getString("A1249"));
                    return 1;
                }
                objectArray[0] = "";
                objectArray[1] = "";
                brokerCmdPrinter.add(objectArray);
                objectArray[0] = this.ar.getString("A1425");
                objectArray[1] = new Integer(serviceInfo.currentThreads).toString();
                brokerCmdPrinter.add(objectArray);
                objectArray[0] = this.ar.getString("A1426");
                objectArray[1] = new Integer(serviceInfo.nConnections).toString();
                brokerCmdPrinter.add(objectArray);
                objectArray[0] = "";
                objectArray[1] = "";
                brokerCmdPrinter.add(objectArray);
                objectArray[0] = this.ar.getString("A1423");
                objectArray[1] = new Integer(serviceInfo.minThreads).toString();
                brokerCmdPrinter.add(objectArray);
                objectArray[0] = this.ar.getString("A1424");
                objectArray[1] = new Integer(serviceInfo.maxThreads).toString();
                brokerCmdPrinter.add(objectArray);
                brokerCmdPrinter.println();
                Globals.stdOutPrintln(this.ar.getString("A1247"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1249"));
                return 1;
            }
        }
        if ("bkr".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1523"));
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1522"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetBrokerPropsMessage();
                Properties properties = brokerAdmin.receiveGetBrokerPropsReplyMessage();
                if (properties == null) {
                    Globals.stdErrPrintln(this.ar.getString("A1523"));
                    return 1;
                }
                if (brokerCmdProperties.adminDebugModeSet()) {
                    this.printAllBrokerAttrs(properties);
                } else {
                    this.printDisplayableBrokerAttrs(properties);
                }
                Globals.stdOutPrintln(this.ar.getString("A1524"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1523"));
                return 1;
            }
        }
        if ("txn".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1256"));
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string5 = brokerCmdProperties.getTargetName();
            Long l = null;
            try {
                l = Long.valueOf(string5);
            }
            catch (NumberFormatException numberFormatException) {
                Globals.stdErrPrintln(this.ar.getString("A3150", string5));
                Globals.stdErrPrintln(this.ar.getString("A1256"));
                return 1;
            }
            Globals.stdOutPrintln(this.ar.getString("A1254"));
            this.printTransactionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetTxnsMessage(l);
                Vector vector = brokerAdmin.receiveGetTxnsReplyMessage();
                if (vector != null && vector.size() == 1) {
                    Enumeration enumeration = vector.elements();
                    Hashtable hashtable = (Hashtable)enumeration.nextElement();
                    if (brokerCmdProperties.debugModeSet()) {
                        this.printAllTxnAttrs(hashtable);
                    } else {
                        this.printDisplayableTxnAttrs(hashtable);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1335"));
                    Globals.stdErrPrintln(this.ar.getString("A1256"));
                    return 1;
                }
                Globals.stdOutPrintln(this.ar.getString("A1255"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1256"));
                return 1;
            }
        }
        if ("cxn".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1334"));
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string6 = brokerCmdProperties.getTargetName();
            Long l = null;
            try {
                l = Long.valueOf(string6);
            }
            catch (NumberFormatException numberFormatException) {
                Globals.stdErrPrintln(this.ar.getString("A3159", string6));
                Globals.stdErrPrintln(this.ar.getString("A1334"));
                return 1;
            }
            Globals.stdOutPrintln(this.ar.getString("A1332"));
            this.printConnectionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetConnectionsMessage(null, l);
                Vector vector = brokerAdmin.receiveGetConnectionsReplyMessage();
                if (vector != null && vector.size() == 1) {
                    Enumeration enumeration = vector.elements();
                    Hashtable hashtable = (Hashtable)enumeration.nextElement();
                    if (brokerCmdProperties.debugModeSet()) {
                        this.printAllCxnAttrs(hashtable);
                    } else {
                        this.printDisplayableCxnAttrs(hashtable);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1335"));
                    Globals.stdErrPrintln(this.ar.getString("A1334"));
                    return 1;
                }
                Globals.stdOutPrintln(this.ar.getString("A1333"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1334"));
                return 1;
            }
        }
        if ("msg".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln("Querying message failed.");
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string7 = brokerCmdProperties.getTargetName();
            int n = this.getDestTypeMask(brokerCmdProperties);
            String string8 = brokerCmdProperties.getMsgID();
            Globals.stdOutPrintln("Querying message:");
            this.printMessageInfo();
            Globals.stdOutPrintln("In the destination");
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetMessagesMessage(string7, n, true, string8, null, null);
                Vector vector = brokerAdmin.receiveGetMessagesReplyMessage();
                if (vector != null && vector.size() == 1) {
                    HashMap hashMap = (HashMap)vector.get(0);
                    this.printDisplayableMsgAttrs(hashMap);
                    Globals.stdOutPrintln("Successfully queried message.");
                } else {
                    Globals.stdErrPrintln("There are no messages.");
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln("Successfully queried message.");
                }
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln("Querying message failed.");
                return 1;
            }
        }
        if (brokerAdmin.isConnected()) {
            brokerAdmin.close();
        }
        return 0;
    }

    private int runMetrics(BrokerCmdProperties brokerCmdProperties) {
        BrokerAdmin brokerAdmin = this.init();
        String string = brokerCmdProperties.getCommandArg();
        long l = brokerCmdProperties.getMetricInterval();
        int n = this.getMetricType(brokerCmdProperties);
        int n2 = brokerCmdProperties.getMetricSamples();
        if ("svc".equals(string)) {
            BrokerCmdPrinter brokerCmdPrinter = this.setupMetricTitle(string, n);
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1559"));
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string2 = brokerCmdProperties.getTargetName();
            Globals.stdOutPrintln(this.ar.getString("A1560"));
            this.printServiceInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                MetricCounters metricCounters = null;
                int n3 = 0;
                this.connectToBroker(brokerAdmin);
                while (true) {
                    brokerAdmin.sendGetMetricsMessage(string2);
                    MetricCounters metricCounters2 = (MetricCounters)brokerAdmin.receiveGetMetricsReplyMessage();
                    if (metricCounters2 == null) {
                        Globals.stdErrPrintln(this.ar.getString("A1559"));
                        return 1;
                    }
                    this.addOneMetricRow(n, brokerCmdPrinter, metricCounters2, metricCounters);
                    if (n3 % 20 == 0) {
                        brokerCmdPrinter.print();
                    } else {
                        brokerCmdPrinter.print(false);
                    }
                    brokerCmdPrinter.clear();
                    metricCounters = metricCounters2;
                    if (n2 > 0 && n2 == ++n3) break;
                    try {
                        Thread.sleep(l * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Globals.stdErrPrintln(interruptedException.toString());
                    }
                }
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1298"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1559"));
                return 1;
            }
        }
        if ("bkr".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1561"));
                return 1;
            }
            BrokerCmdPrinter brokerCmdPrinter = this.setupMetricTitle(string, n);
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1562"));
            this.printBrokerInfo(brokerAdmin);
            try {
                MetricCounters metricCounters = null;
                int n4 = 0;
                this.connectToBroker(brokerAdmin);
                while (true) {
                    brokerAdmin.sendGetMetricsMessage(null);
                    MetricCounters metricCounters3 = (MetricCounters)brokerAdmin.receiveGetMetricsReplyMessage();
                    if (metricCounters3 == null) {
                        Globals.stdErrPrintln(this.ar.getString("A1561"));
                        return 1;
                    }
                    this.addOneMetricRow(n, brokerCmdPrinter, metricCounters3, metricCounters);
                    if (n4 % 20 == 0) {
                        brokerCmdPrinter.print();
                    } else {
                        brokerCmdPrinter.print(false);
                    }
                    brokerCmdPrinter.clear();
                    metricCounters = metricCounters3;
                    if (n2 > 0 && n2 == ++n4) break;
                    try {
                        Thread.sleep(l * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Globals.stdErrPrintln(interruptedException.toString());
                    }
                }
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1299"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1561"));
                return 1;
            }
        }
        if ("dst".equals(string)) {
            String string3 = brokerCmdProperties.getTargetName();
            int n5 = this.getDestTypeMask(brokerCmdProperties);
            BrokerCmdPrinter brokerCmdPrinter = this.setupDestMetricTitle(string, n, n5);
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1296"));
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1297"));
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            try {
                DestMetricsCounters destMetricsCounters = null;
                int n6 = 0;
                this.connectToBroker(brokerAdmin);
                while (true) {
                    brokerAdmin.sendGetMetricsMessage(string3, n5);
                    DestMetricsCounters destMetricsCounters2 = (DestMetricsCounters)brokerAdmin.receiveGetMetricsReplyMessage();
                    if (destMetricsCounters2 == null) {
                        Globals.stdErrPrintln(this.ar.getString("A1296"));
                        return 1;
                    }
                    this.addOneDestMetricRow(n, n5, brokerCmdPrinter, destMetricsCounters2, destMetricsCounters);
                    if (n6 % 20 == 0) {
                        brokerCmdPrinter.print();
                    } else {
                        brokerCmdPrinter.print(false);
                    }
                    brokerCmdPrinter.clear();
                    destMetricsCounters = destMetricsCounters2;
                    if (n2 > 0 && n2 == ++n6) break;
                    try {
                        Thread.sleep(l * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Globals.stdErrPrintln(interruptedException.toString());
                    }
                }
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1300"));
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1296"));
                return 1;
            }
        }
        if (brokerAdmin.isConnected()) {
            brokerAdmin.close();
        }
        return 0;
    }

    private BrokerCmdPrinter setupListDestTitle(int n) {
        BrokerCmdPrinter brokerCmdPrinter = null;
        if (n != 2) {
            brokerCmdPrinter = new BrokerCmdPrinter(8, 2, "-");
            String[] stringArray = new String[8];
            int n2 = 0;
            brokerCmdPrinter.setTitleAlign(1);
            int[] nArray = new int[8];
            nArray[n2++] = 1;
            nArray[n2++] = 1;
            nArray[n2++] = 1;
            nArray[n2++] = 1;
            nArray[n2++] = 1;
            nArray[n2++] = 3;
            nArray[n2++] = 0;
            nArray[n2++] = 0;
            n2 = 0;
            int n3 = n2++;
            stringArray[n3] = this.ar.getString("A1443");
            int n4 = n2++;
            stringArray[n4] = this.ar.getString("A1444");
            int n5 = n2++;
            stringArray[n5] = this.ar.getString("A1445");
            int n6 = n2++;
            stringArray[n6] = this.ar.getString("A1675");
            int n7 = n2++;
            stringArray[n7] = this.ar.getString("A1676");
            int n8 = n2++;
            stringArray[n8] = this.ar.getString("A1677");
            stringArray[n2++] = "";
            stringArray[n2++] = "";
            brokerCmdPrinter.addTitle(stringArray, nArray);
            n2 = 0;
            stringArray[n2++] = "";
            stringArray[n2++] = "";
            stringArray[n2++] = "";
            stringArray[n2++] = "";
            int n9 = n2++;
            stringArray[n9] = this.ar.getString("A1689");
            int n10 = n2++;
            stringArray[n10] = this.ar.getString("A1680");
            int n11 = n2++;
            stringArray[n11] = this.ar.getString("A1681");
            int n12 = n2++;
            stringArray[n12] = this.ar.getString("A1682");
            brokerCmdPrinter.addTitle(stringArray);
        } else {
            brokerCmdPrinter = new BrokerCmdPrinter(9, 2, "-");
            String[] stringArray = new String[9];
            int n13 = 0;
            brokerCmdPrinter.setTitleAlign(1);
            int[] nArray = new int[9];
            nArray[n13++] = 1;
            nArray[n13++] = 1;
            nArray[n13++] = 1;
            nArray[n13++] = 1;
            nArray[n13++] = 2;
            nArray[n13++] = 0;
            nArray[n13++] = 3;
            nArray[n13++] = 0;
            nArray[n13++] = 0;
            n13 = 0;
            int n14 = n13++;
            stringArray[n14] = this.ar.getString("A1443");
            int n15 = n13++;
            stringArray[n15] = this.ar.getString("A1444");
            int n16 = n13++;
            stringArray[n16] = this.ar.getString("A1445");
            int n17 = n13++;
            stringArray[n17] = this.ar.getString("A1675");
            int n18 = n13++;
            stringArray[n18] = this.ar.getString("A1676");
            stringArray[n13++] = "";
            int n19 = n13++;
            stringArray[n19] = this.ar.getString("A1677");
            stringArray[n13++] = "";
            stringArray[n13++] = "";
            brokerCmdPrinter.addTitle(stringArray, nArray);
            n13 = 0;
            stringArray[n13++] = "";
            stringArray[n13++] = "";
            stringArray[n13++] = "";
            stringArray[n13++] = "";
            int n20 = n13++;
            stringArray[n20] = this.ar.getString("A1678");
            int n21 = n13++;
            stringArray[n21] = this.ar.getString("A1679");
            int n22 = n13++;
            stringArray[n22] = this.ar.getString("A1680");
            int n23 = n13++;
            stringArray[n23] = this.ar.getString("A1681");
            int n24 = n13++;
            stringArray[n24] = this.ar.getString("A1682");
            brokerCmdPrinter.addTitle(stringArray);
        }
        return brokerCmdPrinter;
    }

    private BrokerCmdPrinter setupMetricTitle(String string, int n) {
        BrokerCmdPrinter brokerCmdPrinter = null;
        if (n == 0) {
            int n2 = 0;
            int[] nArray = new int[8];
            brokerCmdPrinter = new BrokerCmdPrinter(8, 2, "-", 1);
            brokerCmdPrinter.setTitleAlign(1);
            String[] stringArray = new String[8];
            nArray[n2++] = 2;
            nArray[n2++] = 0;
            nArray[n2++] = 2;
            nArray[n2++] = 0;
            nArray[n2++] = 2;
            nArray[n2++] = 0;
            nArray[n2++] = 2;
            nArray[n2++] = 0;
            n2 = 0;
            int n3 = n2++;
            stringArray[n3] = this.ar.getString("A1659");
            stringArray[n2++] = "";
            int n4 = n2++;
            stringArray[n4] = this.ar.getString("A1660");
            stringArray[n2++] = "";
            int n5 = n2++;
            stringArray[n5] = this.ar.getString("A1661");
            stringArray[n2++] = "";
            int n6 = n2++;
            stringArray[n6] = this.ar.getString("A1662");
            stringArray[n2++] = "";
            brokerCmdPrinter.addTitle(stringArray, nArray);
            n2 = 0;
            int n7 = n2++;
            stringArray[n7] = this.ar.getString("A1667");
            int n8 = n2++;
            stringArray[n8] = this.ar.getString("A1668");
            int n9 = n2++;
            stringArray[n9] = this.ar.getString("A1667");
            int n10 = n2++;
            stringArray[n10] = this.ar.getString("A1668");
            int n11 = n2++;
            stringArray[n11] = this.ar.getString("A1667");
            int n12 = n2++;
            stringArray[n12] = this.ar.getString("A1668");
            int n13 = n2++;
            stringArray[n13] = this.ar.getString("A1667");
            int n14 = n2++;
            stringArray[n14] = this.ar.getString("A1668");
            brokerCmdPrinter.addTitle(stringArray);
        } else if (n == 1) {
            int n15 = 0;
            int[] nArray = new int[8];
            brokerCmdPrinter = new BrokerCmdPrinter(8, 2, "-", 1);
            brokerCmdPrinter.setTitleAlign(1);
            String[] stringArray = new String[8];
            nArray[n15++] = 2;
            nArray[n15++] = 0;
            nArray[n15++] = 2;
            nArray[n15++] = 0;
            nArray[n15++] = 2;
            nArray[n15++] = 0;
            nArray[n15++] = 2;
            nArray[n15++] = 0;
            n15 = 0;
            int n16 = n15++;
            stringArray[n16] = this.ar.getString("A1663");
            stringArray[n15++] = "";
            int n17 = n15++;
            stringArray[n17] = this.ar.getString("A1664");
            stringArray[n15++] = "";
            int n18 = n15++;
            stringArray[n18] = this.ar.getString("A1665");
            stringArray[n15++] = "";
            int n19 = n15++;
            stringArray[n19] = this.ar.getString("A1666");
            stringArray[n15++] = "";
            brokerCmdPrinter.addTitle(stringArray, nArray);
            n15 = 0;
            int n20 = n15++;
            stringArray[n20] = this.ar.getString("A1667");
            int n21 = n15++;
            stringArray[n21] = this.ar.getString("A1668");
            int n22 = n15++;
            stringArray[n22] = this.ar.getString("A1667");
            int n23 = n15++;
            stringArray[n23] = this.ar.getString("A1668");
            int n24 = n15++;
            stringArray[n24] = this.ar.getString("A1667");
            int n25 = n15++;
            stringArray[n25] = this.ar.getString("A1668");
            int n26 = n15++;
            stringArray[n26] = this.ar.getString("A1667");
            int n27 = n15++;
            stringArray[n27] = this.ar.getString("A1668");
            brokerCmdPrinter.addTitle(stringArray);
        } else if (n == 2) {
            int n28 = 0;
            String[] stringArray = new String[6];
            int[] nArray = new int[6];
            brokerCmdPrinter = new BrokerCmdPrinter(6, 2, "-", 1);
            brokerCmdPrinter.setTitleAlign(1);
            nArray[n28++] = 1;
            nArray[n28++] = 2;
            nArray[n28++] = 0;
            nArray[n28++] = 3;
            nArray[n28++] = 0;
            nArray[n28++] = 0;
            n28 = 0;
            int n29 = n28++;
            stringArray[n29] = this.ar.getString("A1608");
            int n30 = n28++;
            stringArray[n30] = this.ar.getString("A1669");
            stringArray[n28++] = "";
            int n31 = n28++;
            stringArray[n31] = this.ar.getString("A1670");
            stringArray[n28++] = "";
            stringArray[n28++] = "";
            brokerCmdPrinter.addTitle(stringArray, nArray);
            n28 = 0;
            int n32 = n28++;
            stringArray[n32] = this.ar.getString("A1609");
            int n33 = n28++;
            stringArray[n33] = this.ar.getString("A1647");
            int n34 = n28++;
            stringArray[n34] = this.ar.getString("A1671");
            int n35 = n28++;
            stringArray[n35] = this.ar.getString("A1672");
            int n36 = n28++;
            stringArray[n36] = this.ar.getString("A1673");
            int n37 = n28++;
            stringArray[n37] = this.ar.getString("A1674");
            brokerCmdPrinter.addTitle(stringArray);
        }
        return brokerCmdPrinter;
    }

    private BrokerCmdPrinter setupDestMetricTitle(String string, int n, int n2) {
        BrokerCmdPrinter brokerCmdPrinter = null;
        if (n == 0) {
            brokerCmdPrinter = new BrokerCmdPrinter(11, 2, "-", 1);
            brokerCmdPrinter.setTitleAlign(1);
            String[] stringArray = new String[11];
            int[] nArray = new int[11];
            int n3 = 0;
            nArray[n3++] = 2;
            nArray[n3++] = 0;
            nArray[n3++] = 2;
            nArray[n3++] = 0;
            nArray[n3++] = 3;
            nArray[n3++] = 0;
            nArray[n3++] = 0;
            nArray[n3++] = 3;
            nArray[n3++] = 0;
            nArray[n3++] = 0;
            nArray[n3++] = 1;
            n3 = 0;
            int n4 = n3++;
            stringArray[n4] = this.ar.getString("A1659");
            stringArray[n3++] = "";
            int n5 = n3++;
            stringArray[n5] = this.ar.getString("A1660");
            stringArray[n3++] = "";
            int n6 = n3++;
            stringArray[n6] = this.ar.getString("A1643");
            stringArray[n3++] = "";
            stringArray[n3++] = "";
            int n7 = n3++;
            stringArray[n7] = this.ar.getString("A1644");
            stringArray[n3++] = "";
            stringArray[n3++] = "";
            int n8 = n3++;
            stringArray[n8] = this.ar.getString("A1645");
            brokerCmdPrinter.addTitle(stringArray, nArray);
            n3 = 0;
            int n9 = n3++;
            stringArray[n9] = this.ar.getString("A1667");
            int n10 = n3++;
            stringArray[n10] = this.ar.getString("A1668");
            int n11 = n3++;
            stringArray[n11] = this.ar.getString("A1667");
            int n12 = n3++;
            stringArray[n12] = this.ar.getString("A1668");
            int n13 = n3++;
            stringArray[n13] = this.ar.getString("A1649");
            int n14 = n3++;
            stringArray[n14] = this.ar.getString("A1650");
            int n15 = n3++;
            stringArray[n15] = this.ar.getString("A1651");
            int n16 = n3++;
            stringArray[n16] = this.ar.getString("A1649");
            int n17 = n3++;
            stringArray[n17] = this.ar.getString("A1650");
            int n18 = n3++;
            stringArray[n18] = this.ar.getString("A1651");
            int n19 = n3++;
            stringArray[n19] = this.ar.getString("A1646");
            brokerCmdPrinter.addTitle(stringArray);
        } else if (n == 1) {
            brokerCmdPrinter = new BrokerCmdPrinter(11, 2, "-", 1);
            brokerCmdPrinter.setTitleAlign(1);
            String[] stringArray = new String[11];
            int[] nArray = new int[11];
            int n20 = 0;
            nArray[n20++] = 2;
            nArray[n20++] = 0;
            nArray[n20++] = 2;
            nArray[n20++] = 0;
            nArray[n20++] = 3;
            nArray[n20++] = 0;
            nArray[n20++] = 0;
            nArray[n20++] = 3;
            nArray[n20++] = 0;
            nArray[n20++] = 0;
            nArray[n20++] = 1;
            n20 = 0;
            int n21 = n20++;
            stringArray[n21] = this.ar.getString("A1663");
            stringArray[n20++] = "";
            int n22 = n20++;
            stringArray[n22] = this.ar.getString("A1664");
            stringArray[n20++] = "";
            int n23 = n20++;
            stringArray[n23] = this.ar.getString("A1643");
            stringArray[n20++] = "";
            stringArray[n20++] = "";
            int n24 = n20++;
            stringArray[n24] = this.ar.getString("A1644");
            stringArray[n20++] = "";
            stringArray[n20++] = "";
            int n25 = n20++;
            stringArray[n25] = this.ar.getString("A1645");
            brokerCmdPrinter.addTitle(stringArray, nArray);
            n20 = 0;
            int n26 = n20++;
            stringArray[n26] = this.ar.getString("A1667");
            int n27 = n20++;
            stringArray[n27] = this.ar.getString("A1668");
            int n28 = n20++;
            stringArray[n28] = this.ar.getString("A1667");
            int n29 = n20++;
            stringArray[n29] = this.ar.getString("A1668");
            int n30 = n20++;
            stringArray[n30] = this.ar.getString("A1649");
            int n31 = n20++;
            stringArray[n31] = this.ar.getString("A1650");
            int n32 = n20++;
            stringArray[n32] = this.ar.getString("A1651");
            int n33 = n20++;
            stringArray[n33] = this.ar.getString("A1649");
            int n34 = n20++;
            stringArray[n34] = this.ar.getString("A1650");
            int n35 = n20++;
            stringArray[n35] = this.ar.getString("A1651");
            int n36 = n20++;
            stringArray[n36] = this.ar.getString("A1646");
            brokerCmdPrinter.addTitle(stringArray);
        } else if (n == 3) {
            if (DestType.isQueue(n2)) {
                brokerCmdPrinter = new BrokerCmdPrinter(9, 2, "-", 1);
                brokerCmdPrinter.setTitleAlign(1);
                String[] stringArray = new String[9];
                int[] nArray = new int[9];
                int n37 = 0;
                nArray[n37++] = 3;
                nArray[n37++] = 0;
                nArray[n37++] = 0;
                nArray[n37++] = 3;
                nArray[n37++] = 0;
                nArray[n37++] = 0;
                nArray[n37++] = 3;
                nArray[n37++] = 0;
                nArray[n37++] = 0;
                n37 = 0;
                int n38 = n37++;
                stringArray[n38] = this.ar.getString("A1652");
                stringArray[n37++] = "";
                stringArray[n37++] = "";
                int n39 = n37++;
                stringArray[n39] = this.ar.getString("A1653");
                stringArray[n37++] = "";
                stringArray[n37++] = "";
                int n40 = n37++;
                stringArray[n40] = this.ar.getString("A1643");
                stringArray[n37++] = "";
                stringArray[n37++] = "";
                brokerCmdPrinter.addTitle(stringArray, nArray);
                n37 = 0;
                int n41 = n37++;
                stringArray[n41] = this.ar.getString("A1649");
                int n42 = n37++;
                stringArray[n42] = this.ar.getString("A1650");
                int n43 = n37++;
                stringArray[n43] = this.ar.getString("A1651");
                int n44 = n37++;
                stringArray[n44] = this.ar.getString("A1649");
                int n45 = n37++;
                stringArray[n45] = this.ar.getString("A1650");
                int n46 = n37++;
                stringArray[n46] = this.ar.getString("A1651");
                int n47 = n37++;
                stringArray[n47] = this.ar.getString("A1649");
                int n48 = n37++;
                stringArray[n48] = this.ar.getString("A1650");
                int n49 = n37++;
                stringArray[n49] = this.ar.getString("A1651");
                brokerCmdPrinter.addTitle(stringArray);
            } else {
                brokerCmdPrinter = new BrokerCmdPrinter(6, 2, "-", 1);
                brokerCmdPrinter.setTitleAlign(1);
                String[] stringArray = new String[6];
                int[] nArray = new int[6];
                int n50 = 0;
                nArray[n50++] = 3;
                nArray[n50++] = 0;
                nArray[n50++] = 0;
                nArray[n50++] = 3;
                nArray[n50++] = 0;
                nArray[n50++] = 0;
                n50 = 0;
                int n51 = n50++;
                stringArray[n51] = this.ar.getString("A1687");
                stringArray[n50++] = "";
                stringArray[n50++] = "";
                int n52 = n50++;
                stringArray[n52] = this.ar.getString("A1643");
                stringArray[n50++] = "";
                stringArray[n50++] = "";
                brokerCmdPrinter.addTitle(stringArray, nArray);
                n50 = 0;
                int n53 = n50++;
                stringArray[n53] = this.ar.getString("A1649");
                int n54 = n50++;
                stringArray[n54] = this.ar.getString("A1650");
                int n55 = n50++;
                stringArray[n55] = this.ar.getString("A1651");
                int n56 = n50++;
                stringArray[n56] = this.ar.getString("A1649");
                int n57 = n50++;
                stringArray[n57] = this.ar.getString("A1650");
                int n58 = n50++;
                stringArray[n58] = this.ar.getString("A1651");
                brokerCmdPrinter.addTitle(stringArray);
            }
        } else if (n == 4) {
            brokerCmdPrinter = new BrokerCmdPrinter(3, 2, "-", 1);
            String[] stringArray = new String[3];
            stringArray[0] = this.ar.getString("A1656");
            stringArray[1] = this.ar.getString("A1657");
            stringArray[2] = this.ar.getString("A1658");
            brokerCmdPrinter.addTitle(stringArray);
        } else if (n == 5) {
            brokerCmdPrinter = new BrokerCmdPrinter(3, 2, "-", 1);
            brokerCmdPrinter.setTitleAlign(1);
            String[] stringArray = new String[3];
            int[] nArray = new int[3];
            int n59 = 0;
            nArray[n59++] = 3;
            nArray[n59++] = 0;
            nArray[n59++] = 0;
            n59 = 0;
            stringArray[n59++] = "Msgs Removed";
            stringArray[n59++] = "";
            stringArray[n59++] = "";
            brokerCmdPrinter.addTitle(stringArray, nArray);
            n59 = 0;
            stringArray[n59++] = "Expired";
            stringArray[n59++] = "Discarded";
            stringArray[n59++] = "Purged";
            brokerCmdPrinter.addTitle(stringArray);
        }
        return brokerCmdPrinter;
    }

    private void addOneMetricRow(int n, BrokerCmdPrinter brokerCmdPrinter, MetricCounters metricCounters, MetricCounters metricCounters2) {
        if (n == 0) {
            Object[] objectArray = new String[]{Long.toString(metricCounters.messagesIn), Long.toString(metricCounters.messagesOut), Long.toString(metricCounters.messageBytesIn), Long.toString(metricCounters.messageBytesOut), Long.toString(metricCounters.packetsIn), Long.toString(metricCounters.packetsOut), Long.toString(metricCounters.packetBytesIn), Long.toString(metricCounters.packetBytesOut)};
            brokerCmdPrinter.add(objectArray);
        } else if (n == 1) {
            Object[] objectArray = new String[8];
            if (metricCounters2 == null) {
                objectArray[0] = "0";
                objectArray[1] = "0";
                objectArray[2] = "0";
                objectArray[3] = "0";
                objectArray[4] = "0";
                objectArray[5] = "0";
                objectArray[6] = "0";
                objectArray[7] = "0";
            } else {
                float f = (float)(metricCounters.timeStamp - metricCounters2.timeStamp) / 1000.0f;
                objectArray[0] = this.getRateString(metricCounters.messagesIn, metricCounters2.messagesIn, f);
                objectArray[1] = this.getRateString(metricCounters.messagesOut, metricCounters2.messagesOut, f);
                objectArray[2] = this.getRateString(metricCounters.messageBytesIn, metricCounters2.messageBytesIn, f);
                objectArray[3] = this.getRateString(metricCounters.messageBytesOut, metricCounters2.messageBytesOut, f);
                objectArray[4] = this.getRateString(metricCounters.packetsIn, metricCounters2.packetsIn, f);
                objectArray[5] = this.getRateString(metricCounters.packetsOut, metricCounters2.packetsOut, f);
                objectArray[6] = this.getRateString(metricCounters.packetBytesIn, metricCounters2.packetBytesIn, f);
                objectArray[7] = this.getRateString(metricCounters.packetBytesOut, metricCounters2.packetBytesOut, f);
            }
            brokerCmdPrinter.add(objectArray);
        } else if (n == 2) {
            Object[] objectArray = new String[]{Integer.toString(metricCounters.nConnections), Long.toString(metricCounters.totalMemory), Long.toString(metricCounters.freeMemory), Integer.toString(metricCounters.threadsActive), Integer.toString(metricCounters.threadsLowWater), Integer.toString(metricCounters.threadsHighWater)};
            brokerCmdPrinter.add(objectArray);
        }
    }

    private String getRateString(long l, long l2, float f) {
        String string = "";
        long l3 = l - l2;
        long l4 = (long)((float)l3 / f);
        string = l4 == 0L ? (l3 != 0L ? "< 1" : "0") : Long.toString(l4);
        return string;
    }

    private String displayInKBytes(long l) {
        if (l == 0L) {
            return "0";
        }
        if (l < 1024L) {
            return "< 1";
        }
        return Long.toString(l / 1024L);
    }

    private void addOneDestMetricRow(int n, int n2, BrokerCmdPrinter brokerCmdPrinter, DestMetricsCounters destMetricsCounters, DestMetricsCounters destMetricsCounters2) {
        if (n == 0) {
            Object[] objectArray = new String[]{Integer.toString(destMetricsCounters.getMessagesIn()), Integer.toString(destMetricsCounters.getMessagesOut()), Long.toString(destMetricsCounters.getMessageBytesIn()), Long.toString(destMetricsCounters.getMessageBytesOut()), Integer.toString(destMetricsCounters.getCurrentMessages()), Integer.toString(destMetricsCounters.getHighWaterMessages()), Integer.toString(destMetricsCounters.getAverageMessages()), this.displayInKBytes(destMetricsCounters.getCurrentMessageBytes()), this.displayInKBytes(destMetricsCounters.getHighWaterMessageBytes()), this.displayInKBytes(destMetricsCounters.getAverageMessageBytes()), this.displayInKBytes(destMetricsCounters.getHighWaterLargestMsgBytes())};
            brokerCmdPrinter.add(objectArray);
        } else if (n == 1) {
            Object[] objectArray = new String[11];
            if (destMetricsCounters2 == null) {
                objectArray[0] = "0";
                objectArray[1] = "0";
                objectArray[2] = "0";
                objectArray[3] = "0";
            } else {
                float f = (float)(destMetricsCounters.timeStamp - destMetricsCounters2.timeStamp) / 1000.0f;
                objectArray[0] = this.getRateString(destMetricsCounters.getMessagesIn(), destMetricsCounters2.getMessagesIn(), f);
                objectArray[1] = this.getRateString(destMetricsCounters.getMessagesOut(), destMetricsCounters2.getMessagesOut(), f);
                objectArray[2] = this.getRateString(destMetricsCounters.getMessageBytesIn(), destMetricsCounters2.getMessageBytesIn(), f);
                objectArray[3] = this.getRateString(destMetricsCounters.getMessageBytesOut(), destMetricsCounters2.getMessageBytesOut(), f);
            }
            objectArray[4] = Integer.toString(destMetricsCounters.getCurrentMessages());
            objectArray[5] = Integer.toString(destMetricsCounters.getHighWaterMessages());
            objectArray[6] = Integer.toString(destMetricsCounters.getAverageMessages());
            objectArray[7] = this.displayInKBytes(destMetricsCounters.getCurrentMessageBytes());
            objectArray[8] = this.displayInKBytes(destMetricsCounters.getHighWaterMessageBytes());
            objectArray[9] = this.displayInKBytes(destMetricsCounters.getAverageMessageBytes());
            objectArray[10] = this.displayInKBytes(destMetricsCounters.getHighWaterLargestMsgBytes());
            brokerCmdPrinter.add(objectArray);
        } else if (n == 3) {
            if (DestType.isQueue(n2)) {
                Object[] objectArray = new String[]{Integer.toString(destMetricsCounters.getActiveConsumers()), Integer.toString(destMetricsCounters.getHWActiveConsumers()), Integer.toString(destMetricsCounters.getAvgActiveConsumers()), Integer.toString(destMetricsCounters.getFailoverConsumers()), Integer.toString(destMetricsCounters.getHWFailoverConsumers()), Integer.toString(destMetricsCounters.getAvgFailoverConsumers()), Integer.toString(destMetricsCounters.getCurrentMessages()), Integer.toString(destMetricsCounters.getHighWaterMessages()), Integer.toString(destMetricsCounters.getAverageMessages())};
                brokerCmdPrinter.add(objectArray);
            } else {
                Object[] objectArray = new String[]{Integer.toString(destMetricsCounters.getActiveConsumers()), Integer.toString(destMetricsCounters.getHWActiveConsumers()), Integer.toString(destMetricsCounters.getAvgActiveConsumers()), Integer.toString(destMetricsCounters.getCurrentMessages()), Integer.toString(destMetricsCounters.getHighWaterMessages()), Integer.toString(destMetricsCounters.getAverageMessages())};
                brokerCmdPrinter.add(objectArray);
            }
        } else if (n == 4) {
            Object[] objectArray = new String[]{Long.toString(destMetricsCounters.getDiskReserved()), Long.toString(destMetricsCounters.getDiskUsed()), Integer.toString(destMetricsCounters.getDiskUtilizationRatio())};
            brokerCmdPrinter.add(objectArray);
        } else if (n == 5) {
            Object[] objectArray = new String[]{"0", "0", "0"};
            brokerCmdPrinter.add(objectArray);
        }
    }

    private int runReload(BrokerCmdProperties brokerCmdProperties) {
        BrokerAdmin brokerAdmin = this.init();
        if (brokerAdmin == null) {
            Globals.stdErrPrintln(this.ar.getString("A1229"));
            return 1;
        }
        boolean bl = brokerCmdProperties.forceModeSet();
        if (!bl) {
            brokerAdmin = this.promptForAuthentication(brokerAdmin);
        }
        Globals.stdOutPrintln(this.ar.getString("A1569"));
        this.printBrokerInfo(brokerAdmin);
        try {
            this.connectToBroker(brokerAdmin);
            brokerAdmin.sendReloadClusterMessage();
            brokerAdmin.receiveReloadClusterReplyMessage();
            Globals.stdOutPrintln(this.ar.getString("A1571"));
        }
        catch (BrokerAdminException brokerAdminException) {
            this.handleBrokerAdminException(brokerAdminException);
            Globals.stdErrPrintln(this.ar.getString("A1570"));
            return 1;
        }
        return 0;
    }

    private int runCommit(BrokerCmdProperties brokerCmdProperties) {
        block11: {
            Long l = null;
            String string = this.ar.getString("A5016");
            String string2 = this.ar.getString("A5015");
            String string3 = this.ar.getString("A5018");
            String string4 = this.ar.getString("A5017");
            BrokerAdmin brokerAdmin = this.init();
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1259"));
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1257"));
            this.printTransactionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            String string5 = brokerCmdProperties.getTargetName();
            try {
                l = Long.valueOf(string5);
            }
            catch (NumberFormatException numberFormatException) {
                Globals.stdErrPrintln(this.ar.getString("A3150", string5));
                Globals.stdErrPrintln(this.ar.getString("A1259"));
                return 1;
            }
            try {
                this.connectToBroker(brokerAdmin);
                String string6 = null;
                if (!bl) {
                    string6 = this.getUserInput(this.ar.getString("A5033"), string4);
                    Globals.stdOutPrintln("");
                }
                if (string2.equalsIgnoreCase(string6) || string.equalsIgnoreCase(string6) || bl) {
                    try {
                        brokerAdmin.sendCommitTxnMessage(l);
                        brokerAdmin.receiveCommitTxnReplyMessage();
                        Globals.stdOutPrintln(this.ar.getString("A1258"));
                        break block11;
                    }
                    catch (BrokerAdminException brokerAdminException) {
                        this.handleBrokerAdminException(brokerAdminException);
                        Globals.stdErrPrintln(this.ar.getString("A1259"));
                        return 1;
                    }
                }
                if (string4.equalsIgnoreCase(string6) || string3.equalsIgnoreCase(string6)) {
                    Globals.stdOutPrintln(this.ar.getString("A1279"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", string6));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1279"));
                return 1;
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1259"));
                return 1;
            }
        }
        return 0;
    }

    private int runRollback(BrokerCmdProperties brokerCmdProperties) {
        block14: {
            Long l = null;
            String string = this.ar.getString("A5016");
            String string2 = this.ar.getString("A5015");
            String string3 = this.ar.getString("A5018");
            String string4 = this.ar.getString("A5017");
            BrokerAdmin brokerAdmin = this.init();
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1262"));
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1260"));
            this.printTransactionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(brokerAdmin);
            String string5 = brokerCmdProperties.getTargetName();
            try {
                l = Long.valueOf(string5);
            }
            catch (NumberFormatException numberFormatException) {
                Globals.stdErrPrintln(this.ar.getString("A3150", string5));
                Globals.stdErrPrintln(this.ar.getString("A1262"));
                return 1;
            }
            try {
                Object object;
                Hashtable hashtable = null;
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetTxnsMessage(l);
                Vector vector = brokerAdmin.receiveGetTxnsReplyMessage();
                if (vector != null && vector.size() == 1) {
                    object = vector.elements();
                    hashtable = (Hashtable)object.nextElement();
                    if (brokerCmdProperties.debugModeSet()) {
                        this.printAllTxnAttrs(hashtable);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1335"));
                    Globals.stdErrPrintln(this.ar.getString("A1262"));
                    return 1;
                }
                object = (Integer)hashtable.get("state");
                String string6 = this.getTxnStateString((Integer)object);
                String string7 = null;
                if (!bl) {
                    string7 = this.getUserInput(this.ar.getString("A5032", string6), string4);
                    Globals.stdOutPrintln("");
                }
                if (string2.equalsIgnoreCase(string7) || string.equalsIgnoreCase(string7) || bl) {
                    try {
                        brokerAdmin.sendRollbackTxnMessage(l);
                        brokerAdmin.receiveRollbackTxnReplyMessage();
                        Globals.stdOutPrintln(this.ar.getString("A1261"));
                        break block14;
                    }
                    catch (BrokerAdminException brokerAdminException) {
                        this.handleBrokerAdminException(brokerAdminException);
                        Globals.stdErrPrintln(this.ar.getString("A1262"));
                        return 1;
                    }
                }
                if (string4.equalsIgnoreCase(string7) || string3.equalsIgnoreCase(string7)) {
                    Globals.stdOutPrintln(this.ar.getString("A1278"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", string7));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1278"));
                return 1;
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1262"));
                return 1;
            }
        }
        return 0;
    }

    private int runCompact(BrokerCmdProperties brokerCmdProperties) {
        String string = null;
        boolean bl = true;
        String string2 = this.ar.getString("A5016");
        String string3 = this.ar.getString("A5015");
        String string4 = this.ar.getString("A5018");
        String string5 = this.ar.getString("A5017");
        String string6 = brokerCmdProperties.getCommandArg();
        boolean bl2 = brokerCmdProperties.forceModeSet();
        BrokerAdmin brokerAdmin = this.init();
        if ("dst".equals(string6)) {
            String string7 = brokerCmdProperties.getTargetName();
            int n = this.getDestTypeMask(brokerCmdProperties);
            if (string7 != null) {
                bl = false;
            }
            if (brokerAdmin == null) {
                if (bl) {
                    Globals.stdErrPrintln(this.ar.getString("A1306"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1305"));
                }
                return 1;
            }
            if (!bl2) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            if (bl) {
                Globals.stdOutPrintln(this.ar.getString("A1302"));
                this.printBrokerInfo(brokerAdmin);
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1301"));
                this.printDestinationInfo();
                Globals.stdOutPrintln(this.ar.getString("A1200"));
                this.printBrokerInfo(brokerAdmin);
            }
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                if (bl) {
                    Globals.stdErrPrintln(this.ar.getString("A1306"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1305"));
                }
                return 1;
            }
            if (!bl2) {
                string = bl ? this.getUserInput(this.ar.getString("A5024"), string5) : this.getUserInput(this.ar.getString("A5023"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl2) {
                try {
                    brokerAdmin.sendCompactDestinationMessage(string7, n);
                    brokerAdmin.receiveCompactDestinationReplyMessage();
                    if (bl) {
                        Globals.stdOutPrintln(this.ar.getString("A1304"));
                    }
                    Globals.stdOutPrintln(this.ar.getString("A1303"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    if (bl) {
                        Globals.stdErrPrintln(this.ar.getString("A1306"));
                    } else {
                        Globals.stdErrPrintln(this.ar.getString("A1305"));
                    }
                    return 1;
                }
            } else {
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    if (bl) {
                        Globals.stdOutPrintln(this.ar.getString("A1308"));
                    } else {
                        Globals.stdOutPrintln(this.ar.getString("A1307"));
                    }
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", string));
                Globals.stdOutPrintln("");
                if (bl) {
                    Globals.stdOutPrintln(this.ar.getString("A1308"));
                } else {
                    Globals.stdOutPrintln(this.ar.getString("A1307"));
                }
                return 1;
            }
        }
        brokerAdmin.close();
        return 0;
    }

    private int runQuiesce(BrokerCmdProperties brokerCmdProperties) {
        String string = null;
        String string2 = this.ar.getString("A5016");
        String string3 = this.ar.getString("A5015");
        String string4 = this.ar.getString("A5018");
        String string5 = this.ar.getString("A5017");
        BrokerAdmin brokerAdmin = this.init();
        boolean bl = brokerCmdProperties.forceModeSet();
        String string6 = brokerCmdProperties.getCommandArg();
        if ("bkr".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1701"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1700"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1701"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5027"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendQuiesceMessage();
                    brokerAdmin.receiveQuiesceReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1702"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1701"));
                    return 1;
                }
            } else {
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln(this.ar.getString("A1703"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", string));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1703"));
                return 1;
            }
        }
        brokerAdmin.close();
        return 0;
    }

    private int runUnquiesce(BrokerCmdProperties brokerCmdProperties) {
        String string = null;
        String string2 = this.ar.getString("A5016");
        String string3 = this.ar.getString("A5015");
        String string4 = this.ar.getString("A5018");
        String string5 = this.ar.getString("A5017");
        BrokerAdmin brokerAdmin = this.init();
        boolean bl = brokerCmdProperties.forceModeSet();
        String string6 = brokerCmdProperties.getCommandArg();
        if ("bkr".equals(string6)) {
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1751"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1750"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1751"));
                return 1;
            }
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5030"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendUnquiesceMessage();
                    brokerAdmin.receiveUnquiesceReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1752"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1751"));
                    return 1;
                }
            } else {
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln(this.ar.getString("A1753"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", string));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1753"));
                return 1;
            }
        }
        brokerAdmin.close();
        return 0;
    }

    private int runTakeover(BrokerCmdProperties brokerCmdProperties) {
        String string = null;
        String string2 = this.ar.getString("A5016");
        String string3 = this.ar.getString("A5015");
        String string4 = this.ar.getString("A5018");
        String string5 = this.ar.getString("A5017");
        BrokerAdmin brokerAdmin = this.init();
        boolean bl = brokerCmdProperties.forceModeSet();
        String string6 = brokerCmdProperties.getCommandArg();
        if ("bkr".equals(string6)) {
            Object[] objectArray;
            Object object;
            String string7 = brokerCmdProperties.getTargetName();
            if (brokerAdmin == null) {
                Globals.stdErrPrintln(this.ar.getString("A1705"));
                return 1;
            }
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            Globals.stdOutPrintln(this.ar.getString("A1704"));
            Globals.stdOutPrintln(this.ar.getString("A1708"));
            this.printBrokerInfo(brokerAdmin);
            try {
                this.connectToBroker(brokerAdmin);
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1705"));
                return 1;
            }
            try {
                brokerAdmin.sendGetBrokerPropsMessage();
                object = brokerAdmin.receiveGetBrokerPropsReplyMessage();
                objectArray = ((Properties)object).getProperty("imq.cluster.ha");
                if (!Boolean.valueOf((String)objectArray).booleanValue()) {
                    Globals.stdErrPrintln(this.ar.getString("A3171"));
                    Globals.stdErrPrintln(this.ar.getString("A1705"));
                    return 1;
                }
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A1523"));
                Globals.stdErrPrintln(this.ar.getString("A1705"));
                return 1;
            }
            Globals.stdOutPrintln(this.ar.getString("A1769"));
            object = new BrokerCmdPrinter(5, 3, "-");
            objectArray = new String[5];
            ((MultiColumnPrinter)object).setSortNeeded(false);
            ((MultiColumnPrinter)object).setTitleAlign(1);
            int n = 0;
            objectArray[n++] = "";
            objectArray[n++] = "";
            objectArray[n++] = "";
            objectArray[n++] = "";
            int n2 = n++;
            objectArray[n2] = this.ar.getString("A1721");
            ((MultiColumnPrinter)object).addTitle((String[])objectArray);
            n = 0;
            int n3 = n++;
            objectArray[n3] = this.ar.getString("A1716");
            int n4 = n++;
            objectArray[n4] = this.ar.getString("A1717");
            int n5 = n++;
            objectArray[n5] = this.ar.getString("A1718");
            int n6 = n++;
            objectArray[n6] = this.ar.getString("A1719");
            int n7 = n++;
            objectArray[n7] = this.ar.getString("A1737");
            ((MultiColumnPrinter)object).addTitle((String[])objectArray);
            Vector vector = null;
            try {
                brokerAdmin.sendGetClusterMessage(true);
                vector = brokerAdmin.receiveGetClusterReplyMessage();
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A3169"));
                Globals.stdErrPrintln(this.ar.getString("A1705"));
                return 1;
            }
            String string8 = null;
            boolean bl2 = false;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)enumeration.nextElement();
                string8 = (String)hashtable.get("ID");
                if (string8 == null || !string8.equals(string7)) continue;
                bl2 = true;
                n = 0;
                objectArray[n++] = this.checkNullAndPrint(string8);
                objectArray[n++] = this.checkNullAndPrint(hashtable.get("Address"));
                Integer n8 = (Integer)hashtable.get("State");
                objectArray[n++] = n8 != null ? BrokerState.toString(n8) : "";
                Long l = (Long)hashtable.get("NumMsgs");
                objectArray[n++] = this.checkNullAndPrint(l);
                l = (Long)hashtable.get("StatusTimestamp");
                if (l != null) {
                    long l2 = System.currentTimeMillis() - l;
                    objectArray[n++] = this.getTimeString(l2);
                } else {
                    objectArray[n++] = "";
                }
                ((MultiColumnPrinter)object).add(objectArray);
                break;
            }
            if (!bl2) {
                Globals.stdErrPrintln(this.ar.getString("A3170", string7));
                Globals.stdErrPrintln(this.ar.getString("A1705"));
                return 1;
            }
            ((MultiColumnPrinter)object).println();
            if (!bl) {
                string = this.getUserInput(this.ar.getString("A5028"), string5);
                Globals.stdOutPrintln("");
            }
            if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || bl) {
                try {
                    brokerAdmin.sendTakeoverMessage(string7);
                    brokerAdmin.receiveTakeoverReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1706"));
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    Globals.stdErrPrintln(this.ar.getString("A1705"));
                    return 1;
                }
            } else {
                if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                    Globals.stdOutPrintln(this.ar.getString("A1707"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", string));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1707"));
                return 1;
            }
        }
        brokerAdmin.close();
        return 0;
    }

    private int runExists(BrokerCmdProperties brokerCmdProperties) {
        int n = 1;
        BrokerAdmin brokerAdmin = this.init();
        String string = brokerCmdProperties.getCommandArg();
        if ("dst".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdOutPrintln("Problems connecting to the broker.");
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string2 = brokerCmdProperties.getTargetName();
            int n2 = this.getDestTypeMask(brokerCmdProperties);
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetDestinationsMessage(string2, n2);
                Vector vector = brokerAdmin.receiveGetDestinationsReplyMessage();
                if (vector == null || vector.size() != 1) {
                    Globals.stdErrPrintln("Problems retrieving the destination info.");
                    return 1;
                }
                Globals.stdOutPrintln(Boolean.TRUE.toString());
                n = 0;
            }
            catch (BrokerAdminException brokerAdminException) {
                if (brokerAdminException.getReplyStatus() == 404) {
                    Globals.stdOutPrintln(Boolean.FALSE.toString());
                    n = 0;
                }
                this.handleBrokerAdminException(brokerAdminException);
                return 1;
            }
        }
        return n;
    }

    private int runGetAttr(BrokerCmdProperties brokerCmdProperties) {
        int n = 1;
        BrokerAdmin brokerAdmin = this.init();
        String string = brokerCmdProperties.getCommandArg();
        if ("dst".equals(string)) {
            block43: {
                if (brokerAdmin == null) {
                    Globals.stdOutPrintln("Problems connecting to the broker.");
                    return 1;
                }
                boolean bl = brokerCmdProperties.forceModeSet();
                if (!bl) {
                    brokerAdmin = this.promptForAuthentication(brokerAdmin);
                }
                String string2 = brokerCmdProperties.getTargetName();
                int n2 = this.getDestTypeMask(brokerCmdProperties);
                String string3 = brokerCmdProperties.getSingleTargetAttr();
                try {
                    this.connectToBroker(brokerAdmin);
                    brokerAdmin.sendGetDestinationsMessage(string2, n2);
                    Vector vector = brokerAdmin.receiveGetDestinationsReplyMessage();
                    if (vector != null && vector.size() == 1) {
                        Enumeration enumeration = vector.elements();
                        DestinationInfo destinationInfo = (DestinationInfo)enumeration.nextElement();
                        if ("maxTotalMsgBytes".equals(string3)) {
                            Globals.stdOutPrintln(Long.toString(destinationInfo.maxMessageBytes));
                            n = 0;
                            break block43;
                        }
                        if ("maxNumMsgs".equals(string3)) {
                            Globals.stdOutPrintln(Integer.toString(destinationInfo.maxMessages));
                            n = 0;
                            break block43;
                        }
                        if ("maxBytesPerMsg".equals(string3)) {
                            Globals.stdOutPrintln(Long.toString(destinationInfo.maxMessageSize));
                            n = 0;
                            break block43;
                        }
                        if ("curTotalMsgBytes".equals(string3)) {
                            Globals.stdOutPrintln(Long.toString(destinationInfo.nMessageBytes));
                            n = 0;
                            break block43;
                        }
                        if ("curNumMsgs".equals(string3)) {
                            Globals.stdOutPrintln(Integer.toString(destinationInfo.nMessages));
                            n = 0;
                            break block43;
                        }
                        if ("curNumProducers".equals(string3)) {
                            Globals.stdOutPrintln(Integer.toString(destinationInfo.nProducers));
                            n = 0;
                            break block43;
                        }
                        if ("maxNumBackupConsumers".equals(string3)) {
                            Globals.stdOutPrintln(Integer.toString(destinationInfo.maxFailoverConsumers));
                            n = 0;
                            break block43;
                        }
                        if ("maxNumActiveConsumers".equals(string3)) {
                            Globals.stdOutPrintln(Integer.toString(destinationInfo.maxActiveConsumers));
                            n = 0;
                            break block43;
                        }
                        if ("isLocalOnly".equals(string3)) {
                            if (destinationInfo.isDestinationLocal()) {
                                Globals.stdOutPrintln(Boolean.TRUE.toString());
                            } else {
                                Globals.stdOutPrintln(Boolean.FALSE.toString());
                            }
                            n = 0;
                            break block43;
                        }
                        if ("limitBehavior".equals(string3)) {
                            Globals.stdOutPrintln(DestLimitBehavior.getString(destinationInfo.destLimitBehavior));
                            n = 0;
                            break block43;
                        }
                        if ("localDeliveryPreferred".equals(string3)) {
                            int n3 = destinationInfo.destCDP;
                            if (n3 == 1) {
                                Globals.stdOutPrintln(Boolean.TRUE.toString());
                            } else {
                                Globals.stdOutPrintln(Boolean.FALSE.toString());
                            }
                            n = 0;
                            break block43;
                        }
                        if ("consumerFlowLimit".equals(string3)) {
                            Globals.stdOutPrintln(Integer.toString(destinationInfo.maxPrefetch));
                            n = 0;
                            break block43;
                        }
                        if ("maxNumProducers".equals(string3)) {
                            Globals.stdOutPrintln(Integer.toString(destinationInfo.maxProducers));
                            n = 0;
                            break block43;
                        }
                        if ("curNumActiveConsumers".equals(string3)) {
                            if (DestType.isQueue(n2)) {
                                Globals.stdOutPrintln(Integer.toString(destinationInfo.naConsumers));
                            } else {
                                Globals.stdOutPrintln(Integer.toString(destinationInfo.nConsumers));
                            }
                            n = 0;
                            break block43;
                        }
                        if ("curNumBackupConsumers".equals(string3)) {
                            Globals.stdOutPrintln(Integer.toString(destinationInfo.nfConsumers));
                            n = 0;
                            break block43;
                        }
                        if ("useDMQ".equals(string3)) {
                            Globals.stdOutPrintln(Boolean.toString(destinationInfo.useDMQ()));
                            n = 0;
                            break block43;
                        }
                        Globals.stdErrPrintln(string3 + " is not recognized.");
                        return 1;
                    }
                    Globals.stdErrPrintln("Problems retrieving the destination info.");
                    return 1;
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    return 1;
                }
            }
            return n;
        }
        if ("svc".equals(string)) {
            block44: {
                if (brokerAdmin == null) {
                    Globals.stdOutPrintln("Problems connecting to the broker.");
                    return 1;
                }
                boolean bl = brokerCmdProperties.forceModeSet();
                if (!bl) {
                    brokerAdmin = this.promptForAuthentication(brokerAdmin);
                }
                String string4 = brokerCmdProperties.getTargetName();
                String string5 = brokerCmdProperties.getSingleTargetAttr();
                try {
                    this.connectToBroker(brokerAdmin);
                    brokerAdmin.sendGetServicesMessage(string4);
                    Vector vector = brokerAdmin.receiveGetServicesReplyMessage();
                    if (vector != null && vector.size() == 1) {
                        Enumeration enumeration = vector.elements();
                        ServiceInfo serviceInfo = (ServiceInfo)enumeration.nextElement();
                        if ("port".equals(string5)) {
                            Globals.stdOutPrintln(Integer.toString(serviceInfo.port));
                            n = 0;
                            break block44;
                        }
                        if ("minThreads".equals(string5)) {
                            Globals.stdOutPrintln(Integer.toString(serviceInfo.minThreads));
                            n = 0;
                            break block44;
                        }
                        if ("maxThreads".equals(string5)) {
                            Globals.stdOutPrintln(Integer.toString(serviceInfo.maxThreads));
                            n = 0;
                            break block44;
                        }
                        Globals.stdOutPrintln(string5 + " is not recognized.");
                        return 1;
                    }
                    Globals.stdOutPrintln("Problems retrieving the service info.");
                    return 1;
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.handleBrokerAdminException(brokerAdminException);
                    return 1;
                }
            }
            return n;
        }
        if ("bkr".equals(string)) {
            if (brokerAdmin == null) {
                Globals.stdOutPrintln("Problems connecting to the broker.");
                return 1;
            }
            boolean bl = brokerCmdProperties.forceModeSet();
            if (!bl) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String string6 = brokerCmdProperties.getSingleTargetAttr();
            try {
                this.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetBrokerPropsMessage();
                Properties properties = brokerAdmin.receiveGetBrokerPropsReplyMessage();
                if (properties == null) {
                    Globals.stdOutPrintln("Problems retrieving the broker info.");
                    return 1;
                }
                String string7 = properties.getProperty(string6, "");
                Globals.stdOutPrintln(string7);
                n = 0;
            }
            catch (BrokerAdminException brokerAdminException) {
                this.handleBrokerAdminException(brokerAdminException);
                return 1;
            }
        }
        return n;
    }

    private int runUngracefulKill(BrokerCmdProperties brokerCmdProperties) {
        BrokerAdmin brokerAdmin = this.init();
        if (brokerAdmin == null) {
            Globals.stdOutPrintln("Problems connecting to the broker.");
            return 1;
        }
        boolean bl = brokerCmdProperties.forceModeSet();
        if (!bl) {
            brokerAdmin = this.promptForAuthentication(brokerAdmin);
        }
        try {
            this.connectToBroker(brokerAdmin);
            brokerAdmin.sendShutdownMessage(false, true);
            Globals.stdOutPrintln("Ungracefully shutdown the broker.");
            return 0;
        }
        catch (BrokerAdminException brokerAdminException) {
            this.handleBrokerAdminException(brokerAdminException);
            return 1;
        }
    }

    private int runDebug(BrokerCmdProperties brokerCmdProperties) {
        Hashtable hashtable = null;
        Properties properties = null;
        BrokerAdmin brokerAdmin = this.init();
        if (brokerAdmin == null) {
            Globals.stdOutPrintln("Problems connecting to the broker.");
            return 1;
        }
        boolean bl = brokerCmdProperties.forceModeSet();
        if (!bl) {
            brokerAdmin = this.promptForAuthentication(brokerAdmin);
        }
        String string = brokerCmdProperties.getCommand();
        String string2 = brokerCmdProperties.getCommandArg();
        String string3 = brokerCmdProperties.getTargetName();
        String string4 = brokerCmdProperties.getDestType();
        properties = brokerCmdProperties.getTargetAttrs();
        Globals.stdOutPrintln("Sending the following DEBUG message:");
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4, "-", 0, false);
        Object[] objectArray = new String[]{"Header Property Name", "Value"};
        brokerCmdPrinter.addTitle((String[])objectArray);
        objectArray[0] = "JMQCommand";
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "JMQCommandArg";
        objectArray[1] = string2;
        brokerCmdPrinter.add(objectArray);
        if (string3 != null) {
            objectArray[0] = "JMQTarget";
            objectArray[1] = string3;
            brokerCmdPrinter.add(objectArray);
        }
        if (string4 != null) {
            objectArray[0] = "JMQTargetType";
            objectArray[1] = string4;
            brokerCmdPrinter.add(objectArray);
        }
        brokerCmdPrinter.println();
        if (properties != null && properties.size() > 0) {
            Globals.stdOutPrintln("Optional properties:");
            this.printAttrs(properties, true);
        }
        Globals.stdOutPrintln("To the broker specified by:");
        this.printBrokerInfo(brokerAdmin);
        try {
            this.connectToBroker(brokerAdmin);
            brokerAdmin.sendDebugMessage(string, string2, string3, string4, properties);
            hashtable = brokerAdmin.receiveDebugReplyMessage();
            if (hashtable != null && hashtable.size() > 0) {
                Globals.stdOutPrintln("Data received back from broker:");
                this.printDebugHash(hashtable);
            } else {
                Globals.stdOutPrintln("No additional data received back from broker.\n");
            }
            Globals.stdOutPrintln("DEBUG message sent successfully.");
            return 0;
        }
        catch (BrokerAdminException brokerAdminException) {
            this.handleBrokerAdminException(brokerAdminException);
            return 1;
        }
    }

    private void printDebugHash(Hashtable hashtable) {
        DebugPrinter debugPrinter = new DebugPrinter(hashtable, 4);
        debugPrinter.println();
    }

    private void printAllBrokerAttrs(Properties properties) {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            objectArray[0] = string = (String)enumeration.nextElement();
            objectArray[1] = properties.getProperty(string, "");
            brokerCmdPrinter.add(objectArray);
        }
        brokerCmdPrinter.println();
    }

    private void printDisplayableBrokerAttrs(Properties properties) {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        brokerCmdPrinter.setSortNeeded(false);
        objectArray[0] = this.ar.getString("A1626");
        String string = properties.getProperty("imq.product.version", "");
        if (string.equals("")) {
            string = this.ar.getString("A1627");
        }
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1525");
        string = properties.getProperty("imq.instancename", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1711");
        string = properties.getProperty("imq.brokerid", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1441");
        string = properties.getProperty("imq.portmapper.port", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1733");
        string = properties.getProperty("imq.embedded", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1763");
        string = properties.getProperty("imq.varhome", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "";
        objectArray[1] = "";
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1628");
        string = properties.getProperty("imq.system.current_count", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1629");
        string = properties.getProperty("imq.system.current_size", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "";
        objectArray[1] = "";
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1684");
        string = properties.getProperty("imq.dmq.current_count", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1685");
        string = properties.getProperty("imq.dmq.current_size", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "";
        objectArray[1] = "";
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1683");
        string = properties.getProperty("imq.destination.logDeadMsgs", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1686");
        string = properties.getProperty("imq.destination.DMQ.truncateBody", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "";
        objectArray[1] = "";
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1534");
        string = properties.getProperty("imq.system.max_count", "");
        objectArray[1] = this.checkAndPrintUnlimited(string, this.zeroNegOneString);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1535");
        string = properties.getProperty("imq.system.max_size", "");
        objectArray[1] = this.checkAndPrintUnlimitedBytes(string, this.zeroNegOneLong);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1536");
        string = properties.getProperty("imq.message.max_size", "");
        objectArray[1] = this.checkAndPrintUnlimitedBytes(string, this.zeroNegOneLong);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "";
        objectArray[1] = "";
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1527");
        string = properties.getProperty("imq.autocreate.queue", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1526");
        string = properties.getProperty("imq.autocreate.topic", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1654");
        string = properties.getProperty("imq.autocreate.queue.maxNumActiveConsumers", "");
        objectArray[1] = this.checkAndPrintUnlimited(string, this.negOneString);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1655");
        string = properties.getProperty("imq.autocreate.queue.maxNumBackupConsumers", "");
        objectArray[1] = this.checkAndPrintUnlimited(string, this.negOneString);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "";
        objectArray[1] = "";
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1709");
        string = properties.getProperty("imq.cluster.clusterid", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1710");
        string = properties.getProperty("imq.cluster.ha");
        objectArray[1] = Boolean.valueOf(string).toString();
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1573");
        string = properties.getProperty("imq.cluster.brokerlist.active", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1572");
        string = properties.getProperty("imq.cluster.brokerlist", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1574");
        string = properties.getProperty("imq.cluster.masterbroker", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1575");
        string = properties.getProperty("imq.cluster.url", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "";
        objectArray[1] = "";
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1528");
        string = properties.getProperty("imq.log.level", "");
        objectArray[1] = string;
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1530");
        string = properties.getProperty("imq.log.file.rolloversecs", "");
        objectArray[1] = this.checkAndPrintUnlimited(string, this.zeroNegOneString);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1529");
        string = properties.getProperty("imq.log.file.rolloverbytes", "");
        objectArray[1] = this.checkAndPrintUnlimitedBytes(string, this.zeroNegOneLong);
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }

    private void printAllTxnAttrs(Hashtable hashtable) {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            objectArray[0] = string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            objectArray[1] = v.toString();
            brokerCmdPrinter.add(objectArray);
        }
        brokerCmdPrinter.println();
    }

    private void printDisplayableTxnAttrs(Hashtable hashtable) {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        objectArray[0] = this.ar.getString("A1263");
        Long l = (Long)hashtable.get("txnid");
        objectArray[1] = this.checkNullAndPrint(l);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1269");
        Integer n = (Integer)hashtable.get("state");
        objectArray[1] = this.getTxnStateString(n);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1268");
        n = (Integer)hashtable.get("nmsgs");
        objectArray[1] = this.checkNullAndPrint(n);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1267");
        n = (Integer)hashtable.get("nacks");
        objectArray[1] = this.checkNullAndPrint(n);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1264");
        String string = (String)hashtable.get("clientid");
        objectArray[1] = this.checkNullAndPrint(string);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1266");
        l = (Long)hashtable.get("timestamp");
        objectArray[1] = this.checkNullAndPrintTimestamp(l);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1265");
        string = (String)hashtable.get("connection");
        objectArray[1] = this.checkNullAndPrint(string);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1277");
        l = (Long)hashtable.get("connectionid");
        objectArray[1] = this.checkNullAndPrint(l);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1270");
        string = (String)hashtable.get("user");
        objectArray[1] = this.checkNullAndPrint(string);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1271");
        string = (String)hashtable.get("xid");
        objectArray[1] = this.checkNullAndPrint(string);
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }

    private void printAllCxnAttrs(Hashtable hashtable) {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            objectArray[0] = string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            objectArray[1] = v.toString();
            brokerCmdPrinter.add(objectArray);
        }
        brokerCmdPrinter.println();
    }

    private void printDisplayableCxnAttrs(Hashtable hashtable) {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        brokerCmdPrinter.setSortNeeded(false);
        objectArray[0] = this.ar.getString("A1323");
        Long l = (Long)hashtable.get("cxnid");
        objectArray[1] = this.checkNullAndPrint(l);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1327");
        String string = (String)hashtable.get("user");
        objectArray[1] = this.checkNullAndPrint(string);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1331");
        string = (String)hashtable.get("service");
        objectArray[1] = this.checkNullAndPrint(string);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1328");
        Integer n = (Integer)hashtable.get("nproducers");
        objectArray[1] = this.checkNullAndPrint(n);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1329");
        n = (Integer)hashtable.get("nconsumers");
        objectArray[1] = this.checkNullAndPrint(n);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1325");
        string = (String)hashtable.get("host");
        objectArray[1] = this.checkNullAndPrint(string);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1326");
        n = (Integer)hashtable.get("port");
        objectArray[1] = this.checkNullAndPrint(n);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1324");
        string = (String)hashtable.get("clientid");
        objectArray[1] = this.checkNullAndPrint(string);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = this.ar.getString("A1330");
        string = (String)hashtable.get("clientplatform");
        objectArray[1] = this.checkNullAndPrint(string);
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }

    private void printDisplayableMsgAttrs(HashMap hashMap) {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        BrokerCmdPrinter brokerCmdPrinter2 = new BrokerCmdPrinter(1, 0, "-");
        Object[] objectArray = new String[2];
        String[] stringArray = new String[1];
        brokerCmdPrinter.setSortNeeded(false);
        stringArray[0] = "Message Header Information";
        brokerCmdPrinter2.addTitle(stringArray);
        brokerCmdPrinter2.print();
        objectArray[0] = "Message ID";
        objectArray[1] = this.checkNullAndPrint(hashMap.get("MessageID"));
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "Correlation ID";
        objectArray[1] = this.checkNullAndPrint(hashMap.get("CorrelationID"));
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "Destination Name";
        objectArray[1] = this.checkNullAndPrint(hashMap.get("DestinationName"));
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "Destination Type";
        Integer n = (Integer)hashMap.get("DestinationType");
        objectArray[1] = BrokerAdminUtil.getDestinationType(n);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "Delivery Mode";
        n = (Integer)hashMap.get("DeliveryMode");
        objectArray[1] = this.checkNullAndPrintDeliveryMode(n);
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "Priority";
        objectArray[1] = this.checkNullAndPrint(hashMap.get("Priority"));
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "Redelivered";
        objectArray[1] = this.checkNullAndPrint(hashMap.get("Redelivered"));
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "Timestamp";
        objectArray[1] = this.checkNullAndPrintTimestamp((Long)hashMap.get("Timestamp"));
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "Type";
        objectArray[1] = this.checkNullAndPrintTimestamp((Long)hashMap.get("Type"));
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "Expiration";
        objectArray[1] = this.checkNullAndPrintTimestamp((Long)hashMap.get("Expiration"));
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "ReplyTo Destination Name";
        objectArray[1] = this.checkNullAndPrint(hashMap.get("ReplyToDestinationName"));
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = "ReplyTo Destination Type";
        n = (Integer)hashMap.get("ReplyToDestinationType");
        objectArray[1] = n != null ? BrokerAdminUtil.getDestinationType(n) : "";
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
        brokerCmdPrinter2.clear();
        brokerCmdPrinter2.clearTitle();
        stringArray[0] = "Message Properties Information";
        brokerCmdPrinter2.addTitle(stringArray);
        brokerCmdPrinter2.print();
        Hashtable hashtable = (Hashtable)hashMap.get("MessageProperties");
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            brokerCmdPrinter.clear();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = hashtable.get(string);
                objectArray[0] = string;
                objectArray[1] = v.toString();
                brokerCmdPrinter.add(objectArray);
            }
            brokerCmdPrinter.println();
        } else {
            Globals.stdOutPrintln("");
        }
        brokerCmdPrinter2.clear();
        brokerCmdPrinter2.clearTitle();
        stringArray[0] = "Message Body Information";
        brokerCmdPrinter2.addTitle(stringArray);
        brokerCmdPrinter2.print();
        brokerCmdPrinter.clear();
        objectArray[0] = "Body Type";
        objectArray[1] = this.checkNullAndPrintMsgBodyType((Integer)hashMap.get("MessageBodyType"), true);
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }

    private int getDestTypeMask(BrokerCmdProperties brokerCmdProperties) {
        Properties properties = brokerCmdProperties.getTargetAttrs();
        String string = brokerCmdProperties.getDestType();
        int n = 0;
        if (string == null || string.equals("")) {
            return -1;
        }
        if (string.equals("t")) {
            n = 2;
        } else if (string.equals("q")) {
            n = 1;
        }
        if (properties == null || properties.isEmpty()) {
            return n;
        }
        String string2 = properties.getProperty("queueDeliveryPolicy");
        if (string2 == null) {
            return n;
        }
        if (string2.equals("s")) {
            n |= 0x100;
        } else if (string2.equals("f")) {
            n |= 0x400;
        } else if (string2.equals("r")) {
            n |= 0x200;
        }
        return n;
    }

    private BrokerAdmin init() {
        BrokerAdmin brokerAdmin;
        String string = this.brokerCmdProps.getBrokerHostPort();
        String string2 = this.getBrokerHost(string);
        String string3 = this.brokerCmdProps.getAdminUserId();
        int n = -1;
        int n2 = this.brokerCmdProps.getNumRetries();
        int n3 = this.brokerCmdProps.getReceiveTimeout();
        boolean bl = this.brokerCmdProps.isAdminKeyUsed();
        boolean bl2 = this.brokerCmdProps.useSSLTransportSet();
        if (this.brokerCmdProps.adminDebugModeSet()) {
            BrokerAdmin.setDebug(true);
        }
        try {
            String string4 = this.getPasswordFromFileOrCmdLine(this.brokerCmdProps);
            brokerAdmin = new BrokerAdmin(string, string3, string4, n3 * 1000, bl2);
            if (bl) {
                brokerAdmin.setAdminKeyUsed(true);
            }
            if (bl2) {
                brokerAdmin.setSSLTransportUsed(true);
            }
            if (n2 > 0) {
                brokerAdmin.setNumRetries(n2);
            }
        }
        catch (BrokerCmdException brokerCmdException) {
            this.handleBrokerCmdException(brokerCmdException);
            return null;
        }
        catch (BrokerAdminException brokerAdminException) {
            this.handleBrokerAdminException(brokerAdminException);
            return null;
        }
        brokerAdmin.addAdminEventListener(this);
        return brokerAdmin;
    }

    private String getBrokerHost(String string) {
        String string2 = string;
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    private int getBrokerPort(String string) throws BrokerAdminException {
        int n = -1;
        if (string == null) {
            return n;
        }
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            try {
                n = Integer.parseInt(string.substring(n2 + 1));
            }
            catch (Exception exception) {
                throw new BrokerAdminException(8);
            }
        }
        return n;
    }

    private void connectToBroker(BrokerAdmin brokerAdmin) throws BrokerAdminException {
        brokerAdmin.connect();
        brokerAdmin.sendHelloMessage();
        brokerAdmin.receiveHelloReplyMessage();
    }

    private void handleBrokerAdminException(BrokerAdminException brokerAdminException) {
        Exception exception = brokerAdminException.getLinkedException();
        int n = brokerAdminException.getType();
        switch (n) {
            case 0: {
                Globals.stdErrPrintln(this.ar.getString("A3120", brokerAdminException.getBrokerHost(), brokerAdminException.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A3139", "-b"));
                break;
            }
            case 1: {
                Globals.stdErrPrintln(this.ar.getString("A3121"));
                this.printBrokerAdminExceptionDetails(brokerAdminException);
                break;
            }
            case 2: {
                Globals.stdErrPrintln(this.ar.getString("A3122"));
                this.printBrokerAdminExceptionDetails(brokerAdminException);
                break;
            }
            case 3: {
                Globals.stdErrPrintln(this.ar.getString("A3123"));
                this.printBrokerAdminExceptionDetails(brokerAdminException);
                break;
            }
            case 4: {
                Globals.stdErrPrintln(this.ar.getString("A3124"));
                this.printBrokerAdminExceptionDetails(brokerAdminException);
                break;
            }
            case 5: {
                Globals.stdErrPrintln(this.ar.getString("A3125"));
                this.printBrokerAdminExceptionDetails(brokerAdminException);
                break;
            }
            case 6: {
                Globals.stdErrPrintln(this.ar.getString("A3126"));
                this.printBrokerAdminExceptionDetails(brokerAdminException);
                break;
            }
            case 7: {
                Globals.stdErrPrintln(this.ar.getString("A3127"));
                this.printBrokerAdminExceptionDetails(brokerAdminException);
                break;
            }
            case 8: {
                Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3128"));
                break;
            }
            case 11: {
                Globals.stdErrPrintln(this.ar.getString("A3120", brokerAdminException.getBrokerHost(), brokerAdminException.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A3140"));
                break;
            }
            case 12: {
                Globals.stdErrPrintln(this.ar.getString("A3120", brokerAdminException.getBrokerHost(), brokerAdminException.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A3141"));
                break;
            }
            case 15: {
                Globals.stdErrPrintln(this.ar.getString("A3120", brokerAdminException.getBrokerHost(), brokerAdminException.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(brokerAdminException);
                Globals.stdErrPrintln(this.ar.getString("A3154"));
                break;
            }
            case 16: {
                Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3167", brokerAdminException.getBrokerAddress()));
            }
        }
    }

    private void printBrokerAdminExceptionDetails(BrokerAdminException brokerAdminException) {
        Exception exception = brokerAdminException.getLinkedException();
        String string = brokerAdminException.getBrokerErrorStr();
        if (string != null) {
            Globals.stdErrPrintln(string);
        }
        if (exception != null) {
            String string2 = exception.getMessage();
            String string3 = exception.toString();
            if (string3 != null) {
                Globals.stdErrPrintln(string3);
            } else if (string2 != null) {
                Globals.stdErrPrintln(string2);
            }
            if (this.brokerCmdProps.debugModeSet()) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private void handleBrokerCmdException(BrokerCmdException brokerCmdException) {
        Exception exception = brokerCmdException.getLinkedException();
        BrokerCmdProperties brokerCmdProperties = brokerCmdException.getProperties();
        int n = brokerCmdException.getType();
        switch (n) {
            case 34: {
                Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3161", exception));
                break;
            }
            default: {
                Globals.stdErrPrintln("Unknown exception caught: " + n);
            }
        }
    }

    private String getUserInput(String string) {
        return this.getUserInput(string, null);
    }

    private String getUserInput(String string, String string2) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            Globals.stdOutPrint(string);
            String string3 = bufferedReader.readLine();
            if (string3.equals("") && string2 != null) {
                string3 = string2;
            }
            return string3;
        }
        catch (IOException iOException) {
            Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3081"));
            return null;
        }
    }

    private String getPassword() {
        Password password = new Password();
        Globals.stdOutPrint(this.ar.getString("A1621"));
        return password.getPassword();
    }

    private void printBrokerInfo(BrokerAdmin brokerAdmin) {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4, "-");
        Object[] objectArray = new String[2];
        objectArray[0] = this.ar.getString("A1440");
        objectArray[1] = this.ar.getString("A1441");
        brokerCmdPrinter.addTitle((String[])objectArray);
        objectArray[0] = brokerAdmin.getBrokerHost();
        objectArray[1] = brokerAdmin.getBrokerPort();
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }

    private void printServiceInfo() {
        this.printServiceInfo(null);
    }

    private void printServiceInfo(String string) {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(1, 4, "-");
        Object[] objectArray = new String[1];
        objectArray[0] = this.ar.getString("A1420");
        brokerCmdPrinter.addTitle((String[])objectArray);
        objectArray[0] = string == null ? this.brokerCmdProps.getTargetName() : string;
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }

    private void printMessageInfo() {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(1, 4, "-");
        Object[] objectArray = new String[]{"Message ID"};
        brokerCmdPrinter.addTitle((String[])objectArray);
        objectArray[0] = this.brokerCmdProps.getMsgID();
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }

    private void printDestinationInfo() {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4, "-");
        Object[] objectArray = new String[2];
        objectArray[0] = this.ar.getString("A1400");
        objectArray[1] = this.ar.getString("A1401");
        brokerCmdPrinter.addTitle((String[])objectArray);
        objectArray[0] = this.brokerCmdProps.getTargetName();
        objectArray[1] = BrokerAdminUtil.getDestinationType(this.getDestTypeMask(this.brokerCmdProps));
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }

    private void printDurableSubscriptionInfo() {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4, "-");
        Object[] objectArray = new String[2];
        objectArray[0] = this.ar.getString("A1430");
        objectArray[1] = this.ar.getString("A1431");
        brokerCmdPrinter.addTitle((String[])objectArray);
        objectArray[0] = this.brokerCmdProps.getTargetName();
        objectArray[1] = this.brokerCmdProps.getClientID();
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }

    private void printTransactionInfo() {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(1, 4, "-");
        Object[] objectArray = new String[1];
        objectArray[0] = this.ar.getString("A1263");
        brokerCmdPrinter.addTitle((String[])objectArray);
        objectArray[0] = this.brokerCmdProps.getTargetName();
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }

    private void printConnectionInfo() {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(1, 4, "-");
        Object[] objectArray = new String[1];
        objectArray[0] = this.ar.getString("A1323");
        brokerCmdPrinter.addTitle((String[])objectArray);
        objectArray[0] = this.brokerCmdProps.getTargetName();
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }

    private void isAdminService(BrokerAdmin brokerAdmin, String string) throws BrokerAdminException {
        brokerAdmin.sendGetServicesMessage(string);
        Vector vector = brokerAdmin.receiveGetServicesReplyMessage();
        if (vector != null && vector.size() == 1) {
            Enumeration enumeration = vector.elements();
            ServiceInfo serviceInfo = (ServiceInfo)enumeration.nextElement();
            if (serviceInfo.type == 1) {
                throw new BrokerAdminException(7);
            }
        }
    }

    private void isDestTypeTopic(BrokerAdmin brokerAdmin, String string) throws BrokerAdminException {
        brokerAdmin.sendGetDestinationsMessage(null, -1);
        Vector vector = brokerAdmin.receiveGetDestinationsReplyMessage();
        boolean bl = false;
        for (int i = 0; !bl && i < vector.size(); ++i) {
            DestinationInfo destinationInfo = (DestinationInfo)vector.elementAt(i);
            if (!string.equals(destinationInfo.name) || !DestType.isTopic(destinationInfo.type)) continue;
            bl = true;
        }
        if (!bl) {
            throw new BrokerAdminException(7);
        }
    }

    private String checkAndPrintUnlimitedInt(int n, int[] nArray) {
        String string = null;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            string = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (string == null) {
            string = new Integer(n).toString();
        }
        return string;
    }

    private String checkAndPrintUnlimitedInt(int n, int n2) {
        String string = n == n2 ? this.ar.getString("A1537") + " (-1)" : new Integer(n).toString();
        return string;
    }

    private String checkAndPrintUnlimitedLong(long l, long[] lArray) {
        String string = null;
        for (int i = 0; i < lArray.length; ++i) {
            if (l != lArray[i]) continue;
            string = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (string == null) {
            string = new Long(l).toString();
        }
        return string;
    }

    private String checkAndPrintUnlimitedBytes(String string, long[] lArray) {
        SizeString sizeString;
        String string2 = null;
        String string3 = string.trim();
        try {
            sizeString = new SizeString(string3);
        }
        catch (Exception exception) {
            return string3;
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (sizeString.getBytes() != lArray[i]) continue;
            string2 = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (string2 == null) {
            string2 = string3;
        }
        return string2;
    }

    private String checkAndPrintUnlimited(String string, String[] stringArray) {
        String string2 = null;
        String string3 = string.trim();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string3.equals(stringArray[i])) continue;
            string2 = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (string2 == null) {
            string2 = string3;
        }
        return string2;
    }

    private String checkNullAndPrint(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    private String checkNullAndPrintTimestamp(Long l) {
        if (l != null) {
            Date date = new Date(l);
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            String string = dateFormat.format(date);
            return string;
        }
        return "";
    }

    private int getMetricType(BrokerCmdProperties brokerCmdProperties) {
        String string = brokerCmdProperties.getMetricType();
        String string2 = brokerCmdProperties.getCommandArg();
        if (string == null) {
            return 0;
        }
        if (string.equals("ttl")) {
            return 0;
        }
        if (string.equals("rts")) {
            return 1;
        }
        if (string.equals("cxn")) {
            return 2;
        }
        if (string.equals("con")) {
            return 3;
        }
        if (string.equals("dsk")) {
            return 4;
        }
        if (string.equals("rem")) {
            return 5;
        }
        return 0;
    }

    private BrokerAdmin promptForAuthentication(BrokerAdmin brokerAdmin) {
        String string = brokerAdmin.getUserName();
        String string2 = brokerAdmin.getPassword();
        boolean bl = false;
        if (string == null) {
            brokerAdmin.setUserName(this.getUserInput(this.ar.getString("A1620")));
            bl = true;
        }
        if (string2 == null) {
            String string3 = this.getPassword();
            brokerAdmin.setPassword(string3);
            bl = false;
        }
        if (bl) {
            Globals.stdOutPrintln("");
        }
        return brokerAdmin;
    }

    private boolean reconnectToBroker(BrokerAdmin brokerAdmin) {
        boolean bl = false;
        int n = 0;
        while (!bl && n < 5) {
            try {
                brokerAdmin.connect();
                brokerAdmin.sendHelloMessage();
                brokerAdmin.receiveHelloReplyMessage();
                bl = true;
            }
            catch (BrokerAdminException brokerAdminException) {
                if (brokerAdminException.getType() == 0) {
                    try {
                        Thread.sleep(5000L);
                        ++n;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            if (n < 5) continue;
            bl = false;
            Globals.stdErrPrintln(this.ar.getString("A3120", brokerAdmin.getBrokerHost(), brokerAdmin.getBrokerPort()));
            Globals.stdErrPrintln(this.ar.getString("A3116", new Long(25L)));
        }
        return bl;
    }

    private static Properties convertQueueDeliveryPolicy(Properties properties) {
        String string = properties.getProperty("imq.queue.deliverypolicy");
        if ("s".equals(string)) {
            properties.setProperty("imq.queue.deliverypolicy", "single");
        } else if ("f".equals(string)) {
            properties.setProperty("imq.queue.deliverypolicy", "failover");
        } else if ("r".equals(string)) {
            properties.setProperty("imq.queue.deliverypolicy", "round-robin");
        }
        return properties;
    }

    private String getDisplayableQueueDeliveryPolicy(String string) {
        if ("single".equals(string)) {
            return this.ar.getString("A1503");
        }
        if ("failover".equals(string)) {
            return this.ar.getString("A1505");
        }
        if ("round-robin".equals(string)) {
            return this.ar.getString("A1504");
        }
        return this.ar.getString("A1502");
    }

    private int getPauseTypeVal(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        if (string.equals("ALL")) {
            n = 3;
        } else if (string.equals("PRODUCERS")) {
            n = 2;
        } else if (string.equals("CONSUMERS")) {
            n = 1;
        }
        return n;
    }

    private String getResetTypeVal(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        if (string.equals("METRICS")) {
            return "JMQMetrics";
        }
        return null;
    }

    private int getLimitBehavValue(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        if (string.equals(LIMIT_BEHAV_FLOW_CONTROL)) {
            n = 0;
        } else if (string.equals(LIMIT_BEHAV_RM_OLDEST)) {
            n = 1;
        } else if (string.equals(LIMIT_BEHAV_REJECT_NEWEST)) {
            n = 2;
        } else if (string.equals(LIMIT_BEHAV_RM_LOW_PRIORITY)) {
            n = 3;
        }
        return n;
    }

    private int getClusterDeliveryPolicy(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        boolean bl = Boolean.valueOf(string);
        n = bl ? 1 : 2;
        return n;
    }

    private String getPasswordFromFileOrCmdLine(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        String string = brokerCmdProperties.getAdminPasswd();
        String string2 = brokerCmdProperties.getAdminPassfile();
        if (string != null) {
            return string;
        }
        if (string2 != null) {
            String string3 = null;
            try {
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(string2);
                properties.load(fileInputStream);
                string3 = properties.getProperty("imq.imqcmd.password");
                fileInputStream.close();
                if (string3 == null) {
                    throw new RuntimeException(this.ar.getString("A3162", "imq.imqcmd.password", string2));
                }
            }
            catch (Exception exception) {
                BrokerCmdException brokerCmdException = new BrokerCmdException(34);
                brokerCmdException.setProperties(brokerCmdProperties);
                brokerCmdException.setLinkedException(exception);
                throw brokerCmdException;
            }
            return string3;
        }
        return null;
    }

    private String checkNullAndPrintDeliveryMode(Integer n) {
        if (n != null) {
            String string;
            switch (n) {
                case 1: {
                    string = "NON_PERSISTENT";
                    break;
                }
                case 2: {
                    string = "PERSISTENT";
                    break;
                }
                default: {
                    string = "Unknown";
                }
            }
            return string + " (" + n + ")";
        }
        return "";
    }

    private String checkNullAndPrintMsgBodyType(Integer n, boolean bl) {
        if (n != null) {
            String string = null;
            switch (n) {
                case 1: {
                    string = "TextMessage";
                    break;
                }
                case 2: {
                    string = "BytesMessage";
                    break;
                }
                case 3: {
                    string = "MapMessage";
                    break;
                }
                case 4: {
                    string = "StreamMessage";
                    break;
                }
                case 5: {
                    string = "ObjectMessage";
                    break;
                }
                default: {
                    string = "Unknown";
                }
            }
            if (bl) {
                return string + " (" + n + ")";
            }
            return string;
        }
        return "";
    }
}

