/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import java.util.Vector;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualServer
extends BaseElement {
    private static Logger log = CommonInfoModel.getDefaultLogger();

    public void transform(Element element, Element parentSource, Element parentResult) {
        NodeList resultVirtualServers = parentResult.getElementsByTagName("virtual-server");
        Element resultVirtualServer = null;
        String serverID = "server1";
        if (commonInfoModel.getSourceVersion().equals("7x")) {
            serverID = element.getOwnerDocument().getDocumentElement().getAttribute("name");
        }
        for (int lh = 0; lh < resultVirtualServers.getLength(); ++lh) {
            if (element.getAttribute("id").equals(serverID) && ((Element)resultVirtualServers.item(lh)).getAttribute("id").equals("server")) {
                resultVirtualServer = (Element)resultVirtualServers.item(lh);
                Vector<String> notToTransferAttrList = new Vector<String>();
                notToTransferAttrList.add("id");
                notToTransferAttrList.add("http-listeners");
                notToTransferAttrList.add("config-file");
                this.transferAttributes(element, resultVirtualServer, notToTransferAttrList);
                break;
            }
            if (!element.getAttribute("id").equals(((Element)resultVirtualServers.item(lh)).getAttribute("id"))) continue;
            resultVirtualServer = (Element)resultVirtualServers.item(lh);
            Vector<String> notToTransferAttrList = new Vector<String>();
            notToTransferAttrList.add("default-web-module");
            if (commonInfoModel.getSourceVersion().equals("7x")) {
                notToTransferAttrList.add("http-listeners");
                notToTransferAttrList.add("config-file");
            }
            this.transferAttributes(element, resultVirtualServer, notToTransferAttrList);
            break;
        }
        if (resultVirtualServer == null) {
            resultVirtualServer = parentResult.getOwnerDocument().createElement("virtual-server");
            this.transferAttributes(element, resultVirtualServer, null);
            this.appendElementToParent(parentResult, resultVirtualServer);
        }
        super.transform(element, parentSource, resultVirtualServer);
    }

    private void printAttrs(Element ele) {
        log.info(" ____________ print virtual-server attributes");
        NamedNodeMap sourceAttrNodeMap = ele.getAttributes();
        for (int index = 0; index < sourceAttrNodeMap.getLength(); ++index) {
            Node sourceAttrNode = sourceAttrNodeMap.item(index);
            log.info("\n attr name=" + sourceAttrNode.getNodeName() + " attrValue=" + sourceAttrNode.getNodeValue());
        }
    }
}

