/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;

public class Header
extends Canvas {
    private String headerText = null;

    public Header() {
        this("");
    }

    public Header(String s) {
        this.headerText = s;
        this.setForeground(Color.black);
        try {
            this.setFont(new Font("SansSerif", 0, 12));
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, 22);
    }

    public String getText() {
        return this.headerText;
    }

    public void paint(Graphics g) {
        Dimension dimension = this.getSize();
        g.setClip(0, 0, dimension.width, dimension.height);
        FontMetrics fontmetrics = null;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, dimension.width + 1, dimension.height + 1);
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        fontmetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int i = (dimension.height - (fontmetrics.getMaxAscent() + fontmetrics.getMaxDescent())) / 2 + fontmetrics.getMaxAscent();
        g.drawString(this.headerText, fontmetrics.stringWidth(""), i);
        int j = dimension.height - fontmetrics.getMaxDescent() / 2;
        g.drawLine(0, j, dimension.width, j);
    }

    public void setText(String s) {
        this.headerText = s;
        this.repaint();
    }
}

