/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.deployment;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.JarArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.tools.upgrade.common.BaseModule;
import com.sun.enterprise.tools.upgrade.common.Commands;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.DomainsProcessor;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.DefaultHandler;

public class DeploymentUpgrade
implements BaseModule {
    private static String EAR_DIR = "j2ee-apps";
    private static String MODULE_DIR = "j2ee-modules";
    private static String SOURCE_LIBRARY_DIR = "lib";
    private static String TARGET_LIBRARY_DIR = "lib";
    private static String MEJB_APP = "MEjbApp";
    private static String TIMER_APP = "__ejb_container_timer";
    private static String JWS_APP = "__JWSappclients";
    private static Hashtable deployedModules = new Hashtable();
    File sourceDir;
    String targetDir;
    boolean success = true;
    boolean domainRunning = false;
    CommonInfoModel commonInfo;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.deployment");
    private Logger logger = CommonInfoModel.getDefaultLogger();

    public boolean upgrade(CommonInfoModel commonInfo) {
        File srcEarDir;
        this.commonInfo = commonInfo;
        String currentDomain = commonInfo.getCurrentDomain();
        String sourceDomainPath = commonInfo.getSourceDomainPath();
        String targetDomainPath = commonInfo.getDestinationDomainPath();
        UpgradeUtils upgrUtils = UpgradeUtils.getUpgradeUtils(commonInfo);
        DomainInfo dInfo = new DomainInfo(currentDomain, sourceDomainPath);
        String applicationRoot = dInfo.getDomainApplicationRoot(upgrUtils);
        if (deployedModules.get(currentDomain) == null) {
            deployedModules.put(currentDomain, new ArrayList());
        }
        this.logger.log(Level.INFO, this.stringManager.getString("upgrade.deployment.startMessage"));
        this.domainRunning = false;
        this.processLibraries(sourceDomainPath, targetDomainPath);
        this.sourceDir = new File(sourceDomainPath, applicationRoot);
        try {
            File tmp = File.createTempFile("upgrade", null);
            this.targetDir = tmp.getParent();
            tmp.delete();
        }
        catch (IOException ioe) {
            this.logger.severe(this.stringManager.getString("upgrade.deployment.ioExceptionMsg") + ioe.getMessage());
            return false;
        }
        this.processLifecycles();
        File srcJarDir = new File(this.sourceDir, MODULE_DIR);
        if (srcJarDir != null && srcJarDir.listFiles() != null && srcJarDir.listFiles().length > 0) {
            if (!this.domainRunning) {
                this.domainRunning = this.startDomain(commonInfo.getCurrentDomain());
            }
            if (this.domainRunning) {
                this.processStandaloneModules(srcJarDir);
            } else {
                return false;
            }
        }
        if ((srcEarDir = new File(this.sourceDir, EAR_DIR)) != null && srcEarDir.listFiles() != null && srcEarDir.listFiles().length > 0) {
            this.domainRunning = this.startDomain(currentDomain);
            if (this.domainRunning) {
                this.processApplications(srcEarDir);
            } else {
                return false;
            }
        }
        if (this.domainRunning) {
            this.stopDomain(commonInfo.getCurrentDomain());
        }
        return this.success;
    }

    public void recovery(CommonInfoModel commonInfo) {
        commonInfo.deletePasswordFile();
    }

    private void processApplications(File srcDir) {
        UpgradeUtils upgradeUtils = UpgradeUtils.getUpgradeUtils(this.commonInfo);
        File[] earDirs = srcDir.listFiles();
        for (int i = 0; i < earDirs.length; ++i) {
            String earDirName = earDirs[i].getName();
            String earName = earDirName.lastIndexOf("_ear") > -1 ? earDirName.substring(0, earDirName.lastIndexOf("_ear")) : earDirName;
            String appName = earName;
            if (appName.startsWith(MEJB_APP) || appName.startsWith(TIMER_APP) || appName.startsWith(JWS_APP)) continue;
            earName = earName + ".ear";
            try {
                JarArchiveFactory jaf = new JarArchiveFactory();
                OutputJarArchive targetJar = (OutputJarArchive)jaf.createArchive(new File(this.targetDir, earName).getAbsolutePath());
                FileArchiveFactory faf = new FileArchiveFactory();
                FileArchive farc = (FileArchive)faf.openArchive(new File(srcDir, earDirName).getAbsolutePath());
                Enumeration e = farc.entries();
                String lastModuleProcessed = "";
                while (e.hasMoreElements()) {
                    String moduleDir;
                    String s = (String)e.nextElement();
                    try {
                        moduleDir = s.substring(0, s.lastIndexOf(95) + 4);
                    }
                    catch (StringIndexOutOfBoundsException sob) {
                        moduleDir = "";
                    }
                    FileInputStream fis = null;
                    OutputStream out = null;
                    try {
                        if (moduleDir.endsWith("_jar") || moduleDir.endsWith("_war") || moduleDir.endsWith("_rar")) {
                            if (lastModuleProcessed.equals(moduleDir)) continue;
                            File jar = this.processModule(EAR_DIR, earDirName, moduleDir);
                            lastModuleProcessed = moduleDir;
                            out = targetJar.putNextEntry(jar.getName());
                            fis = new FileInputStream(jar);
                        } else {
                            if (s.endsWith("Client.jar")) continue;
                            out = targetJar.putNextEntry(s);
                            fis = new FileInputStream(new File(new File(srcDir, earDirName), s));
                        }
                        while (fis.available() > 0) {
                            int ix = fis.read();
                            out.write(ix);
                        }
                    }
                    catch (ZipException z) {
                        this.logger.warning(this.stringManager.getString("upgrade.deployment.zipExceptionMsg") + z.getMessage());
                    }
                    catch (IOException ioe) {
                        this.logger.severe(this.stringManager.getString("upgrade.deployment.ioExceptionMsg") + ioe.getMessage());
                    }
                    targetJar.closeEntry();
                }
                targetJar.close();
                String jarPath = new File(targetJar.getArchiveUri()).getAbsolutePath();
                String fileName = new File(jarPath).getName();
                String moduleName = fileName.substring(0, fileName.lastIndexOf(46));
                ArrayList parameters = upgradeUtils.buildAppDeploymentParameters(moduleName);
                String j2eeAppTarget = upgradeUtils.buildAppDeploymentTarget(moduleName);
                if (j2eeAppTarget != null) {
                    parameters.add("--target");
                    parameters.add(j2eeAppTarget);
                }
                if (this.deploy(jarPath, parameters)) {
                    this.logger.info(this.stringManager.getString("upgrade.deployment.finishedProcessingMsg") + appName);
                    continue;
                }
                this.logger.warning(appName + " " + this.stringManager.getString("upgrade.deployment.errorProcessingMsg"));
                continue;
            }
            catch (Exception ex) {
                this.logger.severe(this.stringManager.getString("upgrade.deployment.generalExceptionMsg") + ex.toString() + ": " + ex.getMessage());
            }
        }
    }

    private HashMap getAllWebModuleContextRoot() {
        HashMap<String, String> contextRootsMap = new HashMap<String, String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (this.commonInfo.getSourceDomainRootFlag()) {
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document sourceDoc = builder.parse(new File(this.commonInfo.getSourceConfigXMLFile()));
            NodeList nl = sourceDoc.getElementsByTagName("web-module");
            if (nl != null) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node = nl.item(i);
                    NamedNodeMap map = node.getAttributes();
                    String contextRoot = map.getNamedItem("context-root").getNodeValue();
                    String appName = map.getNamedItem("name").getNodeValue();
                    contextRootsMap.put(appName, contextRoot);
                }
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.deployment.generalExceptionMsg") + ex.toString());
        }
        return contextRootsMap;
    }

    private void processStandaloneModules(File srcModuleDir) {
        UpgradeUtils upgradeUtils = UpgradeUtils.getUpgradeUtils(this.commonInfo);
        HashMap webModuleContextRootMap = this.getAllWebModuleContextRoot();
        File[] moduleDirs = srcModuleDir.listFiles();
        for (int i = 0; i < moduleDirs.length; ++i) {
            String moduleDirName = moduleDirs[i].getName();
            File jarFile = this.processModule(MODULE_DIR, "", moduleDirName);
            String moduleName = moduleDirName;
            moduleName = moduleDirName.endsWith("_jar") || moduleDirName.endsWith("_war") || moduleDirName.endsWith("_rar") ? moduleDirName.substring(0, moduleDirName.lastIndexOf(95)) : moduleDirName;
            String jarPath = jarFile.getAbsolutePath();
            String fileName = new File(jarPath).getName();
            String modName = fileName.substring(0, fileName.lastIndexOf(46));
            ArrayList<String> parameters = upgradeUtils.buildAppDeploymentParameters(modName);
            String contextRoot = moduleDirName;
            if (jarFile.getName().toLowerCase().endsWith(".war")) {
                contextRoot = upgradeUtils.buildWebModuleContextRoot(moduleDirName);
            }
            if (parameters == null) {
                parameters = new ArrayList<String>(2);
                parameters.add("--contextroot");
                parameters.add(contextRoot);
            } else {
                parameters.add("--contextroot");
                parameters.add(contextRoot);
            }
            String webModuleTarget = upgradeUtils.buildAppDeploymentTarget(moduleName);
            if (webModuleTarget != null) {
                parameters.add("--target");
                parameters.add(webModuleTarget);
            }
            if (this.deploy(jarFile.getAbsolutePath(), parameters)) {
                this.logger.info(this.stringManager.getString("upgrade.deployment.finishedProcessingMsg") + moduleName);
                continue;
            }
            this.logger.warning(moduleName + " " + this.stringManager.getString("upgrade.deployment.errorProcessingMsg"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File processModule(String appDir, String earDirName, String moduleDirName) {
        String moduleName = moduleDirName;
        if (moduleDirName.endsWith("_jar") || moduleDirName.endsWith("_war") || moduleDirName.endsWith("_rar")) {
            moduleName = moduleDirName.substring(0, moduleDirName.lastIndexOf(95));
        }
        try {
            JarArchiveFactory jaf = new JarArchiveFactory();
            FileArchiveFactory faf = new FileArchiveFactory();
            FileArchive farc = (FileArchive)faf.openArchive(new File(new File(new File(this.sourceDir, appDir), earDirName), moduleDirName).getAbsolutePath());
            String suffix = ".jar";
            Enumeration e = farc.entries();
            while (e.hasMoreElements()) {
                String entry = (String)e.nextElement();
                if (entry.equalsIgnoreCase("WEB-INF/web.xml")) {
                    suffix = ".war";
                    continue;
                }
                if (!entry.equalsIgnoreCase("META-INF/ra.xml")) continue;
                suffix = ".rar";
            }
            File tempJar = new File(this.targetDir, moduleName + suffix);
            String path = tempJar.getAbsolutePath();
            OutputJarArchive targetModule = (OutputJarArchive)jaf.createArchive(path);
            this.logger.fine(this.stringManager.getString("upgrade.deployment.addingInfoMsg") + targetModule.getArchiveUri());
            e = farc.entries();
            while (e.hasMoreElements()) {
                InputStream fixedDescriptor;
                String entry = (String)e.nextElement();
                InputStream in = farc.getEntry(entry);
                if (entry.equals("WEB-INF/web.xml") && (fixedDescriptor = this.fixWebServiceDescriptor(farc)) != null) {
                    in = fixedDescriptor;
                }
                if (entry.equals("WEB-INF/sun-web.xml")) {
                    this.checkDescriptors(farc, "sun-web.xml", "WEB-INF");
                }
                if (entry.equals("META-INF/sun-ejb-jar.xml")) {
                    this.checkDescriptors(farc, "sun-ejb-jar.xml", "META-INF");
                }
                OutputStream out = null;
                try {
                    out = targetModule.putNextEntry(entry);
                    int i = in.read();
                    while (i > -1) {
                        out.write(i);
                        i = in.read();
                    }
                }
                catch (ZipException z) {
                    this.logger.warning(this.stringManager.getString("upgrade.deployment.zipExceptionMsg") + z.getMessage());
                }
                catch (IOException ioe) {
                    this.logger.severe(this.stringManager.getString("upgrade.deployment.ioExceptionMsg") + ioe.getMessage());
                }
                finally {
                    targetModule.closeEntry();
                    if (in == null) continue;
                    in.close();
                }
            }
            InputStream in = farc.getEntry("META-INF/MANIFEST.MF");
            OutputStream out = null;
            try {
                if (in != null) {
                    out = targetModule.putNextEntry("META-INF/MANIFEST.MF");
                    int i = in.read();
                    while (i > -1) {
                        out.write(i);
                        i = in.read();
                    }
                }
            }
            catch (ZipException z) {
                this.logger.warning(this.stringManager.getString("upgrade.deployment.zipExceptionMsg") + z.getMessage());
            }
            catch (IOException ioe) {
                this.logger.severe(this.stringManager.getString("upgrade.deployment.ioExceptionMsg") + ioe.getMessage());
            }
            finally {
                targetModule.closeEntry();
                targetModule.close();
                if (in != null) {
                    in.close();
                }
            }
            return tempJar;
        }
        catch (IOException ex) {
            this.logger.severe(this.stringManager.getString("upgrade.deployment.generalExceptionMsg") + ex.toString() + ": " + ex.getMessage());
            return null;
        }
    }

    private void processLifecycles() {
        String sourceConfigXMLFile = this.commonInfo.getSourceConfigXMLFile();
        String targetConfigXMLFile = this.commonInfo.getTargetConfigXMLFile();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (this.commonInfo.getSourceDomainRootFlag()) {
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document sourceDoc = builder.parse(new File(sourceConfigXMLFile));
            Document targetDoc = builder.parse(new File(targetConfigXMLFile));
            NodeList nl = sourceDoc.getElementsByTagName("lifecycle-module");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                Node newNode = targetDoc.importNode(node, true);
                NamedNodeMap attributes = newNode.getAttributes();
                String lcname = attributes.getNamedItem("name").getNodeValue();
                Node classpathNode = attributes.getNamedItem("classpath");
                try {
                    String classpath = null;
                    if (classpathNode != null) {
                        File testPath;
                        classpath = classpathNode.getNodeValue();
                        if (classpath.startsWith("${com.sun.aas.installRoot}")) {
                            String tmpC;
                            String tmpVar = "\\$\\{com.sun.aas.installRoot}";
                            classpath = tmpC = classpath.replaceAll(tmpVar, this.commonInfo.getTargetInstallDir());
                        }
                        if (!(testPath = new File(classpath)).exists()) {
                            this.logger.warning(this.stringManager.getString("upgrade.deployment.lifecycleErrorMsg") + lcname);
                            this.logger.warning(this.stringManager.getString("upgrade.deployment.lifecycleClasspathMsg", (Object)(classpath + "  " + lcname)));
                            continue;
                        }
                    }
                    NodeList appNodeList = targetDoc.getElementsByTagName("applications");
                    Node applicationsNode = appNodeList.item(0);
                    NodeList applicationsList = applicationsNode.getChildNodes();
                    boolean foundDup = false;
                    for (int n = 0; n < applicationsList.getLength(); ++n) {
                        Node appNode = applicationsList.item(n);
                        if (!appNode.getNodeName().equals(newNode.getNodeName())) continue;
                        NamedNodeMap appNodeAttrs = appNode.getAttributes();
                        NamedNodeMap newNodeAttrs = newNode.getAttributes();
                        Node appNodeName = appNodeAttrs.getNamedItem("name");
                        Node newNodeName = appNodeAttrs.getNamedItem("name");
                        String newNodeNameString = newNodeName.getNodeValue();
                        if (!newNodeNameString.equals(appNodeName.getNodeValue())) continue;
                        this.logger.warning(this.stringManager.getString("upgrade.deployment.lifecycleExistsMsg", (Object)newNodeNameString));
                        foundDup = true;
                        break;
                    }
                    if (foundDup) continue;
                    applicationsNode.appendChild(newNode);
                    continue;
                }
                catch (SecurityException se) {
                    this.logger.warning(this.stringManager.getString("upgrade.deployment.lifecycleClasspathMsg", (Object)node.getNodeName()) + "\n" + se.getMessage());
                }
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (targetDoc.getDoctype() != null) {
                String systemValue = targetDoc.getDoctype().getSystemId();
                transformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = targetDoc.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", pubValue);
            }
            DOMSource source = new DOMSource(targetDoc);
            StreamResult result = new StreamResult(new FileOutputStream(targetConfigXMLFile));
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.deployment.generalExceptionMsg") + ex.toString());
        }
    }

    private void processLibraries(String sourceDomainPath, String targetDomainPath) {
        File sourceDir = new File(sourceDomainPath, SOURCE_LIBRARY_DIR);
        File targetDir = new File(targetDomainPath, TARGET_LIBRARY_DIR);
        try {
            this.copyDir(sourceDir, targetDir);
        }
        catch (FileNotFoundException fnf) {
            this.logger.severe(this.stringManager.getString("upgrade.deployment.generalExceptionMsg") + fnf.toString() + ": " + fnf.getMessage());
        }
        catch (IOException ioe) {
            this.logger.severe(this.stringManager.getString("upgrade.deployment.ioExceptionMsg") + ioe.getMessage());
        }
    }

    private void copyDir(File inputDir, File outputDir) throws FileNotFoundException, IOException {
        UpgradeUtils.copyDirectory(inputDir, outputDir);
    }

    private boolean deploy(String modulePath, ArrayList parameters) {
        if (this.commonInfo.isEnterpriseEdition(this.commonInfo.getSourceEdition())) {
            String fileName;
            String moduleName;
            ArrayList mods = (ArrayList)deployedModules.get(this.commonInfo.getCurrentDomain());
            if (mods.contains(moduleName = (fileName = new File(modulePath).getName()).substring(0, fileName.lastIndexOf(46)))) {
                String currentDomain = this.commonInfo.getCurrentDomain();
                String adminPort = DomainsProcessor.getTargetDomainPort(currentDomain, this.commonInfo);
                String adminSecurity = DomainsProcessor.getTargetDomainSecurity(currentDomain, this.commonInfo);
                String[] createAppRefCommand = new String[]{"create-application-ref", "--user", this.commonInfo.getAdminUserName(), "--passwordfile ", "\"" + this.commonInfo.getPasswordFile() + "\"", "--port", adminPort, "--secure=" + adminSecurity, "--target", this.commonInfo.getCurrentSourceInstance(), moduleName};
                try {
                    return Commands.executeCommand(createAppRefCommand);
                }
                catch (CommandException ce) {
                    this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.deployment.generalExceptionMsg") + ce.toString());
                    return false;
                }
            }
            if (Commands.deploy(modulePath, this.commonInfo, parameters)) {
                mods.add(moduleName);
                return true;
            }
            return false;
        }
        return Commands.deploy(modulePath, this.commonInfo, parameters);
    }

    private boolean startDomain(String domainName) {
        return Commands.startDomain(domainName, this.commonInfo);
    }

    private boolean stopDomain(String domainName) {
        return Commands.stopDomain(domainName, this.commonInfo);
    }

    public String getName() {
        return this.stringManager.getString("upgrade.deployment.moduleName");
    }

    private void checkDescriptors(FileArchive farc, String fileName, String dirName) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setEntityResolver((EntityResolver)new SaxParserHandler());
            String dirPath = farc.getArchiveUri();
            Document document = docBuilder.parse(dirPath + File.separatorChar + dirName + File.separatorChar + fileName);
            Element docEle = document.getDocumentElement();
            NodeList securityBindingList = docEle.getElementsByTagName("message-security-binding");
            for (int i = 0; i < securityBindingList.getLength(); ++i) {
                Element element = (Element)securityBindingList.item(i);
                if (element == null || element.getAttribute("provider-id") == null) continue;
                if (element.getAttribute("provider-id").equals("ClientProvider")) {
                    this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.deployment.messageSecurityConfig", (Object)fileName, (Object)"ClientProvider"));
                    continue;
                }
                if (!element.getAttribute("provider-id").equals("ServerProvider")) continue;
                this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.deployment.messageSecurityConfig", (Object)fileName, (Object)"ServerProvider"));
            }
        }
        catch (IOException ioe) {
            this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.deployment.ioExceptionMsg") + ioe.getLocalizedMessage());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.deployment.generalExceptionMsg") + e.getLocalizedMessage());
        }
    }

    private InputStream fixWebServiceDescriptor(FileArchive farc) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setEntityResolver((EntityResolver)new SaxParserHandler());
            String dirPath = farc.getArchiveUri();
            Document document = docBuilder.parse(dirPath + File.separatorChar + "WEB-INF" + File.separatorChar + "web.xml");
            Element docEle = document.getDocumentElement();
            NodeList servletList = docEle.getElementsByTagName("servlet");
            for (int i = 0; i < servletList.getLength(); ++i) {
                Node currentServletNode = servletList.item(i);
                NodeList nodeList = ((Element)currentServletNode).getElementsByTagName("servlet-name");
                String servletName = this.getTextNodeData(nodeList.item(0));
                nodeList = ((Element)currentServletNode).getElementsByTagName("servlet-class");
                Node servletClassNode = nodeList.item(0);
                if (servletClassNode == null) {
                    return null;
                }
                String servletClass = this.getTextNodeData(servletClassNode);
                if (!servletClass.equals("com.sun.enterprise.webservice.JAXRPCServlet")) continue;
                Document sunWebXml = docBuilder.parse(dirPath + File.separatorChar + "WEB-INF" + File.separatorChar + "sun-web.xml");
                Element de = sunWebXml.getDocumentElement();
                NodeList sunServletList = de.getElementsByTagName("servlet");
                for (int x = 0; x < sunServletList.getLength(); ++x) {
                    Node sunServletNode = sunServletList.item(x);
                    NodeList list = ((Element)sunServletNode).getElementsByTagName("servlet-name");
                    String sunServletName = this.getTextNodeData(list.item(0));
                    if (!sunServletName.equals(servletName)) continue;
                    NodeList nList = ((Element)sunServletNode).getElementsByTagName("servlet-impl-class");
                    Node servletImplNode = nList.item(0);
                    String origServletClass = this.getTextNodeData(servletImplNode);
                    this.setTextNodeData(servletClassNode, origServletClass);
                }
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (document.getDoctype() != null) {
                String systemValue = document.getDoctype().getSystemId();
                transformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = document.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", pubValue);
            }
            DOMSource source = new DOMSource(document);
            File webTempFile = File.createTempFile("web", "xml");
            StreamResult result = new StreamResult(new FileOutputStream(webTempFile));
            transformer.transform(source, result);
            return new FileInputStream(webTempFile);
        }
        catch (IOException ioe) {
            this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.deployment.ioExceptionMsg") + ioe.getLocalizedMessage());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.deployment.generalExceptionMsg") + e.getLocalizedMessage());
        }
        return farc.getEntry("WEB-INF/web.xml");
    }

    private String getTextNodeData(Node node) {
        NodeList children = ((Element)node).getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (children.item(index).getNodeType() != 3) continue;
            return children.item(index).getNodeValue();
        }
        return "";
    }

    private void setTextNodeData(Node node, String text) {
        NodeList children = ((Element)node).getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (children.item(index).getNodeType() != 3) continue;
            children.item(index).setNodeValue(text);
        }
    }
}

