/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.jxta.util.SimpleSelectable;
import net.jxta.util.SimpleSelector;

public abstract class AbstractSimpleSelectable
implements SimpleSelectable {
    public final SimpleSelectable.IdentityReference identityReference = new SimpleSelectable.IdentityReference(this);
    private final SimpleSelectable srcObject;
    private final Map<SimpleSelectable, Object> myListeners = Collections.synchronizedMap(new WeakHashMap(2));

    public AbstractSimpleSelectable() {
        this.srcObject = this;
    }

    public AbstractSimpleSelectable(SimpleSelectable srcObject) {
        this.srcObject = srcObject;
    }

    public SimpleSelectable.IdentityReference getIdentityReference() {
        return this.identityReference;
    }

    protected boolean haveListeners() {
        return !this.myListeners.isEmpty();
    }

    protected void registerListener(SimpleSelectable selectable) {
        this.myListeners.put(selectable, null);
    }

    protected void unregisterListener(SimpleSelectable selectable) {
        this.myListeners.remove(selectable);
    }

    public void register(SimpleSelector simpleSelector) {
        this.registerListener(simpleSelector);
        simpleSelector.itemChanged(this);
    }

    public void unregister(SimpleSelector simpleSelector) {
        this.unregisterListener(simpleSelector);
    }

    protected final boolean notifyChange() {
        ArrayList<SimpleSelectable> listeners = new ArrayList<SimpleSelectable>(this.myListeners.keySet());
        for (SimpleSelectable listener : listeners) {
            listener.itemChanged(this.srcObject);
        }
        return !listeners.isEmpty();
    }
}

