/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.PipeAdvertisement;

public abstract class ModuleSpecAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    private ModuleSpecID id = null;
    private String name = null;
    private Element description = null;
    private String creator = null;
    private String uri = null;
    private String version = null;
    private PipeAdvertisement pipeAdv = null;
    private ModuleSpecID proxySpecID = null;
    private ModuleSpecID authSpecID = null;
    private StructuredDocument param = null;

    public static String getAdvertisementType() {
        return "jxta:MSA";
    }

    public final String getBaseAdvType() {
        return ModuleSpecAdvertisement.getAdvertisementType();
    }

    public ModuleSpecAdvertisement clone() {
        try {
            ModuleSpecAdvertisement clone = (ModuleSpecAdvertisement)super.clone();
            clone.setModuleSpecID(this.getModuleSpecID());
            clone.setName(this.getName());
            clone.setDesc(this.getDesc());
            clone.setCreator(this.getCreator());
            clone.setSpecURI(this.getSpecURI());
            clone.setVersion(this.getVersion());
            clone.setPipeAdvertisement(this.getPipeAdvertisement());
            clone.setProxySpecID(this.getProxySpecID());
            clone.setAuthSpecID(this.getAuthSpecID());
            clone.setParam(this.param);
            return clone;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    public ID getID() {
        return this.id;
    }

    public ModuleSpecID getModuleSpecID() {
        return this.id;
    }

    public void setModuleSpecID(ModuleSpecID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        if (null != this.description) {
            return (String)this.description.getValue();
        }
        return null;
    }

    public void setDescription(String description) {
        if (null != description) {
            StructuredDocument newdoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Desc", description);
            this.setDesc(newdoc);
        } else {
            this.description = null;
        }
    }

    public StructuredDocument getDesc() {
        if (null != this.description) {
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(this.description);
            return newDoc;
        }
        return null;
    }

    public void setDesc(Element desc) {
        this.description = null != desc ? StructuredDocumentUtils.copyAsDocument(desc) : null;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getSpecURI() {
        return this.uri;
    }

    public void setSpecURI(String uri) {
        this.uri = uri;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public StructuredDocument getParam() {
        return this.param == null ? null : StructuredDocumentUtils.copyAsDocument(this.param);
    }

    protected StructuredDocument getParamPriv() {
        return this.param;
    }

    public void setParam(Element param) {
        this.param = param == null ? null : StructuredDocumentUtils.copyAsDocument(param);
    }

    public PipeAdvertisement getPipeAdvertisement() {
        return this.pipeAdv == null ? null : this.pipeAdv.clone();
    }

    public void setPipeAdvertisement(PipeAdvertisement pipeAdv) {
        this.pipeAdv = pipeAdv == null ? null : pipeAdv.clone();
    }

    public ModuleSpecID getProxySpecID() {
        return this.proxySpecID;
    }

    public void setProxySpecID(ModuleSpecID proxySpecID) {
        this.proxySpecID = proxySpecID;
    }

    public ModuleSpecID getAuthSpecID() {
        return this.authSpecID;
    }

    public void setAuthSpecID(ModuleSpecID authSpecID) {
        this.authSpecID = authSpecID;
    }
}

