/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.impl.access.AccessList;
import net.jxta.impl.endpoint.EndpointUtils;
import net.jxta.impl.util.SeedingManager;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

public abstract class ACLSeedingManager
implements SeedingManager {
    private static final transient Logger LOG = Logger.getLogger(ACLSeedingManager.class.getName());
    private static final long ACL_REFRESH_INTERVAL = 1800000L;
    private final URI aclLocation;
    private long aclLastModified = 0L;
    protected final AccessList acl = new AccessList();
    private long nextACLrefreshTime = 0L;

    public ACLSeedingManager(URI aclLocation) {
        this.aclLocation = aclLocation;
        this.acl.setGrantAll(true);
        if (null == aclLocation) {
            this.nextACLrefreshTime = Long.MAX_VALUE;
        }
    }

    public boolean isAcceptablePeer(PeerAdvertisement peeradv) {
        RouteAdvertisement route = EndpointUtils.extractRouteAdv(peeradv);
        if (null != route) {
            return this.isAcceptablePeer(route);
        }
        return this.acl.getGrantAll();
    }

    public synchronized boolean isAcceptablePeer(RouteAdvertisement radv) {
        if (TimeUtils.timeNow() > this.nextACLrefreshTime) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Updating ACL");
            }
            try {
                URL asURL = this.aclLocation.toURL();
                URLConnection connection = asURL.openConnection();
                connection.setDoInput(true);
                InputStream is = connection.getInputStream();
                long last_mod = connection.getLastModified();
                if (last_mod == 0L || last_mod > this.aclLastModified) {
                    this.acl.setGrantAll(false);
                    this.acl.refresh(is);
                }
                this.nextACLrefreshTime = TimeUtils.toAbsoluteTimeMillis(1800000L);
            }
            catch (IOException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "ACL update failed. GRANTING ALL PERMISSIONS.", failed);
                }
                this.acl.setGrantAll(true);
                this.nextACLrefreshTime = TimeUtils.toAbsoluteTimeMillis(900000L);
            }
        }
        return this.acl.isAllowed(radv.getDestPeerID());
    }
}

