/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.router.RouteControl;
import net.jxta.impl.meter.MonitorManager;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.protocol.ResolverSrdiMsgImpl;
import net.jxta.impl.resolver.InternalQueryHandler;
import net.jxta.impl.resolver.ResolverServiceInterface;
import net.jxta.impl.resolver.resolverMeter.QueryHandlerMeter;
import net.jxta.impl.resolver.resolverMeter.ResolverMeter;
import net.jxta.impl.resolver.resolverMeter.ResolverMeterBuildSettings;
import net.jxta.impl.resolver.resolverMeter.ResolverServiceMonitor;
import net.jxta.impl.resolver.resolverMeter.SrdiHandlerMeter;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.meter.MonitorResources;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.ResolverSrdiMsg;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezVousStatus;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.resolver.SrdiHandler;

public class ResolverServiceImpl
implements ResolverService {
    private static final transient Logger LOG = Logger.getLogger(ResolverServiceImpl.class.getName());
    public static final String outQueNameShort = "ORes";
    public static final String inQueNameShort = "IRes";
    public static final String srdiQueNameShort = "Srdi";
    private static final MimeMediaType GZIP_MEDIA_TYPE = new MimeMediaType("application/gzip").intern();
    private String outQueName = "ORes";
    private String inQueName = "IRes";
    private String srdiQueName = "Srdi";
    private String handlerName = null;
    private PeerGroup group = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private EndpointService endpoint = null;
    private MembershipService membership = null;
    private RouteControl routeControl = null;
    private final Map<String, QueryHandler> handlers = Collections.synchronizedMap(new HashMap(5));
    private final Map<String, SrdiHandler> srdiHandlers = Collections.synchronizedMap(new HashMap(5));
    private EndpointListener queryListener = null;
    private EndpointListener responseListener = null;
    private EndpointListener srdiListener = null;
    private ResolverServiceMonitor resolverServiceMonitor;
    private ResolverMeter resolverMeter;
    private ResolverService resolverInterface = null;
    CurrentCredential currentCredential;
    final CredentialListener membershipCredListener = new CredentialListener();

    private static EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        return new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl) {
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.group = group;
        this.handlerName = assignedID.toString();
        String uniqueStr = group.getPeerGroupID().getUniqueValue().toString();
        this.outQueName = uniqueStr + outQueNameShort;
        this.inQueName = uniqueStr + inQueNameShort;
        this.srdiQueName = uniqueStr + srdiQueNameShort;
        if (ResolverMeterBuildSettings.RESOLVER_METERING) {
            this.resolverServiceMonitor = (ResolverServiceMonitor)MonitorManager.getServiceMonitor(group, MonitorResources.resolverServiceMonitorClassID);
            if (this.resolverServiceMonitor != null) {
                this.resolverMeter = this.resolverServiceMonitor.getResolverMeter();
            }
        }
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Resolver Service : " + assignedID);
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(group);
            configInfo.append("\n\t\tPeer ID : ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration:");
            configInfo.append("\n\t\tIn Queue name: ").append(this.outQueName);
            configInfo.append("\n\t\tOut Queue name: ").append(this.inQueName);
            configInfo.append("\n\t\tSRDI Queue name: ").append(this.srdiQueName);
            LOG.config(configInfo.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startApp(String[] arg) {
        this.endpoint = this.group.getEndpointService();
        if (null == this.endpoint) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is an endpoint service");
            }
            return 2;
        }
        this.membership = this.group.getMembershipService();
        if (null == this.membership) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a membership service");
            }
            return 2;
        }
        try {
            this.queryListener = new DemuxQuery();
            if (!this.endpoint.addIncomingMessageListener(this.queryListener, this.handlerName, this.outQueName) && Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Cannot register listener (already registered)");
            }
            this.responseListener = new DemuxResponse();
            if (!this.endpoint.addIncomingMessageListener(this.responseListener, this.handlerName, this.inQueName) && Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Cannot register listener (already registered)");
            }
            this.srdiListener = new DemuxSrdi();
            if (!this.endpoint.addIncomingMessageListener(this.srdiListener, this.handlerName, this.srdiQueName) && Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Cannot register listener (already registered)");
            }
        }
        catch (Exception e) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "failed to add listeners", e);
            }
            return -1;
        }
        ResolverServiceImpl resolverServiceImpl = this;
        synchronized (resolverServiceImpl) {
            block16: {
                this.membership.addPropertyChangeListener("defaultCredential", this.membershipCredListener);
                try {
                    this.currentCredential = null;
                    Credential credential = this.membership.getDefaultCredential();
                    if (null != credential) {
                        XMLDocument credentialDoc = (XMLDocument)credential.getDocument(MimeMediaType.XMLUTF8);
                        this.currentCredential = new CurrentCredential(credential, credentialDoc);
                    }
                }
                catch (Exception all) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block16;
                    LOG.log(Level.WARNING, "could not get default credential", all);
                }
            }
        }
        return 0;
    }

    public void stopApp() {
        this.endpoint.removeIncomingMessageListener(this.handlerName, this.outQueName);
        this.endpoint.removeIncomingMessageListener(this.handlerName, this.inQueName);
        if (null != this.srdiListener) {
            this.endpoint.removeIncomingMessageListener(this.handlerName, this.srdiQueName);
        }
        this.queryListener = null;
        this.responseListener = null;
        this.srdiListener = null;
        this.membership.removePropertyChangeListener("defaultCredential", this.membershipCredListener);
        this.currentCredential = null;
        this.routeControl = null;
        this.membership = null;
        this.group = null;
    }

    public synchronized ResolverService getInterface() {
        if (this.resolverInterface == null) {
            this.resolverInterface = new ResolverServiceInterface(this);
        }
        return this.resolverInterface;
    }

    public ModuleImplAdvertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public QueryHandler registerHandler(String name, QueryHandler handler) {
        if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
            this.resolverServiceMonitor.registerQueryHandlerMeter(name);
        }
        return this.handlers.put(name, handler);
    }

    public QueryHandler unregisterHandler(String name) {
        if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
            this.resolverServiceMonitor.unregisterQueryHandlerMeter(name);
        }
        return this.handlers.remove(name);
    }

    public QueryHandler getHandler(String name) {
        return this.handlers.get(name);
    }

    public SrdiHandler registerSrdiHandler(String name, SrdiHandler handler) {
        if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
            this.resolverServiceMonitor.registerSrdiHandlerMeter(name);
        }
        return this.srdiHandlers.put(name, handler);
    }

    public SrdiHandler unregisterSrdiHandler(String name) {
        if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
            this.resolverServiceMonitor.unregisterSrdiHandlerMeter(name);
        }
        return this.srdiHandlers.remove(name);
    }

    public SrdiHandler getSrdiHandler(String name) {
        return this.srdiHandlers.get(name);
    }

    public void sendQuery(String destPeer, ResolverQueryMsg query) {
        block20: {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("sending query to resolver handler: " + query.getHandlerName());
            }
            if (query.getSrcPeerRoute() == null) {
                if (this.getRouteControl() != null) {
                    RouteAdvertisement route = this.routeControl.getMyLocalRoute();
                    if (route != null) {
                        query.setSrcPeerRoute(route.clone());
                    }
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Sending query with route info to " + destPeer);
                    }
                } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No route control--could not set local route on query");
                }
            }
            String queryHandlerName = query.getHandlerName();
            QueryHandlerMeter queryHandlerMeter = null;
            if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
                queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(queryHandlerName);
            }
            if (destPeer == null) {
                try {
                    Message queryMsg = new Message();
                    XMLDocument asDoc = (XMLDocument)query.getDocument(MimeMediaType.XMLUTF8);
                    TextDocumentMessageElement docElem = new TextDocumentMessageElement(this.outQueName, asDoc, null);
                    queryMsg.addMessageElement("jxta", docElem);
                    RendezVousService rendezvous = this.group.getRendezVousService();
                    if (null != rendezvous) {
                        if (rendezvous.getRendezVousStatus() != RendezVousStatus.ADHOC) {
                            rendezvous.walk(queryMsg.clone(), this.handlerName, this.outQueName, Integer.MAX_VALUE);
                        }
                        rendezvous.propagateToNeighbors(queryMsg, this.handlerName, this.outQueName, 2);
                    } else {
                        this.endpoint.propagate(queryMsg, this.handlerName, this.outQueName);
                    }
                    if (ResolverMeterBuildSettings.RESOLVER_METERING && queryHandlerMeter != null) {
                        queryHandlerMeter.querySentInGroup(query);
                    }
                    break block20;
                }
                catch (IOException e) {
                    if (ResolverMeterBuildSettings.RESOLVER_METERING && queryHandlerMeter != null) {
                        queryHandlerMeter.queryPropagateError();
                    }
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Failure during propagate", e);
                    }
                    break block20;
                }
            }
            boolean success = this.sendMessage(destPeer, null, this.handlerName, this.outQueName, this.outQueName, (XMLDocument)query.getDocument(MimeMediaType.XMLUTF8), false);
            if (ResolverMeterBuildSettings.RESOLVER_METERING && queryHandlerMeter != null) {
                if (success) {
                    queryHandlerMeter.querySentViaUnicast(destPeer, query);
                } else {
                    queryHandlerMeter.querySendError();
                }
            }
        }
    }

    public void sendResponse(String destPeer, ResolverResponseMsg response) {
        block9: {
            if (destPeer == null) {
                this.propagateResponse(response);
            } else {
                QueryHandlerMeter queryHandlerMeter = null;
                try {
                    if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
                        queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(response.getHandlerName());
                    }
                    RouteAdvertisement route = response.getSrcPeerRoute();
                    boolean success = this.sendMessage(destPeer, route, this.handlerName, this.inQueName, this.inQueName, (XMLDocument)response.getDocument(MimeMediaType.XMLUTF8), false);
                    if (ResolverMeterBuildSettings.RESOLVER_METERING && queryHandlerMeter != null) {
                        if (success) {
                            queryHandlerMeter.responseSentViaUnicast(destPeer, response);
                        } else {
                            queryHandlerMeter.responseSendError();
                        }
                    }
                }
                catch (Exception e) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Error in sending response", e);
                    }
                    if (!ResolverMeterBuildSettings.RESOLVER_METERING || queryHandlerMeter == null) break block9;
                    queryHandlerMeter.responseSendError();
                }
            }
        }
    }

    public void sendSrdi(String destPeer, ResolverSrdiMsg srdi) {
        block15: {
            String srdiHandlerName = srdi.getHandlerName();
            SrdiHandlerMeter srdiHandlerMeter = null;
            if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
                srdiHandlerMeter = this.resolverServiceMonitor.getSrdiHandlerMeter(srdiHandlerName);
            }
            if (destPeer == null) {
                RendezVousService rendezvous = this.group.getRendezVousService();
                if (rendezvous == null) {
                    return;
                }
                Message propagateMsg = new Message();
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gos = new GZIPOutputStream(baos);
                    srdi.getDocument(MimeMediaType.XMLUTF8).sendToStream(gos);
                    gos.finish();
                    gos.close();
                    byte[] gzipBytes = baos.toByteArray();
                    ByteArrayMessageElement zipElem = new ByteArrayMessageElement(this.srdiQueName, GZIP_MEDIA_TYPE, gzipBytes, null);
                    propagateMsg.addMessageElement("jxta", zipElem);
                    if (rendezvous.getRendezVousStatus() != RendezVousStatus.ADHOC) {
                        rendezvous.walk(propagateMsg, this.handlerName, this.srdiQueName, Integer.MAX_VALUE);
                    }
                    rendezvous.propagateToNeighbors(propagateMsg, this.handlerName, this.srdiQueName, 2);
                    if (ResolverMeterBuildSettings.RESOLVER_METERING && srdiHandlerMeter != null) {
                        srdiHandlerMeter.messageSentViaWalker(srdi);
                    }
                    break block15;
                }
                catch (IOException e) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Failure sending srdi message", e);
                    }
                    if (ResolverMeterBuildSettings.RESOLVER_METERING && srdiHandlerMeter != null) {
                        srdiHandlerMeter.errorPropagatingMessage();
                    }
                    break block15;
                }
            }
            try {
                boolean success = this.sendMessage(destPeer, null, this.handlerName, this.srdiQueName, this.srdiQueName, (XMLDocument)srdi.getDocument(MimeMediaType.XMLUTF8), true);
                if (ResolverMeterBuildSettings.RESOLVER_METERING && srdiHandlerMeter != null) {
                    if (success) {
                        srdiHandlerMeter.messageSentViaUnicast(destPeer, srdi);
                    } else {
                        srdiHandlerMeter.errorSendingMessage();
                    }
                }
            }
            catch (Exception e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Error in sending srdi message", e);
                }
                if (!ResolverMeterBuildSettings.RESOLVER_METERING || srdiHandlerMeter == null) break block15;
                srdiHandlerMeter.errorSendingMessage();
            }
        }
    }

    private void repropagateQuery(Message msg, ResolverQueryMsg query) {
        block10: {
            RendezVousService rendezvous = this.group.getRendezVousService();
            if (null != rendezvous && !this.group.isRendezvous()) {
                return;
            }
            if (query.getHopCount() > 3) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("discarding ResolverQuery. HopCount exceeded : " + query.getHopCount());
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverMeter != null) {
                    this.resolverMeter.propagationQueryDropped(query);
                }
                return;
            }
            XMLDocument asDoc = (XMLDocument)query.getDocument(MimeMediaType.XMLUTF8);
            TextDocumentMessageElement docElem = new TextDocumentMessageElement(this.outQueName, asDoc, null);
            msg.replaceMessageElement("jxta", docElem);
            try {
                if (null != rendezvous) {
                    if (rendezvous.getRendezVousStatus() != RendezVousStatus.ADHOC) {
                        rendezvous.walk(msg, this.handlerName, this.outQueName, Integer.MAX_VALUE);
                    }
                    rendezvous.propagateToNeighbors(msg, this.handlerName, this.outQueName, 2);
                } else {
                    this.endpoint.propagate(msg, this.handlerName, this.inQueName);
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverMeter != null) {
                    this.resolverMeter.queryPropagatedViaWalker(query);
                }
            }
            catch (IOException e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block10;
                LOG.log(Level.WARNING, "Failure propagating query", e);
                if (!ResolverMeterBuildSettings.RESOLVER_METERING || this.resolverMeter == null) break block10;
                this.resolverMeter.queryPropagationError(query);
            }
        }
    }

    private int processQuery(ResolverQueryMsg query, EndpointAddress srcAddr) {
        String queryHandlerName = query.getHandlerName();
        QueryHandler theHandler = this.getHandler(queryHandlerName);
        if (query.getHopCount() > 2) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Discarding query #" + query.getQueryId() + " hopCount > 2 : " + query.getHopCount());
            }
            if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
                QueryHandlerMeter queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(queryHandlerName);
                if (queryHandlerMeter != null) {
                    queryHandlerMeter.queryHopCountDropped();
                } else {
                    this.resolverMeter.invalidQueryDiscarded(srcAddr);
                }
            }
            return 0;
        }
        if (theHandler == null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Discarding query #" + query.getQueryId() + ", no handler for :" + queryHandlerName);
            }
            if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverMeter != null) {
                this.resolverMeter.unknownHandlerForQuery(query);
            }
            return -1;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Handing query #" + query.getQueryId() + " to : " + queryHandlerName);
        }
        QueryHandlerMeter queryHandlerMeter = null;
        long startTime = 0L;
        if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
            startTime = System.currentTimeMillis();
            queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(queryHandlerName);
        }
        try {
            int result = theHandler instanceof InternalQueryHandler ? ((InternalQueryHandler)theHandler).processQuery(query, srcAddr) : theHandler.processQuery(query);
            if (ResolverMeterBuildSettings.RESOLVER_METERING && queryHandlerMeter != null) {
                queryHandlerMeter.queryProcessed(query, result, System.currentTimeMillis() - startTime);
            }
            return result;
        }
        catch (Throwable any) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Uncaught Throwable from handler for : " + queryHandlerName, any);
            }
            if (ResolverMeterBuildSettings.RESOLVER_METERING && queryHandlerMeter != null) {
                queryHandlerMeter.errorWhileProcessingQuery(query);
            }
            return 0;
        }
    }

    private void processResponse(ResolverResponseMsg resp, EndpointAddress srcAddr) {
        block14: {
            String handlerName = resp.getHandlerName();
            if (handlerName == null) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Missing handlername in response");
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverMeter != null) {
                    this.resolverMeter.invalidResponseDiscarded(srcAddr);
                }
                return;
            }
            QueryHandler theHandler = this.getHandler(handlerName);
            if (theHandler == null) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("No handler for :" + handlerName);
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverMeter != null) {
                    this.resolverMeter.unknownHandlerForResponse(srcAddr, resp);
                }
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Process response to query #" + resp.getQueryId() + " with " + handlerName);
            }
            QueryHandlerMeter queryHandlerMeter = null;
            long startTime = 0L;
            if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
                startTime = System.currentTimeMillis();
                queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(handlerName);
            }
            try {
                if (theHandler instanceof InternalQueryHandler) {
                    ((InternalQueryHandler)theHandler).processResponse(resp, srcAddr);
                } else {
                    theHandler.processResponse(resp);
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && queryHandlerMeter != null) {
                    queryHandlerMeter.responseProcessed(resp, System.currentTimeMillis() - startTime, srcAddr);
                }
            }
            catch (Throwable all) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Uncaught Throwable from handler for: " + handlerName, all);
                }
                if (!ResolverMeterBuildSettings.RESOLVER_METERING || queryHandlerMeter == null) break block14;
                queryHandlerMeter.errorWhileProcessingResponse(srcAddr);
            }
        }
    }

    private void propagateResponse(ResolverResponseMsg response) {
        block8: {
            Message propagateMsg = new Message();
            String queryHandlerName = response.getHandlerName();
            QueryHandlerMeter queryHandlerMeter = null;
            try {
                if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
                    queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(queryHandlerName);
                }
                XMLDocument responseDoc = (XMLDocument)response.getDocument(MimeMediaType.XMLUTF8);
                TextDocumentMessageElement elemDoc = new TextDocumentMessageElement(this.inQueName, responseDoc, null);
                propagateMsg.addMessageElement("jxta", elemDoc);
                RendezVousService rendezvous = this.group.getRendezVousService();
                if (null != rendezvous) {
                    rendezvous.walk(propagateMsg, this.handlerName, this.inQueName, Integer.MAX_VALUE);
                    if (ResolverMeterBuildSettings.RESOLVER_METERING && queryHandlerMeter != null) {
                        queryHandlerMeter.responseSentViaWalker(response);
                    }
                } else {
                    this.endpoint.propagate(propagateMsg, this.handlerName, this.inQueName);
                    if (ResolverMeterBuildSettings.RESOLVER_METERING && queryHandlerMeter != null) {
                        queryHandlerMeter.responseSentViaWalker(response);
                    }
                }
            }
            catch (IOException e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "failure during propagateResponse", e);
                }
                if (!ResolverMeterBuildSettings.RESOLVER_METERING || queryHandlerMeter == null) break block8;
                queryHandlerMeter.responsePropagateError();
            }
        }
    }

    private void processSrdi(ResolverSrdiMsgImpl srdimsg, EndpointAddress srcAddr) {
        block15: {
            SrdiHandler theHandler;
            String handlerName = srdimsg.getHandlerName();
            if (handlerName == null) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Missing handlername in response");
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverMeter != null) {
                    this.resolverMeter.invalidSrdiMessageDiscarded(srcAddr);
                }
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Processing an SRDI msg for : " + handlerName + " in Group ID:" + this.group.getPeerGroupID());
            }
            if ((theHandler = this.getSrdiHandler(handlerName)) != null) {
                SrdiHandlerMeter srdiHandlerMeter = null;
                try {
                    long startTime = 0L;
                    if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverServiceMonitor != null) {
                        startTime = System.currentTimeMillis();
                        srdiHandlerMeter = this.resolverServiceMonitor.getSrdiHandlerMeter(handlerName);
                    }
                    theHandler.processSrdi(srdimsg);
                    if (ResolverMeterBuildSettings.RESOLVER_METERING && srdiHandlerMeter != null) {
                        srdiHandlerMeter.messageProcessed(srdimsg, System.currentTimeMillis() - startTime, srcAddr);
                    }
                    break block15;
                }
                catch (Throwable all) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Uncaught Throwable from handler for: " + handlerName, all);
                    }
                    if (ResolverMeterBuildSettings.RESOLVER_METERING && srdiHandlerMeter != null) {
                        srdiHandlerMeter.errorWhileProcessing(srcAddr);
                    }
                    break block15;
                }
            }
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING) && this.group.isRendezvous()) {
                LOG.warning("No srdi handler registered :" + handlerName + " for Group ID:" + this.group.getPeerGroupID());
            } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("No srdi handler registered :" + handlerName + " for Group ID:" + this.group.getPeerGroupID());
            }
            if (ResolverMeterBuildSettings.RESOLVER_METERING && this.resolverMeter != null) {
                this.resolverMeter.unknownHandlerForSrdiMessage(srcAddr, handlerName);
            }
        }
    }

    private boolean sendMessage(String destPeer, RouteAdvertisement route, String pName, String pParam, String tagName, XMLDocument body, boolean gzip) {
        ID dest;
        try {
            dest = IDFactory.fromURI(new URI(destPeer));
        }
        catch (URISyntaxException badpeer) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "bad destination peerid : " + destPeer, badpeer);
            }
            return false;
        }
        EndpointAddress destAddress = ResolverServiceImpl.mkAddress(dest, pName, pParam);
        Messenger messenger = null;
        if (route == null) {
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("No route info available for " + destPeer);
            }
        } else if (null == this.getRouteControl() || this.routeControl.addRoute(route) == -1) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Failed to add route for " + route.getDestPeerID());
            }
        } else if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Added route for " + route.getDestPeerID());
        }
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Creating a messenger immediate for :" + destAddress);
        }
        if (null == (messenger = this.endpoint.getMessengerImmediate(destAddress, route))) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Failed creating messenger for " + destAddress);
            }
            return false;
        }
        Message msg = new Message();
        try {
            MessageElement msgEl;
            if (gzip) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gos = new GZIPOutputStream(baos);
                body.sendToStream(gos);
                gos.finish();
                gos.close();
                byte[] gzipBytes = baos.toByteArray();
                msgEl = new ByteArrayMessageElement(tagName, GZIP_MEDIA_TYPE, gzipBytes, null);
            } else {
                msgEl = new TextDocumentMessageElement(tagName, body, null);
            }
            msg.addMessageElement("jxta", msgEl);
        }
        catch (Exception ez1) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed building message", ez1);
            }
            return false;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending " + msg + " to " + destAddress + " " + tagName);
        }
        messenger.sendMessage(msg, null, null, new FailureListener(dest));
        return true;
    }

    private RouteControl getRouteControl() {
        if (this.routeControl == null) {
            MessageTransport endpointRouter = this.endpoint.getMessageTransport("jxta");
            if (endpointRouter != null) {
                this.routeControl = (RouteControl)endpointRouter.transportControl(EndpointRouter.GET_ROUTE_CONTROL, null);
            } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Failed to get RouteControl object. Resolver will not set route hints.");
            }
        }
        return this.routeControl;
    }

    class FailureListener
    implements OutgoingMessageEventListener {
        final ID dest;

        FailureListener(ID dest) {
            this.dest = dest;
        }

        public void messageSendFailed(OutgoingMessageEvent event) {
            if (event.getFailure() == null) {
                return;
            }
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Clearing SRDI tables for failed peer : " + this.dest);
            }
            for (Object o : Arrays.asList(ResolverServiceImpl.this.srdiHandlers.values().toArray())) {
                SrdiHandler theHandler = (SrdiHandler)o;
                try {
                    theHandler.messageSendFailed((PeerID)this.dest, event);
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Uncaught Throwable from handler : " + theHandler, all);
                }
            }
        }

        public void messageSendSucceeded(OutgoingMessageEvent event) {
        }
    }

    private class DemuxSrdi
    implements EndpointListener {
        private DemuxSrdi() {
        }

        public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            ResolverSrdiMsgImpl srdimsg;
            MessageElement element2;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Demuxing an SRDI message from : " + srcAddr);
            }
            if ((element2 = message.getMessageElement("jxta", ResolverServiceImpl.this.srdiQueName)) == null) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Message does not contain a SRDI element. Discarding message");
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && ResolverServiceImpl.this.resolverMeter != null) {
                    ResolverServiceImpl.this.resolverMeter.invalidSrdiMessageDiscarded(srcAddr);
                }
                return;
            }
            try {
                if (element2.getMimeType().getBaseMimeMediaType().equals(GZIP_MEDIA_TYPE)) {
                    GZIPInputStream gzipStream = new GZIPInputStream(element2.getStream());
                    StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, gzipStream);
                    srdimsg = new ResolverSrdiMsgImpl(asDoc, ResolverServiceImpl.this.membership);
                } else {
                    StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(element2);
                    srdimsg = new ResolverSrdiMsgImpl(asDoc, ResolverServiceImpl.this.membership);
                }
            }
            catch (IOException e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Ill formatted SRDI message, ignoring.", e);
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && ResolverServiceImpl.this.resolverMeter != null) {
                    ResolverServiceImpl.this.resolverMeter.invalidSrdiMessageDiscarded(srcAddr);
                }
                return;
            }
            ResolverServiceImpl.this.processSrdi(srdimsg, srcAddr);
        }
    }

    private class DemuxResponse
    implements EndpointListener {
        private DemuxResponse() {
        }

        public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            ResolverResponse resolverResponse;
            MessageElement element2;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Demuxing a response from " + srcAddr);
            }
            if (null == (element2 = message.getMessageElement("jxta", ResolverServiceImpl.this.inQueName))) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Message does not contain a response. Discarding message");
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && ResolverServiceImpl.this.resolverMeter != null) {
                    ResolverServiceImpl.this.resolverMeter.invalidResponseDiscarded(srcAddr);
                }
                return;
            }
            try {
                StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(element2);
                resolverResponse = new ResolverResponse(asDoc);
            }
            catch (IOException e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Ill formatted resolver response, ignoring.", e);
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && ResolverServiceImpl.this.resolverMeter != null) {
                    ResolverServiceImpl.this.resolverMeter.invalidResponseDiscarded(srcAddr);
                }
                return;
            }
            catch (IllegalArgumentException e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Ill formatted resolver response, ignoring.", e);
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && ResolverServiceImpl.this.resolverMeter != null) {
                    ResolverServiceImpl.this.resolverMeter.invalidResponseDiscarded(srcAddr);
                }
                return;
            }
            ResolverServiceImpl.this.processResponse(resolverResponse, srcAddr);
        }
    }

    private class DemuxQuery
    implements EndpointListener {
        private DemuxQuery() {
        }

        public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            ResolverQuery query;
            MessageElement element2;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Demuxing a query message from " + srcAddr);
            }
            if ((element2 = message.getMessageElement("jxta", ResolverServiceImpl.this.outQueName)) == null) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Message does not contain a query. Discarding message");
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && ResolverServiceImpl.this.resolverMeter != null) {
                    ResolverServiceImpl.this.resolverMeter.invalidQueryDiscarded(srcAddr);
                }
                return;
            }
            try {
                StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(element2);
                query = new ResolverQuery(asDoc);
            }
            catch (IOException e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Ill formatted resolver query, ignoring.", e);
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && ResolverServiceImpl.this.resolverMeter != null) {
                    ResolverServiceImpl.this.resolverMeter.invalidQueryDiscarded(srcAddr);
                }
                return;
            }
            catch (IllegalArgumentException e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Ill formatted resolver query, ignoring.", e);
                }
                if (ResolverMeterBuildSettings.RESOLVER_METERING && ResolverServiceImpl.this.resolverMeter != null) {
                    ResolverServiceImpl.this.resolverMeter.invalidQueryDiscarded(srcAddr);
                }
                return;
            }
            int res = ResolverServiceImpl.this.processQuery(query, srcAddr);
            if (-1 == res) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Repropagating query " + message + " from " + srcAddr);
                }
                ResolverServiceImpl.this.repropagateQuery(message, query);
            }
        }
    }

    private class CredentialListener
    implements PropertyChangeListener {
        CredentialListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if ("defaultCredential".equals(evt.getPropertyName())) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("New default credential event");
                }
                ResolverServiceImpl resolverServiceImpl = ResolverServiceImpl.this;
                synchronized (resolverServiceImpl) {
                    Credential cred = (Credential)evt.getNewValue();
                    if (null != cred) {
                        try {
                            XMLDocument credentialDoc = (XMLDocument)cred.getDocument(MimeMediaType.XMLUTF8);
                            ResolverServiceImpl.this.currentCredential = new CurrentCredential(cred, credentialDoc);
                        }
                        catch (Exception all) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.log(Level.WARNING, "Could not generate credential document", all);
                            }
                            ResolverServiceImpl.this.currentCredential = null;
                        }
                    } else {
                        ResolverServiceImpl.this.currentCredential = null;
                    }
                }
            }
        }
    }

    static final class CurrentCredential {
        final Credential credential;
        final XMLDocument credentialDoc;

        CurrentCredential(Credential credential, XMLDocument credentialDoc) {
            this.credential = credential;
            this.credentialDoc = credentialDoc;
        }
    }
}

