/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rendezvousMeter;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class RendezvousMetric
implements DocumentSerializable {
    public static final String EDGE = "edge";
    public static final String RENDEZVOUS = "rendezvous";
    public static final String STOPPED = "stopped";
    private String state = null;
    private long transitionTime = 0L;
    private long totalEdgeTime;
    private int numEdgeTransitions;
    private long totalRendezvousTime;
    private long numRendezvousTransitions;
    private int numReceivedProcessedLocally;
    private int numReceivedRepropagatedInGroup;
    private int numReceivedInvalid;
    private int numReceivedDead;
    private int numReceivedLoopback;
    private int numReceivedDuplicate;
    private int numPropagated;
    private int numFailedPropagating;
    private int numRepropagated;
    private int numFailedRepropagating;
    private int numPropagatedToPeers;
    private int numFailedPropagatingToPeers;
    private int numPeersPropagatedTo;
    private int numPropagatedInGroup;
    private int numPropagatedToNeighbors;
    private int numFailedPropagatingToNeighbors;
    private int numWalks;
    private int numFailedWalks;
    private int numWalkedToPeers;
    private int numFailedWalkToPeers;
    private int numPeersWalkedTo;

    public RendezvousMetric() {
    }

    public RendezvousMetric(RendezvousMetric prototype) {
        if (prototype == null) {
            this.state = STOPPED;
        } else {
            this.state = prototype.state;
            this.transitionTime = prototype.transitionTime;
        }
    }

    public String getState() {
        return this.state != null ? this.state : STOPPED;
    }

    public long getTransitionTime() {
        return this.transitionTime;
    }

    public boolean isEdge() {
        return this.state != null && this.state.equals(EDGE);
    }

    public boolean isRendezvous() {
        return this.state != null && this.state.equals(RENDEZVOUS);
    }

    public long getEdgeStartTime() {
        return this.isEdge() ? this.transitionTime : 0L;
    }

    public long getTotalEdgeTime() {
        return this.totalEdgeTime;
    }

    public long getTotalEdgeTime(long adjustmentTime) {
        long result = this.totalEdgeTime;
        if (this.isEdge()) {
            result += adjustmentTime - this.transitionTime;
        }
        return result;
    }

    public int getNumEdgeTransitions() {
        return this.numEdgeTransitions;
    }

    public long getRendezvousStartTime() {
        return this.isRendezvous() ? this.transitionTime : 0L;
    }

    public long getTotalRendezvousTime() {
        return this.totalRendezvousTime;
    }

    public long getTotalRendezvousTime(long adjustmentTime) {
        long result = this.totalRendezvousTime;
        if (this.isRendezvous()) {
            result += adjustmentTime - this.transitionTime;
        }
        return result;
    }

    public long getNumRendezvousTransitions() {
        return this.numRendezvousTransitions;
    }

    public int getNumReceivedProcessedLocally() {
        return this.numReceivedProcessedLocally;
    }

    public int getNumReceivedRepropagatedInGroup() {
        return this.numReceivedRepropagatedInGroup;
    }

    public int getNumReceivedInvalid() {
        return this.numReceivedInvalid;
    }

    public int getNumReceivedDead() {
        return this.numReceivedDead;
    }

    public int getNumReceivedLoopback() {
        return this.numReceivedLoopback;
    }

    public int getNumReceivedDuplicate() {
        return this.numReceivedDuplicate;
    }

    public int getTotalReceivedUndelivered() {
        return this.numReceivedInvalid + this.numReceivedDead + this.numReceivedLoopback + this.numReceivedDuplicate;
    }

    public int getTotalReceived() {
        return this.getTotalReceivedUndelivered() + this.numReceivedProcessedLocally + this.numReceivedRepropagatedInGroup;
    }

    public int getNumPropagated() {
        return this.numPropagated;
    }

    public int getNumFailedPropagating() {
        return this.numFailedPropagating;
    }

    public int getNumRepropagated() {
        return this.numRepropagated;
    }

    public int getNumFailedRepropagating() {
        return this.numFailedRepropagating;
    }

    public int getNumPropagatedToPeers() {
        return this.numPropagatedToPeers;
    }

    public int getNumFailedPropagatingToPeers() {
        return this.numFailedPropagatingToPeers;
    }

    public int getNumPeersPropagatedTo() {
        return this.numPeersPropagatedTo;
    }

    public int getNumPropagatedInGroup() {
        return this.numPropagatedInGroup;
    }

    public int getNumPropagatedToNeighbors() {
        return this.numPropagatedToNeighbors;
    }

    public int getNumFailedPropagatingToNeighbors() {
        return this.numFailedPropagatingToNeighbors;
    }

    public int getNumWalks() {
        return this.numWalks;
    }

    public int getNumFailedWalks() {
        return this.numFailedWalks;
    }

    public int getNumWalkedToPeers() {
        return this.numWalkedToPeers;
    }

    public int getNumFailedWalkToPeers() {
        return this.numFailedWalkToPeers;
    }

    public int getNumPeersWalkedTo() {
        return this.numPeersWalkedTo;
    }

    public long getTimeAsEdge() {
        return this.getTimeAsEdge(System.currentTimeMillis());
    }

    public long getTimeAsEdge(long adjustmentTime) {
        if (this.isEdge()) {
            return adjustmentTime - this.transitionTime;
        }
        return 0L;
    }

    public long getTimeAsRendezvous() {
        return this.getTimeAsRendezvous(System.currentTimeMillis());
    }

    public long getTimeAsRendezvous(long adjustmentTime) {
        if (this.isRendezvous()) {
            return adjustmentTime - this.transitionTime;
        }
        return 0L;
    }

    void startEdge(long transitionTime) {
        this.transitionTime = transitionTime;
        this.state = EDGE;
        ++this.numEdgeTransitions;
    }

    void stopEdge(long transitionTime, long timeAsEdge) {
        this.state = STOPPED;
        this.transitionTime = transitionTime;
        this.totalEdgeTime += timeAsEdge;
    }

    void startRendezvous(long transitionTime) {
        this.state = RENDEZVOUS;
        this.transitionTime = transitionTime;
        ++this.numRendezvousTransitions;
    }

    void stopRendezvous(long transitionTime, long timeAsRendezvous) {
        this.state = STOPPED;
        this.transitionTime = transitionTime;
        this.totalRendezvousTime += timeAsRendezvous;
    }

    void invalidMessageReceived() {
        ++this.numReceivedInvalid;
    }

    void receivedMessageProcessedLocally() {
        ++this.numReceivedProcessedLocally;
    }

    void receivedMessageRepropagatedInGroup() {
        ++this.numReceivedRepropagatedInGroup;
    }

    void receivedDeadMessage() {
        ++this.numReceivedDead;
    }

    void receivedLoopbackMessage() {
        ++this.numReceivedLoopback;
    }

    void receivedDuplicateMessage() {
        ++this.numReceivedDuplicate;
    }

    void propagateToPeers(int numPeers) {
        ++this.numPropagatedToPeers;
        this.numPeersPropagatedTo += numPeers;
    }

    void propagateToNeighbors() {
        ++this.numPropagatedToNeighbors;
    }

    void propagateToNeighborsFailed() {
        ++this.numFailedPropagatingToNeighbors;
    }

    void propagateToGroup() {
        ++this.numPropagatedInGroup;
    }

    void walk() {
        ++this.numWalks;
    }

    void walkFailed() {
        ++this.numFailedWalks;
    }

    void walkToPeers(int numPeers) {
        ++this.numWalkedToPeers;
        this.numPeersWalkedTo += numPeers;
    }

    void walkToPeersFailed() {
        ++this.numFailedWalkToPeers;
    }

    public void mergeMetrics(RendezvousMetric otherRendezvousMetric) {
        if (otherRendezvousMetric == null) {
            return;
        }
        if (otherRendezvousMetric.state != null) {
            this.state = otherRendezvousMetric.state;
        }
        if (otherRendezvousMetric.transitionTime != 0L) {
            this.transitionTime = otherRendezvousMetric.transitionTime;
        }
        this.totalEdgeTime += otherRendezvousMetric.totalEdgeTime;
        this.numEdgeTransitions += otherRendezvousMetric.numEdgeTransitions;
        this.totalRendezvousTime += otherRendezvousMetric.totalRendezvousTime;
        this.numRendezvousTransitions += otherRendezvousMetric.numRendezvousTransitions;
        this.numReceivedProcessedLocally += otherRendezvousMetric.numReceivedProcessedLocally;
        this.numReceivedRepropagatedInGroup += otherRendezvousMetric.numReceivedRepropagatedInGroup;
        this.numReceivedInvalid += otherRendezvousMetric.numReceivedInvalid;
        this.numReceivedDead += otherRendezvousMetric.numReceivedDead;
        this.numReceivedLoopback += otherRendezvousMetric.numReceivedLoopback;
        this.numReceivedDuplicate += otherRendezvousMetric.numReceivedDuplicate;
        this.numPropagated += otherRendezvousMetric.numPropagated;
        this.numFailedPropagating += otherRendezvousMetric.numFailedPropagating;
        this.numRepropagated += otherRendezvousMetric.numRepropagated;
        this.numFailedRepropagating += otherRendezvousMetric.numFailedRepropagating;
        this.numPropagatedToPeers += otherRendezvousMetric.numPropagatedToPeers;
        this.numFailedPropagatingToPeers += otherRendezvousMetric.numFailedPropagatingToPeers;
        this.numPeersPropagatedTo += otherRendezvousMetric.numPeersPropagatedTo;
        this.numPropagatedInGroup += otherRendezvousMetric.numPropagatedInGroup;
        this.numPropagatedToNeighbors += otherRendezvousMetric.numPropagatedToNeighbors;
        this.numFailedPropagatingToNeighbors += otherRendezvousMetric.numFailedPropagatingToNeighbors;
        this.numWalks += otherRendezvousMetric.numWalks;
        this.numFailedWalks += otherRendezvousMetric.numFailedWalks;
        this.numWalkedToPeers += otherRendezvousMetric.numWalkedToPeers;
        this.numFailedWalkToPeers += otherRendezvousMetric.numFailedWalkToPeers;
        this.numPeersWalkedTo += otherRendezvousMetric.numPeersWalkedTo;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        if (this.state != null) {
            DocumentSerializableUtilities.addString(element2, "state", this.state);
        }
        if (this.transitionTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "transitionTime", this.transitionTime);
        }
        if (this.totalEdgeTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "totalEdgeTime", this.totalEdgeTime);
        }
        if (this.numEdgeTransitions != 0) {
            DocumentSerializableUtilities.addInt(element2, "numEdgeTransitions", this.numEdgeTransitions);
        }
        if (this.totalRendezvousTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "totalRendezvousTime", this.totalRendezvousTime);
        }
        if (this.numRendezvousTransitions != 0L) {
            DocumentSerializableUtilities.addLong(element2, "numRendezvousTransitions", this.numRendezvousTransitions);
        }
        if (this.numReceivedProcessedLocally != 0) {
            DocumentSerializableUtilities.addInt(element2, "numReceivedProcessedLocally", this.numReceivedProcessedLocally);
        }
        if (this.numReceivedRepropagatedInGroup != 0) {
            DocumentSerializableUtilities.addInt(element2, "numReceivedRepropagatedInGroup", this.numReceivedRepropagatedInGroup);
        }
        if (this.numReceivedInvalid != 0) {
            DocumentSerializableUtilities.addInt(element2, "numReceivedInvalid", this.numReceivedInvalid);
        }
        if (this.numReceivedDead != 0) {
            DocumentSerializableUtilities.addInt(element2, "numReceivedDead", this.numReceivedDead);
        }
        if (this.numReceivedLoopback != 0) {
            DocumentSerializableUtilities.addInt(element2, "numReceivedLoopback", this.numReceivedLoopback);
        }
        if (this.numReceivedDuplicate != 0) {
            DocumentSerializableUtilities.addInt(element2, "numReceivedDuplicate", this.numReceivedDuplicate);
        }
        if (this.numPropagated != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPropagated", this.numPropagated);
        }
        if (this.numFailedPropagating != 0) {
            DocumentSerializableUtilities.addInt(element2, "numFailedPropagating", this.numFailedPropagating);
        }
        if (this.numRepropagated != 0) {
            DocumentSerializableUtilities.addInt(element2, "numRepropagated", this.numRepropagated);
        }
        if (this.numFailedRepropagating != 0) {
            DocumentSerializableUtilities.addInt(element2, "numFailedRepropagating", this.numFailedRepropagating);
        }
        if (this.numPropagatedToPeers != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPropagatedToPeers", this.numPropagatedToPeers);
        }
        if (this.numFailedPropagatingToPeers != 0) {
            DocumentSerializableUtilities.addInt(element2, "numFailedPropagatingToPeers", this.numFailedPropagatingToPeers);
        }
        if (this.numPeersPropagatedTo != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPeersPropagatedTo", this.numPeersPropagatedTo);
        }
        if (this.numPropagatedInGroup != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPropagatedInGroup", this.numPropagatedInGroup);
        }
        if (this.numPropagatedToNeighbors != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPropagatedToNeighbors", this.numPropagatedToNeighbors);
        }
        if (this.numFailedPropagatingToNeighbors != 0) {
            DocumentSerializableUtilities.addInt(element2, "numFailedPropagatingToNeighbors", this.numFailedPropagatingToNeighbors);
        }
        if (this.numWalks != 0) {
            DocumentSerializableUtilities.addInt(element2, "numWalks", this.numWalks);
        }
        if (this.numFailedWalks != 0) {
            DocumentSerializableUtilities.addInt(element2, "numFailedWalks", this.numFailedWalks);
        }
        if (this.numWalkedToPeers != 0) {
            DocumentSerializableUtilities.addInt(element2, "numWalkedToPeers", this.numWalkedToPeers);
        }
        if (this.numFailedWalkToPeers != 0) {
            DocumentSerializableUtilities.addInt(element2, "numFailedWalkToPeers", this.numFailedWalkToPeers);
        }
        if (this.numPeersWalkedTo != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPeersWalkedTo", this.numPeersWalkedTo);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("state")) {
                this.state = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals("transitionTime")) {
                this.transitionTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("totalEdgeTime")) {
                this.totalEdgeTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numEdgeTransitions")) {
                this.numEdgeTransitions = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("totalRendezvousTime")) {
                this.totalRendezvousTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numRendezvousTransitions")) {
                this.numRendezvousTransitions = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numReceivedProcessedLocally")) {
                this.numReceivedProcessedLocally = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numReceivedRepropagatedInGroup")) {
                this.numReceivedRepropagatedInGroup = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numReceivedInvalid")) {
                this.numReceivedInvalid = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numReceivedDead")) {
                this.numReceivedDead = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numReceivedLoopback")) {
                this.numReceivedLoopback = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numReceivedDuplicate")) {
                this.numReceivedDuplicate = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numPropagated")) {
                this.numPropagated = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numFailedPropagating")) {
                this.numFailedPropagating = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numRepropagated")) {
                this.numRepropagated = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numFailedRepropagating")) {
                this.numFailedRepropagating = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numPropagatedToPeers")) {
                this.numPropagatedToPeers = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numFailedPropagatingToPeers")) {
                this.numFailedPropagatingToPeers = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numPeersPropagatedTo")) {
                this.numPeersPropagatedTo = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numPropagatedInGroup")) {
                this.numPropagatedInGroup = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numPropagatedToNeighbors")) {
                this.numPropagatedToNeighbors = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numFailedPropagatingToNeighbors")) {
                this.numFailedPropagatingToNeighbors = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numWalks")) {
                this.numWalks = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numFailedWalks")) {
                this.numFailedWalks = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numWalkedToPeers")) {
                this.numWalkedToPeers = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numFailedWalkToPeers")) {
                this.numFailedWalkToPeers = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (!tagName.equals("numPeersWalkedTo")) continue;
            this.numPeersWalkedTo = DocumentSerializableUtilities.getInt(childElement);
        }
    }
}

