/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.net.URI;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import net.jxta.logging.Logging;

public class RendezVousPropagateMessage {
    private static final transient Logger LOG = Logger.getLogger(RendezVousPropagateMessage.class.getName());
    public static final String MSG_NAME = "jxta:RendezVousPropagateMessage";
    public static final String MsgIdTag = "MessageId";
    public static final String DestSNameTag = "DestSName";
    public static final String DestSParamTag = "DestSParam";
    public static final String TTLTag = "TTL";
    public static final String PathTag = "Path";
    public static final String Name = "RendezVousPropagate";
    private UUID msgId = null;
    private String destSName = null;
    private String destSParam = null;
    private int TTL = Integer.MIN_VALUE;
    private final Set<URI> visited = new LinkedHashSet<URI>();

    public RendezVousPropagateMessage() {
    }

    public RendezVousPropagateMessage(Element root) {
        this();
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(MSG_NAME) && !MSG_NAME.equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
        if (Integer.MIN_VALUE == this.getTTL()) {
            throw new IllegalArgumentException("TTL value not specified");
        }
        if (null == this.destSName) {
            throw new IllegalArgumentException("Destination service name uninitialized");
        }
        if (null == this.msgId) {
            throw new IllegalArgumentException("Message id uninitialized");
        }
    }

    protected boolean handleElement(Element raw) {
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(MsgIdTag)) {
            try {
                this.msgId = new UUID(elem.getTextValue().trim());
            }
            catch (IllegalArgumentException iae) {
                try {
                    this.msgId = UUIDFactory.newHashUUID(Long.parseLong(elem.getTextValue().trim()), 0L);
                }
                catch (NumberFormatException notanumber) {
                    this.msgId = UUIDFactory.newHashUUID(elem.getTextValue().trim().hashCode(), 0L);
                }
            }
            return true;
        }
        if (elem.getName().equals(DestSNameTag)) {
            this.destSName = elem.getTextValue().trim();
            return true;
        }
        if (elem.getName().equals(DestSParamTag)) {
            this.destSParam = elem.getTextValue().trim();
            return true;
        }
        if (elem.getName().equals(TTLTag)) {
            this.TTL = Integer.parseInt(elem.getTextValue().trim());
            return true;
        }
        if (elem.getName().equals(PathTag)) {
            this.addVisited(URI.create(elem.getTextValue().trim()));
            return true;
        }
        return false;
    }

    public UUID getMsgId() {
        return this.msgId;
    }

    public void setMsgId(UUID id) {
        this.msgId = id;
    }

    public String getDestSName() {
        return this.destSName;
    }

    public void setDestSName(String sName) {
        this.destSName = sName;
    }

    public String getDestSParam() {
        return this.destSParam;
    }

    public void setDestSParam(String sParam) {
        this.destSParam = sParam;
    }

    public int getTTL() {
        return this.TTL;
    }

    public void setTTL(int ttl) {
        this.TTL = ttl;
    }

    public void addVisited(URI location) {
        this.visited.add(location);
    }

    public boolean isVisited(URI location) {
        return this.visited.contains(location);
    }

    public URI[] getPath() {
        return this.visited.toArray(new URI[this.visited.size()]);
    }

    public Document getDocument(MimeMediaType encodeAs) {
        if (this.getTTL() <= 0) {
            throw new IllegalStateException("TTL value < 1");
        }
        if (null == this.destSName) {
            throw new IllegalStateException("Destination service name uninitialized");
        }
        if (null == this.msgId) {
            throw new IllegalStateException("Message id uninitialized");
        }
        if (this.visited.isEmpty()) {
            throw new IllegalStateException("Message has not visited local peer.");
        }
        StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(encodeAs, MSG_NAME);
        if (doc instanceof XMLDocument) {
            ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
            ((Attributable)((Object)doc)).addAttribute("xml:space", "preserve");
        }
        Object e = null;
        e = doc.createElement(MsgIdTag, this.msgId.toString());
        doc.appendChild(e);
        e = doc.createElement(DestSNameTag, this.destSName);
        doc.appendChild(e);
        if (null != this.destSParam) {
            e = doc.createElement(DestSParamTag, this.destSParam);
            doc.appendChild(e);
        }
        e = doc.createElement(TTLTag, Integer.toString(this.TTL));
        doc.appendChild(e);
        for (URI aVisited : this.visited) {
            e = doc.createElement(PathTag, ((Object)aVisited).toString());
            doc.appendChild(e);
        }
        return doc;
    }
}

